#ifndef _AIXLIB_H
#define _AIXLIB_H

#include "AIX.h"

typedef struct {
	short deviceid ;
	short state ;
        int   size ;
	char *devinfo;
} AIXInputDeviceInfo;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window window;	        /* "event" window it is reported relative to */
	Window root;	        /* root window that the event occured on */
	Window subwindow;	/* child window */
	Time time;		/* milliseconds */
	int x, y;		/* pointer x, y coordinates in event window */
	int x_root, y_root;	/* coordinates relative to root */
	unsigned int state;	/* key or button mask */
	unsigned int keycode;	/* detail */
	Bool same_screen;	/* same screen flag */
} XLPFKeyEvent;

typedef XLPFKeyEvent XLPFKeyPressedEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window window;	        /* "event" window it is reported relative to */
	Window root;	        /* root window that the event occured on */
	Window subwindow;	/* child window */
	Time time;		/* milliseconds */
	int x, y;		/* pointer x, y coordinates in event window */
	int x_root, y_root;	/* coordinates relative to root */
	unsigned int state;	/* key or button mask */
	short int dialval ;	/* dial value */
	short int dialnum ;	/* dial number */
	Bool same_screen;	/* same screen flag */
} XRotateEvent;

typedef XRotateEvent XDialRotatedEvent;

typedef struct {
	int type;		/* FocusIn or FocusOut */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window window;		/* window of event */
	short mode;		/* NotifyNormal */
	short devtype;		/* Dial/lpfk */
	int detail;
	/*
	 * NotifyAncestor, NotifyVirtual, NotifyInferior, 
	 * NotifyNonLinear,NotifyNonLinearVirtual, NotifyPointer,
	 * NotifyPointerRoot, NotifyDetailNone 
	 */
} XAIXFocusChangeEvent;

typedef XAIXFocusChangeEvent XAIXFocusInEvent;
typedef XAIXFocusChangeEvent XAIXFocusOutEvent;

typedef struct {
	int type;
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window window;		/* unused */
	int request;		/* one of AIXMappingDial,AIXMappingLpfk */
	int lpfkmask ;		/* lpfk input */
	int lightmask ;		/* lpfk output */
	int dialmask ;		/* dial mask */
} XAIXDeviceMappingEvent;

typedef XAIXDeviceMappingEvent XDialMappingEvent ;
typedef XAIXDeviceMappingEvent XLpfkMappingEvent ;

typedef union _XExtEvent {
        int type;
	XLPFKeyEvent xelpfkey;
	XRotateEvent xerotate;
	XAIXFocusChangeEvent xeaixfocuschange;
	XAIXDeviceMappingEvent xedevicemapping;
	long pad[24];
} XExtEvent;

AIXInputDeviceInfo *XListInputDevices() ;

#endif /* _AIXLIB_H */
