h21527
s 00007/00005/00053
d D 1.2 83/01/28 13:56:56 tes 2 1
c initial_internal_update
e
s 00058/00000/00000
d D 1.1 83/01/28 13:03:32 tes 1 0
c date and time created 83/01/28 13:03:32 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpperx (index, type, prdstr, prdend, numprd, ntics)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: output a periodic axis in x or y                       #
#                                                                      #
#     Input Parameters:                                                #
#            index  - flag indicating direction of axis (x=1, y=2)     #
#            type   - type of periodic axis                            #
#                     1 = days of the week (3 characters)              #
#                     2 = days of the week (1 character)               #
#                     3 = months of the year (3 characters)            #
#                     4 = months of the year (1 character)             #
#                     5 = quarters                                     #
#                     6 = user specified period                        #
#            prdstr - label starting value                             #
D 2
#            lperid - end of 1 period                                  #
E 2
I 2
#            prdend - number of periods in a cycle                     #
E 2
#            numprd - number of periods to be displayed                #
#            ntics  - 0 = no tics, 1 = tics                            #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gpgnax - generate an axis with labels                     #
#            gpitic - initialize tic environment                       #
#            gppenv - set up the periodic environment                  #
#                                                                      #
########################################################################
integer index, type, ntics
real prdstr, prdend, numprd
 
I 2
real val1, val2
real grmnmx, gtreal
E 2
integer gimnmx
D 2
PLOTxREALS PLOTxGETREAL
E 2
 
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) index, type, prdstr, prdend, numprd, ntics
DxB 100 format (' xaxper:', 2i5, 3f10.5, i5)
 
   natype(index) = LINEARxAXIS
   call gpitic (index)   # Set up x axis tic environment
   ntstat(index) = ntics
   nperid = gimnmx (type, 1, 6)
D 2
   call gppenv (index, PLOTxGETREAL(prdstr), PLOTxGETREAL(prdend), 
		PLOTxGETREAL(numprd))
   call gpgnax (index, PLOTxGETREAL(prdstr))       # Output x axis
E 2
I 2
   val1 = gtreal (prdend, 0)    # The number of periods
   val2 = grmnmx (gtreal (prdstr, 0), 1.0, val1)  # Which period to start at
   call gppenv (index, val2, val1, gtreal (numprd, 0))
   call gpgnax (index, val2)       # Output x axis
E 2
   nperid = 0
 
   return
end
E 1
