h26102
s 00001/00003/00070
d D 1.6 83/03/09 14:02:35 tes 6 5
c fixed viewport problem and line color problem with hershy text
e
s 00023/00006/00050
d D 1.5 83/03/08 20:20:57 tes 5 4
c modified axis pipeline for integer calculations
e
s 00005/00008/00051
d D 1.4 83/03/02 00:43:28 mrk 4 3
c make these work always in (0-1) space, removed all (0-100) references
e
s 00005/00004/00054
d D 1.3 83/03/01 23:27:21 mrk 3 2
c removed a little math
e
s 00000/00000/00058
d D 1.2 83/01/28 13:54:15 tes 2 1
c initial_internal_update
e
s 00058/00000/00000
d D 1.1 83/01/28 13:02:52 tes 1 0
c date and time created 83/01/28 13:02:52 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpitic (index)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: initialize the tic environment for one axis            #
#                                                                      #
#     Input Parameters:                                                #
#            index  - index of the axis to be initialized (1=x, 2=y)   #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gptxat - set the proper text attributes                   #
#                                                                      #
########################################################################
integer index
I 3
D 5
real temp
E 5
E 3
 
I 5
integer dc(2)
real start, end, p(2), temp

E 5
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) index
DxB 100 format (' gpitic:', i5)
 
   call gptxat (TICxTEXTxATT)   # set up tic text attributes
   if (nsstat(index) == 0 | nrstat(index) == 0) {
 
      # If the user has not specified both start position and range, use the
      #   plot extents for the tic extents.
 
D 4
      ztstrt(index) = 100.*zplmin(index)
      ztend(index) = 100.*zplmax(index)
E 4
I 4
D 5
      ztstrt(index) = zplmin(index)
      ztend(index) = zplmax(index)
E 5
I 5
      start = zplmin(index)
      end = zplmax(index)
E 5
E 4
      }
   else {
 
      # If the user has set both range and start position, we determine where
      #    the tics begin on the axis and set the data to axis ratio.
 
D 3
      ratio(index) = (100.*zplmax(index)-
		      100.*zplmin(index))/(zrend(index)-zrstrt(index))
E 3
I 3
D 4
      temp =          (100.*(zplmax(index)-zplmin(index)))  _
		      /(zrend(index)-zrstrt(index))
E 3
      ztstrt(index) = 100.*zplmin(index) +
D 3
                      ratio(index)*(zdstrt(index) - zrstrt(index))
E 3
I 3
                      temp*(zdstrt(index) - zrstrt(index))
E 3
      ztend(index) = 100.*zplmax(index) -
D 3
                     ratio(index)*(zrend(index) - zdend(index))
E 3
I 3
                     temp*(zrend(index) - zdend(index))
E 4
I 4
      temp =  (zplmax(index)-zplmin(index)) / (zrend(index)-zrstrt(index))
D 5
      ztstrt(index) = zplmin(index) + temp*(zdstrt(index) - zrstrt(index))
      ztend(index) = zplmax(index) - temp*(zrend(index) - zdend(index))
E 5
I 5
      start = zplmin(index) + temp*(zdstrt(index) - zrstrt(index))
      end = zplmax(index) - temp*(zrend(index) - zdend(index))
E 5
E 4
E 3
      }
 
   # Set the distance between the max and minimum tic extents
 
D 5
   ztdist (index) = ztend(index) - ztstrt(index)
E 5
I 5
   ztdist = end - start
   ztstrt = start

   p(1) = 0.0
   p(2) = 0.0
   p(index) = start
   call gpn2dc (p(1), p(2), dc)
   ntstrt = dc(index)

   p(index) = end
   call gpn2dc (p(1), p(2), dc)
   ntend = dc(index)

D 6
   p(index) = ztdist
   call gpn2dc (p(1), p(2), dc)
   ntdist = dc(index)
E 6
I 6
   ntdist = ntend - ntstrt
E 6
E 5
 
   return
end
E 1
