h21361
s 00005/00006/00073
d D 1.2 83/03/31 12:44:04 mmm 2 1
c 
e
s 00079/00000/00000
d D 1.1 83/03/15 21:44:01 tes 1 0
c date and time created 83/03/15 21:44:01 by tes
e
u
4
U
t
T
I 1
subroutine gswkw (xmin, xmax, ymin, ymax)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set the workstation size                               #
#                                                                      #
#     Input Parameters:                                                #
#            xmin,ymin -   the lower left corner (0.0-1.0 NDC)         #
#            xmax,ymax -   the upper right corner (0.0-1.0 NDC)        #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#      Errors:                                                         #
#          7 GKS not in proper state: GKS must be in one of the states #
#            WSOP, WSAC, or SGOP                                       #
#         20 specified workstation identifier is invalid               #
#         25 Specified workstation is not open                         #
#         41 Rectangle definition is invalid                           #
#         44 Workstation window is not within the Normalized Device    #
#            Coordinate unit square                                    #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
real xmin, xmax, ymin, ymax
 
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

D 2
real txmin, txmax, tymin, tymax
REALS GETREAL
E 2
I 2
real txmin, txmax, tymin, tymax, gtreal 
E 2

include(`gkscom')

D 2
   txmin = GETREAL(xmin)  # convert to R real format 
   txmax = GETREAL(xmax)
   tymin = GETREAL(ymin)
   tymax = GETREAL(ymax)
E 2
I 2
   txmin = gtreal (xmin, 0)  # convert to R real format 
   txmax = gtreal (xmax, 0)
   tymin = gtreal (ymin, 0)
   tymax = gtreal (ymax, 0)
E 2

   ifdef(`ERROR_ON',`
      rounum = GSWKW
      errind = errchk(wrkid, ierdum)
      errind = 0
      ')

      if (txmax <= txmin | tymax <= tymin)
      ifdef(`ERROR_ON',`errind = 41',`return')

      if ((amin1(0.0,txmin,txmax,tymin,tymax) != 0.0) |
	  (amax1(1.0,txmin,txmax,tymin,tymax) != 1.0))
      ifdef(`ERROR_ON',`errind = 44',`return')

   ifdef(`ERROR_ON',`
      if (errind != 0) {
	 call gkserr (errind)
	 return
	 }
      ')
 
   cwrkwn(1) = txmin     # Set the workstation window limits
   cwrkwn(2) = txmax
   cwrkwn(3) = tymin
   cwrkwn(4) = tymax

   nwkvw = 1            # Set the workstation transform dirty
   ntext = 1            # Set the text transform dirty 

   return
end
E 1
