h62338
s 00002/00002/00071
d D 1.2 83/03/31 12:40:35 mmm 2 1
c 
e
s 00073/00000/00000
d D 1.1 83/03/15 21:42:47 tes 1 0
c date and time created 83/03/15 21:42:47 by tes
e
u
4
U
t
T
I 1
subroutine gsmssf (mkrssf)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set marker size scale factor                           #
#                                                                      #
#     Input Parameters:                                                #
#            mkrssf - marker size scale factor                         #
#      Output Parameters:                                              #
#            none                                                      #
#                                                                      #
#      Errors:                                                         #
#            8  GKS not in proper state: GKS must be in one of the     #
#               states GKOP, WSOP, WSAC, or SGOP                       #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gzddop - d/i driver interface                             #
#                                                                      #
########################################################################
real mkrssf

integer contrl(5), opcd, vertin, idummy(1), ptsin(2), ptsin1, ptsin2,
	ptsout(2), ptsou2, nommrk

D 2
REALS GETREAL  
E 2
I 2
real gtreal   
E 2

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

include(`gkscom')

equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin),
	    (ptsin(1), ptsin1), (ptsin(2), ptsin2),
	    (ptsout(2), ptsou2)

ifdef(`ERROR_ON',`
      rounum = GSMSSF
      errind = errchk(ierdum(1), ierdum)
      ')

   #   contrl(OPCODE) = SETxPOLYMARKERxSCALE
   opcd = SETxPOLYMARKERxSCALE
   #   contrl(VERTICESxIN) = 1
   vertin = 1

   nommrk = mnmksz
   if (nommrk <= 0) nommrk = 1   # Make sure have a nominal marker size
				 # for continous devices
   #   ptsin(1) = 0.0
   ptsin1 = 0.0
   #   ptsin(2) = mkrssf * nommrk  (convert scale factor to marker height)
D 2
   ptsin2 = GETREAL(mkrssf) * float(nommrk) + 0.5
E 2
I 2
   ptsin2 = gtreal (mkrssf, 0) * float(nommrk) + 0.5
E 2

   # Set output to nommrk for devices which do not support marker sizes
   #   ptsout(2) = nommrk
   ptsou2 = nommrk

   call gzddop (contrl, idummy, ptsin, idummy, ptsout)

   # Set marker size scale factor in common
   mkszsf = float(ptsou2) / float(nommrk)

   return
end
E 1
