h25045
s 00002/00003/00054
d D 1.2 83/03/31 12:38:01 mmm 2 1
c 
e
s 00057/00000/00000
d D 1.1 83/03/15 21:41:40 tes 1 0
c date and time created 83/03/15 21:41:40 by tes
e
u
4
U
t
T
I 1
subroutine gschh (chh)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set the current character height                       #
#                                                                      #
#     Input Parameters:                                                #
#            chh - height of character in world units (default .01)    #
#                                                                      #
#      Output Parameters:                                              #
#            none                                                      #
#      Errors:                                                         #
#            8  GKS not in proper state: GKS must be in one of the     #
#               states  GKOP, WSOP, WSAC, or SGOP                      #
#           60  Character height invalid                               #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gztxtn - select best fit character size and notifies d/d  #
#                                                                      #
########################################################################
real chh
 
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

D 2
real tchh
REALS GETREAL
E 2
I 2
real tchh, gtreal 
E 2
 
include(`gkscom')

D 2
   tchh = GETREAL(chh)  # convert to R number format
E 2
I 2
   tchh = gtreal (chh, 0)  # convert to R number format
E 2

   ifdef(`ERROR_ON',`
      rounum = GSCHH
      errind = errchk(ierdum(1), ierdum)
      ')

   if (tchh <= 0.0) {
      ifdef(`ERROR_ON',`call gkserr (60)')
      tchh = .01          # Use default if bad size
      }

   chrhgt = tchh       # Set user defined character height global
   call gztxtn (tchh)   # notify driver of new size
   ntext = 0           # reset text flag to zero
   
   return
end
E 1
