h43123
s 00005/00007/00060
d D 1.2 83/03/31 12:28:13 mmm 2 1
c 
e
s 00067/00000/00000
d D 1.1 83/03/15 21:35:25 tes 1 0
c date and time created 83/03/15 21:35:25 by tes
e
u
4
U
t
T
I 1
subroutine gdcndc (xin,yin,xout,yout)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: transform device coordinate to NDC space               #
#                                                                      #
#     Input Parameters:                                                #
#            xin - device x coordinate                                 #
#            yin - device y coordinate                                 #
#     Output Parameters:                                               #
#            xout - NDC x coordinate                                   #
#            yout - NDC y coordinate                                   #
#                                                                      #
#     Routines Called:                                                 #
#            gzmtml - matrix multiplier                                #
#            gzwktn - update workstation transform                     #
#                                                                      #
########################################################################
real xin, yin, xout, yout
 
real temp1(3), temp11, temp12, temp13,
     temp2(3), temp21, temp22, temp23,
D 2
     tempx, tempy

REALS GETREAL
E 2
I 2
     tempx, tempy, gtreal
E 2
 
include(`gkscom')
 
equivalence (temp1(1), temp11), (temp1(2), temp12), (temp1(3), temp13),
            (temp2(1), temp21), (temp2(2), temp22), (temp2(3), temp23)
 
#    temp1(3)
data temp13 /1.0/
 
   if (nwkvw == 1) call gzwktn

D 2
   tempx = GETREAL(xin)
   tempy = GETREAL(yin)
E 2
I 2
   tempx = gtreal(xin, 0)
   tempy = gtreal(yin, 0)
E 2

   if (devcor == METERS) {  # Convert to raster if user has specified meters
      tempx = tempx / sptszx
      tempy = tempy / sptszy
      }
    
   #   temp1(1) = xin  # Also convert from device to 32k space
   #   temp1(2) = yin
 
   temp11 = (tempx / (float(mxdsdc(1))+1.0)) * 32768.0 
   temp12 = (tempy / (float(mxdsdc(2))+1.0)) * 32768.0
 
   call gzmtml (1,3,3,temp1,rwview,temp2)
 
   #   xout = temp2(1)
   #   yout = temp2(2)
 
D 2
   PUTREAL(temp21,xout)
   PUTREAL(temp22,yout)
E 2
I 2
   call ptreal(temp21, 0, xout)
   call ptreal(temp22, 0, yout)
E 2
 
   return
end
E 1
