h64391
s 00010/00010/00102
d D 1.11 83/03/15 13:09:21 mjb 11 10
c fixed bugs with labeling legends and calculating ranges
e
s 00001/00001/00111
d D 1.10 83/03/10 19:33:57 mjb 10 9
c 
e
s 00006/00006/00106
d D 1.9 83/03/08 22:01:29 mjb 9 8
c 
e
s 00002/00002/00110
d D 1.8 83/03/08 18:44:18 mjb 8 7
c 
e
s 00002/00002/00110
d D 1.7 83/03/08 17:04:15 mjb 7 6
c 
e
s 00001/00001/00111
d D 1.6 83/03/08 14:13:23 mjb 6 5
c 
e
s 00001/00001/00111
d D 1.5 83/03/07 23:15:45 mjb 5 4
c fixed axis edit bugs, tick labeling bugs, menu.tex
e
s 00000/00000/00112
d D 1.4 83/03/07 06:58:42 mjb 4 3
c 
e
s 00000/00000/00112
d D 1.3 83/03/04 13:45:23 mjb 3 2
c 
e
s 00050/00043/00062
d D 1.2 83/03/03 17:37:54 mjb 2 1
c fixed bugs with x/y plotting and logarithmic axis stuff
e
s 00105/00000/00000
d D 1.1 83/03/02 22:27:30 mjb 1 0
c date and time created 83/03/02 22:27:30 by mjb
e
u
mjb
tes
U
t
T
I 1
subroutine graphc  
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Output a graph to the current device                   #
#                                                                      #
#     Input Parameters:                                                #
#            None                                                      #
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################

D 2
integer font, color, i, j, k, type, itemp
E 2
I 2
D 11
integer font, color, i, j, k, n, type, itemp
E 11
I 11
integer font, color, i, j, k, type, itemp
E 11
E 2
real chrsiz, xdata(75), rtemp1, rtemp2

include(`gattcom')

# Assumptions:
#   - the common block 'gphcom' has been updated and properly set for
#     outputting a graph       

D 2
if (bgadfg(1) == BIGY) {
   j = (bgadcv-1) * 75 + 1
   do i = 1, maxpts {
      xdata(i) = zydata(j)
      j = j + 1
E 2
I 2
D 7
if (maxpts > 0) {
E 7
I 7
D 8
if (maxpts > 1) {
E 8
I 8
if (maxpts > 0) {
E 8
E 7
   if (bgadfg(1) == BIGY & bgaxis(1) != BIGP) {
      j = (bgadcv-1) * 75 + 1
      do i = 1, maxpts {
         xdata(i) = zydata(j)
         j = j + 1
         }
E 2
      }
D 2
   }
else {
   rtemp1 = 0.0
   # initialize xdata
   do i = 1, maxpts {
      rtemp1 = rtemp1 + 1.0
      xdata(i) = rtemp1 
E 2
I 2
   else {
      rtemp1 = 0.0
      # initialize xdata
      do i = 1, maxpts {
         rtemp1 = rtemp1 + 1.0
         xdata(i) = rtemp1 
         }
E 2
      }
D 2
   }
E 2


D 2
# Output the graphs

# Set the points labeled attributes
font = bgtfnt(5)
chrsiz = bgtsiz(5)
color = bgtclr(5)

j = 1
k = 1
do i = 1, 5 {
   if (bgddef(i) > 0) { 
      if (bgadfg(1) == BIGY & i == bgadcv) { # skip over xdata curve
	 j = j + 75
	 k = k + 2
	 }
      type = OFF
      if (bgptfl(k) == BIGY) type = ON  # Points labeled via tic attributes
      call lablpt (type, font, chrsiz, color) 
	 
      itemp = bgddef(i)
      if (bgstfg(1) == BIGY | bgadfg(1) == BIGY) itemp = maxpts
E 2
I 2
   # Output the graphs
E 2
   
D 2
      if (bgbard(1) == BIGV) {
         call crvout (i, itemp, xdata, zydata(j))
E 2
I 2
   # Set the points labeled attributes
   font = bgtfnt(5)
   chrsiz = bgtsiz(5)
   color = bgtclr(5)
   
   j = 1
   k = 1
D 11
   n = 1
   do i = 1, 5 {
E 11
I 11
   i = 1
   while (i <= 5) {
E 11
I 9
      # Skip xdata and or curves with no data
D 11
      if (bgadfg(1) == BIGY & n == bgadcv & bgaxis(1) != BIGP) { 
E 11
I 11
      if (bgadfg(1) == BIGY & i == bgadcv & bgaxis(1) != BIGP) { 
E 11
	 j = j + 75
	 k = k + 2
D 11
	 n = n + 1
E 11
I 11
	 i = i + 1
E 11
	 }
E 9
D 5
      if (bgddef(i) > 0) { 
E 5
I 5
D 7
      if (bgddef(n) > 0) { 
E 7
I 7
D 8
      if (bgddef(n) > 1) { 
E 8
I 8
D 11
      if (bgddef(n) > 0) { 
E 11
I 11
      if (bgddef(i) > 0) { 
E 11
E 8
E 7
E 5
D 9
         # skip over xdata curve
         if (bgadfg(1) == BIGY & i == bgadcv & bgaxis(1) != BIGP) { 
	    j = j + 75
	    k = k + 2
	    n = n + 1
	    }
E 9
         type = OFF
         if (bgptfl(k) == BIGY) type = ON  # Points labeled via tic attributes
         call lablpt (type, font, chrsiz, color) 
	    
D 11
         itemp = bgddef(n)
E 11
I 11
         itemp = bgddef(i)
E 11
         if (bgstfg(1) == BIGY | (bgadfg(1) == BIGY & bgaxis(1) != BIGP)) {
	    itemp = maxpts
	    }
         if (bgbard(1) == BIGV) {
D 11
            call crvout (n, itemp, xdata, zydata(j))
E 11
I 11
            call crvout (i, itemp, xdata, zydata(j))
E 11
            }
         else {
D 11
            call crvout (n, itemp, zydata(j), xdata)
E 11
I 11
            call crvout (i, itemp, zydata(j), xdata)
E 11
            }
E 2
         }
D 2
      else {
         call crvout (i, itemp, zydata(j), xdata)
         }
E 2
I 2
      j = j + 75
      k = k + 2
D 11
      n = n + 1
E 11
I 11
      i = i + 1
E 11
E 2
      }
D 2
   j = j + 75
   k = k + 2
   }
E 2
I 2
   }                        # END of maxpts loop
E 2

if (bgfrfg(1) == BIGY) {    # Output graph frame if defined
   # * Frame the graph
   color = bgbrcl(2)
   rtemp1 = bgbrwd(2) - 1
   rtemp2 = rtemp1 / 10.
   call linatt (color, 1, rtemp2)
   call frame (zxmin,zxmax,zymin,zymax)
   call linatt (1, 1, 0.)
   }

if (bgbrfg(1) == BIGY) {    # Output graph border if defined
   # * OUTLINE THE GRAPH
   color = bgbrcl(1)
   rtemp1 = bgbrwd(1) - 1
   rtemp2 = rtemp1 / 10.
   call linatt (color, 1, rtemp2)
D 6
   call frame (0.,100.,0.,100.)
E 6
I 6
D 10
   call frame (0.00001,99.99999,0.00001,99.99999)
E 10
I 10
   call frame (0.,100.,0.,100.)
E 10
E 6
   call linatt (1, 1, 0.)   # Reset line to default
   }

return
end
E 1
