h24171
s 00076/00000/00000
d D 1.1 83/03/15 21:14:17 tes 1 0
c date and time created 83/03/15 21:14:17 by tes
e
u
4
U
t
T
I 1
/************************************************************************
* gdc.h -- parameters describing the commands to drive the NEC 7220	*
* chip on the CS Artist I board. This file is substantially copied	*
* from the file by the same name supplied by Control Systems.		*
************************************************************************/
 
/* definition of bit fields in the 7220 status byte */
#define DATAREADY 0x01		/* input data available */
#define FIFOFULL 0x02		/* don't send data if this is true */
#define FIFOEMPTY 0x04		/* 7220 has no more data */
#define DRAWING 0x08		/* 7220 is busy doing something */
#define DMAEXEC 0x10		/* DMA operation in progress */
#define VERTSYNC 0x20		/* it's vertical sync time */
#define HORIZBLANK 0x40		/* it's horizontal blanking interval */
#define LIGHTPEN 0x80
 
/* 7220 command bytes */
#define RESETC 0x00		/* reset 7220 */
#define SYNCC 0x0E		/* set sync parameters */
#define VSYNCC 0x6E		/* vertical sync mode -- LSB = master/slave */
#define CCHARC 0x4B		/* cursor and character characteristics */
#define STARTC 0x6B		/* start display */
#define BCTRLC 0x0C		/* blanking control -- LSB = blank or <enable */
#define ZOOMC 0x46		/* set zoom factors for display and chars */
#define CURSC 0x49		/* set cursor position */
#define PARAMC 0x70		/* load parameter RAM */
#define PITCHC 0x47		/* set words per line */
#define WDATC 0x20		/* write data into display memory */
#define MASKC 0x4A		/* load the MASK register */
#define FIGSC 0x4C		/* specify figure drawing parameters */
#define FIGDC 0x6C		/* start drawing a figure */
#define GCHRDC 0x68		/* graphics character drawing start */
#define RDATC 0xA0		/* read data from display memory */
#define CURDC 0xE0		/* cursor address read */
#define LPRDC 0xC0		/* light pen address read */
#define DMARC 0xA4		/* DMA read request */
#define DMAWC 0x24		/* DMA write request */
 
/* mode definitions for misc. commands */
#define GRAFMODE 0x02		/* graphics mode */
#define CHARMODE 0x20		/* character mode -- no graphics */
#define MIXMODE 0x00		/* both */
#define ILACE 0x09		/* interlaced framing */
#define NILACE 0x00		/* non-interlaced */
#define STATIC 0x00		/* don't refresh the display RAMs */
#define DYNAMIC 0x04		/* display RAMs forget things now and again */
#define DRAWACTIVE 0x00		/* draw during display */
#define DRAWRETRACE 0x10	/* don't disturb the display when drawing */
#define DISABLE 0x00		/* turn off display */
#define ENABLE 0x01		/* turn on display */
#define VSMASTER 0x01		/* vertical sync master */
#define VSSLAVE 0x00		/* vertical sync comes from another chip */
#define DISPCURSOR 0x80		/* display cursor */
#define BLINKCUR 0x00		/* blinking cursor */
#define STEADYCUR 0x20		/* steady cursor */
#define REPLACE 0x00		/* pixels overwrite what's there */
#define COMPLEMENT 0x01		/* XOR mode writing */
#define RESET 0x02		/* blank things out */
#define SET 0x03		/* write bits into display */
#define WORD 0x00		/* data transfer definition for wdat, rdat */
#define LOWBYTE 0x10		/* 8-bits, low byte only */
#define HIGHBYTE 0x18		/* same, but high byte */
#define FIGCHAR 0x00		/* for FIGSC command, doing a character */
#define FIGLINE 0x08		/* for FIGSC command, doing a line */
#define FIGGRAFCHAR 0x10	/* "   " area fill and graphic characters */
#define FIGARC 0x20		/* "  " arc and circle drawing */
#define FIGRECT 0x40		/* "  " boring things */
#define FIGSLANTED 0x90		/* indicating a different point of view */
 
/* the hardware locations of the 7220 registers, and the other board ports */
#define PARAM 0x2F0
#define CMD 0x2F1
#define FIFO 0x2F1
#define GDCSTAT 0x2F0
#define CONFIGURE 0x2F2
#define ZOOMREG 0x2F6
E 1
