C     TEST PROGRAM FOR INITIAL 3D PACKAGE   
	COMMON /DFILE/IBUF(3000)
      DIMENSION FDATA(32),IBUTT(5)  
	DATA XDEG,YDEG,ZDEG,SX,SY,SZ,TX,TY,TZ,TP,IFIG 
     *     /0.,0.,0.,1.,1.,1.,511.,511.,-3100.,4000.,1/
	DATA IFLG/1/
      MACRO=1
	CALL INIT(3000)
10    CALL INIT3D   
      CALL DAU(FDATA,IBUTT,KEY) 
C     PERFORM TRANSFORMATIONS ACCORDING TO USER INPUT   
C     SET UP ROTATIONAL TRANSFORMATIONS 
	IF(FDATA(1).EQ.0.) GOTO 11
	XDEG=FDATA(17)*.5
	GOTO 13
11    CONTINUE 
	IF(FDATA(2).EQ.0.) GOTO 12
	YDEG=FDATA(17)*.5
	GOTO 13
12    CONTINUE  
	IF(FDATA(3).EQ.0.) GOTO 13
	ZDEG=FDATA(17)*.5
13    CONTINUE  
      CALL ROTX3D(XDEG) 
      CALL ROTY3D(YDEG) 
      CALL ROTZ3D(ZDEG) 
C     SET UP SCALING TRANSFORMATIONS
C     SET SCALING IN ALL 3 DIRECTIONS EQUAL 
	IF(FDATA(5).EQ.0.) GOTO 15
	SX=.01*FDATA(17) 
      SY=SX
      SZ=SX 
15      CALL SCAL3D(SX,SY,SZ) 
C     SET UP TRANSLATION
	IF(FDATA(9).EQ.0.) GOTO 16
	TX=FDATA(17)
	GOTO 19
16	IF(FDATA(10).EQ.0.) GOTO 17
	TY=FDATA(17)
	GOTO 19
17	IF(FDATA(11).EQ.0.) GOTO 19
	TZ=FDATA(17)
19      CALL TRAN3D(TX,TY,TZ) 
C     SET UP THE PERSPECTIVE
	IF(FDATA(12).EQ.0.) GOTO 21
	TP=FDATA(17)*.5   
C     MODIFY BY AN APPROPRIATE AMOUNT   
       TP=TP*TP*TP  
21	CALL PERS3D(TP)   
C     NOW DRAW THE OBJECT(S)
C     CHECK FOR FIGURE CHANGE   
	IF(FDATA(16).EQ.0.) GOTO 50
	IFIG=FDATA(17)
50    CONTINUE  
C
C	INITIALIZE THE DISPLAY FILE
C
	CALL INIT
	CALL SUBP(1)
C
C     CALL THE SUBROUTINE DESCRIBING THE FIGURE 
      GOTO (1,2,3,4,5,6,7,8,9),IFIG 
C
1	CALL APNT3D(511.,511.,,-4,-1,2)
	CALL PYRAMD
      GOTO 100  
2	CALL APNT3D(511.,511.,,-4,-1,1)
	CALL DICE 
      GOTO 100  
3	CALL APNT3D(511.,511.,,-4,-1,1)
	CALL TETRA
      GOTO 100  
4	CALL APNT3D(511.,511.,,-4,-1,1)
	CALL BOOK 
      GOTO 100  
5	CALL APNT3D(511.,511.,,-4,-1,1)
	CALL EXPAND(SX,SY,SZ,XDEG,YDEG,ZDEG,TX,TY,TZ,TP)
      GOTO 100  
6	CALL APNT3D(511.,511.,,-4,-1,1)
	CALL MESAGE(SX,SY,SZ)
      GOTO 100  
7     CONTINUE  
	CALL APNT3D(511.,511.,,-4,-1,1)
	CALL STRWAR(1)
      GOTO 100
8     CONTINUE
	CALL APNT3D(511.,511.,,-4,-1,4)
	CALL STRWAR(4)
      GOTO 100  
9     CONTINUE  
	CALL TSTCHR
100   CONTINUE  
	CALL ESUB

	IF(FDATA(6).NE.1.) GOTO 190
	IFLG=FDATA(17)
190	IF(IFLG.EQ.1) GOTO 10
	CALL POINTR(1,1)
200	CALL JOYSTK(IX,IY,IBUT)
	IF(IBUT.EQ.1) GOTO 10
	CALL CHANGE(1,FLOAT(IX),FLOAT(IY))
	GOTO 200
      END   


      SUBROUTINE BOOK
C     THIS ROUTINE DRAWS WHAT APPEARS TO BE A TWO PAGE BOOK,WITH COVERS.
      CALL PNT3D(0.,0.,100.,,-4,-1,1)
      CALL VECT3D(0.,200.,100.,,4,-1,1)
      CALL VECT3D(0.,200.,-100.)
      CALL VECT3D(0.,0.,-100.)
      CALL VECT3D(0.,0.,100.)
      CALL VECT3D(87.,100.,100.)  
      CALL VECT3D(87.,100.,-100.)
      CALL VECT3D(0.,0.,-100.)
      CALL VECT3D(100.,87.,-100.)
      CALL VECT3D(100.,87.,100.)  
      CALL VECT3D(0.,0.,100.)
      CALL VECT3D(200.,0.,100.)   
      CALL VECT3D(200.,0.,-100.)
      CALL VECT3D(0.,0.,-100.)
      RETURN
      END   

      SUBROUTINE DICE
C     THIS FIGURE DRAWS A SINGLE DIE
C     COMPLETE WITH MARKINGS ON EACH FACE   
      CALL PNT3D(-100.,-100.,-100.,,-4,-1,1)
      CALL VECT3D(-100.,-100.,100.,,4,-1,1)
      CALL VECT3D(-100.,100.,100.) 
      CALL VECT3D(-100.,100.,-100.)   
      CALL VECT3D(-100.,-100.,-100.)   
      CALL VECT3D(100.,-100.,-100.)
      CALL VECT3D(100.,100.,-100.) 
      CALL VECT3D(-100.,100.,-100.)
      CALL PNT3D(-100.,100.,100.,,-4)   
      CALL VECT3D(100.,100.,100.)  
      CALL VECT3D(100.,-100.,100.) 
      CALL VECT3D(-100.,-100.,100.)
      CALL PNT3D(100.,-100.,100.,,-4)   
      CALL VECT3D(100.,-100.,-100.)
      CALL PNT3D(100.,100.,100.,,-4)   
      CALL VECT3D(100.,100.,-100.) 
      CALL PNT3D(50.,-100.,50.,,4)
      CALL PNT3D(50.,50.,-100.)
      CALL PNT3D(-50.,-100.,-50.)  
      CALL PNT3D(0.,0.,-100.)  
      CALL PNT3D(-50.,50.,-100.)  
      CALL PNT3D(-100.,0.,0.)  
      CALL PNT3D(50.,50.,100.) 
      CALL PNT3D(50.,-50.,100.)
      CALL PNT3D(-50.,-50.,100.)   
      CALL PNT3D(-50.,50.,100.)
      CALL PNT3D(50.,100.,50.) 
      CALL PNT3D(50.,100.,-50.)
      CALL PNT3D(-50.,100.,-50.)   
      CALL PNT3D(-50.,100.,50.)
      CALL PNT3D(0.,100.,0.)   
      CALL PNT3D(100.,50.,-50.)
      CALL PNT3D(100.,0.,-50.) 
      CALL PNT3D(100.,-50.,-50.)   
      CALL PNT3D(100.,50.,50.) 
      CALL PNT3D(100.,0.,50.)  
      CALL PNT3D(100.,-50.,50.)
      RETURN
      END   


      SUBROUTINE EXPAND(SX,SY,SZ,XDEG,YDEG,ZDEG,TX,TY,TZ,PERS)
	DIMENSION TSAVE(4,3)
C     CONTINUED UPWARD SCALING OF THIS ROUTINE WILL ALLOW THE USER
C     TO SEE MORE CLEARLY THE INNER FIGURES
C     DRAW ENCLOSING CUBE
      CALL PNT3D(-3000.,-3000., 3000.,,-4,-1,1)
      CALL VECT3D(3000.,-3000., 3000.,,4,-1,1)
      CALL VECT3D(3000.,-3000.,-3000.) 
      CALL VECT3D(-3000.,-3000.,-3000.)
      CALL VECT3D(-3000.,-3000., 3000.)
      CALL VECT3D(-3000., 3000., 3000.)
      CALL VECT3D( 3000., 3000., 3000.)
      CALL VECT3D( 3000., 3000.,-3000.)
      CALL VECT3D(-3000., 3000.,-3000.)
      CALL VECT3D(-3000., 3000., 3000.)
      CALL PNT3D (-3000., 3000.,-3000.,,-4)
      CALL VECT3D(-3000.,-3000.,-3000.)
      CALL PNT3D ( 3000.,-3000.,-3000.,,-4)
      CALL VECT3D( 3000., 3000.,-3000.)
      CALL PNT3D ( 3000., 3000., 3000.,,-4)
      CALL VECT3D( 3000.,-3000., 3000.)
C     NOW INSERT THE PYRAMID FIGURE INSIDE THE CUBE 
      CALL PNT3D (-1000.,-1000.,1000.,,-4)   
      CALL VECT3D( 1000.,-1000.,1000.)  
      CALL VECT3D(    0., 1000.,   0.)
      CALL VECT3D(-1000.,-1000., 1000.) 
      CALL VECT3D(-1000.,-1000.,-1000.)
      CALL VECT3D(    0., 1000.,    0.)
      CALL VECT3D( 1000.,-1000.,-1000.) 
      CALL VECT3D(-1000.,-1000.,-1000.)
      CALL PNT3D ( 1000.,-1000.,-1000.,,-4)   
      CALL VECT3D( 1000.,-1000., 1000.)
C     HEXAGONAL OBJECT INSIDE PYRAMID   
      CALL PNT3D (    0.,  200.,    0.,,-4)
      CALL VECT3D(  133.,    0.,  133.)
      CALL VECT3D(  133.,    0., -133.)  
      CALL VECT3D(    0., -200.,    0.)
      CALL VECT3D(    0.,    0., -200.)
      CALL VECT3D(  133.,    0., -133.)  
      CALL VECT3D(    0.,  200.,    0.) 
      CALL VECT3D(    0.,    0., -200.)
      CALL VECT3D( -133.,    0., -133.) 
      CALL VECT3D(    0., -200.,    0.)
      CALL VECT3D( -133.,    0.,  133.)  
      CALL VECT3D(    0.,  200.,    0.)
      CALL VECT3D( -133.,    0., -133.) 
      CALL VECT3D( -133.,    0.,  133.)
      CALL VECT3D(    0.,    0.,  200.) 
      CALL VECT3D(    0., -200.,    0.)
      CALL VECT3D(  133.,    0.,  133.)   
      CALL VECT3D(    0.,    0.,  200.)
      CALL VECT3D(    0.,  200.,    0.) 
C     NOW FOR THE MESSAGE
      CALL PNT3D (  -10.,   -5.,    0.,,-4)
      CALL VECT3D(  -10.,    5.,    0.) 
      CALL PNT3D (  -10.,    0.,    0.,,-4)
      CALL VECT3D(   -5.,    0.,    0.)  
      CALL PNT3D (   -5.,   -5.,    0.,,-4)
      CALL VECT3D(   -5.,    5.,    0.)  
      CALL PNT3D (    0.,   -5.,    0.,,-4)
      CALL VECT3D(    0.,    5.,    0.)   
C	NOW FOR A TINY BOX BY THE MESSAGE
	CALL PNT3D(0.,0.,0.,,-4)
	CALL VECT3D(-.1,0.,0.)
	CALL VECT3D(-.1,-.1,0.)
	CALL VECT3D(0.,-.1,0.)
	CALL VECT3D(0.,0.,0.)
	CALL VECT3D(0.,0.,-.1)
	CALL VECT3D(0.,-.1,-.1)
	CALL VECT3D(0.,-.1,0.)
	CALL PNT3D(0.,0.,-.1,,-4)
	CALL VECT3D(-.1,0.,-.1)
	CALL VECT3D(-.1,-.1,-.1)
	CALL VECT3D(0.,-.1,-.1)
	CALL PNT3D(-.1,-.1,-.1,,-4)
	CALL VECT3D(-.1,-.1,0.)
	CALL PNT3D(-.1,0.,0.,,-4)
	CALL VECT3D(-.1,0.,-.1)
C	NOW FOR A TINIER MESSAGE INSIDE THE TINY BOX
	CALL SAVE3D(TSAVE)
	CALL INIT3D
	CALL SCAL3D(.0000001,.0000001,.0000001)
	CALL ROTX3D(XDEG)
	CALL ROTY3D(YDEG)
	CALL ROTZ3D(ZDEG)
	CALL TRAN3D(TX,TY,TZ)
	CALL PERS3D(PERS)
	CALL CHAR3D(-.09,-.05,-.05,18HSNOOPY, AREN'T WE?,,4,-1,1,0)
	CALL RECL3D(TSAVE)
C     NOW FOR THE OCTAGONAL OBJECT AT THE SIDE OF THE CUBE  
      CALL PNT3D (-2890., 1140.,    0.,,-4)
      CALL VECT3D(-2840., 1000.,  110.,,,-1)
      CALL VECT3D(-2780., 1000.,   50.)
      CALL VECT3D(-2890., 1140.,    0.) 
      CALL VECT3D(-2780., 1000.,  -50.)   
      CALL VECT3D(-2840., 1000., -110.)  
      CALL VECT3D(-2890., 1140.,    0.) 
      CALL VECT3D(-2940., 1000., -110.)  
      CALL VECT3D(-3000., 1000.,  -50.)   
      CALL VECT3D(-2890., 1140.,    0.) 
      CALL VECT3D(-3000., 1000.,   50.)
      CALL VECT3D(-2940., 1000.,  110.)   
      CALL VECT3D(-2890., 1140.,    0.) 
      CALL PNT3D (-2940., 1000.,  110.,,-4)
      CALL VECT3D(-2840., 1000.,  110.)
      CALL VECT3D(-2840.,  900.,  110.)
      CALL VECT3D(-2890.,  760.,    0.)
      CALL VECT3D(-2780.,  900.,   50.)
      CALL VECT3D(-2840.,  900.,  110.)
      CALL PNT3D (-2780.,  900.,   50.,,-4)   
      CALL VECT3D(-2780., 1000.,   50.)
      CALL VECT3D(-2780., 1000.,  -50.)   
      CALL VECT3D(-2780.,  900.,  -50.)
      CALL VECT3D(-2780.,  900.,   50.)
      CALL PNT3D (-2780.,  900.,  -50.,,-4)  
      CALL VECT3D(-2890.,  760.,    0.)  
      CALL VECT3D(-2840.,  900., -110.)   
      CALL VECT3D(-2780.,  900.,  -50.)
      CALL PNT3D (-2840., 1000., -110.,,-4)
      CALL VECT3D(-2840.,  900., -110.)
      CALL VECT3D(-2940.,  900., -110.)   
      CALL VECT3D(-2890.,  760.,    0.)  
      CALL VECT3D(-3000.,  900.,  -50.)
      CALL VECT3D(-2940.,  900., -110.)   
      CALL VECT3D(-2940., 1000., -110.)  
      CALL VECT3D(-2840., 1000., -110.)  
      CALL PNT3D (-3000.,  900.,   50.,,-4)
      CALL VECT3D(-3000., 1000.,   50.)
      CALL VECT3D(-3000., 1000.,  -50.)   
      CALL VECT3D(-3000.,  900.,  -50.)
      CALL VECT3D(-3000.,  900.,   50.) 
      CALL VECT3D(-2890.,  760.,    0.)  
      CALL VECT3D(-2940.,  900.,  110.)
      CALL VECT3D(-3000.,  900.,   50.) 
      CALL PNT3D (-2940., 1000.,  110.,,-4) 
      CALL VECT3D(-2940.,  900.,  110.)
      CALL VECT3D(-2840.,  900.,  110.)
      RETURN
      END

      SUBROUTINE MESAGE(SX,SY,SZ)
	CALL CHAR3D(-975.,-150.,150.,'HI FOLKS',,4,-1,1,0)
	CALL SCAL3D(.2,.2,.5)
	CALL CHAR3D(-250.,-350.,150.,'COURTESY',,6,-1,,1)
	CALL CHAR3D(-600.,-700.,150.,'CSD CONSULTING',,6,1,,1)
      RETURN
      END

      SUBROUTINE PYRAMD
C     PYRAMID FIGURE
      CALL PNT3D(0.,100.,0.,,-4,-1,2)
      CALL VECT3D(-100.,-100.,100.,,4,-1,2)
      CALL VECT3D(-100.,-100.,-100.)   
      CALL VECT3D(100.,-100.,-100.)
      CALL VECT3D(100.,-100.,100.) 
      CALL VECT3D(-100.,-100.,100.)
      CALL PNT3D(100.,-100.,100.,,-4)   
      CALL VECT3D(0.,100.,0.)
      CALL VECT3D(100.,-100.,-100.)
      CALL PNT3D(0.,100.,0.,,-4)
      CALL VECT3D(-100.,-100.,-100.)   
      RETURN
      END

      SUBROUTINE TETRA
      CALL PNT3D(-100.,0.,0.,,-4,-1,1)
      CALL VECT3D(0.,0.,-173.,,4,-1,1)
      CALL VECT3D(100.,0.,0.) 
      CALL VECT3D(-100.,0.,0.)
      CALL VECT3D(0.,163.,-58.)   
      CALL VECT3D(100.,0.,0.) 
      CALL PNT3D(0.,0.,-173.,,-4)  
      CALL VECT3D(0.,163.,-58.)   
      RETURN
      END   

	SUBROUTINE STRWAR(LINTYP)
	CALL PNT3D(100.,0.,100.,,-4,-1,LINTYP)
	CALL VECT3D(200.,0.,100.,,4,-1,LINTYP)
	CALL PNT3D(200.,150.,200.,,-4)
	CALL VECT3D(200.,200.,150.)
	CALL VECT3D(200.,200.,-150.)
	CALL VECT3D(200.,150.,-200.)
	CALL VECT3D(200.,-150.,-200.)
	CALL VECT3D(200.,-200.,-150.)
	CALL VECT3D(200.,-200.,150.)
	CALL VECT3D(200.,-150.,200.)
	CALL VECT3D(200.,150.,200.)
C	FINISHED WITH RIGHT 'WING'
C	NOW TRY FILLING IN THE SIDE
C	CALL PNT3D(200,175,175,-1,1)
C	CALL VECT3D(200,-175,175,4,1)
C	CALL PNT3D(200,-200,150,-1,1)
C	CALL VECT3D(200,200,150,4,1)
C	CALL PNT3D(200,200,125,-1,1)
C	CALL VECT3D(200,-200,125,4,1)
C	CALL PNT3D(200,-200,100,-1,1)
C	CALL VECT3D(200,200,100,4,1)
C	CALL PNT3D(200,200,75,-1,1)
C	CALL VECT3D(200,-200,75,4,1)
C	CALL PNT3D(200,-200,50,-1,1)
C	CALL VECT3D(200,200,50,4,1)
C	CALL PNT3D(200,200,25,-1,1)
C	CALL VECT3D(200,-200,25,4,1)
C	CALL PNT3D(200,-200,0,-1,1)
C	CALL VECT3D(200,200,0,4,1)
C	CALL PNT3D(200,200,-25,-1,1)
C	CALL VECT3D(200,-200,-25,4,1)

	CALL PNT3D(200.,0.,-100.,,-4)
	CALL VECT3D(100.,0.,-100.)
C	FINISHED WITH RIGHT STRUT
	CALL PNT3D(100.,0.,-150.,,-4)
	CALL VECT3D(100.,0.,150.)
	CALL VECT3D(80.,80.,150.)
	CALL VECT3D(80.,80.,-150.)
	CALL VECT3D(100.,0.,-150.)
	CALL VECT3D(80.,-80.,-150.)
	CALL VECT3D(80.,-80.,150.)
	CALL VECT3D(100.,0.,150.)
C	FINISHED WITH RIGHT SIDE
	CALL PNT3D(80.,80.,150.,,-4)
	CALL VECT3D(-80.,80.,150.)
	CALL VECT3D(-80.,80.,-150.)
	CALL VECT3D(80.,80.,-150.)
C	TOP FINISHED
	CALL PNT3D(-80.,80.,-150.,,-4)
	CALL VECT3D(-100.,0.,-150.)
	CALL VECT3D(-100.,0.,150.)
	CALL VECT3D(-80.,80.,150.)
	CALL PNT3D(-100.,0.,150.,,-4)
	CALL VECT3D(-80.,-80.,150.)
	CALL VECT3D(80.,-80.,150.)
C	FINISHED WITH FRONT
	CALL PNT3D(-80.,-80.,150.,,-4)
	CALL VECT3D(-80.,-80.,-150.)
	CALL VECT3D(80.,-80.,-150.)
	CALL PNT3D(-80.,-80.,-150.,,-4)
	CALL VECT3D(-100.,0.,-150.)
C	FINISHED WITH BODY
	CALL PNT3D(-100.,0.,-100.,,-4)
	CALL VECT3D(-200.,0.,-100.)
	CALL PNT3D(-100.,0.,100.,,-4)
	CALL VECT3D(-200.,0.,100.)
C	FINISHED WITH STRUT ON LEFT SIDE
	CALL PNT3D(-200.,-150.,200.,,-4)
	CALL VECT3D(-200.,150.,200.)
	CALL VECT3D(-200.,200.,150.)
	CALL VECT3D(-200.,200.,-150.)
	CALL VECT3D(-200.,150.,-200.)
	CALL VECT3D(-200.,-150.,-200.)
	CALL VECT3D(-200.,-200.,-150.)
	CALL VECT3D(-200.,-200.,150.)
	CALL VECT3D(-200.,-150.,200.)
C	END OF LEFT SIDE
	RETURN
	END

	SUBROUTINE TSTCHR
	LOGICAL*1 ICHAR(2)
	DATA ICHAR/2*0/
10	WRITE(5,20)
20	FORMAT($,' ENTER A CHARACTER:')
	READ(5,30,END=40) ICHAR(1)
30	FORMAT(A1)
	IF(ICHAR(1).EQ.'O') RETURN
	CALL INIT
	CALL SUBP(1)
	CALL APNT3D(0.,0.,,4,-1,1)
	CALL CHAR3D(-300.,0.,-100.,ICHAR,,4,-1,1,0)
	CALL CHAR3D(300.,0.,-100.,ICHAR,,,,,1)
	GOTO 10
40	RETURN
	END
