	SUBROUTINE DAU(FDATA,IBUTT,IKEY)
	DIMENSION FDATA(32),IBUTT(5)
	DIMENSION LIST(16),IOLIST(4)
	DIMENSION ITTSET(4)
C	REMOVE FDATA DIMENSION WHEN THIS SUBROUTINE IS CHANGED
	DIMENSION IDATA(32)
	DATA ITTSET/O137777,0,0,132/
	DATA IFRST/0/
	DATA LIST/16*0/
	GOTO 123
C
C	DETERMINE IF THIS IS THE FIRST TIME THROUGH
	IF(IFRST.NE.0) GOTO 1
	IFRST=1
C	SET TTY INTO SPECIAL MODE
	I=MTATCH(0)
	CALL MTSET(0,ITTSET)
	CALL IPOKE("44,"50100.OR.IPEEK("44))
C
C	GET A READING FROM THE JOYSTICK
C
1	CALL JOYSTK(IDATA(17),IDATA(18),IDATA(19))
	CALL FUNBOX(LIST)
C
C	SCAN FUNCTION BOX
C
	DO 10 I=1,16
	IDATA(I)=0
	IF(LIST(I).EQ.IOLIST(I)) GOTO 10
	IOLIST(I)=LIST(I)
	IDATA(I)=1
10	CONTINUE
C
C	NOW READ A CHARACTER FROM THE KEYBOARD
C
	I=MTIN(0,IKEY)
	IF(I.NE.0) IKEY=0
	RETURN
123	DO 122 I=1,17
122	FDATA(I)=0.
	READ(5,130) I,VAL
130	FORMAT(I2,F10.0)
	FDATA(I)=1.
	FDATA(17)=VAL
	RETURN
C	END
C
C	FUNCTION ISHFT(INUM,NO)
C	IF(NO) 5,10,15
C5	ISHFT=INUM/(2**(-NO))
C	RETURN
C10	ISHFT=INUM
C	RETURN
C15	ISHFT=INUM*(2**NO)
C	RETURN
	END

	SUBROUTINE APNT3D(X,Y,LPEN,INTENS,ITAG,ITYPE)
C
C	THIS SUBROUTINE PROVIDES THE INTERFACE BETWEEN THE GT-46
C	AND THE 3-D PACKAGE
C
	COMMON /REPNT/XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
	IF(IADDR(LPEN).EQ.-1) GOTO 10
	LASTPN=LPEN
10	IF(IADDR(INTENS).EQ.-1) GOTO 20
	LASTIN=INTENS
20	IF(IADDR(ITAG).EQ.-1) GOTO 30
	LASTAG=ITAG
30	IF(IADDR(ITYPE).EQ.-1) GOTO 40
	LASTYP=ITYPE
40	XLAST=X
	YLAST=Y
	CALL APNT(XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP)
	LASTIN=IABS(LASTIN)
	RETURN
	END


      SUBROUTINE CHAR3D(X,Y,Z,ILIST,LPEN,INTENS,ITAG,ITYPE,IFLAG)
C
C
C    THE SUBROUTINE CALL IS OF THE FOLLOWING FORM   
C             CALL CHAR3D(X,Y,Z,'MESAGE',LPEN,INTENS,ITAG,LINETYPE)   
C
C
C    X,Y AND Z ARE THE FRONT-LOWER-LEFT CO-ORDINATES OF THE FIRST
C    CHARACTER IN THE MESSAGE.  
C
C    MESSAGE IS WHAT YOU WANT TO BE DRAWN, AND IS PRECEDED AND FOLLOWED 
C    BY QUOTES. 
C
C    INTENS IS THE INTENSITY YOU WANT THE MESSAGE DRAWN AT. 
C
C    ITAG IS THE BLINKING FREQUENCY.
C
C	ITYPE IS THE LINE TYPE.
C
C    ARRAY ILOC CONTAINS NUMBERS TO BE USED AS POINTERS, TO ACCESS  
C    INFORMATION CONTAINED IN ARRAY INFO.  ILOC(1) POINTS TO THE
C    FIRST LOCATION IN ARRAY INFO NEEDED TO DRAW THE CHARACTER  
C    (EXCLAMATION POINT), WHOSE ASCII CODE IS 21.  ILOC(2) CONTAINS 
C    THE POINTER TO (DOUBLE QUOTE), WHOSE ASCII CODE IS 22.  IN GENERAL 
C    ILOC(N) POINTS TO THE CHARACTER WHOSE ASCII CODE IS N+20 (IN HEX). 
C    THE DATA IN ARRAY INFO BETWEEN THE POINTERS ILOC(N) AND ILOC(N+1)  
C    IS THE INFORMATION NEEDED TO DRAW THE CHARACTER.  THE FIRST NUMBER 
C    IN SUCH A FIELD, CONTAINS THE LENGTH ALONG THE X AXIS OF THE   
C    CHARACTER.  THE SECOND NUMBER SAYS HOW MANY VECTORS ARE NEEDED TO  
C    DRAW THE CHARACTER.  THE THIRD NUMBER IS THE NUMBER OF DIFFERENT   
C    ENDPOINTS NEEDED TO DRAW THE VECTORS. EVERY TWO NUMBERS AFTER  
C    THAT SPECIFY A POINT, AND TWO POINTS WILL DRAW A VECTOR.   
C
C
	DIMENSION INFO(1329),ILOC(63) 
	LOGICAL*1 ILIST(100)
	COMMON /REPNT/XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
C
C

      DATA ILOC/1,12,23,42,77,116,147,154,173,192,207,218,225,232,239,24
     C6,289,304,331,366,381,412,463,478,521,572,583,594,605,616,627,662,
     C713,728,771,798,829,848,863,898,913,920,943,958,969,988,1003,1038,
     C1061,1100,1127,1158,1169,1196,1207,1226,1237,1256,1271,1286,1293,
     C1308,1323/
C
C
C
C
C	NOW FOR THE EXCLAMATION POINT, ETC
C
      DATA INFO/100,2,3,50,275,50,75,50,25,50,25                            "
     C,200,2,4,50,200,50,300,150,200,150,300                                #
     C,200,4,8,0,100,200,100,0,200,200,200,50,50,50,250,150,50,150,250      $
     C,200,8,10,125,0,125,300,200,225,125,250,50,225,50,175,200,125,200,
     C75,125,50,50,75,125,50,200,75,200,125,50,175,50,225,125,250           %
     C,200,9,10,0,50,200,250,0,200,50,250,50,150,100,200,100,100,150,150
     C,150,50,200,100,200,100,150,150,150,50,100,100,50,150,0,200,100,20
     C0,50,250                                                              &
     C,100,7,10,50,50,50,100,50,200,50,250,75,100,25,100,50,150,0,150,25
     C,200,75,200,25,200,0,150,25,100,0,150                                 '
     C,100,1,2,50,200,50,300                                                (
     C,100,4,5,100,0,25,50,0,150,25,250,100,300,25,250,0,150,25,50          )
     C,100,4,5,0,0,75,50,100,150,75,250,0,300,75,250,100,150,75,50          *
     C,150,3,6,0,75,150,225,0,150,150,150,0,225,150,75                      +
     C,150,2,4,0,150,150,150,75,75,75,225                                   ,
     C,100,1,2,0,0,50,100                                                   -
     C,150,1,2,0,150,150,150                                                .
     C,100,1,1,50,25,50,25                                                  /
     C,150,1,2,0,0,150,300                                                  0
     C,250,10,10,0,100,0,200,50,275,125,300,200,275,250,200,250,100,200,
     C25,125,0,50,25,50,25,0,100,0,200,50,275,125,300,200,275,250,200,25
     C0,100,200,25,125,0                                                    1
     C,200,3,5,25,200,100,300,0,0,200,0,100,0,100,300                       2
     C,250,6,7,25,275,125,300,200,275,200,200,50,100,0,0,250,0,0,0,50,10
     C0,200,200,200,275,125,300                                             3
     C,225,8,9,50,275,125,300,200,275,200,200,125,175,200,150,225,50,125
     C,0,25,50,125,0,225,50,200,150,125,175,200,200,200,275,125,300         4
     C,250,3,4,200,0,200,300,0,115,250,115,0,115,200,300                    5
     C,250,7,8,240,300,50,300,50,150,150,175,250,150,250,50,150,0,25,25,
     C150,0,250, 50,250,150,150,175,50,150,50,300                           6
     C,250,12,12,225,275,125,300,25,275,0,200,0,100,25,25,125,0,225,25,2
     C50,100,225,175,125,200,25,175,125,300,25,275,0,200,0,100,25,25,125
     C,0,225,25,250,100,225,175,125,200,25,175,0,100                        7
     C,250,3,4,0,300,250,300,125,100,100,0,125,100,250,300                  8
     C,225,10,10,25,50,125,0,225,50,200,150,50,200,50,275,125,300,200,27
     C5,200,200,50,150,50,150,25,50,125,0,225,50,200,150,50,200,50,275,1
     C25,300,200,275,200,200                                                9
     C,250,12,12,25,25,125,0,225,25,250,100,250,200,225,275,125,300,25,2
     C75,0,200,25,125,125,100,225,125,125,0,225,25,250,100,250,200,225,2
     C75,125,300,25,275,0,200,25,125,125,100,225,125,250,200                :
     C,100,2,4,50,75,50,80,50,225,50,230                                    ;
     C,150,2,3,50,50,100,150,100,250,100,250                                <
     C,250,2,3,0,150,250,50,250,250,0,150                                   =
     C,250,2,4,0,75,250,75,0,225,250,225                                    >
     C,250,2,3,0,50,250,150,0,250,250,150                                   ?
     C,250,8,9,0,225,50,285,125,300,200,285,250,225,200,165,125,150,125,
     C50,125,0,125,0,125,150,200,165,250,225,200,285,150,300,50,285         @
     C,250,12,12,250,50,150,0,50,50,0,150,50,250,150,300,250,250,250,150
     C,225,150,150,225,75,150,150,75,150,225,75,150,150,75,225,150,225,1
     C50,250,150,250,250,150,300,50,250,0,150,50,50,150,0                   A
     C,         300,3,5,50,100,250,100,150,300,300,0,0,0,150,300,           B
     C 250,10,11,0,0,160,0,250,60,250,110,200,210,140,160,200,255,140,30
     C0,0,160,139,160,0,300,0,0, 0,300,140,300,200,255,200,210,140,160,2
     C50,110,250,60,160,0                                                   C
     C,250,6,7,50,50,150,0,0,150,50,250,150,300,250,250,250,50,150,0,0,1
     C50,50,50,50,250,150,300                                               D
     C,250,7,7,0,0,0,300,100,300,200,250,250,150,200,50,100,0,0,0,0,300,
     C100,300,200,250,250,150,200,50,100,0  
     C       ,250,4,6,0,300,250,300,0,160,150,160,0,0,250,0,0,0,0,300       F
     C       ,250,3,5,0,300,250,300,0,160,150,160,0,0,0,300 
     C,250,8,9,150,150,250,150,250,50,150,0,50,50,0,150,50,250,150,300,
     C250,250,150,300,50,250,0,150,50,50,150,0,250,50,250,150               H
     C       ,250,3,6,0,0,0,300,250,300,250,0,0,160,250,160 
     C       ,100,1,2,50,0,50,300   
     C,250,5,6,250,300,250,100,200,25,125,0,50,25,0,100,50,25,125,0,200,
     C25,250,100
     C       ,250,3,6,0,0,0,300,225,300,0,100,250,0,100,189 
     C       ,250,2,3,0,0,0,300,250,0,0,0   
     C       ,300,4,5,0,0,0,300,300,300,300,0,150,0,0,300,300,300,150,0 
     C       ,250,3,4,0,0,0,300,250,300,250,0,0,300,250,0   
     C,300,8,8,50,50,150,0,0,150,50,250,150,300,250,250,300,150,250,50,2
     C50,50,150,0,50,50,0,150,50,250,150,300,250,250,300,150
     C,200,5,6,0,0,0,300,150,300,200,225,150,150,0,150,0,300,150,300,200
     C,225,150,150  
     C,300,9,10,50,50,150,0,0,150,50,250,150,300,250,250,300,150,250,50,
     C250,0,200,75,250,50,150,0,50,50,0,150,50,250,150,300,250,250,300,1
     C50
     C,200,6,8,0,0,0,300,150,300,200,225,150,150,0,150,200,0,125,150,0,3
     C00,150,300,200,225,150,150
     C,225,7,8,25,50,125,0,225,50,200,150,50,200,50,275,125,300,200,275,
     C125,0,225,50,200,150,50,200,50,275,125,300
     C       ,300,2,4,150,0,150,300,0,300,300,300   
     C,250,6,7,250,300,250,100,200,25,125,0,50,25,0,100,0,300,0,100,50,2
     C5,125,0,200,25,250,100
     C       ,300,2,3,0,300,150,0,300,300,150,0 
     C       ,500,4,5,0,300,100,0,400,300,300,0,200,300,300,0,200,300,10
     C0,0   
     C        ,300,2,4,0,0,275,300,300,0,25,300 
     C        ,300,4,5,0,300,0,150,200,300,200,150,100,0,100,150,0,150,2
     C00,150
     C        ,225,3,6,0,300,200,300,200,300,0,0,0,0,200,0,
     C150,3,6,0,0,150,0,0,0,0,300,0,300,150,300,
     C150,1,2,0,300,150,0,
     C150,3,6,0,0,150,0,150,0,150,300,150,300,0,300,
     C200,3,6,0,200,100,300,100,300,200,200,100,300,100,0,
     C200,1,2,0,0,200,0/ 
C
C	INDICATE MAX CHARACTER IN INFO ARRAY
C
	DATA MAXCHR/64/
C
	EX=X
	I=1
	IF(IADDR(IFLAG).EQ.-1) GOTO 1
	IF(IFLAG.EQ.1) GOTO 110

1	CONTINUE
C
C    THIS PART OF THE SUBROUTINE UNPACKS THE ASCII CHARACTERS   
C    AND STORES THE UNPACKED NUMBER - 20 IN ICHAR   
C
	ICHAR=ILIST(I)
	IF(ICHAR.EQ.0) RETURN
	ICHAR=ICHAR-32
C	CHECK FOR VALID CHARACTERS
	IF(ICHAR.GT.0.AND.ICHAR.LT.MAXCHR) GOTO 6
	L=1
	GOTO 5
6	L=ILOC(ICHAR) 
C
C    INFO(L) CONTAINS THE LENGTH OF THE CHARACTER   
C    INFO(L+1) CONTAINS THE NUMBER OF VECTORS USED TO DRAW  
C    THE CHARACTER IN TWO DIMENSIONS
C    INFO(L+2) CONTAINS THE NUMBER OF POINTS IN THE CHARACTER   
C
	ICHECK=2*INFO(L+2)+2  
C
C    THIS LOOP DRAWS THE DEPTH OF THE CHARACTER 
C
      DO 7 J=4,ICHECK,2 
	X1=FLOAT(INFO(L+J-1))+EX
	Y2=FLOAT(INFO(L+J))+Y   
	Z3=Z-300. 
	CALL PNT3D(X1,Y2,Z,,0-LASTIN)
7	CALL VECT3D(X1,Y2,Z3,LPEN,INTENS,ITAG,ITYPE)
      ICHCK=4*INFO(L+1) 
C
C    THIS LOOP DRAWS THE CHARACTERS IN THE FRONT X-Y PLANE, 
C    THEN THE REAR X-Y PLANE
C
      DO 9 K=4,ICHCK,4
	X4=FLOAT(INFO(K+L-1))+EX
	Y5=FLOAT(INFO(L+K))+Y
	CALL PNT3D(X4,Y5,Z,,0-LASTIN)
	X6=FLOAT(INFO(L+K+1))+EX
	Y7=FLOAT(INFO(L+K+2))+Y 
	CALL VECT3D(X6,Y7,Z,LPEN,INTENS,ITAG,ITYPE)
	CALL PNT3D(X4,Y5,Z3,,0-LASTIN)
9	CALL VECT3D(X6,Y7,Z3,LPEN,INTENS,ITAG,ITYPE) 
5	EX=EX+FLOAT(150+INFO(L))
C
C	NOW INCREMENT POINTER AND GET ANOTHER CHARACTER
C
100	I=I+1
	GOTO 1
C
C	NOW FOR THE 2-DIMENSIONAL CHARACTER SET DRAWING
C
C	RESET LAST FLAG ADDRESS
C
110	CONTINUE
115	IF(ILIST(I).EQ.0) RETURN
	ICHAR=ILIST(I)-32
	IF(ICHAR.GT.0.AND.ICHAR.LT.MAXCHR) GOTO 120
	L=1
	GOTO 150
120	L=ILOC(ICHAR)
C
C	NOW DRAW ALL THE ENDPOINTS
C
	ICHECK=2*INFO(L+2)+2
	DO 125 J=4,ICHECK,2
	X1=FLOAT(INFO(L+J-1))+EX
	Y2=FLOAT(INFO(L+J))+Y
	CALL PNT3D(X1,Y2,Z,LPEN,INTENS,ITAG,ITYPE)
125	CONTINUE
C
C	NOW DRAW THE CHARACTER OUTLINE
C
	ICHCK=4*INFO(L+1)
	DO 130 K=4,ICHCK,4
	X4=FLOAT(INFO(K+L-1))+EX
	Y5=FLOAT(INFO(K+L))+Y
	CALL PNT3D(X4,Y5,Z,,0-LASTIN)
	X6=FLOAT(INFO(K+L+1))+EX
	Y7=FLOAT(INFO(K+L+2))+Y
130	CALL VECT3D(X6,Y7,Z,LPEN,INTENS,ITAG,ITYPE)
C
C	SET UP FOR NEXT CHARACTER
C
150	I=I+1
	EX=EX+FLOAT(150+INFO(L))
	GOTO 115
      END   


      SUBROUTINE INIT3D 
C     THIS SUBROUTINE INITIALIZES THE TRANSFORMATION ARRAY  
C     TO THE IDENTITY MATRIX
      COMMON/THREED/TMATRX(4,3) 
      COMMON /LAST3D/PER,XOLD,YOLD,ZOLD 
	COMMON/REPNT/XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
      TMATRX(1,1)=1.
      TMATRX(1,2)=0.
      TMATRX(1,3)=0.
      TMATRX(2,1)=0.
      TMATRX(2,2)=1.
      TMATRX(2,3)=0.
      TMATRX(3,1)=0.
      TMATRX(3,2)=0.
      TMATRX(3,3)=1.
      TMATRX(4,1)=0.
      TMATRX(4,2)=0.
      TMATRX(4,3)=0.
      PER=1.E6  
C	INITIALIZE OTHER PARAMETERS
	LASTIN=4
	LASTAG=-1
	LASTYP=1
	LASTPN=-1
      RETURN
      END   


      SUBROUTINE PERS3D(P)  
C     THIS SUBROUTINE SETS THE PERSPECTIVE FOR THE FIGURE TO BE DRAWN   
      COMMON /LAST3D/PER,XOLD,YOLD,ZOLD 
      PER=P 
      RETURN
      END   


	SUBROUTINE PNT3D(X,Y,Z,LPEN,INTENS,ITAG,ITYPE)
C     THIS SUBROUTINE COMPUTES THE DISPLAY POSITION OF A POINT IN 3D
      COMMON /LAST3D/PER,XOLD,YOLD,ZOLD 
      COMMON/THREED/TMATRX(4,3) 
	COMMON/REPNT/ XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
      RX=X*TMATRX(1,1)+Y*TMATRX(2,1)+Z*TMATRX(3,1)+TMATRX(4,1)  
      RY=X*TMATRX(1,2)+Y*TMATRX(2,2)+Z*TMATRX(3,2)+TMATRX(4,2)  
      RZ=X*TMATRX(1,3)+Y*TMATRX(2,3)+Z*TMATRX(3,3)+TMATRX(4,3)  
C     PER IS THE PERSPECTIVE DIMENSION  
      PERT=PER-RZ   
      IF(PERT.EQ.0.)PERT=1.E-10 
      PERT=PER/PERT 
      RX=PERT*(RX-511.5)+511.5
      RY=PERT*(RY-511.5)+511.5
      XOLD=RX   
      YOLD=RY   
      ZOLD=RZ   
C	NOW SET PREVIOUS VALUES FOR INTENSITY, ETC
	IF(IADDR(LPEN)  .NE.-1) LASTPN=LPEN
	IF(IADDR(INTENS).NE.-1) LASTIN=INTENS
	IF(IADDR(ITAG)  .NE.-1) LASTAG=ITAG
	IF(IADDR(ITYPE) .NE.-1) LASTYP=ITYPE
C     A SIMPLE ONE-POINT CLIP   
	IF(RX.LT.0.0.OR.RX.GT.1023.) GOTO 1
	IF(RY.LT.0.0.OR.RY.GT.1023.) GOTO 1
	IF(RZ.GT.0.) GOTO 1
C     POINT IS EXISTING SYSTEM SOFTWARE 
	CALL POINT(RX,RY,LASTPN,LASTIN,LASTAG,LASTYP)
1	LASTIN=IABS(LASTIN)
	RETURN
      END   

	SUBROUTINE POINT(RX,RY,LPEN,INTENS,ITAG,ITYPE)
	COMMON /REPNT/ XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
	XDIF=RX-XLAST
	YDIF=RY-YLAST
	ITER=MAX0(IABS(IFIX(XDIF)/63),IABS(IFIX(YDIF)/63))
	IF(ITER.NE.0) GOTO 5
	CALL RPNT(XDIF,YDIF,LPEN,INTENS,ITAG,ITYPE)
	XLAST=RX
	YLAST=RY
	RETURN
5	FITER=FLOAT(ITER+1)
	DX=XDIF/FITER
	DY=YDIF/FITER
	XFRAC=DX-AINT(DX)
	YFRAC=DY-AINT(DY)
	XSUM=0.
	YSUM=0.
	DO 10 I=1,ITER
	XSUM=XSUM+XFRAC
	YSUM=YSUM+YFRAC
	IF(ABS(XSUM).LT.1.) GOTO 6
	DXOUT=DX+XSUM
	XSUM=XSUM-AINT(XSUM)
	GOTO 8
6	DXOUT=DX
8	IF(ABS(YSUM).LT.1.) GOTO 9
	DYOUT=DY+YSUM
	YSUM=YSUM-AINT(YSUM)
	GOTO 10
9	DYOUT=DY
10	CALL RPNT(DXOUT,DYOUT,,0-IABS(LASTIN))
15	CALL RPNT(DX+XFRAC+XSUM,DY+YFRAC+YSUM,LPEN,INTENS,ITAG,ITYPE)
20	XLAST=RX
	YLAST=RY
	RETURN
	END

      SUBROUTINE RECL3D(A)  
      DIMENSION TMATRX(12),A(12)
      COMMON /THREED/TMATRX 
C     ALLOW USER TO RELOAD TRANSFORMATION MATRIX WITH A PREVIOUSLY SAVED
C     MATRIX
      DO 10 I=1,12  
10    TMATRX(I)=A(I)
      RETURN
      END   


      SUBROUTINE ROTX3D(DEGREE) 
C     SUBROUTINE TO COMPUTE THE X ROTATIONAL TRANSFORM  
      DIMENSION ROTX(3,3)   
      COMMON/THREED/TMATRX(4,3) 
      THETA=DEGREE*.01745329
      ROTX(2,2)=COS(THETA)  
      ROTX(3,2)=SIN(THETA)  
      ROTX(2,3)=-ROTX(3,2)  
      ROTX(3,3)=ROTX(2,2)   
      T12=TMATRX(1,2)*ROTX(2,2)+TMATRX(1,3)*ROTX(3,2)   
      TMATRX(1,3)=TMATRX(1,2)*ROTX(2,3)+TMATRX(1,3)*ROTX(3,3)   
      TMATRX(1,2)=T12   
      T22=TMATRX(2,2)*ROTX(2,2)+TMATRX(2,3)*ROTX(3,2)   
      TMATRX(2,3)=TMATRX(2,2)*ROTX(2,3)+TMATRX(2,3)*ROTX(3,3)   
      TMATRX(2,2)=T22   
      T32=TMATRX(3,2)*ROTX(2,2)+TMATRX(3,3)*ROTX(3,2)   
      TMATRX(3,3)=TMATRX(3,2)*ROTX(2,3)+TMATRX(3,3)*ROTX(3,3)   
      TMATRX(3,2)=T32   
      T42=TMATRX(4,2)*ROTX(2,2)+TMATRX(4,3)*ROTX(3,2)   
      TMATRX(4,3)=TMATRX(4,2)*ROTX(2,3)+TMATRX(4,3)*ROTX(3,3)   
      TMATRX(4,2)=T42   
      RETURN
      END   


      SUBROUTINE ROTY3D(DEGREE) 
C     SUBROUTINE TO COMPUTE THE Y ROTATIONAL TRANSFORM  
      DIMENSION ROTY(3,3)   
      COMMON/THREED/TMATRX(4,3) 
      THETA=DEGREE*.01745329
      ROTY(1,1)=COS(THETA)  
      ROTY(1,3)=SIN(THETA)  
      ROTY(3,1)=-ROTY(1,3)  
      ROTY(3,3)=ROTY(1,1)   
      T11=TMATRX(1,1)*ROTY(1,1)+TMATRX(1,3)*ROTY(3,1)   
      TMATRX(1,3)=TMATRX(1,1)*ROTY(1,3)+TMATRX(1,3)*ROTY(3,3)   
      TMATRX(1,1)=T11   
      T21=TMATRX(2,1)*ROTY(1,1)+TMATRX(2,3)*ROTY(3,1)   
      TMATRX(2,3)=TMATRX(2,1)*ROTY(1,3)+TMATRX(2,3)*ROTY(3,3)   
      TMATRX(2,1)=T21   
      T31=TMATRX(3,1)*ROTY(1,1)+TMATRX(3,3)*ROTY(3,1)   
      TMATRX(3,3)=TMATRX(3,1)*ROTY(1,3)+TMATRX(3,3)*ROTY(3,3)   
      TMATRX(3,1)=T31   
      T41=TMATRX(4,1)*ROTY(1,1)+TMATRX(4,3)*ROTY(3,1)   
      TMATRX(4,3)=TMATRX(4,1)*ROTY(1,3)+TMATRX(4,3)*ROTY(3,3)   
      TMATRX(4,1)=T41   
      RETURN
      END   


	SUBROUTINE ROTZ3D(DEGREE) 
C	SUBROUTINE TO COMPUTE Z ROTATIONAL TRANSFORM  
	DIMENSION ROTZ(3,3)   
	COMMON/THREED/TMATRX(4,3) 
      THETA=DEGREE*.01745329
      ROTZ(1,1)=COS(THETA)  
      ROTZ(2,1)=SIN(THETA)  
      ROTZ(1,2)=-ROTZ(2,1)  
      ROTZ(2,2)=ROTZ(1,1)   
      T11=TMATRX(1,1)*ROTZ(1,1)+TMATRX(1,2)*ROTZ(2,1)   
      TMATRX(1,2)=TMATRX(1,1)*ROTZ(1,2)+TMATRX(1,2)*ROTZ(2,2)   
      TMATRX(1,1)=T11   
      T21=TMATRX(2,1)*ROTZ(1,1)+TMATRX(2,2)*ROTZ(2,1)   
      TMATRX(2,2)=TMATRX(2,1)*ROTZ(1,2)+TMATRX(2,2)*ROTZ(2,2)   
      TMATRX(2,1)=T21   
      T31=TMATRX(3,1)*ROTZ(1,1)+TMATRX(3,2)*ROTZ(2,1)   
      TMATRX(3,2)=TMATRX(3,1)*ROTZ(1,2)+TMATRX(3,2)*ROTZ(2,2)   
      TMATRX(3,1)=T31   
      T41=TMATRX(4,1)*ROTZ(1,1)+TMATRX(4,2)*ROTZ(2,1)   
      TMATRX(4,2)=TMATRX(4,1)*ROTZ(1,2)+TMATRX(4,2)*ROTZ(2,2)   
      TMATRX(4,1)=T41   
      RETURN
      END   


      SUBROUTINE SAVE3D(A)  
      DIMENSION TMATRX(12),A(12)
      COMMON /THREED/TMATRX 
C    ALLOW USER TO SAVE A TRANSFORMATION MATRIX 
      DO 10 I=1,12  
10    A(I)=TMATRX(I)
      RETURN
      END   


      SUBROUTINE SCAL3D(SX,SY,SZ)   
C     SUBROUTINE TO CONCATENATE SCALING PARAMETERS WITH TRANSFORM ARRAY 
      COMMON/THREED/TMATRX(4,3) 
      TMATRX(1,1)=TMATRX(1,1)*SX
      TMATRX(2,1)=TMATRX(2,1)*SX
      TMATRX(3,1)=TMATRX(3,1)*SX
      TMATRX(4,1)=TMATRX(4,1)*SX
      TMATRX(1,2)=TMATRX(1,2)*SY
      TMATRX(2,2)=TMATRX(2,2)*SY
      TMATRX(3,2)=TMATRX(3,2)*SY
      TMATRX(4,2)=TMATRX(4,2)*SY
      TMATRX(1,3)=TMATRX(1,3)*SZ
      TMATRX(2,3)=TMATRX(2,3)*SZ
      TMATRX(3,3)=TMATRX(3,3)*SZ
      TMATRX(4,3)=TMATRX(4,3)*SZ
      RETURN
      END   


      SUBROUTINE TRAN3D(TX,TY,TZ)   
C     SUBROUTINE TO CONCATENATE TRANSLATION PARAMETERS WITH TRANS ARRAY 
      COMMON/THREED/TMATRX(4,3) 
      TMATRX(4,1)=TMATRX(4,1)+TX
      TMATRX(4,2)=TMATRX(4,2)+TY
      TMATRX(4,3)=TMATRX(4,3)+TZ
      RETURN
	END   


	SUBROUTINE VECT3D(X,Y,Z,LPEN,INTENS,ITAG,ITYPE)
C
C     3 DIMENSIONAL VECTOR ROUTINE
C
C     THIS ROUTINE UTLIZES ROBERT'S 3-D CLIPPING ALGORITHM,DESCRIBED
C     IN NEUMANN AND SPROUL,PGS 291-293. BRIEFLY,IT DETERMINES WHETHER A
C     TRANSFORMED VECTOR SHOULD BE DISPLAYED OR NOT,AND IF SO,WHERE IT
C     SHOULD BE CLIPPED SO THAT THERE IS NO WRAP-AROUND.THE VIEWPORT IS
C     DEFINED TO BE THE ENTIRE 1023 PIXEL WIDTH OF THE GT-46 SCREEN.
C     DEVELOPED AND SUBMITTED FOR COMPUTER GRAPHICS BY GREG FUNK,
C     IN CONJUNCTION WITH THE REST OF THE MEMBERS OF GROUP 2,SPRING 1978
C
C
	COMMON/THREED/TMATRX(4,3)
	COMMON /LAST3D/PER,X1,Y1,Z1
	COMMON/REPNT/XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
C
C
C	X1,Y1,X1 ARE THE CO-ORDINATES FOR THE FIRST ENDPOINT,PASSED
C	FROM PNT3D. X2,Y2,Z2 ARE THE TRANSFORMED CO-ORDINATES FOR THE 
C	SECOND ENDPOINT.X3,Y3,Z3 ARE THE DIFFERANCE BETWEEN THESE
C	ENDPOINTS.
C
	X2=X*TMATRX(1,1)+Y*TMATRX(2,1)+Z*TMATRX(3,1)+TMATRX(4,1)  
	Y2=X*TMATRX(1,2)+Y*TMATRX(2,2)+Z*TMATRX(3,2)+TMATRX(4,2)  
	Z2=X*TMATRX(1,3)+Y*TMATRX(2,3)+Z*TMATRX(3,3)+TMATRX(4,3)  
C
C     PER IS THE Z PERSPECTIVE VIEWPOINT
C
	PERT=PER-Z2   
	IF(PERT.EQ.0.) PERT=1.E-10  
C
C     THE OBJECT IS MAGNIFIED SO FOR ANY VALUE OF PER AN OBJECT DRAWN   
C     WITH A Z VALUE OF 0 WILL REMAIN THE SAME SIZE 
C
      PERT=PER/PERT 
      X2=PERT*(X2-511.5)+511.5
      Y2=PERT*(Y2-511.5)+511.5
      X3=X1-X2  
      Y3=Y1-Y2  
      Z3=Z1-Z2  
C
C     SET INITIAL VALUES
C
      XMIN=0.   
      XMAX=1.   
      IF(X3.EQ.0.)X3=1.E-10  
      T1=(0.-X2)/X3
      T2=(X2-1023.)/(0.-X3)
      IF(X3.LT.0.) GO TO 10  
C   
C     THE T VALUES ARE THE MODIFYING PARAMETERS 
C     THESE MUST TAKE ON A VALUE BETWEEN ZERO AND ONE   
C
      IF(T1.GT.XMIN) XMIN=T1
      IF(T2.LT.XMAX)XMAX=T2 
      GO TO 20  
 10   IF(T1.LT.XMAX)XMAX=T1 
      IF(T2.GT.XMIN)XMIN=T2 
20    IF(Y3.EQ.0.)Y3=1.E-10  
      T1=(0.-Y2)/Y3
      T2=(Y2-1023.)/(0.-Y3)   
      IF(Y3.LT.0.) GO TO 30  
      IF(T1.GT.XMIN)XMIN=T1 
      IF(T2.LT.XMAX)XMAX=T2 
      GO TO 40  
 30   IF(T1.LT.XMAX) XMAX=T1
      IF(T2.GT.XMIN) XMIN=T2
40    IF(Z3.EQ.0.)Z3=1.E-10  
      T1=Z2/(0.-Z3)   
      IF(Z3.LT.0.) GO TO 50  
      IF(T1.LT.XMAX) XMAX=T1
      GO TO 60  
50    IF(T1.GT.XMIN)XMIN=T1 
C     XMIN MUST BE LESS THAN XMAX   
60	CONTINUE
	IF(IADDR(LPEN)  .NE.-1) LASTPN=LPEN
	IF(IADDR(INTENS).NE.-1) LASTIN=INTENS
	IF(IADDR(ITAG)  .NE.-1) LASTAG=ITAG
	IF(IADDR(ITYPE) .NE.-1) LASTYP=ITYPE
C
	IF(XMIN.GT.XMAX) GO TO 70 
C   
C     X4,Y4,Z4 ARE THE COORDINATES FOR THE NEW,CLIPPED ENDPOINT.
      X4=X2+XMAX*X3 
      Y4=Y2+XMAX*Y3 
      Z4=Z2+XMAX*Z3 
C   
C     X5,Y5, AND Z5 COORESPOND TO THE SECOND ENDPOINT.  
      X5=X2+XMIN*X3 
      Y5=Y2+XMIN*Y3 
      Z5=Z2+XMIN*Z3 
C   
C     POINT AND VECTOR UTILIZE EXISTING SYSTEM SOFTWARE.
	CALL POINT(X4,Y4,,0-IABS(LASTIN))
	CALL VECTOR(X5,Y5,LASTPN,LASTIN,LASTAG,LASTYP)
 70   X1=X2 
      Y1=Y2 
      Z1=Z2 
	LASTIN=IABS(LASTIN)
      RETURN
      END   


	SUBROUTINE VECTOR(X,Y,LPEN,INTENS,ITAG,ITYPE)
	COMMON /REPNT/ XLAST,YLAST,LASTPN,LASTIN,LASTAG,LASTYP
C
C	COMPUTE THE RELATIVE LOCATION ON THE SCREEN
C
	DX=X-XLAST
	DY=Y-YLAST
	CALL VECT(DX,DY,LPEN,INTENS,ITAG,ITYPE)
	XLAST=X
	YLAST=Y
	RETURN
	END
 