#define _UPPER 1
#define _LOWER 2
#define _NUMBER 4
#define _SPACE	8
#define _PUNCT	16
#define _CNTRL	32
#define _HEX	64
#define _BLANK	128

extern unsigned char _ctype[256];
#if 0	/* Here are the contents of this external array: */
= {
   _CNTRL, /* \0 */
   _CNTRL, /* \001 */
   _CNTRL, /* \002 */
   _CNTRL, /* \003 */
   _CNTRL, /* \004 */
   _CNTRL, /* \005 */
   _CNTRL, /* \006 */
   _CNTRL, /* \007 - bell */
   _CNTRL, /* \b - backspace */
   _CNTRL | _SPACE, /* \t - horizontal tab */
   _CNTRL | _SPACE, /* \n - newline (linefeed) */
   _CNTRL | _SPACE, /* \v - vertical tab */
   _CNTRL | _SPACE, /* \f - form feed */
   _CNTRL | _SPACE, /* \r - carriage return */
   _CNTRL, /* \016 */
   _CNTRL, /* \017 */
   _CNTRL, /* \020 */
   _CNTRL, /* \021 */
   _CNTRL, /* \022 */
   _CNTRL, /* \023 */
   _CNTRL, /* \024 */
   _CNTRL, /* \025 */
   _CNTRL, /* \026 */
   _CNTRL, /* \027 */
   _CNTRL, /* \030 */
   _CNTRL, /* \031 */
   _CNTRL, /* \032 */
   _CNTRL, /* \033 */
   _CNTRL, /* \034 */
   _CNTRL, /* \035 */
   _CNTRL, /* \036 */
   _CNTRL, /* \037 */
   _SPACE | _BLANK, /* ' ' (space) */
   _PUNCT, /* '!' */
   _PUNCT, /* '"' */
   _PUNCT, /* '#' */
   _PUNCT, /* '$' */
   _PUNCT, /* '%' */
   _PUNCT, /* '&' */
   _PUNCT, /* ''' a single quote */
   _PUNCT, /* '(' */
   _PUNCT, /* ')' */
   _PUNCT, /* '*' */
   _PUNCT, /* '+' */
   _PUNCT, /* ',' */
   _PUNCT, /* '-' */
   _PUNCT, /* '.' */
   _PUNCT, /* '/' */
   _NUMBER, /* '0' */
   _NUMBER, /* '1' */
   _NUMBER, /* '2' */
   _NUMBER, /* '3' */
   _NUMBER, /* '4' */
   _NUMBER, /* '5' */
   _NUMBER, /* '6' */
   _NUMBER, /* '7' */
   _NUMBER,/* '8' */
   _NUMBER,/* '9' */
   _PUNCT, /* ':' */
   _PUNCT, /* ';' */
   _PUNCT, /* '<' */
   _PUNCT, /* '=' */
   _PUNCT, /* '>' */
   _PUNCT, /* '?' */
   _PUNCT, /* '@' */
   _UPPER | _HEX, /* 'A' */
   _UPPER | _HEX, /* 'B' */
   _UPPER | _HEX, /* 'C' */
   _UPPER | _HEX, /* 'D' */
   _UPPER | _HEX, /* 'E' */
   _UPPER | _HEX, /* 'F' */
   _UPPER, /* 'G' */
   _UPPER, /* 'H' */
   _UPPER, /* 'I' */
   _UPPER, /* 'J' */
   _UPPER, /* 'K' */
   _UPPER, /* 'L' */
   _UPPER, /* 'M' */
   _UPPER, /* 'N' */
   _UPPER, /* 'O' */
   _UPPER, /* 'P' */
   _UPPER, /* 'Q' */
   _UPPER, /* 'R' */
   _UPPER, /* 'S' */
   _UPPER, /* 'T' */
   _UPPER, /* 'U' */
   _UPPER, /* 'V' */
   _UPPER, /* 'W' */
   _UPPER, /* 'X' */
   _UPPER, /* 'Y' */
   _UPPER, /* 'Z' */
   _PUNCT, /* '[' */
   _PUNCT, /* '\' */
   _PUNCT, /* ']' */
   _PUNCT, /* '^' */
   _PUNCT, /* '_' */
   _PUNCT, /* '`' */
   _LOWER | _HEX, /* 'a' */
   _LOWER | _HEX, /* 'b' */
   _LOWER | _HEX, /* 'c' */
   _LOWER | _HEX, /* 'd' */
   _LOWER | _HEX, /* 'e' */
   _LOWER | _HEX, /* 'f' */
   _LOWER, /* 'g' */
   _LOWER, /* 'h' */
   _LOWER, /* 'i' */
   _LOWER, /* 'j' */
   _LOWER, /* 'k' */
   _LOWER, /* 'l' */
   _LOWER, /* 'm' */
   _LOWER, /* 'n' */
   _LOWER, /* 'o' */
   _LOWER, /* 'p' */
   _LOWER, /* 'q' */
   _LOWER, /* 'r' */
   _LOWER, /* 's' */
   _LOWER, /* 't' */
   _LOWER, /* 'u' */
   _LOWER, /* 'v' */
   _LOWER, /* 'w' */
   _LOWER, /* 'x' */
   _LOWER, /* 'y' */
   _LOWER, /* 'z' */
   _PUNCT, /* '{' */
   _PUNCT, /* '|' */
   _PUNCT, /* '}' */
   _PUNCT, /* '~' */
   _CNTRL /* \177 */
   };
#endif

#define isupper(c)	(_ctype[(c) & 0XFF] & _UPPER)
#define islower(c)	(_ctype[(c) & 0XFF] & _LOWER)
#define isalpha(c)	(_ctype[(c) & 0XFF] & (_UPPER | _LOWER))
#define isdigit(c)	(_ctype[(c) & 0XFF] & _NUMBER)
#define isxdigit(c)	(_ctype[(c) & 0XFF] & (_NUMBER | _HEX))
#define isspace(c)	(_ctype[(c) & 0XFF] & _SPACE)
#define ispunct(c)	(_ctype[(c) & 0XFF] & _PUNCT)
#define isalnum(c)	(_ctype[(c) & 0XFF] & (_UPPER | _LOWER | _NUMBER))
#define isgraph(c)	(_ctype[(c) & 0XFF] & (_UPPER | _LOWER | _NUMBER | _PUNCT))
#define isprint(c)	(_ctype[(c) & 0XFF] & (_UPPER | _LOWER | _NUMBER | _PUNCT | _BLANK))
#define iscntrl(c)	(_ctype[(c) & 0XFF] & _CNTRL)
#define isascii(c)	((unsigned) (c) <= 0177)
#define _toupper(c)	((c) - 'a' + 'A')
#define _tolower(c)	((c) - 'A' + 'a')
#define toupper(c)	(islower(c) ? _toupper(c) : (c))
#define tolower(c)	(isupper(c) ? _tolower(c) : (c))

/* _isodigit is not ANSI Standard.  */
#define _isodigit(c) ((unsigned int)(((c)&0xFF) - '0') <= 7)
