;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpSb.asm                                                            *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/08/89 120E/02 T. Ball      / changed pbcb's to sb's for msg file       *;
;* 10/23/89 120D/01 T. Ball      / added sbBkgColor                          *;
;* 08/28/89 120C/00 P. Campbell  / Master -> Server, Server -> Service       *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

DGroup group SbSeg
assume ds: DGroup

SbSeg segment word public 'data'

%out(
)

%*define (DefineSb(name, "text", maxlen ))
(%'
	public sb%name
%if (%Len(%text) gt %maxlen) then (
%out(WARNING:  sb%name too long, truncated.
)
sb%name	db	%maxlen, '%Substr(%text,1,%maxlen)'
)
else (
%out(sb%name
)
sb%name	db	%Len(%text), '%text'
	%if (%Len(%text) lt %maxlen) then
		(db  %eval(%maxlen - %Len(%text)) dup (?))
	fi%'
)
fi%'
)%'

; The following text describes the nationalization filespec.
; DO NOT CHANGE.
%DefineSb(NatlFile,   "[Sys]<Sys>EditorMsg.sys",    23)

; The following text strings are overridden by NLS.sys CtosLib table
; DO NOT CHANGE.
%DefineSb(OldSuffix,  "-Old",                        4)
%DefineSb(UserSuffix, ".user",                       5)


;------------------
; sb definitions:  WARNING -- do not change the maxlen fields.
;------------------

; Program name includes space as version string follows it

%DefineSb(Herald,        "Editor ",                 20)


; parameter names and values in .user file

%DefineSb(DfltOpenMode,  "EditorOpenMode",          30)
%DefineSb(DfltTabLength, "EditorTabLength",         30)
%DefineSb(AutoIndent,    "EditorAutoIndent",        30)
%DefineSb(UseWildCards,  "EditorUseWildcards",      30)
%DefineSb(LineMapping,   "EditorLineMapping",       30)
%DefineSb(NormalColor,   "EditorNormalColor",       30)
%DefineSb(HbColor,       "EditorHalfBrightColor",   30)
%DefineSb(BkgColor,      "EditorBackgroundColor",   30)


; temporary files on local scratch vol/dir

%DefineSb(TmpDir,     "[Scr]<$>",                   28)
%DefineSb(WpDir,      "[Scr]<$>EditorDir.tmp",      50)
%DefineSb(WpVol,      "[Scr]<$>EditorVol.tmp",      50)
%DefineSb(WpStatus,   "[Scr]<$>EditorStat.tmp",     50)
%DefineSb(WpScr,      "[Scr]<$>Editor.tmp",         50)


; typescript goes on local scratch volume

%DefineSb(TsDir,      "",                           28)
%DefineSb(TsSuffix,   ".Editor.ts",                 20)

%DefineSb(NewSuffix,           "-New",              10)

; .user file
%DefineSb(UserDir,             "[Sys]<Sys>",        28)

; status line text
%DefineSb(Path,                "Path:",             20)
%DefineSb(AttentionMail,       "Mail",              20)
%DefineSb(AttentionUrgentMail, "Urgent Mail",       40)
%DefineSb(Calls,               "Calls",             20)
%DefineSb(MasterDown,          "Server down",       40)
%DefineSb(MasterGoingDown,     "SERVER GOING DOWN", 40)


; local and master node synonyms:
; NOTE: do not change these names for internationalization
;       unless you have changed the names in CTOS
%DefineSb(LocalNode,           "Local",             12)
%DefineSb(MasterNode,          "Master",            12)


; directory list and volume status text

%DefineSb(DirDetailsDoc,       "Filename",          20)
%DefineSb(DirDetailsLen,       "Length",            20)
%DefineSb(DirDetailsSec,       "Sectors",           20)
%DefineSb(DirDetailsCre,       "Created",           20)
%DefineSb(DirDetailsRev,       "Revised",           20)
%DefineSb(DirDetailsAcc,       "Accessed",          20)

; the following strings are appended to each other -- adjust padding as needed
%DefineSb(DirTotalFiles,       "Number of files:                ",  40)
%DefineSb(DirSpaceUsed,        "Space used:                     ",  40)
%DefineSb(DirSectors,          " sector(s)   ",                     20)
%DefineSb(DirKBytes,           "k bytes",                           20)
%DefineSb(VolSpaceLeft,        "Space left on volume:           ",  40)
%DefineSb(VolFhbsLeft,         "File headers free:              ",  40)

; List Open Files strings
%DefineSb(OpenFiles,           "Open Files",        20)
%DefineSb(DirStatus,           "Status",            20)
%DefineSb(DirMode,             "Open Mode",         20)
%DefineSb(StatusClean,         "Unchanged",         20)
%DefineSb(StatusDirty,         "Changed",           20)
%DefineSb(StatusDeleted,       "Deleted",           20)
%DefineSb(ModeModify,          "Modify",            20)
%DefineSb(ModeRead,            "Read",              20)

; Line Mapping modes
%DefineSb(LfMode,              "LF",                8)
%DefineSb(CrLfMode,            "CRLF",              8)

SbSeg ends

end
