;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpCnfgHB.asm                                                        *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:  help for menus defined in WpCnfgB.asm                       *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/25/90 120F/03 T. Ball      / More Pubs changes                         *;
;* 01/16/89 120F/02 T. Ball      / Cleaned up wording per Pubs               *;
;* 12/07/89 120E/01 T. Ball      / Fixed BlockCheck typo.                    *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpCnfgHB.asm -- help for menus defined in WpCnfgB.asm

$include(WpKbd.mdf)
$include(WpCmid.mdf)
$include(WpCmdd.mdf)
$include(WpMsg.mdf)
$include(WpCnfg.mdf)


extrn cmidDspHelp: abs


DGroup group CmidSeg, CmddSeg, MenuSeg
assume ds: DGroup


%DefineMenu(cmidSearchHelp, iCmrDisplayHelpMenu, false, 22,
~ SEARCH HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Search command is used to search for a string of one or more characters within a file.  The search begins at the cursor position.  If you press Go, it continues to the end of the file until a successful match is found.  If you press CODE-GO, the Editor searches backwards to the beginning of the file.

Search string:  Enter the string of characters you want to find.  If the 
	Expand wildcards? option is set to Yes, a question mark (?) will match on 
	any single character, while an asterisk (*) will match on any range of 
	characters in a manner similar to the filename wildcarding used by the 
	Executive.

	If you want to search for either of these characters as part of a wildcard 
	string, type a single quote before the character.

Search using string:  Depending on whether you choose 1, 2, or Both for this 
	option, the Editor searches using either or both of the search strings 
	specified.

Check caps?:  If you choose Yes, the Editor finds only those occurrences of 
	the string with capitalization exactly matching the search string(s).

Select?:  If you choose Yes, when it finds a match for the search string the 
	Editor highlights the matched text.  If you choose No, the Editor moves 
	the cursor after the matched text, but does not highlight it.

Ignore embedded match?:  If you choose Yes, the Editor does not match on a 
	part of a larger word.  For example, searching for the string For would 
	not match on the word Form if this option is selected.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidReplaceHelp, iCmrDisplayHelpMenu, false, 22,
~ REPLACE HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Replace command searches for a specific string of characters and replaces 
it with another character string.  You can search an entire document or only a 
selection.

Search for:  Enter the string of characters you want to find.  Unlike the 
	Search function, wildcard characters cannot be expanded, so all search 
	string characters are treated literally.

Replace with:  Enter the characters you want to use for replacement.

Check caps while searching?:  If you choose Yes, the Editor finds only those 
	occurrences of the string with capitalization exactly matching the search 
	string.

Alter caps of replacement?:  If you choose Yes, the Editor modifies the 
	replacement string to match the capitalization of the text being replaced.
	Choose No to leave the replacement string unmodified.

Confirm each?:  Choose Yes if you want the search to stop and wait for your 
	confirmation before carrying out each replacement.  Choose No if you want 
	all instances of the string replaced without pause.

Ignore embedded match?:  If you choose Yes, the Editor does not match on a 
	part of a larger word.  For example, searching for the string For would 
	not match on the word Form if this option is selected.  This feature is 
	recommended as an alternative to Confirm each if you are globally 
	replacing a string that is likely to be part of other words.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidGotoLineHelp, iCmrDisplayHelpMenu, false, 7,
~ GO TO SOURCE LINE HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Go to Source Line command moves the cursor to a specific line number in a
file.  Source code listings often include the line number when reporting
errors.

Line number:  Enter the number of the desired line.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidBlkChkHelp, iCmrDisplayHelpMenu, false, 22,
~ BLOCK CHECK HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Block Check command is used to verify beginning and end delimiters in a
source code file.  You can verify either a whole file or a selection inside it.
If comment delimiters are specified, beginning and end delimiters inside a
comment are ignored.  Block Check string matching is not case-sensitive.

Block start:  One or more beginning block delimiters.  These can be words, 
	such as the Pascal BEGIN statement, or they may be characters, such as the 
	C block start character { or a left parenthesis.  If a block can begin 
	with more than one type of block delimiter, all starting delimiters can be 
	entered, separated by a space or comma.  For example, PL/M can start a 
	block with either a PROCEDURE statement or a DO statement.

Block end:  One or more ending block delimiters.  These can be words, such as 
	the Pascal END statement, or characters such as the C block end character 
	} or a right parenthesis.

Comment start:  The character string used to indicate the start of a comment.

Comment end:  The character string used to indicate the end of a comment.  If 
	nothing is specified in this field, the comment is assumed to continue to 
	the end of the current line.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidWindowsHelp, iCmrDisplayHelpMenu, false, 22,
~ WINDOW COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Editor supports multiple windows into one or more files.  Each of these
windows can be displayed concurrently on the screen, separated by a window bar,
in what is called a Tiled Window display.  The Tiled Window display is the 
default display.  Alternately, each window may occupy the full screen; this is 
called a Full Window display.  Windows are created by the Open File, List 
Directory Files, Volume Status, and List Opened Files commands.

Press F for Full window display    Press D for Divide window (CODE/D)
      T     Tiled window display         C     Close window (CODE/C)
      H     Hexadecimal display          P     Previous window (CODE/NUMERIC -)
      V     Change visibility            N     Next window (CODE/NEXT)

Full window display:  Press F to select Full Window display.

Tiled window display:  Press T to select Tiled Window display.

Hexadecimal display:  Press H to change the window text display between normal 
	and hexadecimal display.  This command can also be invoked using CODE-H.

Change visibility:  Press V to view formatting characters, such as tabs, 
	spaces, end-of-line, and formfeed characters.  This command can also be 
	invoked using CODE-V.

Divide window:  Press D to split the window containing the cursor into two 
	equal sized windows into the same file.  This command can also be invoked 
	using CODE-D.

Close window:  Press C to close the window containing the cursor.  This 
	command can also be invoked using CODE-C.

Previous window:  Press P to move the cursor to the top of the previous 
	window.  This command can also be invoked using CODE-numeric hyphen.

Next window:  Press N to move the cursor to the top of the next window.  
	This command can also be invoked using CODE-NEXT.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidDefaultsHelp, iCmrDisplayHelpMenu, false, 22,
~ SET DEFAULTS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Set Defaults command allows you to tailor certain Editor defaults to your 
needs.  Each of these defaults can be made permanent by storing them in your 
.user file.  If you have a color display, use the Display Colors menu to set 
the color defaults.

New tab length:  Unlike Word Processors, the Editor uses fixed length tabs.  
	The current tab length is displayed, and can be overridden by entering the 
	desired tab length in this field. Changing the value of the tab length has 
	no effect on the file itself, only the manner in which it is displayed.  
	The user file option name is :EditorTabLength:.

Open file mode:  When a file is opened using the Open File command, the 
	default value for the Allow Changes field can be changed by changing the 
	open file mode.  Specifying Modify sets the Allow Changes field to Yes, 
	while specifying Read sets the Allow Changes field to No.  The user file 
	option is :EditorOpenMode:.

Autoindent mode:  You turn the autoindention feature on or off with this 
	default.  When autoindention is turned on, pressing RETURN causes the tabs 
	and spaces at the beginning of the previous line to be copied to the 
	current line. SHIFT-RETURN inserts a Return without autoindention.  The 
	user file option is :EditorAutoIndent:.

Use wildcards default:  The default of the Expand Wildcard field of the Search 
	command can be changed here. Changing this default also changes whether 
	wildcard expansion occurs with Look For strings in the List Files 
	command.  The user file option is :EditorUseWildcards:.

Line mapping mode:  CTOS uses a linefeed (LF) character to end a text line.  
	DOS uses a carriage-return (CR) followed by a linefeed to end text lines.
	Choose CrLf if editing a file created under DOS; otherwise, use the 
	default Lf option for normal CTOS editing.

Save to user file:  Choose Yes to update the user file with the specified 
	defaults.  This makes the specified defaults permanent for future Editor 
	sessions.  Choose No to change the defaults for the current Editor session
	only.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidMarkBlkHelp, iCmrDisplayHelpMenu, false, 22,
~ MARK BLOCK HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Mark Block command is used to select and highlight text from the beginning 
to the end of a block in a source code file.  If comment delimiters are 
specified, beginning and end delimiters inside a comment are ignored.  Mark 
Block string matching is not case-sensitive.

A second Mark Block command (or Redo) selects the block beginning with the 
next Block Start delimiter in the source file.  A Bound command selects the 
previous level of nesting for the selected block.  If the block currently 
selected is at the outermost nesting level, subsequent Bound commands do 
nothing.

Block start:  One or more beginning block delimiters.  These can be words, 
	such as the Pascal BEGIN statement, or they can be characters, such as the 
	C block start character { or a left parenthesis.  If a block can begin 
	with more than one type of block delimiter, all starting delimiters can be 
	entered, separated by a space or comma.  For example, PL/M can start a 
	block with either a PROCEDURE statement or a DO statement.

Block end:  One or more ending block delimiters.  These can be words, such as 
	the Pascal END statement, or characters such as the C block end character 
	} or a right parenthesis.

Comment start:  The character string used to indicate the start of a comment.

Comment end:  The character string used to indicate the end of a comment.  If 
	nothing is specified in this field, the comment is assumed to continue to 
	the end of the current line.
~,
~
<idParTitle> <idMsg, typSysBlank> <idMsg> <idParPlace>
<idParMenuHelp> <idNil, typProtected or maskfRev or maskfHb> <>
~,
~
<chHelp, cmidDspHelp>
~)%'


end; WpCnfgH.asm
