/****************************** INCLUDE HEADER (.H)***************************/
/*                                                                           */
/* INCLUDE FILE: ExRqBlk.h                                                   */
/*                                                                           */
/* MACHINE: B20        LANGUAGE: METAWARE C V1.0  OS: BTOS                   */
/*                                                                           */
/* DESCRIPTION: Header for procedural interface definitions of example Rqs.  */
/*                                                                           */
/*                                                                           */
/* HISTORY:                                                                  */
/*                                                                           */
/* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) */
/*                                                                           */
/* 12/03/89 120E/01 S. Emmons    / Changed C typing to CTOS-based typing.    */
/*                                                                           */
/*                                                                           */
/* TITLE:  BTOS SYSTEM SOFTWARE                                              */
/*                                                                           */
/*            PROPRIETARY PROGRAM MATERIAL                                   */
/*                                                                           */
/* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       */
/* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   */
/* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            */
/* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                */
/*                                                                           */
/*                                                                           */
/* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPROATED. ALL RIGHTS RESERVED     */
/* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          */
/* ************************************************************************* */
/*                                                                           */
/* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      */
/* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      */
/* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        */
/* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   */
/* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         */
/* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 */
/*                                                                           */
/* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      */
/* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        */
/* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           */
/*                                                                           */
/*                                                                           */
/*************************** END OF MODULE HEADER ****************************/
#if defined(AbortExampleType) || defined(All)
#undef AbortExampleType
typedef struct { 
	RqHeaderType	rqhdr;
	Word 			wErc
}	AbortExampleType;
#endif

#if defined(ChangeUserNumExampleType) || defined(All)
#undef ChangeUserNumExampleType
typedef struct { 
	RqHeaderType	rqhdr;
	Word			wOldUserNum
}	ChangeUserNumExampleType;
#endif

#if defined(DeinstallExampleType) || defined(All)
#undef DeinstallExampleType
typedef struct { 
	RqHeaderType	rqhdr;
	Word			*pPhRet;
	Word			sPhMax
}	DeinstallExampleType;
#endif

#if defined(OpenFileType) || defined(All)
#undef OpenFileType
typedef struct { 
	RqHeaderType	rqhdr;
	Byte			res12[2];
	Word			mode;
	Byte			res16[2];
	Pointer			pbFileSpec;
	Word			cbFileSpec;
	Pointer			pbPassword;
	Word			cbPassword;
	Pointer			pFhRet;
	Word			sFhMax
}	OpenFileType;
#endif

#if defined(OpenFileLLType) || defined(All)
#undef OpenFileLLType
typedef struct { 
	RqHeaderType	rqhdr;
	Byte			res12[2];
	Word 			mode;
	Byte 			res16[2];
	Pointer			pbFileSpec;
	Word 			cbFileSpec;
	Pointer			pbPassword;
	Word 			cbPassword;
	Pointer			pFhRet;
	Word 			sFhMax
}	OpenFileLLType;
#endif

#if defined(ReOpenFileType) || defined(All)
#undef ReOpenFileType
typedef struct { 
	RqHeaderType	rqhdr;
	Byte			res12[2];
	Word			mode;
	Byte			res16[2];
	Pointer			pbFileSpec;
	Word			cbFileSpec;
	Pointer			pbPassword;
	Word			cbPassword;
	Pointer			pFhRet;
	Word			sFhMax
}	ReOpenFileType;
#endif

#if defined(StartRecordType) || defined(All)
#undef StartRecordType
typedef struct { 
	RqHeaderType	rqhdr
}	StartRecordType;
#endif

#if defined(StopRecordType) || defined(All)
#undef StopRecordType
typedef struct { 
	RqHeaderType	rqhdr
}	StopRecordType;
#endif

#if defined(SwapExampleType) || defined(All)
#undef SwapExampleType
typedef struct { 
	RqHeaderType	rqhdr;
	Word			wErc
}	SwapExampleType;
#endif

#if defined(TerminateExampleType) || defined(All)
#undef TerminateExampleType
typedef struct { 
	RqHeaderType	rqhdr;
	Word			wErc
}	TerminateExampleType;
#endif

#undef All                      