/*
 * Convergent Technologies
 *
 * Dec 17, 1984  MEC  Created
 *
 * This is more restrictive than the System 5 version:
 *
 *    -- Cannot declare any arguments before va_alist.
 *    -- Va_end changes addresses of locals and arguments.
 *       Any pointers holding these addresses thus become invalid.
 */

#ifdef lint
#define va_alist		fake_argument
#define va_dcl			va_list fake_argument;
#else
#define va_alist		/* NULL */
#define va_dcl			/* NULL */
#endif
#define va_start(ap)		((ap) = _va_start())
#define va_arg(ap, type)	(*( (type *) _va_arg(&(ap), sizeof(type)) ))
#define va_end(ap)		(_va_end())

typedef char *va_list;
va_list _va_start();
va_list _va_arg();
