/* 
	Copyright 1989, 1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in an XVT 
	user's application.

	url.h - header that defines all default resources (dialogs, menus,
           about box, accelerators, ...) and resource file preamble.

	Last Date Modified: 10/28/90
*/

/* System specific resource file preamble */

#define NO_INCLUDES
#scan "xvt.h"

#ifdef NO_STD_FILE_MENU
#define NO_FILE  1
#else
#define NO_FILE 0
#endif

#ifdef NO_STD_EDIT_MENU
#define NO_EDIT 1
#else
#define NO_EDIT 0
#endif

#if  (NO_FILE) && (NO_EDIT)
#else
#include "xvtmenu.h"		/* standard XVT menu tags */
#endif

/****************/
/* WS PREAMBLE  */
/****************/
#if XVTWS == WINWS

#ifndef APPNAME
#define APPNAME xvtapp
#endif

#ifndef QAPPNAME
#define QAPPNAME "xvtapp"
#endif

#ifndef LIBDIR
#define LIBDIR .\..\lib
#endif

#endif

/****************/
/* PM PREAMBLE  */
/****************/
#if XVTWS == PMWS

#ifndef APPNAME
#define APPNAME xvtapp
#endif

#ifndef QAPPNAME
#define QAPPNAME "xvtapp"
#endif


#ifndef LIBDIR
#if XVTOS == CTOOS
#define LIBDIR [Sys]<Xvt2.0>Resources
#else
#define LIBDIR .\..\lib
#endif
#endif

#endif

/****************/
/* MAC PREAMBLE */
/****************/
#if XVTWS == MACWS
#transparent $$$
PROJECT.rsrc
$$$

#ifndef NO_STD_BUNDLE
#transparent $$$

***************************************************************
**************
* Bundle resource
***************************************************************
**************
type CCCC = STR 
    ,0 (0)
XVT Application

type BNDL
	,999 (0)
CCCC 0
ICN#
0 999
FREF
0 999

type FREF
	,999 (0)
APPL 0

$$$
#else
#transparent $$$

$$$
#endif
#endif

/****************/
/* MTF PREAMBLE */
/****************/
#if XVTWS == MTFWS
#define MENU10				2560 +
#define MENU11				2816 +
#define M_FONT				MAKE_MENU_TAG(MENU10, 0)
#define M_FONT_COURIER		MAKE_MENU_TAG(MENU10, 1)
#define M_FONT_HELVETICA	MAKE_MENU_TAG(MENU10, 2)
#define M_FONT_TIMES		MAKE_MENU_TAG(MENU10, 3)
#define M_FONT_SYSTEM		MAKE_MENU_TAG(MENU10, 4)
#define M_FONT_FIXED		MAKE_MENU_TAG(MENU10, 5)
#define M_STYLE				MAKE_MENU_TAG(MENU11, 0)
#define M_STYLE_NORMAL		MAKE_MENU_TAG(MENU11, 1)
#define M_STYLE_BOLD		MAKE_MENU_TAG(MENU11, 2)
#define M_STYLE_ITALIC		MAKE_MENU_TAG(MENU11, 3)
#define M_STYLE_SEP1		MAKE_MENU_TAG(MENU11, 4)
#define M_STYLE_8			MAKE_MENU_TAG(MENU11, 5)
#define M_STYLE_10			MAKE_MENU_TAG(MENU11, 6)
#define M_STYLE_12			MAKE_MENU_TAG(MENU11, 7)
#define M_STYLE_14			MAKE_MENU_TAG(MENU11, 8)
#define M_STYLE_18			MAKE_MENU_TAG(MENU11, 9)
#define M_STYLE_24			MAKE_MENU_TAG(MENU11, 10)

#ifdef XSIGHT
#transparent $$$

module APPL1
	names = case_sensitive

include file 'XmAppl.uil';

value
! resource IDs
   XVT_9101		: exported 'hlp';

! quick fix to get Font and Style symbols defined
! really need to include or scan a private header file which contains these
! define constants, currently these are defined in xmimp.h, but scanning it
! pulls into much, it trys to bring all the other headers from Xm etc.

! new line "macro" for creating multi-line strings
    NL			: compound_string('', separate = true);

procedure
    xvt_create_dlg(integer);
    xvt_do_dlg(integer);
    xvt_destroy_dlg(integer);
    xvt_create_menu();
    xvt_do_menu();
    xvt_destroy_menu();
    xvt_do_fontstyle();
    xvt_do_help();
    xvt_scroll_cb(integer);

identifier
    xvt_scroll_tag;

object
! horizontal scroll bar
    xvt_horiz_bar : XmScrollBar {
		arguments {
		    XmNorientation = XmHORIZONTAL;
		    XmNmaximum = 1;
		    XmNsliderSize = 1;
		    XmNpageIncrement = 1;
		};
		callbacks {
		    XmNdecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNdragCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNincrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageDecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageIncrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoBottomCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoTopCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNvalueChangedCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		};
    };

! vertical scroll bar
    xvt_vertical_bar : XmScrollBar {
		arguments {
		    XmNorientation = XmVERTICAL;
		    XmNmaximum = 1;
		    XmNsliderSize = 1;
	    	XmNpageIncrement = 1;
		};	
		callbacks {
		    XmNdecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNdragCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNincrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageDecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageIncrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoBottomCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoTopCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNvalueChangedCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		};
    };

! Font menu
    xvt_font : XmCascadeButton {
	arguments {
	    XmNlabelString = "Font";
	    XmNmnemonic = 116;  ! "t"
	    XmNuserData = M_FONT;
	};
	controls {
	    XmPulldownMenu xvt_font_menu;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_font_menu : XmPulldownMenu {
	controls {
	    XmToggleButton gadget xvt_courier;
	    XmToggleButton gadget xvt_helvetica;
	    XmToggleButton gadget xvt_times;
	    XmToggleButton gadget xvt_system;
	    XmToggleButton gadget xvt_fixed;
	};
    };

    xvt_courier : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Courier";
	    XmNmnemonic = 67;  ! "C"
	    XmNuserData = M_FONT_COURIER;
	};
	callbacks {
	   MrmNcreateCallback = procedure xvt_create_menu();
	   XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_helvetica : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Helvetica";
	    XmNmnemonic = 72;  ! "H"
	    XmNuserData = M_FONT_HELVETICA;
	};
	callbacks {
	 MrmNcreateCallback = procedure xvt_create_menu();
	 XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_times : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Times";
	    XmNmnemonic = 84;  ! "T"
	    XmNuserData = M_FONT_TIMES;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_system : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "System";
	    XmNmnemonic = 83;  ! "S"
	    XmNuserData = M_FONT_SYSTEM;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_fixed : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Fixed";
	    XmNmnemonic = 70;  ! "F"
	    XmNuserData = M_FONT_FIXED;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

! Style menu
! NOTE - in general, application developers should not modify this menu

    xvt_style : XmCascadeButton {
	arguments {
	    XmNlabelString = "Style";
	    XmNmnemonic = 83;  ! "S"
	    XmNuserData = M_STYLE;
	};
	controls {
	    XmPulldownMenu xvt_style_menu;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_style_menu : XmPulldownMenu {
	controls {
	    XmToggleButton gadget xvt_normal;
	    XmToggleButton gadget xvt_bold;
	    XmToggleButton gadget xvt_italic;
	    XmSeparator    gadget xvt_style_sep1;
	    XmToggleButton gadget xvt_8_point;
	    XmToggleButton gadget xvt_10_point;
	    XmToggleButton gadget xvt_12_point;
	    XmToggleButton gadget xvt_14_point;
	    XmToggleButton gadget xvt_18_point;
	    XmToggleButton gadget xvt_24_point;
	};
    };

    xvt_normal : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Normal";
	    XmNmnemonic = 78;  ! "N"
	    XmNuserData = M_STYLE_NORMAL;
	};
	callbacks {
	   MrmNcreateCallback = procedure xvt_create_menu();
	   XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_bold : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Bold";
	    XmNmnemonic = 66;  ! "B"
	    XmNuserData = M_STYLE_BOLD;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_italic : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Italic";
	    XmNmnemonic = 73;  ! "I"
	    XmNuserData = M_STYLE_ITALIC;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	   XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_style_sep1 : XmSeparator gadget {
	arguments {
	    XmNuserData = M_STYLE_SEP1;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_8_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = " 8 Point";
	    XmNuserData = M_STYLE_8;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_10_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "10 Point";
	    XmNuserData = M_STYLE_10;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_12_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "12 Point";
	    XmNuserData = M_STYLE_12;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_14_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "14 Point";
	    XmNuserData = M_STYLE_14;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_18_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "18 Point";
	    XmNuserData = M_STYLE_18;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_24_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "24 Point";
	    XmNuserData = M_STYLE_24;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };
$$$
#else
#transparent $$$

module APPL1
	names = case_sensitive

include file 'XmAppl.uil';

value
! resource IDs
   XVT_9101		: exported 'hlp';

! quick fix to get Font and Style symbols defined
! really need to include or scan a private header file which contains these
! define constants, currently these are defined in xmimp.h, but scanning it
! pulls into much, it trys to bring all the other headers from Xm etc.

! new line "macro" for creating multi-line strings
    NL			: compound_string('', separate = true);

procedure
    xvt_create_dlg(integer);
    xvt_do_dlg(integer);
    xvt_destroy_dlg(integer);
    xvt_create_menu();
    xvt_do_menu();
    xvt_destroy_menu();
    xvt_do_fontstyle();
    xvt_do_help();
    xvt_scroll_cb(integer);

identifier
    xvt_scroll_tag;

object
! horizontal scroll bar
    xvt_horiz_bar : XmScrollBar {
		arguments {
		    XmNorientation = XmHORIZONTAL;
		    XmNmaximum = 1;
		    XmNsliderSize = 1;
		    XmNpageIncrement = 1;
		};
		callbacks {
		    XmNdecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNdragCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNincrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageDecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageIncrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoBottomCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoTopCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNvalueChangedCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		};
    };

! vertical scroll bar
    xvt_vertical_bar : XmScrollBar {
		arguments {
		    XmNorientation = XmVERTICAL;
		    XmNmaximum = 1;
		    XmNsliderSize = 1;
	    	XmNpageIncrement = 1;
		};	
		callbacks {
		    XmNdecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNdragCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNincrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageDecrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNpageIncrementCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoBottomCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNtoTopCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		    XmNvalueChangedCallback = procedure xvt_scroll_cb(xvt_scroll_tag);
		};
    };

! Font menu
    xvt_font : XmCascadeButton {
	arguments {
	    XmNlabelString = "Font";
	    XmNmnemonic = 116;  ! "t"
	    XmNuserData = M_FONT;
	};
	controls {
	    XmPulldownMenu xvt_font_menu;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_font_menu : XmPulldownMenu {
	controls {
	    XmToggleButton gadget xvt_courier;
	    XmToggleButton gadget xvt_helvetica;
	    XmToggleButton gadget xvt_times;
	    XmToggleButton gadget xvt_system;
	    XmToggleButton gadget xvt_fixed;
	};
    };

    xvt_courier : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Courier";
	    XmNmnemonic = 67;  ! "C"
	    XmNuserData = M_FONT_COURIER;
	};
	callbacks {
	   XmNcreateCallback = procedure xvt_create_menu();
	   XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_helvetica : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Helvetica";
	    XmNmnemonic = 72;  ! "H"
	    XmNuserData = M_FONT_HELVETICA;
	};
	callbacks {
	 XmNcreateCallback = procedure xvt_create_menu();
	 XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_times : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Times";
	    XmNmnemonic = 84;  ! "T"
	    XmNuserData = M_FONT_TIMES;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_system : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "System";
	    XmNmnemonic = 83;  ! "S"
	    XmNuserData = M_FONT_SYSTEM;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_fixed : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Fixed";
	    XmNmnemonic = 70;  ! "F"
	    XmNuserData = M_FONT_FIXED;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

! Style menu
! NOTE - in general, application developers should not modify this menu

    xvt_style : XmCascadeButton {
	arguments {
	    XmNlabelString = "Style";
	    XmNmnemonic = 83;  ! "S"
	    XmNuserData = M_STYLE;
	};
	controls {
	    XmPulldownMenu xvt_style_menu;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_style_menu : XmPulldownMenu {
	controls {
	    XmToggleButton gadget xvt_normal;
	    XmToggleButton gadget xvt_bold;
	    XmToggleButton gadget xvt_italic;
	    XmSeparator    gadget xvt_style_sep1;
	    XmToggleButton gadget xvt_8_point;
	    XmToggleButton gadget xvt_10_point;
	    XmToggleButton gadget xvt_12_point;
	    XmToggleButton gadget xvt_14_point;
	    XmToggleButton gadget xvt_18_point;
	    XmToggleButton gadget xvt_24_point;
	};
    };

    xvt_normal : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Normal";
	    XmNmnemonic = 78;  ! "N"
	    XmNuserData = M_STYLE_NORMAL;
	};
	callbacks {
	   XmNcreateCallback = procedure xvt_create_menu();
	   XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_bold : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Bold";
	    XmNmnemonic = 66;  ! "B"
	    XmNuserData = M_STYLE_BOLD;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_italic : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "Italic";
	    XmNmnemonic = 73;  ! "I"
	    XmNuserData = M_STYLE_ITALIC;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	   XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_style_sep1 : XmSeparator gadget {
	arguments {
	    XmNuserData = M_STYLE_SEP1;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_8_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = " 8 Point";
	    XmNuserData = M_STYLE_8;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_10_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "10 Point";
	    XmNuserData = M_STYLE_10;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_12_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "12 Point";
	    XmNuserData = M_STYLE_12;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_14_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "14 Point";
	    XmNuserData = M_STYLE_14;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_18_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "18 Point";
	    XmNuserData = M_STYLE_18;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };

    xvt_24_point : XmToggleButton gadget {
	arguments {
	    XmNlabelString = "24 Point";
	    XmNuserData = M_STYLE_24;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNvalueChangedCallback = procedure xvt_do_fontstyle();
	};
    };
$$$
#endif

#endif
/********************************/
/* END OF PREAMBLES             */
/********************************/

/********************************/
/* STANDARD EDIT MENUS          */
/********************************/
#ifndef NO_STD_EDIT_MENU

/********************************/
/* MTF STANDARD EDIT MENU       */
/********************************/
#if XVTWS == MTFWS
MENU 512 "~Edit"
	ITEM M_EDIT_UNDO "~Undo" DISABLED
	SEPARATOR
	ITEM M_EDIT_CUT "Cu~t" DISABLED
	ITEM M_EDIT_COPY "~Copy" DISABLED
	ITEM M_EDIT_PASTE "~Paste" DISABLED
	SEPARATOR
	ITEM M_EDIT_CLEAR "Cl~ear" DISABLED
	
ACCEL M_EDIT_UNDO 	BACK	ALT
ACCEL M_EDIT_CUT 	DEL		SHIFT
ACCEL M_EDIT_COPY 	INS 	CONTROL
ACCEL M_EDIT_PASTE	INS 	SHIFT
#endif /*endif WSMTF*/

/********************************/
/* WS STANDARD EDIT MENU       */
/********************************/
#if XVTWS == WINWS
MENU 512 "~Edit"
	ITEM M_EDIT_UNDO "~Undo\tAlt+BS" DISABLED
	SEPARATOR
	ITEM M_EDIT_CUT "Cu~t\tShift+Del" DISABLED
	ITEM M_EDIT_COPY "~Copy\tCtrl+Ins" DISABLED
	ITEM M_EDIT_PASTE "~Paste\tShift+Ins" DISABLED
	ITEM M_EDIT_CLEAR "Cl~ear\tDel" DISABLED

ACCEL M_EDIT_UNDO 	BACK	ALT
ACCEL M_EDIT_CUT 	DEL		SHIFT
ACCEL M_EDIT_COPY 	INS 	CONTROL
ACCEL M_EDIT_PASTE	INS 	SHIFT
ACCEL M_EDIT_CLEAR	DEL 
#endif

/********************************/
/* PM STANDARD EDIT MENU       */
/********************************/
#if XVTWS == PMWS
MENU 512 "~Edit"
	ITEM M_EDIT_UNDO "~Undo\tAlt+BS" DISABLED
	SEPARATOR
	ITEM M_EDIT_CUT "Cu~t\tShift+Del" DISABLED
	ITEM M_EDIT_COPY "~Copy\tCtrl+Ins" DISABLED
	ITEM M_EDIT_PASTE "~Paste\tShift+Ins" DISABLED
	ITEM M_EDIT_CLEAR "Cl~ear\tDel" DISABLED
	
ACCEL M_EDIT_UNDO 	BACK	ALT
ACCEL M_EDIT_CUT 	DEL		SHIFT
ACCEL M_EDIT_COPY 	INS 	CONTROL
ACCEL M_EDIT_PASTE	INS 	SHIFT
ACCEL M_EDIT_CLEAR	DEL 
#endif

/********************************/
/* MAC STANDARD EDIT MENU       */
/********************************/
#if XVTWS == MACWS
MENU 512 "Edit"
	ITEM M_EDIT_UNDO "Undo" DISABLED
	SEPARATOR
	ITEM M_EDIT_CUT "Cut" DISABLED
	ITEM M_EDIT_COPY "Copy" DISABLED
	ITEM M_EDIT_PASTE "Paste" DISABLED
	ITEM M_EDIT_CLEAR "Clear" DISABLED
	ITEM M_EDIT_SEL_ALL "Select All" DISABLED
	SEPARATOR
	ITEM M_EDIT_CLIPBOARD "Show Clipboard" DISABLED
	
ACCEL M_EDIT_UNDO 	"Z"		ALT
ACCEL M_EDIT_CUT 	"X"		ALT
ACCEL M_EDIT_COPY 	"C" 	ALT
ACCEL M_EDIT_PASTE	"V"		ALT
#endif

/********************************/
/* XVT/CH STANDARD EDIT MENU    */
/********************************/
#if XVTWS == WMWS
MENU 512 "~Edit"
	ITEM M_EDIT_UNDO "~Undo" DISABLED
	SEPARATOR
	ITEM M_EDIT_CUT "Cu~t" DISABLED
	ITEM M_EDIT_COPY "~Copy" DISABLED
	ITEM M_EDIT_PASTE "~Paste" DISABLED
	ITEM M_EDIT_CLEAR "Cl~ear" DISABLED

ACCEL M_EDIT_UNDO 	"U"    	CONTROL
ACCEL M_EDIT_CUT 	"t"		CONTROL
ACCEL M_EDIT_COPY 	"C"		CONTROL
ACCEL M_EDIT_PASTE	"P" 	CONTROL
ACCEL M_EDIT_CLEAR	"e" 	CONTROL
#endif
#endif /*ifndef NO_STD_EDIT_MENU*/

/********************************/
/* STANDARD FILE MENU           */
/********************************/
#ifndef NO_STD_FILE_MENU
/********************************/
/* MTF STANDARD FILE MENU       */
/********************************/
#if XVTWS == MTFWS
MENU 256 "~File"
	ITEM M_FILE_NEW "~New" DISABLED
	ITEM M_FILE_OPEN "~Open..." DISABLED
	ITEM M_FILE_SAVE "~Save" DISABLED
	ITEM M_FILE_SAVE_AS "Save ~As..." DISABLED
	ITEM M_FILE_PRINT "~Print" DISABLED
	ITEM M_FILE_QUIT "E~xit"
#endif /*Motif*/

/********************************/
/* WS STANDARD FILE MENU        */
/********************************/
#if XVTWS == WINWS
MENU 256 "~File"
	ITEM M_FILE_NEW "~New" DISABLED
	ITEM M_FILE_OPEN "~Open..." DISABLED
	ITEM M_FILE_SAVE "~Save" DISABLED
	ITEM M_FILE_SAVE_AS "Save ~As..." DISABLED
	ITEM M_FILE_REVERT "~Revert to Saved" DISABLED
	SEPARATOR
	ITEM M_FILE_PG_SETUP "Page Setup..." DISABLED
	ITEM M_FILE_PRINT "~Print..." DISABLED
	SEPARATOR
	ITEM M_FILE_QUIT "E~xit"
	ITEM M_FILE_ABOUT "A~bout..."
#endif

/********************************/
/* PM STANDARD FILE MENU        */
/********************************/
#if XVTWS == PMWS
MENU 256 "~File"
	ITEM M_FILE_NEW "~New" DISABLED
	ITEM M_FILE_OPEN "~Open..." DISABLED
	ITEM M_FILE_SAVE "~Save" DISABLED
	ITEM M_FILE_SAVE_AS "Save ~As..." DISABLED
	ITEM M_FILE_REVERT "~Revert to Saved" DISABLED
	SEPARATOR
	ITEM M_FILE_PG_SETUP "Page Setup..." DISABLED
	ITEM M_FILE_PRINT "~Print..." DISABLED
	SEPARATOR
	ITEM M_FILE_QUIT "E~xit"
#ifndef SHELP
	ITEM M_FILE_ABOUT "A~bout..."
#endif
#endif

/********************************/
/* MAC STANDARD FILE MENU       */
/********************************/
#if XVTWS == MACWS
MENU 256 "File"
	ITEM M_FILE_NEW "New/N" DISABLED
	ITEM M_FILE_OPEN "Open.../O" DISABLED
	SEPARATOR
	ITEM M_FILE_CLOSE "Close" DISABLED
	ITEM M_FILE_SAVE "Save/S" DISABLED
	ITEM M_FILE_SAVE_AS "Save As..." DISABLED
	ITEM M_FILE_REVERT "Revert to Saved" DISABLED
	SEPARATOR
	ITEM M_FILE_PG_SETUP "Page Setup..." DISABLED
	ITEM M_FILE_PRINT "Print..." DISABLED
	SEPARATOR
	ITEM M_FILE_QUIT "Quit/Q"
#endif /* MACWS*/

/********************************/
/* XVT/CH STANDARD FILE MENU    */
/********************************/
#if XVTWS == WMWS
MENU 256 "~File"
	ITEM M_FILE_NEW "~New" DISABLED
	ITEM M_FILE_OPEN "~Open..." DISABLED
	SEPARATOR
	ITEM M_FILE_CLOSE "~Close" DISABLED
	ITEM M_FILE_SAVE "~Save" DISABLED
	ITEM M_FILE_SAVE_AS "Save ~As..." DISABLED
	ITEM M_FILE_REVERT "~Revert to Saved" DISABLED
	SEPARATOR
	ITEM M_FILE_PRINT "~Print..." DISABLED
	SEPARATOR
#ifndef SHELP
	ITEM M_FILE_ABOUT "A~bout..."
#endif
	ITEM M_FILE_QUIT "E~xit"
#endif

#endif /*ifndef NO_STD_FILE_MENU*/

/********************************/
/* STANDARD HELP MENU           */
/********************************/
#ifndef NO_STD_HELP_MENU

/********************************/
/* MTF STANDARD HELP MENU       */
/********************************/
#if XVTWS == MTFWS
#define MENU_HELP			M_HELP +
#define M_HELP_INDEX		MAKE_MENU_TAG(MENU_HELP, 1)
#define M_HELP_VERSION		MAKE_MENU_TAG(MENU_HELP, 2)

MENU M_HELP "Help"
	SEPARATOR

#ifdef XSIGHT
#transparent $$$

object
! Help menu
    xvt_help : XmCascadeButton {
	arguments {
	    XmNlabelString = "Help";
	    XmNmnemonic = 72;  ! "H"
	    XmNuserData = M_HELP;
	};
	controls {
	    XmPulldownMenu xvt_help_menu;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_help_menu : XmPulldownMenu {
	controls {
	    XmPushButton gadget xvt_index;
	    XmPushButton gadget xvt_version;
	};
    };

    xvt_index : XmPushButton gadget {
	arguments {
	    XmNlabelString = "Index";
	    XmNmnemonic = 73;  ! "I"
	    XmNuserData = M_HELP_INDEX;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNactivateCallback = procedure xvt_do_help();
	};
    };

    xvt_version : XmPushButton gadget {
	arguments {
	    XmNlabelString = "On Version";
	    XmNmnemonic = 86;  ! "V"
	    XmNuserData = M_HELP_VERSION;
	};
	callbacks {
	    MrmNcreateCallback = procedure xvt_create_menu();
	    XmNactivateCallback = procedure xvt_do_help();
	};
    };
$$$
#else
#transparent $$$

object
! Help menu
    xvt_help : XmCascadeButton {
	arguments {
	    XmNlabelString = "Help";
	    XmNmnemonic = 72;  ! "H"
	    XmNuserData = M_HELP;
	};
	controls {
	    XmPulldownMenu xvt_help_menu;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	};
    };

    xvt_help_menu : XmPulldownMenu {
	controls {
	    XmPushButton gadget xvt_index;
	    XmPushButton gadget xvt_version;
	};
    };

    xvt_index : XmPushButton gadget {
	arguments {
	    XmNlabelString = "Index";
	    XmNmnemonic = 73;  ! "I"
	    XmNuserData = M_HELP_INDEX;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNactivateCallback = procedure xvt_do_help();
	};
    };

    xvt_version : XmPushButton gadget {
	arguments {
	    XmNlabelString = "On Version";
	    XmNmnemonic = 86;  ! "V"
	    XmNuserData = M_HELP_VERSION;
	};
	callbacks {
	    XmNcreateCallback = procedure xvt_create_menu();
	    XmNactivateCallback = procedure xvt_do_help();
	};
    };
$$$
#endif
#endif /* MOTIF */

/********************************/
/* WS STANDARD HELP MENU        */
/********************************/
#if XVTWS == WINWS
MENU M_HELP "\aF1=Help"
	SEPARATOR
	
accel M_HELP F1	
#endif /*WSWIN definition of help menu*/

/********************************/
/* PM STANDARD HELP MENU        */
/********************************/
#ifndef SHELP
#if XVTWS == PMWS
MENU M_HELP "F1=Help"
	SEPARATOR

accel M_HELP F1	
#endif /*WSWIN definition of help menu*/
#endif

#endif /*ifndef NO_STD_HELP_MENU*/

/********************************/
/* STANDARD FONT MENU           */
/********************************/
#ifndef NO_STD_FONT_MENU

/********************************/
/* WS STANDARD FONT MENU        */
/********************************/
#if XVTWS == WINWS
MENU  FONT_BASE "Fon~t"
	ITEM M_FONT_NORMAL "~Normal\tF5"
	SEPARATOR 
	ITEM M_FONT_BOLD "~Bold\tF6" 
	ITEM M_FONT_ITALIC "~Italic\tF7" 
	ITEM M_FONT_UNDER "~Underline\tF8" 
	SEPARATOR
	ITEM 65500 "Stroke Fonts" 
	ITEM M_FONT_MODERN "  ~Modern" 
	ITEM M_FONT_ROMAN "  ~Roman" 
	ITEM M_FONT_SCRIPT "  ~Script" 
	ITEM 65501 "Raster Fonts"
	ITEM M_FONT_COURIER "  ~Courier"
	ITEM M_FONT_HELV "  ~Helvetica"
	ITEM M_FONT_TIMESROMAN "  ~Times Roman"
	SEPARATOR
	ITEM M_FONT_VAR "~Variable Pitch"
	ITEM M_FONT_FIX "~Fixed Pitch"
	ITEM M_FONT_PROOF "|Best Appearance"
	ITEM M_FONT_DRAFT "Conform to Si&ze"
	SEPARATOR
	ITEM M_FONT_6 " 6 Point"
	ITEM M_FONT_8 " 8 Point"
	ITEM M_FONT_9 " 9 Point"
	ITEM M_FONT_10 " 10 Point"
	ITEM M_FONT_12 " 12 Point"
	ITEM M_FONT_14 " 14 Point"
	ITEM M_FONT_16 " 16 Point"
	ITEM M_FONT_18 " 18 Point"
	ITEM M_FONT_20 " 20 Point"
	ITEM M_FONT_24 " 24 Point"
	ITEM M_FONT_36 " 36 Point"
	ITEM M_FONT_48 " 48 Point"
	ITEM M_FONT_54 " 54 Point"
	ITEM M_FONT_60 " 60 Point"
	ITEM M_FONT_72 " 72 Point"
	
ACCEL M_FONT_NORMAL 	F5  
ACCEL M_FONT_BOLD		F6
ACCEL M_FONT_ITALIC		F7
ACCEL M_FONT_UNDER		F8
#endif /*endif WSWIN*/

/********************************/
/* PM STANDARD FONT MENU        */
/********************************/
#if XVTWS == PMWS
MENU FONT_BASE "Fon~t"
	ITEM M_FONT_NORMAL		"~Normal\tF5"
	SEPARATOR
	ITEM M_FONT_BOLD		"~Bold\tF6"
	ITEM M_FONT_ITALIC		"~Italic\tF7"
	ITEM M_FONT_UNDER		"~Underline\tF8"
	SEPARATOR
	ITEM 65500				"Fonts"		/* unused must have a uniq value */
	ITEM M_FONT_COURIER		"  ~Courier"
	ITEM M_FONT_HELV		"  ~Helvetica"
	ITEM M_FONT_TIMESROMAN	"  ~Times"
	ITEM M_FONT_MODERN		"  ~System"	/* used for system font under PM */
	ITEM M_FONT_VAR			"|~Variable Pitch"
	ITEM M_FONT_FIX			"~Fixed Pitch"
	SEPARATOR
	ITEM M_FONT_8			" 8 Point"
	ITEM M_FONT_10			"10 Point"
	ITEM M_FONT_12			"12 Point"
	ITEM M_FONT_16			"16 Point"
	ITEM M_FONT_24			"24 Point"
	ITEM M_FONT_36			"36 Point"
	ITEM M_FONT_48			"48 Point"
	ITEM M_FONT_60			"60 Point"
	
ACCEL M_FONT_NORMAL 	F5  
ACCEL M_FONT_BOLD		F6
ACCEL M_FONT_ITALIC		F7
ACCEL M_FONT_UNDER		F8

#endif

#endif /*endif NO_STD_FONT_MENU*/

/***************************/
/* DIALOGUES               */
/***************************/

#if XVTWS == MACWS
/**********************/
/* MAC DIALOGUES      */
/**********************/
#ifndef NO_STD_ABOUT_BOX
/**********************/
/* MAC ABOUT BOX      */
/**********************/
#transparent $$$ literal
***************************************************************
*******************
* Default About box. ID must be equal to DB_ABOUT. App can override.
***************************************************************
*******************
type DLOG 
    ,9050 (32)

60 106 120 406
Invisible NoGoAway
1
0
9050

type DITL 
    ,9050 (32)
5
BtnItem Enabled
35 224 55 294
OK

staticText disabled 
5 20 21 210
This program was developed

UserItem Disabled
0 0 0 0

staticText disabled 
21 20 37 210
with XVT, the Extensible

staticText disabled 
37 20 53 210
Virtual Toolkit.

$$$
#endif /*NO_STD_ABOUT_BOX for mac*/

#transparent $$$ literal

***************************************************************
*******************
* The following standard XVT dialogs must not be altered
***************************************************************
*******************

***************************************************************
*******************
* Dialog box for ask() function. ID must be equal to DB_ASK.
***************************************************************
*******************
type DLOG 
    ,9051 (32)

60 68 176 444
Invisible NoGoAway
1
0
9051

type DITL 
    ,9051 (32)
6
button 
80 296 100 356


button 
16 296 36 356


userItem disabled 
0 0 0 0

button 
48 296 68 356


staticText disabled 
16 72 80 280


iconItem disabled 
10 20 42 52
2

***************************************************************
*******************
* Dialog box for error() function. ID must be equal to DB_ERROR.
***************************************************************
*******************
type DLOG 
    ,9052 (32)

60 68 156 444
Invisible NoGoAway
1
0
9052

type DITL 
    ,9052 (32)
6
button 
60 296 80 356
OK

button 
0 0 0 0
Cancel

userItem disabled 
0 0 0 0

button 
0 0 0 0
No

staticText disabled 
16 72 80 280


iconItem disabled 
10 20 42 52
0

***************************************************************
*******************
* Dialog box for note() function. ID must be equal to DB_NOTE.
***************************************************************
*******************
type DLOG 
    ,9053 (32)

60 68 156 444
Invisible NoGoAway
1
0
9053

type DITL 
    ,9053 (32)
6
button 
60 296 80 356
OK

button 
0 0 0 0
Cancel

userItem disabled 
0 0 0 0

button 
0 0 0 0
No

staticText disabled 
16 72 80 280


iconItem disabled 
10 20 42 52
1

***************************************************************
*******************
* Dialog box for printing cancellation. ID must be equal to DB_ABORT.
* Lower third of screen to stay clear of printer timeout box
***************************************************************
*******************
type DLOG 
    ,9055 (0)

200 105 261 408
Visible NoGoAway
1
0
9055

type DITL 
    ,9055 (0)
1
staticText disabled 
12 41 48 270
To cancel printing, hold down the\0D\11 key and type a period (.).

***************************************************************
*******************
* Dialog box for help topics. ID must be equal to DB_HELPTOPICS.
***************************************************************
*******************
type DLOG 
    ,9057 (32)
Help Topics
44 6 290 230
Invisible GoAway
0
0
9057

type DITL 
    ,9057 (32)
6
button 
214 156 234 216
Help

button 
214 84 234 144
Cancel

userItem disabled 
0 0 0 0

staticText 
20 5 201 220
=LBox 128 3 9

staticText disabled 
2 5 18 216
Select help topic...

checkBox 
208 5 240 77
Fresh\0Dwindow

***************************************************************
*******************
* Dialog box for help text. ID must be equal to DB_HELPTEXT.
***************************************************************
*******************
type DLOG 
    ,9058 (32)
Help Text
44 234 328 506
Invisible GoAway
0
0
9058

type DITL 
    ,9058 (32)
6
button 
256 205 276 261
Topics

button 
256 10 276 66
Cancel

userItem disabled 
0 0 0 0

staticText 
5 5 247 267
=LBOX -1 3 9

button 
256 75 276 131
Next

button 
256 140 276 196
Prev

***************************************************************
*******************
* Dialog box for get_str_response() function. ID must be equal to 
* DB_RESPONSE.
***************************************************************
*******************
type DLOG 
    ,9059 (32)
String Response Dialog
68 174 228 374
Invisible NoGoAway
1
0
9059

type DITL 
    ,9059 (32)
5
button 
128 128 148 188
OK

button 
128 48 148 108
Cancel

userItem disabled 
0 0 0 0

staticText disabled 
8 8 88 192


editText 
96 8 112 192

***************************************************************
*******************
* Replacement for standard open dialog box -- adds static text line.
* Macintosh implementation doesn't use DB_OPEN.
* The outline item is ID 2 here -- XVT doesn't put up this box.
***************************************************************
*******************
type DLOG 
    ,-4000 (-4096)

0 0 200 348
Invisible NoGoAway
1
0
-4000

type DITL 
    ,-4000 (-4096)
11
button 
138 256 156 336
Open

button 
1152 59 1232 77
Hidden

button 
163 256 181 336
Cancel

userItem disabled 
39 232 59 347

button 
68 256 86 336
Eject

button 
93 256 111 336
Drive

userItem 
39 12 185 230

userItem 
39 229 185 246

userItem disabled 
124 252 125 340

staticText disabled 
1044 20 1145 116


staticText disabled 
0 12 16 336
^0^1^2^3

$$$
#endif /*XVTWS == MACWS*/

/********************************/
/* MTF DIALOGUES                */
/********************************/
#if XVTWS == MTFWS /* MOTIF */
#ifdef XSIGHT
#transparent $$$
value
    ! Dialog related values
    LIST_ITEM		: 4;
    NEXT_ITEM		: 5;
    PREV_ITEM		: 6;
    FRESH_ITEM		: 6;

object
! text response dialog
	XVT_9059: XmPromptDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = false;
			XmNnoResize = true;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg (DB_RESPONSE);
			XmNokCallback = procedure xvt_do_dlg (DLG_OK);
			XmNcancelCallback = procedure xvt_do_dlg (DLG_CANCEL);
	    };
	};
! ask box
	XVT_9051: XmQuestionDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = true;
			XmNnoResize = true;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DB_ASK);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
			XmNokCallback = procedure xvt_do_dlg(DLG_OK);
			XmNhelpCallback = procedure xvt_do_dlg(DLG_CANCEL);
			XmNcancelCallback = procedure xvt_do_dlg(DLG_NO);
	    };
	};
! error box
	XVT_9052: XmErrorDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = true;
			XmNnoResize = true;
		};
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DB_ERROR);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
			XmNokCallback = procedure xvt_do_dlg(DLG_YES);
	    };
	};
! note box
	XVT_9053: XmInformationDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = true;
			XmNnoResize = true;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DB_NOTE);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
			XmNokCallback = procedure xvt_do_dlg(DLG_OK);
	    };
	};
			       
! open file dialog - should work but does not
! 	XVT_9054: XmFileSelectionDialog {
! 	    arguments {
! 			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
! 			XmNautoUnmanage = true;
! 			XmNnoResize = true;
! 			XmNlistUpdated = true;
! 	    };
! 	    callbacks {
! 			MrmNcreateCallback   = procedure xvt_create_dlg(DB_OPEN);
! 			XmNunmapCallback   = procedure xvt_do_dlg(DLG_CLOSE);
! 			XmNokCallback       = procedure xvt_do_dlg(DLG_OK);
! 			XmNcancelCallback   = procedure xvt_do_dlg(DLG_CANCEL);
! 	    };
! 	};
! open file dialog - temporary fix
	XVT_9054 : XmBulletinBoardDialog {
		arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNdefaultPosition = true;
			XmNautoUnmanage = false;
			XmNnoResize = true;
			XmNdefaultButton = XmPushButton control_9054_1;
			XmNmarginWidth = 3;
		};
		controls {
			XmPushButton gadget control_9054_1;
			XmPushButton gadget control_9054_2;
			XmPushButton gadget control_9054_3;
			XmLabel gadget control_9054_4;
			XmLabel gadget control_9054_5;
			XmLabel gadget control_9054_6;
			XmLabel gadget control_9054_7;
			XmForm control_9054_8;
			XmLabel gadget control_9054_9;
			XmText control_9054_10;
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(9054);
			XmNunmapCallback = procedure xvt_do_dlg(9003);
			XmNdestroyCallback = procedure xvt_destroy_dlg(9054);
		};
	};

object
	control_9054_1 : XmPushButton gadget {
		arguments {
			XmNx = 21;
			XmNy = 261;
			XmNwidth = 46;
			XmNheight = 31;
			XmNrecomputeSize = false;
			XmNshowAsDefault = 1;
			XmNlabelString = "Open";
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(1);
			XmNactivateCallback = procedure xvt_do_dlg(1);
		};
	};

object
	control_9054_2 : XmPushButton gadget {
		arguments {
			XmNx = 115;
			XmNy = 265;
			XmNwidth = 48;
			XmNheight = 24;
			XmNrecomputeSize = false;
			XmNlabelString = "Cancel";
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(2);
			XmNactivateCallback = procedure xvt_do_dlg(2);
		};
	};

object
	control_9054_3 : XmPushButton gadget {
		arguments {
			XmNx = 205;
			XmNy = 265;
			XmNwidth = 48;
			XmNheight = 24;
			XmNrecomputeSize = false;
			XmNlabelString = "Help";
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(13);
			XmNactivateCallback = procedure xvt_do_dlg(13);
		};
	};

object
	control_9054_4 : XmLabel gadget {
		arguments {
			XmNx = 10;
			XmNy = 0;
			XmNwidth = 200;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "";
			XmNalignment = XmALIGNMENT_BEGINNING;
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(9084);
		};
	};

object
	control_9054_5 : XmLabel gadget {
		arguments {
			XmNx = 0;
			XmNy = 33;
			XmNwidth = 48;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "Path:";
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(10);
		};
	};

object
	control_9054_6 : XmLabel gadget {
		arguments {
			XmNx = 50;
			XmNy = 35;
			XmNwidth = 250;
			XmNheight = 8;
			XmNrecomputeSize = false;
			XmNlabelString = "";
			XmNalignment = XmALIGNMENT_BEGINNING;
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(9081);
		};
	};

object
	control_9054_7 : XmLabel gadget {
		arguments {
			XmNx = 5;
			XmNy = 55;
			XmNwidth = 48;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "Files:";
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(11);
		};
	};

object
	control_9054_8 : XmForm {
		arguments {
			XmNx = 10;
			XmNy = 70;
			XmNwidth = 250;
			XmNheight = 130;
		};
		controls {
			XmScrolledList list_9054_8;
		};
	};

object
	list_9054_8 : XmScrolledList {
		arguments {
			XmNx = 10;
			XmNy = 70;
			XmNwidth = 250;
			XmNlistSizePolicy = XmCONSTANT;
			XmNvisibleItemCount = 8;
			XmNscrollBarDisplayPolicy = XmSTATIC;
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(9083);
			XmNextendedSelectionCallback = procedure xvt_do_dlg(9083);
			XmNbrowseSelectionCallback = procedure xvt_do_dlg(9083);
			XmNmultipleSelectionCallback = procedure xvt_do_dlg(9083);
			XmNsingleSelectionCallback = procedure xvt_do_dlg(9083);
			XmNdefaultActionCallback = procedure xvt_do_dlg(9083);
		};
	};

object
	control_9054_9 : XmLabel gadget {
		arguments {
			XmNx = 5;
			XmNy = 207;
			XmNwidth = 72;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "Selection:";
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(12);
		};
	};

object
	control_9054_10 : XmText {
		arguments {
			XmNx = 10;
			XmNy = 220;
			XmNwidth = 270;
		};
		callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(9082);
		};
	};

! helptopics
 	XVT_9057: XmBulletinBoardDialog {
	    arguments {
			XmNdialogTitle = "Help Topics";
			XmNautoUnmanage = true;
			XmNnoResize = true;
			XmNdialogStyle = XmDIALOG_MODELESS;
	    };
	    controls {
			XmLabel gadget   xvt_help_label;
			XmScrolledList   xvt_list;
			XmRowColumn      xvt_help_button_box;
			XmToggleButton gadget   xvt_fresh_button;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DB_HELPTOPICS);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
	    };
	};
	xvt_help_button_box: XmRowColumn {
	    arguments {
			XmNorientation= XmHORIZONTAL;
			XmNspacing = 25;
			XmNx = 105;
			XmNy = 150;
			XmNborderWidth = 0 ;
	    };
	    controls {
			XmPushButton xvt_cancel_button;
			XmPushButton xvt_ok_button;
	    };	
	};
	xvt_ok_button: XmPushButton gadget {
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "OK";
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DLG_OK);
			XmNactivateCallback = procedure xvt_do_dlg (DLG_OK);
	    };
	};

	xvt_cancel_button: XmPushButton gadget {
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "Cancel";
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DLG_CANCEL);
			XmNactivateCallback = procedure xvt_do_dlg(DLG_CANCEL);
	    };
	};
	xvt_fresh_button: XmToggleButton gadget {
	    arguments {
			XmNlabelString = "Fresh" & NL & "Window";
			XmNx = 30;
			XmNy = 150;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(FRESH_ITEM);
			XmNvalueChangedCallback = procedure xvt_do_dlg(FRESH_ITEM);
	    };
	};
	xvt_help_label: XmLabel gadget {
	    arguments{
			XmNlabelString = "Select help topic ...";
			XmNx = 30;
			XmNy = 10;
			XmNrecomputeSize = false;
	    };
	};
	xvt_list: XmScrolledList {
	    arguments {
			XmNvisibleItemCount = 6;
			XmNlistSizePolicy = XmCONSTANT;
			XmNselectionPolicy = XmEXTENDED_SELECT;
			XmNx = 30;
			XmNy = 30;
			XmNwidth = 350;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(LIST_ITEM);
			XmNmultipleSelectionCallback = procedure xvt_do_dlg(LIST_ITEM);
			XmNdefaultActionCallback = procedure xvt_do_dlg(LIST_ITEM);
	    };
	};

! helptext
	XVT_9058: XmBulletinBoardDialog {
	    arguments {
			XmNdialogTitle = "Help Text";
			XmNautoUnmanage = true;
			XmNnoResize = true;
			XmNdialogStyle = XmDIALOG_MODELESS;
	    };
	    controls {
			XmScrolledList  xvt_list;
			XmRowColumn     xvt_topics_box;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DB_HELPTEXT);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
	    };
	};
	xvt_topics_box: XmRowColumn {
	    arguments {
			XmNorientation= XmHORIZONTAL;
			XmNspacing = 35;
			XmNx = 30;
			XmNy = 150;
			XmNborderWidth = 0 ;
	    };
	    controls {
			XmPushButton gadget xvt_cancel_button;
			XmPushButton gadget xvt_next_button;
			XmPushButton gadget xvt_prev_button;
			XmPushButton gadget xvt_topics_button;
	    };
	};
	xvt_topics_button: XmPushButton gadget{
	    arguments {
			XmNlabelString = "Topics";
			XmNrecomputeSize = false;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(DLG_OK);
			XmNactivateCallback = procedure xvt_do_dlg(DLG_OK);
	    };
	};
	xvt_next_button: XmPushButton gadget {
	    arguments {
			XmNlabelString = "Next";
			XmNrecomputeSize = false;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(NEXT_ITEM);
			XmNactivateCallback = procedure xvt_do_dlg(NEXT_ITEM);
	    };
	};
	xvt_prev_button: XmPushButton gadget {
	    arguments {
			XmNlabelString = "Prev";
			XmNrecomputeSize = false;
	    };
	    callbacks {
			MrmNcreateCallback = procedure xvt_create_dlg(PREV_ITEM);
			XmNactivateCallback = procedure xvt_do_dlg(PREV_ITEM);
	    };
	};

$$$
#else

#transparent $$$
value
    ! Dialog related values
    LIST_ITEM		: 4;
    NEXT_ITEM		: 5;
    PREV_ITEM		: 6;
    FRESH_ITEM		: 6;

object
! text response dialog
	XVT_9059: XmPromptDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = false;
			XmNnoResize = true;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg (DB_RESPONSE);
			XmNokCallback = procedure xvt_do_dlg (DLG_OK);
			XmNcancelCallback = procedure xvt_do_dlg (DLG_CANCEL);
	    };
	};
! ask box
	XVT_9051: XmQuestionDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = true;
			XmNnoResize = true;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DB_ASK);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
			XmNokCallback = procedure xvt_do_dlg(DLG_OK);
			XmNhelpCallback = procedure xvt_do_dlg(DLG_CANCEL);
			XmNcancelCallback = procedure xvt_do_dlg(DLG_NO);
	    };
	};
! error box
	XVT_9052: XmErrorDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = true;
			XmNnoResize = true;
		};
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DB_ERROR);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
			XmNokCallback = procedure xvt_do_dlg(DLG_YES);
	    };
	};
! note box
	XVT_9053: XmInformationDialog {
	    arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNautoUnmanage = true;
			XmNnoResize = true;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DB_NOTE);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
			XmNokCallback = procedure xvt_do_dlg(DLG_OK);
	    };
	};
			       
! open file dialog - should work but does not
!	XVT_9054: XmFileSelectionDialog {
!	    arguments {
!			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
!			XmNautoUnmanage = true;
!			XmNnoResize = true;
!			XmNlistUpdated = true;
!	    };
!	    callbacks {
!			XmNcreateCallback   = procedure xvt_create_dlg(DB_OPEN);
!			XmNunmapCallback   = procedure xvt_do_dlg(DLG_CLOSE);
!			XmNokCallback       = procedure xvt_do_dlg(DLG_OK);
!			XmNcancelCallback   = procedure xvt_do_dlg(DLG_CANCEL);
!	    };
!	};
! open file dialog - temporary fix
	XVT_9054 : XmBulletinBoardDialog {
		arguments {
			XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
			XmNdefaultPosition = true;
			XmNautoUnmanage = false;
			XmNnoResize = true;
			XmNdefaultButton = XmPushButton control_9054_1;
			XmNmarginWidth = 3;
		};
		controls {
			XmPushButton gadget control_9054_1;
			XmPushButton gadget control_9054_2;
			XmPushButton gadget control_9054_3;
			XmLabel gadget control_9054_4;
			XmLabel gadget control_9054_5;
			XmLabel gadget control_9054_6;
			XmLabel gadget control_9054_7;
			XmForm control_9054_8;
			XmLabel gadget control_9054_9;
			XmText control_9054_10;
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(9054);
			XmNunmapCallback = procedure xvt_do_dlg(9003);
			XmNdestroyCallback = procedure xvt_destroy_dlg(9054);
		};
	};

object
	control_9054_1 : XmPushButton gadget {
		arguments {
			XmNx = 21;
			XmNy = 261;
			XmNwidth = 46;
			XmNheight = 31;
			XmNrecomputeSize = false;
			XmNshowAsDefault = 1;
			XmNlabelString = "Open";
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(1);
			XmNactivateCallback = procedure xvt_do_dlg(1);
		};
	};

object
	control_9054_2 : XmPushButton gadget {
		arguments {
			XmNx = 115;
			XmNy = 265;
			XmNwidth = 48;
			XmNheight = 24;
			XmNrecomputeSize = false;
			XmNlabelString = "Cancel";
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(2);
			XmNactivateCallback = procedure xvt_do_dlg(2);
		};
	};

object
	control_9054_3 : XmPushButton gadget {
		arguments {
			XmNx = 205;
			XmNy = 265;
			XmNwidth = 48;
			XmNheight = 24;
			XmNrecomputeSize = false;
			XmNlabelString = "Help";
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(13);
			XmNactivateCallback = procedure xvt_do_dlg(13);
		};
	};

object
	control_9054_4 : XmLabel gadget {
		arguments {
			XmNx = 10;
			XmNy = 0;
			XmNwidth = 200;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "";
			XmNalignment = XmALIGNMENT_BEGINNING;
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(9084);
		};
	};

object
	control_9054_5 : XmLabel gadget {
		arguments {
			XmNx = 0;
			XmNy = 33;
			XmNwidth = 48;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "Path:";
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(10);
		};
	};

object
	control_9054_6 : XmLabel gadget {
		arguments {
			XmNx = 50;
			XmNy = 35;
			XmNwidth = 250;
			XmNheight = 8;
			XmNrecomputeSize = false;
			XmNlabelString = "";
			XmNalignment = XmALIGNMENT_BEGINNING;
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(9081);
		};
	};

object
	control_9054_7 : XmLabel gadget {
		arguments {
			XmNx = 5;
			XmNy = 55;
			XmNwidth = 48;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "Files:";
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(11);
		};
	};

object
	control_9054_8 : XmForm {
		arguments {
			XmNx = 10;
			XmNy = 70;
			XmNwidth = 250;
			XmNheight = 130;
		};
		controls {
			XmScrolledList list_9054_8;
		};
	};

object
	list_9054_8 : XmScrolledList {
		arguments {
			XmNx = 10;
			XmNy = 70;
			XmNwidth = 250;
			XmNlistSizePolicy = XmCONSTANT;
			XmNvisibleItemCount = 8;
			XmNscrollBarDisplayPolicy = XmSTATIC;
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(9083);
			XmNextendedSelectionCallback = procedure xvt_do_dlg(9083);
			XmNbrowseSelectionCallback = procedure xvt_do_dlg(9083);
			XmNmultipleSelectionCallback = procedure xvt_do_dlg(9083);
			XmNsingleSelectionCallback = procedure xvt_do_dlg(9083);
			XmNdefaultActionCallback = procedure xvt_do_dlg(9083);
		};
	};

object
	control_9054_9 : XmLabel gadget {
		arguments {
			XmNx = 5;
			XmNy = 207;
			XmNwidth = 72;
			XmNheight = 12;
			XmNrecomputeSize = false;
			XmNlabelString = "Selection:";
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(12);
		};
	};

object
	control_9054_10 : XmText {
		arguments {
			XmNx = 10;
			XmNy = 220;
			XmNwidth = 270;
		};
		callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(9082);
		};
	};

! helptopics
	XVT_9057: XmBulletinBoardDialog {
	    arguments {
			XmNdialogTitle = "Help Topics";
			XmNautoUnmanage = true;
			XmNnoResize = true;
			XmNdialogStyle = XmDIALOG_MODELESS;
	    };
	    controls {
			XmLabel gadget   xvt_help_label;
			XmScrolledList   xvt_list;
			XmRowColumn      xvt_help_button_box;
			XmToggleButton gadget   xvt_fresh_button;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DB_HELPTOPICS);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
	    };
	};
	xvt_help_button_box: XmRowColumn {
	    arguments {
			XmNorientation= XmHORIZONTAL;
			XmNspacing = 25;
			XmNx = 105;
			XmNy = 150;
			XmNborderWidth = 0 ;
	    };
	    controls {
			XmPushButton xvt_cancel_button;
			XmPushButton xvt_ok_button;
	    };	
	};
	xvt_ok_button: XmPushButton gadget {
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "OK";
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DLG_OK);
			XmNactivateCallback = procedure xvt_do_dlg (DLG_OK);
	    };
	};

	xvt_cancel_button: XmPushButton gadget {
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "Cancel";
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DLG_CANCEL);
			XmNactivateCallback = procedure xvt_do_dlg(DLG_CANCEL);
	    };
	};
	xvt_fresh_button: XmToggleButton gadget {
	    arguments {
			XmNlabelString = "Fresh" & NL & "Window";
			XmNx = 30;
			XmNy = 150;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(FRESH_ITEM);
			XmNvalueChangedCallback = procedure xvt_do_dlg(FRESH_ITEM);
	    };
	};
	xvt_help_label: XmLabel gadget {
	    arguments{
			XmNrecomputeSize = false;
			XmNlabelString = "Select help topic ...";
			XmNx = 30;
			XmNy = 10;
	    };
	};
	xvt_list: XmScrolledList {
	    arguments {
			XmNvisibleItemCount = 6;
			XmNlistSizePolicy = XmCONSTANT;
			XmNselectionPolicy = XmEXTENDED_SELECT;
			XmNx = 30;
			XmNy = 30;
			XmNwidth = 350;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(LIST_ITEM);
			XmNmultipleSelectionCallback = procedure xvt_do_dlg(LIST_ITEM);
			XmNdefaultActionCallback = procedure xvt_do_dlg(LIST_ITEM);
	    };
	};

! helptext
	XVT_9058: XmBulletinBoardDialog {
	    arguments {
			XmNdialogTitle = "Help Text";
			XmNautoUnmanage = true;
			XmNnoResize = true;
			XmNdialogStyle = XmDIALOG_MODELESS;
	    };
	    controls {
			XmScrolledList  xvt_list;
			XmRowColumn     xvt_topics_box;
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DB_HELPTEXT);
			XmNunmapCallback = procedure xvt_do_dlg(DLG_CLOSE);
	    };
	};
	xvt_topics_box: XmRowColumn {
	    arguments {
			XmNorientation= XmHORIZONTAL;
			XmNspacing = 35;
			XmNx = 30;
			XmNy = 150;
			XmNborderWidth = 0 ;
	    };
	    controls {
			XmPushButton gadget xvt_cancel_button;
			XmPushButton gadget xvt_next_button;
			XmPushButton gadget xvt_prev_button;
			XmPushButton gadget xvt_topics_button;
	    };
	};
	xvt_topics_button: XmPushButton gadget{
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "Topics";
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(DLG_OK);
			XmNactivateCallback = procedure xvt_do_dlg(DLG_OK);
	    };
	};
	xvt_next_button: XmPushButton gadget {
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "Next";
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(NEXT_ITEM);
			XmNactivateCallback = procedure xvt_do_dlg(NEXT_ITEM);
	    };
	};
	xvt_prev_button: XmPushButton gadget {
	    arguments {
			XmNrecomputeSize = false;
			XmNlabelString = "Prev";
	    };
	    callbacks {
			XmNcreateCallback = procedure xvt_create_dlg(PREV_ITEM);
			XmNactivateCallback = procedure xvt_do_dlg(PREV_ITEM);
	    };
	};

$$$
#endif
#ifndef NO_STD_ABOUT_BOX
#ifdef XSIGHT
#transparent $$$
object
! About box
    XVT_9050: XmMessageDialog {
		arguments {
		    XmNdialogType = XmDIALOG_INFORMATION;
		    XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
		    XmNmessageString = 
			"This program was developed with XVT," & NL &
			"the Extensible Virtual Toolkit";
		    XmNdefaultPosition = true;
		    XmNnoResize = true;
		};
		callbacks {
		    MrmNcreateCallback = procedure xvt_create_dlg(DB_ABOUT);
		    XmNokCallback     = procedure xvt_do_dlg(DLG_OK);
		};
    };

$$$
#else
#transparent $$$
object
! About box
    XVT_9050: XmMessageDialog {
		arguments {
		    XmNdialogType = XmDIALOG_INFORMATION;
		    XmNdialogStyle = XmDIALOG_APPLICATION_MODAL;
		    XmNmessageString = 
			"This program was developed with XVT," & NL &
			"the Extensible Virtual Toolkit";
		    XmNdefaultPosition = true;
		    XmNnoResize = true;
		};
		callbacks {
		    XmNcreateCallback = procedure xvt_create_dlg(DB_ABOUT);
		    XmNokCallback     = procedure xvt_do_dlg(DLG_OK);
		};
    };

$$$
#endif
#endif /* ABOUT BOX for Motif */

#endif/*Motif not defined*/

/********************************/
/* WS DIALOGUES                 */
/********************************/
#if XVTWS == WINWS
/*
	Standard symbols for dialog and control styles.
*/
#transparent $$$ 
#define DIALOG_LMD		DIALOG LOADONCALL MOVEABLE DISCARDABLE
#define STYLE_MODELESS	STYLE WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU | WS_CLIPSIBLINGS | WS_CLIPCHILDREN
#define STYLE_MODAL		STYLE WS_POPUP | WS_DLGFRAME | WS_VISIBLE
#define WSGT			WS_GROUP | WS_TABSTOP
#define C_DEFBUTTON_GT	BS_DEFPUSHBUTTON | WS_CHILD | WSGT
#define C_BUTTON_GT		BS_PUSHBUTTON | WS_CHILD | WSGT
#define C_LTEXT			SS_LEFT | WS_CHILD | SS_NOPREFIX
#define C_CTEXT			SS_CENTER | WS_CHILD | SS_NOPREFIX
#define C_RTEXT			SS_RIGHT | WS_CHILD | SS_NOPREFIX
#define C_LEDIT_GT		ES_LEFT | WS_BORDER | WS_CHILD | WSGT
#define C_LBOX_GT		LBS_NOTIFY | WS_BORDER | WS_VSCROLL | WS_CHILD | WSGT
#define C_DSPLBOX_GT	WS_BORDER | WS_VSCROLL | WS_CHILD | WSGT
#define C_CHECK_GT		BS_CHECKBOX | WS_CHILD | WSGT
#define C_RADIO_GT		BS_RADIOBUTTON | WS_CHILD | WSGT
#define C_RADIO			BS_RADIOBUTTON | WS_CHILD
#define C_HSCROLL_GT	SBS_HORZ | WS_CHILD | WSGT
#define C_VSCROLL_GT	SBS_VERT | WS_CHILD | WSGT

/*
	Application icon is required; crosshair cursor is a standard XVT cursor
	shape that's not predefined by Windows
*/
ICON_RSRC		ICON DISCARDABLE	APPNAME.ico
CURSOR_CROSS	CURSOR DISCARDABLE	LIBDIR\croshair.cur
/*
	Dialog box for ask()
*/
DB_ASK DIALOG_LMD 58, 19, 205, 73
STYLE_MODAL
CAPTION QAPPNAME
BEGIN
	CONTROL "", DLG_OK, "button", C_DEFBUTTON_GT, 160, 10, 40, 14
	CONTROL "", DLG_CANCEL, "button", C_BUTTON_GT, 160, 30, 40, 14
	CONTROL "", DLG_NO, "button", C_BUTTON_GT, 160, 50, 40, 14
	CONTROL "", 5, "static", C_LTEXT, 35, 10, 115, 55
	ICON "#32514", DLG_ICON, 10, 10, 0, 0
END

/*
	Dialog box for error()
*/
DB_ERROR DIALOG_LMD 58, 19, 205, 73
STYLE_MODAL
CAPTION QAPPNAME
BEGIN
	CONTROL "", DLG_OK, "button", C_DEFBUTTON_GT, 160, 10, 40, 14
	CONTROL "", DLG_CANCEL, "button", C_BUTTON_GT, 160, 30, 40, 14
	CONTROL "", DLG_NO, "button", C_BUTTON_GT, 160, 50, 40, 14
	CONTROL "", 5, "static", C_LTEXT, 35, 10, 115, 55
	ICON "#32515", DLG_ICON, 10, 10, 0, 0
END

/*
	Dialog box for note()
*/
DB_NOTE DIALOG_LMD 58, 19, 205, 73
STYLE_MODAL
CAPTION QAPPNAME
BEGIN
	CONTROL "", DLG_OK, "button", C_DEFBUTTON_GT, 160, 10, 40, 14
	CONTROL "", DLG_CANCEL, "button", C_BUTTON_GT, 160, 30, 40, 14
	CONTROL "", DLG_NO, "button", C_BUTTON_GT, 160, 50, 40, 14
	CONTROL "", 5, "static", C_LTEXT, 35, 10, 115, 55
	ICON "#32516", DLG_ICON, 10, 10, 0, 0
END

/*
	Dialog box for get_str_response().
*/
DB_RESPONSE DIALOG_LMD 12, 19, 222, 78
STYLE_MODAL
BEGIN
	CONTROL "", DLG_RESPONSE, "edit", C_LEDIT_GT, 5, 60, 210, 12
	CONTROL "OK", DLG_OK, "button", C_DEFBUTTON_GT, 185, 5, 30, 14
	CONTROL "Cancel", DLG_CANCEL, "button", C_BUTTON_GT, 185, 25, 30, 14
	CONTROL "", DLG_PROMPT, "static", C_LTEXT, 5, 5, 170, 46
END

/*
	Dialog box for printing cancellation
*/
DB_ABORT DIALOG_LMD 30,40,90, 68
STYLE_MODAL
CAPTION QAPPNAME
BEGIN
	CONTROL "Cancel", DLG_CANCEL,, "button", C_DEFBUTTON_GT, 29, 48, 32, 14
	CONTROL "Printing", -1, "static", C_CTEXT, 0, 8, 90, 8
	CONTROL "", 4, "static", C_CTEXT, 0, 18, 90, 8
	CONTROL "", 5, "static", C_CTEXT, 0, 32, 90, 8
END

/*
	Dialog box for help topics
*/
DB_HELPTOPICS DIALOG_LMD 2, 16, 165, 140
STYLE_MODELESS
CAPTION "Help Topics"
BEGIN
	CONTROL "&Help", DLG_OK, "button", C_DEFBUTTON_GT, 126, 119, 35, 14
	CONTROL "Cancel", DLG_CANCEL, "button", C_BUTTON_GT, 82, 119, 35, 14
	CONTROL "", 4, "listbox", C_LBOX_GT, 4, 15, 159, 98
	CONTROL "Select help topic...", 5, "static", C_LTEXT, 6, 5, 95, 8
	CONTROL "Fresh Window", 6, "button", C_CHECK_GT, 13, 121, 59, 10
END

/*
	Dialog box for help text
*/
DB_HELPTEXT DIALOG_LMD 120, 22, 229, 152
STYLE_MODELESS
CAPTION "Help Text"
BEGIN
	CONTROL "&Topics", DLG_OK, "button", C_DEFBUTTON_GT, 159, 135, 28, 14
	CONTROL "Cancel", DLG_CANCEL, "button", C_BUTTON_GT, 45, 135, 28, 14
	CONTROL "", 4, "listbox", C_DSPLBOX_GT, 2, 2, 225, 133
	CONTROL "&Next", 5, "button", C_BUTTON_GT, 121, 135, 28, 14
	CONTROL "&Prev", 6, "button", C_BUTTON_GT, 83, 135, 28, 14
END

/*
	Dialog box for standard file open
*/
DB_OPEN DIALOG_LMD 10, 10, 150, 96
STYLE_MODAL
BEGIN
	CONTROL "", ID_EDIT, "edit", C_LEDIT_GT | ES_AUTOHSCROLL, 46, 15, 100, 12
	CONTROL "", ID_LISTBOX, "listbox", C_LBOX_GT | LBS_SORT, 4, 32,  70, 56
	CONTROL "&Open", DLG_OK, "button", C_DEFBUTTON_GT, 87, 52,  50, 14
	CONTROL "Cancel", DLG_CANCEL, "button", C_BUTTON_GT, 87, 70,  50, 14
	CONTROL "", ID_PATH, "static", C_LTEXT, 78, 32, 60, 12
	CONTROL "Filename:", -1, "static", C_RTEXT, 2, 15, 40, 12
	CONTROL "", ID_TITLE, "static", C_LTEXT, 2, 2, 140, 12
END

/*
	Dialog box for standard file save
*/
DB_SAVE DIALOG_LMD 30, 40, 166, 47
STYLE_MODAL
BEGIN
	CONTROL "", ID_EDIT, "edit", C_LEDIT_GT | ES_AUTOHSCROLL, 12, 15, 104 12
	CONTROL "", ID_PATH, "static", C_RTEXT, 80, 2, 72, 12
	CONTROL "Save file as:", ID_TITLE, "static", C_LTEXT, 2, 2, 75, 12
	CONTROL "&Save", DLG_OK, "button", C_DEFBUTTON_GT, 120, 14, 35,14
	CONTROL "Cancel", DLG_CANCEL, "button", C_BUTTON_GT, 120, 32, 35, 14
END
/* end */
$$$

#ifndef NO_STD_ABOUT_BOX
/********************************/
/* WIN STANDARD ABOUT BOX        */
/********************************/
DIALOG 9050,   106, 60, 300, 60   "" MODAL
	BUTTON 1,   224, 35, 70, 20   "Help" DEFAULT
	BUTTON 2,   224, 5, 70, 20   "Cancel"
	TEXT 4,   20, 5, 190, 16   "An XVT Application"
	TEXT 5,   20, 21, 190, 16   "Version 2.0"
	TEXT 6,   20, 37, 190, 16   "by XVT Software, Inc."
#endif /*About box*/

#endif/* WSWIN defined*/

/*********************/
/* PM Dialogues      */
/*********************/
#if XVTWS ==  PMWS
#transparent $$$
/*
	Standard symbols for dialog and control styles.
*/
#define STYLE_MODELESS	FCF_TITLEBAR | FCF_SYSMENU | FCF_NOMOVEWITHOWNER | FCF_BORDER
#define STYLE_MODAL 	FCF_DLGBORDER
#define WSGT			WS_GROUP | WS_TABSTOP
#define C_DEFBUTTON_GT	BS_PUSHBUTTON | BS_DEFAULT | WSGT | WS_VISIBLE
#define C_BUTTON_GT 	BS_PUSHBUTTON | WSGT | WS_VISIBLE
#define C_LTEXT 		SS_TEXT | DT_LEFT | WS_VISIBLE
#define C_CTEXT 		SS_TEXT | DT_CENTER | WS_VISIBLE
#define C_RTEXT 		SS_TEXT | DT_RIGHT | WS_VISIBLE
#define C_LEDIT_GT		ES_LEFT | WSGT | WS_VISIBLE | SS_FGNDFRAME
#define C_LBOX_GT		WSGT | WS_VISIBLE
#define C_DSPLBOX_GT	WSGT | WS_VISIBLE
#define C_CHECK_GT		BS_CHECKBOX | WSGT | WS_VISIBLE
#define C_RADIO_GT		BS_RADIOBUTTON | WSGT | WS_VISIBLE
#define C_RADIO 		BS_RADIOBUTTON | WS_VISIBLE
#define C_HSCROLL_GT	SBS_HORZ | WSGT | WS_VISIBLE
#define C_VSCROLL_GT	SBS_VERT | WSGT | WS_VISIBLE
#define C_ICON			SS_ICON | WS_VISIBLE

/*
STRINGTABLE DISCARDABLE
BEGIN
	STR_APPNAME, QAPPNAME
	STR_HELPTYPE, "HLP"
END
*/

/*
	Application icon is required; crosshair cursor is a standard XVT cursor
	shape that's not predefined by Windows
*/
BITMAP ICON_RSRC APPNAME.bmp				/* for use by draw_icon */
ICON MENU_BAR APPNAME.ICP
#if (XVTOS == CTOOS)
POINTER CURSOR_CROSS LIBDIR>croshair.ptr
POINTER CURSOR_PLUS LIBDIR>plus.ptr
BITMAP 9071 LIBDIR>cross.bmp
BITMAP 9072 LIBDIR>dcross.bmp
#else 
POINTER CURSOR_CROSS LIBDIR\croshair.ptr
POINTER CURSOR_PLUS LIBDIR\plus.ptr
BITMAP 9071 LIBDIR\cross.bmp
BITMAP 9072 LIBDIR\dcross.bmp
#endif


/*
	Dialog box for ask()
*/
DLGTEMPLATE DB_ASK
BEGIN
	DIALOG "", DB_ASK, 58, 20, 205, 72, , STYLE_MODAL
BEGIN
	CONTROL "", DLG_OK, 152, 56, 48, 20, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "", DLG_CANCEL, 152, 32, 48, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", DLG_NO, 152, 8, 48, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", 5, 36, 8, 110, 55, WC_STATIC, C_LTEXT | DT_WORDBREAK
	CONTROL "#12", DLG_ICON, 6, 48, 24, 24, WC_STATIC, SS_SYSICON | WS_VISIBLE
/*	CTLDATA DLG_ICON */
END
END

/*
	Dialog box for error()
*/
DLGTEMPLATE DB_ERROR
BEGIN
	DIALOG "", DB_ERROR, 58, 20, 205, 72, , STYLE_MODAL
BEGIN
	CONTROL "", DLG_OK, 152, 56, 48, 20, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "", DLG_CANCEL, 152, 32, 48, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", DLG_NO, 152, 8, 48, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", 5, 36, 8, 110, 55, WC_STATIC, C_LTEXT | DT_WORDBREAK
	CONTROL "#13", DLG_ICON, 6, 48, 24, 24, WC_STATIC, SS_SYSICON | WS_VISIBLE
/*	CTLDATA DLG_ICON */
END
END

/*
	Dialog box for note()
*/
DLGTEMPLATE DB_NOTE
BEGIN
	DIALOG "", DB_NOTE, 58, 20, 205, 72, , STYLE_MODAL
BEGIN
	CONTROL "", DLG_OK, 152, 56, 48, 20, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "", DLG_CANCEL, 152, 32, 48, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", DLG_NO, 152, 8, 48, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", 5, 36, 8, 110, 55, WC_STATIC, C_LTEXT | DT_WORDBREAK
	CONTROL "#14", DLG_ICON, 6, 48, 24, 24, WC_STATIC, SS_SYSICON | WS_VISIBLE
/*	CTLDATA DLG_ICON */
END
END

/*
	Dialog box for get_str_response().
*/
DLGTEMPLATE DB_RESPONSE
BEGIN
	DIALOG "", DB_RESPONSE, 12, 19, 222, 78,  STYLE_MODAL
BEGIN
	CONTROL "", DLG_RESPONSE, 5, 6, 210, 16, WC_ENTRYFIELD, C_LEDIT_GT
	CONTROL "OK", DLG_OK, 185, 60, 35, 20, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Cancel", DLG_CANCEL, 185, 32, 35, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", DLG_PROMPT, 5, 27, 170, 46, WC_STATIC, C_LTEXT | DT_WORDBREAK
END
END

/*
	Dialog box for get_choice().
*/
DLGTEMPLATE DB_CHOICE
BEGIN
	DIALOG "", DB_CHOICE, 12, 19, 222, 112,  STYLE_MODAL
BEGIN
	LISTBOX, DLG_RESPONSE, 4, 3, 159, 100
	CONTROL "OK", DLG_OK, 181, 88, 35, 20, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Cancel", DLG_CANCEL, 181, 64, 35, 20, WC_BUTTON, C_BUTTON_GT
	CONTROL "", DLG_PROMPT, 5, 103, 170, 9, WC_STATIC, C_LTEXT
END
END

/*
	Dialog box for printing cancellation
*/
DLGTEMPLATE DB_ABORT
BEGIN
	DIALOG "", DB_ABORT, 30, 40, 110, 68, , STYLE_MODAL
BEGIN
	CONTROL "Cancel", DLG_CANCEL, 34, 6, 38, 20, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Printing", -1, 10, 52, 90, 8, WC_STATIC, C_CTEXT
	CONTROL "", 4, 10, 42, 90, 8, WC_STATIC, C_CTEXT
	CONTROL "", 5, 10, 26, 90, 8, WC_STATIC, C_CTEXT
END
END

/*
	Dialog box for help topics
*/
#ifndef SHELP
DLGTEMPLATE DB_HELPTOPICS
BEGIN
	DIALOG "Help Topics", DB_HELPTOPICS, 2, 16, 165, 140, , STYLE_MODELESS
BEGIN
	CONTROL "~Help", DLG_OK, 126, 7, 35, 12, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Cancel", DLG_CANCEL, 82, 7, 35, 12, WC_BUTTON, C_BUTTON_GT
	LISTBOX, 4, 1, 27, 159, 98
	CONTROL "Select help topic...", 5, 6, 127, 95, 8, WC_STATIC, C_LTEXT
	CONTROL "Fresh Window", 6, 2, 9, 74, 10, WC_BUTTON, C_CHECK_GT
END
END

/*
	Dialog box for help text
*/
DLGTEMPLATE DB_HELPTEXT
BEGIN
	DIALOG "Help Text", DB_HELPTEXT, 120, 22, 254, 152, , STYLE_MODELESS
BEGIN
	CONTROL "~Topics", DLG_OK, 159, 2, 35, 12, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Cancel", DLG_CANCEL, 45, 2, 35, 12, WC_BUTTON, C_BUTTON_GT
	LISTBOX, 4, 3, 21, 252, 133
	CONTROL "~Next", 5, 121, 2, 35, 12, WC_BUTTON, C_BUTTON_GT
	CONTROL "~Prev", 6, 83, 2, 35, 12, WC_BUTTON, C_BUTTON_GT
END
END
#endif

#if (XVTOS != CTOOS)
/*
	Dialog box for standard file open
*/
DLGTEMPLATE DB_OPEN
BEGIN
	DIALOG "", DB_OPEN, 10, 10, 170, 96, , STYLE_MODAL
BEGIN
	CONTROL "", ID_EDIT, 50, 74, 100, 8, WC_ENTRYFIELD, C_LEDIT_GT
	LISTBOX, ID_LISTBOX, 4, 2, 86, 56
	CONTROL "~Open", DLG_OK, 113, 30, 38, 12, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Cancel", DLG_CANCEL, 113, 12, 38, 12, WC_BUTTON, C_BUTTON_GT
	CONTROL "", ID_PATH, 38, 60, 130, 10, WC_STATIC, C_LTEXT
	CONTROL "Files in", -1, 2, 60, 34, 10, WC_STATIC, C_LTEXT
	CONTROL "Filename:", -1, 2, 70, 44, 10, WC_STATIC, C_LTEXT
	CONTROL "", ID_TITLE, 2, 84, 140, 10, WC_STATIC, C_LTEXT
END
END
#endif
/*
	Dialog box for standard file save
*/
DLGTEMPLATE DB_SAVE
BEGIN
	DIALOG "", DB_SAVE, 30, 40, 166, 47, , STYLE_MODAL
BEGIN
	CONTROL "", ID_EDIT, 12, 20, 104 8, WC_ENTRYFIELD, C_LEDIT_GT
	CONTROL "", ID_PATH, 80, 33, 72, 12, WC_STATIC, C_RTEXT
	CONTROL "Save file as:", ID_TITLE, 2, 33, 75, 12, WC_STATIC, C_LTEXT
	CONTROL "~Save", DLG_OK, 120, 19, 35, 12, WC_BUTTON, C_DEFBUTTON_GT
	CONTROL "Cancel", DLG_CANCEL, 120, 1, 35, 12, WC_BUTTON, C_BUTTON_GT
END
END

/*
** additional dialog boxes for CTOS/PM
*/

#if (XVTOS == CTOOS)

DLGTEMPLATE DB_ABORTPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_ABORTPM, 31, 40, 110, 68, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "Cancel", DLG_CANCEL, 38, 8, 38, 14, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Printing", 65535, 10, 52, 90, 8, WC_STATIC, SS_TEXT | 
                DT_CENTER | DT_TOP | WS_VISIBLE
        CONTROL "", 4, 11, 36, 90, 8, WC_STATIC, SS_TEXT | DT_CENTER | 
                DT_TOP | WS_VISIBLE
        CONTROL "", 5, 11, 29, 90, 16, WC_STATIC, SS_TEXT | DT_CENTER | 
                DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_ABOUTPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_ABOUTPM, 56, 47, 150, 74, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "Help", DLG_OK, 111, 15, 35, 14, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Cancel", DLG_CANCEL, 111, 45, 35, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "An XVT Application", 4, 10, 45, 95, 16, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "Version 2.0", 5, 12, 25, 95, 16, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "by XVT Software, Inc.", 6, 11, 6, 95, 16, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_CHOICEPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_CHOICEPM, 30, 50, 222, 122, FS_NOBYTEALIGN | FS_DLGBORDER | 
                FS_BORDER | WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "", 5, 15, 4, 159, 100, WC_LISTBOX, WS_TABSTOP | WS_VISIBLE
        CONTROL "OK", DLG_OK, 182, 62, 35, 14, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Cancel", DLG_CANCEL, 182, 30, 35, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 4, 12, 110, 170, 8, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_ERRORPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_ERRORPM, 25, 87, 239, 75, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "", 1, 7, 8, 48, 14, WC_BUTTON, BS_PUSHBUTTON | BS_DEFAULT | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 2, 234, 13, 5, 14, WC_BUTTON, BS_PUSHBUTTON | WS_GROUP | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "", 4, 233, -2, 5, 14, WC_BUTTON, BS_PUSHBUTTON | WS_GROUP | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "", 5, 76, 10, 144, 48, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | DT_WORDBREAK | WS_VISIBLE
        CONTROL "#13", 9001, 7, 37, 36, 30, WC_STATIC, SS_SYSICON | WS_VISIBLE
    END
END
DLGTEMPLATE DB_NOTEPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_NOTEPM, 25, 87, 239, 75, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "", 1, 7, 8, 48, 14, WC_BUTTON, BS_PUSHBUTTON | BS_DEFAULT | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 2, 234, 13, 5, 14, WC_BUTTON, BS_PUSHBUTTON | WS_GROUP | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "", 4, 233, -2, 5, 14, WC_BUTTON, BS_PUSHBUTTON | WS_GROUP | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "", 5, 76, 10, 144, 48, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | DT_WORDBREAK | WS_VISIBLE
        CONTROL "#14", 9001, 7, 37, 36, 30, WC_STATIC, SS_SYSICON | WS_VISIBLE
    END
END
DLGTEMPLATE DB_ASKPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_ASKPM, 26, 88, 236, 75, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "", 1, 11, 6, 48, 14, WC_BUTTON, BS_PUSHBUTTON | BS_DEFAULT | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 2, 94, 6, 48, 14, WC_BUTTON, BS_PUSHBUTTON | WS_GROUP | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "", 4, 177, 6, 48, 14, WC_BUTTON, BS_PUSHBUTTON | WS_GROUP | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "", 5, 49, 25, 158, 43, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | DT_WORDBREAK | WS_VISIBLE
        CONTROL "#12", 9001, 6, 38, 36, 30, WC_STATIC, SS_SYSICON | WS_VISIBLE
    END
END
DLGTEMPLATE DB_OPENPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "Open a file", DB_OPENPM, 85, -2, 356, 202, FS_NOBYTEALIGN | 
                FS_NOMOVEWITHOWNER | FS_DLGBORDER | FS_BORDER | WS_CLIPSIBLINGS | 
                WS_SAVEBITS, FCF_SYSMENU | FCF_TITLEBAR
    BEGIN
        CONTROL "  ~OK  ", 1, 104, 5, 41, 14, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "~Cancel", 2, 218, 5, 40, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 5, 55, 85, 70, 56, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "", 6, 146, 85, 70, 56, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "", 7, 236, 85, 70, 56, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "", 8, 77, 24, 213, 49, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "*", 10, 64, 160, 151, 10, WC_ENTRYFIELD, ES_LEFT | ES_MARGIN | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 17, 271, 160, 48, 10, WC_ENTRYFIELD, ES_LEFT | ES_MARGIN | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "{Nodes}", 11, 74, 144, 34, 8, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | WS_VISIBLE
        CONTROL "[Volumes]", 12, 159, 144, 41, 8, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "<Directories>", 13, 242, 144, 52, 8, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "Files", 14, 173, 75, 23, 8, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | WS_VISIBLE
        CONTROL "File name:", 15, 16, 160, 40, 8, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "Password:", 16, 222, 160, 42, 8, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "Search path:", 18, 8, 182, 51, 8, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "", 19, 62, 176, 155, 14, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_RESPONSEPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_RESPONSEPM, 74, 87, 292, 86, FS_NOBYTEALIGN | FS_DLGBORDER | 
                FS_BORDER | WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "", 5, 24, 21, 206, 8, WC_ENTRYFIELD, ES_LEFT | ES_MARGIN | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "OK", DLG_OK, 249, 52, 35, 14, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Cancel", DLG_CANCEL, 249, 19, 35, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 4, 22, 49, 210, 22, WC_STATIC, SS_TEXT | DT_LEFT | 
                DT_TOP | DT_WORDBREAK | WS_VISIBLE
    END
END
DLGTEMPLATE DB_SAVEPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_SAVEPM, 82, 93, 198, 59, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "", 9082, 8, 18, 120, 8, WC_ENTRYFIELD, ES_LEFT | ES_MARGIN | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "", 9081, 58, 40, 72, 12, WC_STATIC, SS_TEXT | DT_RIGHT | 
                DT_TOP | WS_VISIBLE
        CONTROL "Save file as:", 9084, 5, 40, 51, 12, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_VISIBLE
        CONTROL "~Save", DLG_OK, 146, 38, 35, 12, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Cancel", DLG_CANCEL, 145, 10, 35, 12, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_PAGESETUPPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "", DB_PAGESETUPPM, 40, 49, 176, 120, FS_NOBYTEALIGN | FS_DLGBORDER | 
                WS_VISIBLE | WS_CLIPSIBLINGS | WS_SAVEBITS
    BEGIN
        CONTROL "OK", DLG_OK, 137, 11, 29, 13, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_TABSTOP | WS_VISIBLE
        CONTROL "Cancel", DLG_CANCEL, 81, 11, 39, 13, WC_BUTTON, BS_PUSHBUTTON | 
                WS_TABSTOP | WS_VISIBLE
        LISTBOX, DLG_PTRLIST, 29, 36, 118, 57, 0|WS_VISIBLE|WS_GROUP|WS_TABSTOP
        CONTROL "Properties...", DLG_PROPERTIES, 17, 11, 53, 13, WC_BUTTON, BS_PUSHBUTTON | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "Default printer:", DLG_DEFAULT, 26, 100, 70, 8, WC_STATIC, SS_TEXT | 
                DT_LEFT | DT_TOP | WS_GROUP | WS_VISIBLE
    END
END

#endif /* CTOOS */
$$$

#ifndef NO_STD_ABOUT_BOX
/********************************/
/* PM STANDARD ABOUT BOX        */
/********************************/
DIALOG 9050,   106, 60, 300, 60   "" MODAL
	BUTTON 1,   224, 35, 70, 20   "Help" DEFAULT
	BUTTON 2,   224, 5, 70, 20   "Cancel"
	TEXT 4,   20, 5, 190, 16   "An XVT Application"
	TEXT 5,   20, 21, 190, 16   "Version 2.0"
	TEXT 6,   20, 37, 190, 16   "by XVT Software, Inc."
#endif /*About box*/

/*  open file dialog */
#if (XVTOS == CTOOS)
UNITS SEMICHARS
DIALOG		DB_OPEN		  56,   24,  204,  192	"Open a file" MODELESS
	BUTTON	DLG_OK		  52,  168,   32,   24	"  ~OK  "     DEFAULT
	BUTTON	DLG_CANCEL	  112,  168,   40,   24	"~Cancel"
	BUTTON	OPEN_HELP	 144,  168,   32,   24	" ~Help "     DISABLED HIDDEN
	LISTBOX	OPEN_NODE_LBOX	   4,   48,   60,   56
	LISTBOX	OPEN_VOL_LBOX	  72,   48,   60,   56
	LISTBOX	OPEN_DIR_LBOX	 140,   48,   60,   56
	LISTBOX	OPEN_FILE_LBOX	   4,  112,  196,   56
	EDIT	OPEN_SPEC_VAL	  44,   16,   64,   24  "*"
	EDIT	OPEN_PASS_VAL	 152,   16,   48,   24  ""
	TEXT	OPEN_WORK_TXT	   4,    0,  196,    8	""
	TEXT	OPEN_NOD_TXT	  20,   40,   28,    8	"{Nodes}"
	TEXT	OPEN_VOL_TXT	  84,   40,   36,    8	"[Volumes]"
	TEXT	OPEN_DIR_TXT	 144,   40,   52,    8	"<Directories>"
	TEXT	OPEN_FIL_TXT	  92,  104,   20,    8	"Files"
	TEXT	OPEN_SPEC_TXT	   4,   24,   40,    8  "File name:"
	TEXT	OPEN_PASS_TXT	 116,   24,   36,    8  "Password:"
	TEXT	OPEN_PATH_TXT	   4,    8,   48,    8  "Search path:"
	TEXT	OPEN_PATH_VAL	  52,    8,  156,    8  ""

UNITS PIXELS

/*
	Dialog boxes for page setup dialog
*/

DIALOG _psd_SETUP_DLG,			 80,  24, 336, 192 "Page Setup" MODAL
	BUTTON DLG_OK,				  8, 160,  64,  24    "~OK"    DEFAULT
	BUTTON _psd_Pr_CHANGE,		 80, 160,  72,  32 "Printer"
	BUTTON _psd_Pa_CHANGE,		160, 160,  96,  32 "Paper Size"
	BUTTON DLG_CANCEL,			264, 160,  64,  24  "~Cancel"
	TEXT 4,						 24,   8,  64,   8 "Printer:"
	TEXT _psd_Pr_NAME,			120,   8, 168,   8
	TEXT 6,						 24,  24,  88,   8 "Paper Size:"
	TEXT _psd_Pa_NAME,			120,  24, 168,   8
	TEXT _psd_Pa_SIZE,			120,  32, 168,   8
	TEXT 9,						 24,  48,  56,   8 "Copies:"
	EDIT _psd_COPIES,			 88,  48,  48,   8
	TEXT 11,					 24,  64, 144,   8 "Paper Orientation:"
	RADIOBUTTON _psd_PO_PORTRAIT,	 40,  72,  88,   8 "Portrait"		GROUP
	RADIOBUTTON _psd_PO_LANDSCAPE, 40,  80,  96,   8 "Landscape"
	TEXT 14,					 24,  96,  88,   8 "Paper Feed:"
	RADIOBUTTON _psd_PF_CONT,	 40, 104, 104,   8 "Continuous"	GROUP
	RADIOBUTTON _psd_PF_MANUAL,	 40, 112,  72,   8 "Manual"
	TEXT 17,					 24, 128,  72,   8 "Security:"
	RADIOBUTTON _psd_Se_NO,		 40, 136,  40,   8 "No"			GROUP
	RADIOBUTTON _psd_Se_YES,		 40, 144,  48,   8 "Yes"
	TEXT 20,					184,  48,  72,   8 "Priority:"
	EDIT _psd_PRIORITY,			264,  48,  40,   8
	TEXT 22,					184,  64,  88,   8 "Print Mode:"
	RADIOBUTTON _psd_Md_NORMAL,	200,  72,  72,   8 "Normal"		GROUP
	RADIOBUTTON _psd_Md_IMAGE,	200,  80,  64,   8 "Image"
	RADIOBUTTON _psd_Md_BINARY,	200,  88,  72,   8 "Binary"
	TEXT 26,					184, 104,  64,   8 "Quality:"
	RADIOBUTTON _psd_Qu_LETTER,	200, 112,  72,   8 "Letter"		GROUP
	RADIOBUTTON _psd_Qu_MEMO,	200, 120,  56,   8 "Memo"
	RADIOBUTTON _psd_Qu_DRAFT,	200, 128,  64,   8 "Draft"

DIALOG _psd_PrCHOICE_DLG,		200,  80, 152, 112 "Printers"	MODAL
	BUTTON DLG_OK,				  8,  80,  64,  24   "~OK"     DEFAULT
	BUTTON DLG_CANCEL,			 80,  80,  64,  24 "~Cancel"
	LISTBOX _psd_LBOX,			  8,   8, 136,  64

DIALOG _psd_PaCHOICE_DLG,		200,  80, 248, 104 "Paper Size"  MODAL
	BUTTON DLG_OK,				 16,  72,  64,  24   "~OK"  DEFAULT
	BUTTON DLG_CANCEL,			 96,  72,  64,  24 "~Cancel"
	RADIOBUTTON _psd_Pa_PRESET1,	 16,   8,  96,   8 "" 			GROUP
	RADIOBUTTON _psd_Pa_PRESET2,	 16,  16,  96,   8 ""
	RADIOBUTTON _psd_Pa_PRESET3,	144,   8,  96,   8 ""
	RADIOBUTTON _psd_Pa_PRESET4,	144,  16,  96,   8 ""
	RADIOBUTTON _psd_Pa_OTHER,	 16,  32,  72,   8 "Other"		GROUP
	EDIT _psd_WIDTH,			 96,  32,  56,   8
	TEXT 10,					152,  32,  24,   8 " x "
	EDIT _psd_LENGTH,			176,  32,  56,   8
	TEXT 12,					 96,  40, 120,   8 "Measurement In-"
	RADIOBUTTON _psd_INCHES,		120,  48,  72,   8 "Inches"	GROUP
	RADIOBUTTON _psd_MILLIMETERS,	120,  56, 112,   8 "Millimeters"
#endif /* CTOOS */
#endif /*pm dialogues*/

/*********************/
/* XVT/CH Dialogues  */
/*********************/
#if XVTWS ==  WMWS
/*
	Resource scripts for standard dialogs and miscellanea.
	Nothing in this file should be tampered with.
*/

/*
	Dialog box for ask(), error(), and note() functions
*/
DIALOG DB_ASK 120, 64, 408, 72   "" MODAL
	BUTTON DLG_OK, 320, 0, 80, 24 "" DEFAULT
	BUTTON DLG_NO, 320, 24, 80, 24 ""
	BUTTON DLG_CANCEL, 320, 48, 80, 24 ""
	TEXT 6, 8, 0, 112, 8 ""
	TEXT 5, 16, 24, 280, 24

/*
	Dialog box for get_str_response().
*/
DIALOG DB_RESPONSE 48, 64, 448, 72   "" MODAL
	EDIT DLG_RESPONSE,   8, 64, 432, 8  
	BUTTON DLG_OK, 368, 0, 64, 24 "~OK" DEFAULT
	BUTTON DLG_CANCEL, 368, 24, 64, 24 "~Cancel"
	TEXT DLG_PROMPT, 8, 8, 336, 40
	
/*
	Dialog box for get_choice().
*/
/* TODO what to do for get_choice? */

/*
	Dialog box for help topics
*/
#ifndef SHELP
DIALOG DB_HELPTOPICS 8, 16, 328, 128 "Help Topics" MODELESS
	LISTBOX 4, 8, 16, 312, 88
	CHECKBOX 6, 16, 112, 128, 8 "~Fresh Window"
	BUTTON DLG_CANCEL, 160, 104, 64, 24 "~Cancel"
	BUTTON DLG_OK, 256, 104, 48, 24 "~Help" DEFAULT
	TEXT 5, 16, 8, 176, 8 "Select help topic..."

/*
	Dialog box for help text
*/
DIALOG DB_HELPTEXT 160, 24, 464, 160 "Help Text" MODELESS
	LISTBOX 4, 8, 8, 448, 128 READONLY
	BUTTON DLG_CANCEL 64, 136, 64, 24 "~Cancel"
	BUTTON 6, 160, 136, 48, 24 "~Prev"
	BUTTON 5, 240, 136, 48, 24 "~Next"
	BUTTON DLG_OK, 320, 136, 64, 24 "~Topics" DEFAULT
#endif

/*
	Dialog box for standard file open
*/
/* TODO no standard file open dialog box */

/*
	Dialog box for standard file save
*/
/* TODO no standard file save dialog box */

/*
	Dialog box for about box
*/
#ifndef NO_STD_ABOUT_BOX
DIALOG DB_ABOUT 216, 40, 200, 72 "" MODAL
	TEXT 4,   8, 8, 184, 8   "An XVT Application"
	TEXT 5,   8, 16, 184, 8   "Version 1.5"
	TEXT 6,   8, 24, 184, 8   "by XVT Software, Inc."
	BUTTON DLG_OK, 120, 40, 48, 24 "~Help" DEFAULT
	BUTTON DLG_CANCEL, 32, 40, 64, 24 "~Cancel"
#endif

#endif /*xvtch dialogues*/

/*********************/
/* WS STRINGS        */
/*********************/
#if XVTWS == WINWS
STRING STR_APPNAME QAPPNAME
STRING STR_HELPTYPE "HLP"
#endif

/*********************/
/* MAC STRINGS        */
/*********************/
#if XVTWS == MACWS
STRING 9101 "XVTH"
#endif

/*********************/
/* PM STRINGS        */
/*********************/
#if XVTWS == PMWS
STRING STR_APPNAME QAPPNAME
STRING STR_HELPTYPE "HLP"
#endif

#if (XVTOS == CTOOS) || (XVTWS == WMWS)
/*************************************/
/* National Language Support strings */
/*************************************/
/* Strings must contain fewer than 128 characters */

/**** cnls.c ****/
STRING NLS_START   "String %d not found in resource file"

/**** cdlg.c ****/
STRING NLS_START+1	"OK"
STRING NLS_START+2	"Help"
STRING NLS_START+3	"~Help"
STRING NLS_START+4	"&Help"
STRING NLS_START+5	"Can't show response dialog (xvterrno = %d)"

/**** cdraw.c ****/
STRING NLS_START+6	"Icon #%d"
STRING NLS_START+7	"Picture"

/**** cfile.c && ctosfile.c ****/
STRING NLS_START+8	"File name on command line is too long: <%s>."
STRING NLS_START+9	"Can't change to saved directory [%d]"
STRING NLS_START+10	"Can't change to startup directory [%d]"
STRING NLS_START+11	"Can't put up open file dialog."
STRING NLS_START+12	"Can't get current directory."
STRING NLS_START+13	"Can't show current directory."
STRING NLS_START+14	"Error clearing."
STRING NLS_START+15	"Can't list files."
STRING NLS_START+16	"Can't add to list box."
STRING NLS_START+19	"Local"
STRING NLS_START+20	"Node"
STRING NLS_START+21	"Working..."
STRING NLS_START+22 "OS can't retrieve NODE or VOLUME info."
STRING NLS_START+23	"WARNING: INVALID PATH"
#if (XVTOS != CTOOS)
STRING NLS_START+24	"File pattern"
STRING NLS_START+25	"Directory pattern"
STRING NLS_START+26	"Volume pattern"
STRING NLS_START+27	"Node pattern"
#else
STRING NLS_START+24	"No files found in this directory"
STRING NLS_START+25	"No directories found for this Volume"
STRING NLS_START+26	"No Volumes found for this node"
STRING NLS_START+27	"No nodes found"
#endif
/**** cfont.c ****/
STRING NLS_START+28	"System"

/**** cimp.h ****/
STRING NLS_START+29	" NOTE "
STRING NLS_START+30	" ERROR "

/**** cmenu.c ****/
STRING NLS_START+36	"Quit"
STRING NLS_START+37	"File"

/**** cwindow.c and wwindow.c ****/
STRING NLS_START+43	"Untitled"		/* document title */

/**** dbg.c and wmisc.c ****/
STRING NLS_START+44	"---------- CLOSED ----------\n"

/**** lle_ctos.c ****/
STRING NLS_START+54	"Key not defined"

/**** port.c ****/
STRING NLS_START+55	"ERROR: %s (%d"
STRING NLS_START+56 "; "
STRING NLS_START+57 ")"
STRING NLS_START+58 "; %s)\n"

/**** ps_ctos.c ****/
STRING NLS_START+59	"This workstation not supported"

/**** ps_termc.c ****/
STRING NLS_START+60	"Terminal %s %s\n"
STRING NLS_START+61	"is not defined"
STRING NLS_START+62	"is not a CRT"
STRING NLS_START+63	"lacks cursor addressing"

/* STRINGS NLS_START+63 - NLS_START+75 defined in urlshelp.h */
#if (XVTOS != CTOOS)
/**** vhelp.c ****/
STRING NLS_START+64	"Can't access help file %s."
STRING NLS_START+65	"Out of memory."
STRING NLS_START+66	"Error reading help file."
STRING NLS_START+67	"No help on this topic yet."
STRING NLS_START+68	"Can't access data in help file."
STRING NLS_START+69	"Can't show help text dialog."
STRING NLS_START+70	"Can't show help topics dialog."
STRING NLS_START+71	"Can't change to help directory."
STRING NLS_START+72	"Can't get current directory."
STRING NLS_START+73	"Can't open '%s'"
STRING NLS_START+74	"Please locate '%s.hlp'"
STRING NLS_START+75	"Illegal file name: %s"
#endif 

/**** vslist.c ****/
STRING NLS_START+77	"NULL argument."
STRING NLS_START+78	"Empty list."
STRING NLS_START+79	"slist_get failed on element %d"
STRING NLS_START+80	"%4d: Refcon =%10ld   String = '%s'"

/**** vtc.c ****/
STRING NLS_START+81	"tc_create: (l:%d t:%d r:%d b:%d) overlaps an existing txedit."

/**** vtedit.c ****/
STRING NLS_START+82	"Text Edit style %d"

#if (XVTOS == CTOOS)
/**** psd_ctos.c ****/
STRING NLS_START+85	"Problem with NlsClass"
STRING NLS_START+88	"Problem getting resource string"
STRING NLS_START+89	"Problem with GPS (%s)"
STRING NLS_START+90	"Unrecognized paper size default"
STRING NLS_START+91	"Unrecognized current printer choice"
STRING NLS_START+92	"Problem getting or no item selected"
STRING NLS_START+94	"Width and Length fields are too long (max 7 digits each)"
STRING NLS_START+95	"Width field is too long (max 7 digits)"
STRING NLS_START+96	"Length field is too long (max 7 digits)"
STRING NLS_START+97	"Width and Length are not valid numbers"
STRING NLS_START+98	"Length is not a valid number"
STRING NLS_START+99	"Width is not a valid number"
STRING NLS_START+100 "The priority value is not a valid number"
STRING NLS_START+101 "The copies value is not a valid number"
STRING NLS_START+102 "The priority value cannot be over 99"
STRING NLS_START+103 "The copies value cannot be over 999"
STRING NLS_START+104 "Problem getting decimal point (using '.')"
STRING NLS_START+105 "Problem setting up dialog box"
STRING NLS_START+106 "US Letter"    /* default paper size; max length=20 */
STRING NLS_START+108 "US Letter"    /* max length=20*/
STRING NLS_START+109 "US Legal "    /* max length=20*/
STRING NLS_START+110 "A4"           /* max length=20*/
STRING NLS_START+111 "B5"           /* max length=20*/
STRING NLS_START+112 "Other"        /* max length=20*/
STRING NLS_START+113 "in"           /* inches; max length=4 */
STRING NLS_START+114 "mm"           /* millimeters; max length=4 */
STRING NLS_START+115 " x "          /* max length=4 */
STRING NLS_START+116 "Please fill in page width and page length"
STRING NLS_START+117 "Print job aborted: polygon/polyline does not fit on page"
STRING NLS_START+118 "Service not available"
STRING NLS_START+119 "Cluster down"

/* strings NLS_START+120 - NLS_START+199 define in urlshelp.h */

/** pmerror  **/
STRING NLS_START+200 "No error info available."

/** wdraw.c  **/
STRING NLS_START+205 "Can't access font %d" 
STRING NLS_START+206 "Bitmap Error"
STRING NLS_START+207 "Icon Error"
STRING NLS_START+208 "Picture still locked."

/** wprint.c **/
STRING NLS_START+215 "Cannot print."
STRING NLS_START+216 "(untitled)"
STRING NLS_START+217 "Not enough memory to print."
STRING NLS_START+218 "Not enough disk space to print."
STRING NLS_START+219 "Printing Error"
STRING NLS_START+220 "Error"
STRING NLS_START+221 "(Cancelling...)"
STRING NLS_START+222 "(Initializing)"
STRING NLS_START+223 "(Opening Printer)"
STRING NLS_START+224 "(Starting Document)"
STRING NLS_START+225 "(Started Document)"
STRING NLS_START+226 "(Ending Document)"
STRING NLS_START+227 "Page setup dialog not implemented."
STRING NLS_START+228 "(Starting Page %d)"
STRING NLS_START+229 "(Banding page %d)"
STRING NLS_START+230 "(Finishing Page %d)"    
STRING NLS_START+231 "Could not create print thread"

/** wdlg.c **/
STRING NLS_START+240 "OK"     /* label for button that signals OK     */
STRING NLS_START+241 "Cancel" /* label for button that signals cancel */
/*
** label for Help button in About Box - must match label in About Dialog 
*/	
STRING NLS_START+242 "Help"	   
STRING NLS_START+243 "Can't show about box." 

/** wfile.c **/

STRING NLS_START+245 "Illegal file name: %s."	   
STRING NLS_START+246 "File name is too long."	   
STRING NLS_START+247 "Can't change to saved directory [%d]"	   
STRING NLS_START+248 "Can't change to startup directory [%d]"

/** wmain.c **/
STRING NLS_START+250 "Incompatible XVT DLL"
STRING NLS_START+251 "Installation Error"

/** wmenu.c **/
STRING NLS_START+255 "Choose font ..."
STRING NLS_START+256 "Font~t"			/* label for font menu */

/** wmisc.c **/
STRING NLS_START+260 "Alert (Cancel exits program)"

/** nls_dll.c - some of these messages appear in the message file as well **/
STRING NLS_START+265 "Internal XVT Error: %u-%lu"
STRING NLS_START+266 "ERROR: %s"
STRING NLS_START+267 "System Error"
STRING NLS_START+268 "Recursive call to fatal: %s"
STRING NLS_START+269 "Original message: %s"
STRING NLS_START+270 "Fatal error in XVT/PM DLL: %d"

/** XVT/CH ICONS **/

STRING ICON_START+12	"---  ASK   ---"		/* Ask Box Icon */
STRING ICON_START+13	"-----  ERROR -----"	/* Error dialog Icon */
STRING ICON_START+14	"----  NOTE  ----"	/* Note dialog Icon */
#endif

#endif

#ifdef SHELP
#include "urlshelp.h"
#endif
