/* $Header:   E:/src/xvt/pmwin/vcs/xvthelp.h_v   2.1   03 May 1989 16:23:10   MJR  $ */
/* XVT Version 1.2 */
/* Copyright 1987,1988 Advanced Programming Inst., Ltd. All rights reserved. */
 
/*
	Header file to be shared between SHELP.C and SCHELP.C.
*/

/* include menu tags */

#include "shelpmenu.h"

#define HELP_MAGIC		27637
#define VERSION			2
#define MAX_TOPICS 		1000
#define MAX_TOPIC_TEXT	INT_MAX
#define N_FILE_POS		10
#define O_TOPICS		0
#define O_CONTEXT		1
#define O_LISTS			2
#define O_INDEX			3
#define O_LAST			4
#define SZ_TOPIC		49
#define SZ_RGOFFSETS	N_FILE_POS * sizeof(long)
#define SZ_FRONTSTUFF	(5 * sizeof(short) + SZ_RGOFFSETS)
#define SZ_HEADER		(SZ_FRONTSTUFF + SZ_TOPIC_BLK)
#define HEADER_SIZE(n)	(((n) - 1) * SZ_TOPIC_BLK + SZ_HEADER)
#define CTABLE_SIZE(n)  ( (n) * sizeof(CTABLE_ENTRY))
#define ITABLE_SIZE(n)  ( (n) * sizeof(ITABLE_ENTRY))
#define O_TOPIC_DESC(n) ( ((n) * SZ_TOPIC_BLK) + SZ_FRONTSTUFF)

typedef unsigned int TOPICNUM;

/* return indexing portion of TOPICNUM */
#define TOPICINDEX(n) ( (n))	

typedef struct {
	unsigned int no_wrap: 1, dummy:  15;
} TOPIC_ATTR_FLAGS;
 
typedef struct {
	long offset;				/* offset from end of header */
	short nlines;				/* number of lines of text in topic */
	TOPIC_ATTR_FLAGS flags;		/* attribute flags */
	int cbytes;					/* size of topic in bytes */
} TOPIC;
 
typedef struct {
	short hlpmagic;				/* magic number to identify file */
	short version;				/* version number */
	short ntopics;				/* number of topics */
	short ncstrings;			/* number of context strings */
	short nlists;				/* number of topic lists */
	long  rgoffsets[N_FILE_POS];/* array of help offsets */	
	TOPIC topics[1];			/* topics (variable length array) */
} HEADER;
 
typedef struct {
	char *str;				/* pointer to context string */
	int topic;				/* topic string belongs to */
} CTABLE_ENTRY;

typedef struct {
	char *str;				/* pointer to index string */
	int topic;				/* topic string belongs to */
} ITABLE_ENTRY;

#define SZ_TOPIC_BLK	(sizeof(TOPIC))


/*
** help messages, button text, etc. 
** this range is defined in url.h, along with the 
** nationalizable text 
*/

#define HLP_MSG_BASE		NLS_START+120
#define STR_HELP_HELP		HLP_MSG_BASE
#define STR_HELP_EXTENDED	HLP_MSG_BASE+1
#define STR_HELP_KEYS		HLP_MSG_BASE+2
#define STR_HELP_PATH		HLP_MSG_BASE+3
#define STR_NEXT_BUTTON		HLP_MSG_BASE+4
#define STR_PREV_BUTTON		HLP_MSG_BASE+5

/*
** error message numbers for cchelp
*/

#define MSG_MAX			  	255
#define MSG_NO_MORE_MEM 	1
#define MSG_WRITE_ERROR 	2
#define MSG_CONTEXT_EXISTS 	3
#define MSG_TOPIC_EXISTS 	4
#define MSG_NAME_LONG		5
#define MSG_TOPIC_START 	6
#define MSG_TOPIC_ENDS		7
#define MSG_CATEGORY		8
#define MSG_CONTEXT			9
#define MSG_TOPICLIST		10
#define MSG_TEXT_LONG		11
#define MSG_EOF				12
#define MSG_CREATE_FAILED	13
#define MSG_COPY_HDR		14
#define MSG_DONE			15
#define MSG_COPY_TEXT		16
#define MSG_COPY_CONTEXT	17
#define MSG_COPY_TOPICS     18
#define MSG_COPY_INDEX		19
#define MSG_N_TOPICS		20
#define MSG_N_CONTEXTS		21
#define MSG_N_TOPICLISTS	22
#define MSG_C_CONTEXTS		23
#define MSG_C_INDEX			24
#define MSG_USAGE			25
#define MSG_ERC_OPEN		26
#define MSG_TOPICS_MAXED	27
#define MSG_TOPIC_DETAIL	28
#define MSG_FATAL			29
#define MSG_NOT_YESNO		30
#define MSG_IN_TEXT			31
#define MSG_ILLEGAL_DOT		32
#define MSG_NO_TEXT			33
#define MSG_SUB_NO_MAIN		34
#define MSG_TMPFILE_FAIL	35
#define MSG_REMOVE_ILLEGAL	36
#define MSG_UNEXPECTED_EOF	37
#define MSG_LINE_TOO_LONG	38
#define MSG_PARAM_REQUIRED	39

