/*******************************************************************************
*  Copyright 1985 - 1990 by Advanced Programming Institute, Ltd.               *
*  All rights reserved.  May not be reproduced or distributed, in printed or   *
*  electronic form, without permission of Advanced Programming Institute, Ltd. *
*  May not be distributed as object code, separately or linked with other      *
*  object modules, without permission.                                         *
*******************************************************************************/



/* define MEMDEBUG1 to use a data segment per memory allocation on OS2 */

#ifdef OSOS2
#ifdef MEMDEBUG1
#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#define COLOR pm_COLOR		       /* trick to avoid multiple definition
                    * errors */
#define UINT pm_UINT
#define ULONG pm_ULONG
#include <os2.h>
#undef COLOR
#undef UINT
#undef ULONG
#endif
#endif

#include "xvt.h"
#include "cmalloc.h"

#if (XVTOS == BSDOS) || (XVTOS == SV0OS)
#include <sys/types.h>
#endif

/* {[( */

#ifdef DMALLOC
char           *dmalloc (char *file, int line, unsigned size);
void            dfree (char *file, int line, char *p);
char           *drealloc (char *file, int line, char *ptr, unsigned size);

#endif

#undef xvt_malloc
#undef xvt_free
#undef xvt_realloc
#define PAD 0

#ifdef FPROTO
char           *     XVTENTRY
xvt_malloc (size_t size)
#else
char           *     XVTENTRY
xvt_malloc (size)
size_t          size;

#endif
{
   return ((char *) xvt_fmalloc (size + PAD));
}

#ifdef FPROTO
void     XVTENTRY
xvt_free (char *ptr)
#else
void     XVTENTRY
xvt_free (ptr)
char           *ptr;

#endif
{
   xvt_ffree (ptr);
}

#ifdef FPROTO
char           *     XVTENTRY
xvt_realloc (char *ptr, size_t size)
#else
char           *     XVTENTRY
xvt_realloc (ptr, size)
char           *ptr;
size_t          size;

#endif
{
   return ((char *) xvt_frealloc (ptr, size + PAD));
}

#ifdef FPROTO
STR_FAR     XVTENTRY
xvt_fmalloc (size_t n)
#else
STR_FAR     XVTENTRY
xvt_fmalloc (n)
size_t          n;

#endif
{
#ifdef MEMDEBUG1
   SEL             sel;

   n = (n + 1) & 0xfffe;
   if (DosAllocSeg (n, &sel, SEG_NONSHARED))
      return NULL;
/*   dbg2(("xvt_fmalloc: 0x%lx", (char*)MAKEP(sel,0))); */
   return (char *) MAKEP (sel, 0);
#else
   return (char *) malloc (n + PAD);
#endif
}

#ifdef FPROTO
void     XVTENTRY
xvt_ffree (char far *p)
#else
void     XVTENTRY
xvt_ffree (p)
char    far    *p;

#endif
{
#ifdef MEMDEBUG1
   if (OFFSETOF (p) != 0)
      fatal ("bad pointer free: 0x%lx", (long) p);
/*   dbg2(("xvt_ffree: 0x%lx", p)); */
   if (DosFreeSeg (SELECTOROF (p)))
      fatal ("bad pointer free: 0x%lx", (long) p);
#else
   free (p);
#endif
}

#ifdef FPROTO
STR_FAR     XVTENTRY
xvt_frealloc (char far *p, size_t n)
#else
STR_FAR     XVTENTRY
xvt_frealloc (p, n)
char   far     *p;
size_t          n;

#endif
{
#ifdef MEMDEBUG1
   char far       *p2;
   ULONG           size;

   p2 = xvt_fmalloc (n);
   memset (p2, 0, n);
   DosSizeSeg (SELECTOROF (p), &size);
   memcpy (p2, p, min (n, (short) size));
   xvt_ffree (p);
   return p2;
#else
   return (char far *) realloc (p, n + PAD);
#endif
}

#ifdef DMALLOC
#ifdef FPROTO
void           *
vxvt_malloc (char *file, int line, size_t size)
#else
void           *
vxvt_malloc (file, line, size)
char           *file;
int             line;
size_t          size;

#endif
{
   void           *ptr;

   ptr = (void *) dmalloc (file, line, size);
   memset (ptr, 0, (int) size);
   return ((void *) ptr);
}

#ifdef FPROTO
void
vxvt_free (char *file, int line, void *ptr)
#else
void
vxvt_free (file, line, ptr)
char           *file;
int             line;
void           *ptr;

#endif
{
   dfree (file, line, ptr);
}

#ifdef FPROTO
void           *
vxvt_realloc (char *file, int line, void *ptr, size_t size)
#else
void           *
vxvt_realloc (file, line, ptr, size)
char           *file;
int             line;
void           *ptr;
size_t          size;

#endif
{
   void           *nptr;

   nptr = (void *) drealloc (file, line, ptr, size);
   return ((void *) nptr);
}

#endif

/* }]) */
