;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: IsSubs.asm                                                          *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* subroutines for 80X86 Input/Output Programming                            *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 09/12/90 121E/00 P. Johansson / Created                                   *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;
$TITLE(24 SEP 90: Subroutines for 80X86 Input/Output Programming)
$PAGEWIDTH(96)
$PAGELENGTH(60)

IoSubs	SEGMENT PUBLIC 'Code'
	ASSUME	CS:IoSubs

	PUBLIC	SaData
	PUBLIC	SaStack
	PUBLIC	Disable
	PUBLIC	Enable
	PUBLIC	Input
	PUBLIC	Output
	PUBLIC	InWord
	PUBLIC	OutWord

SaData	PROC	FAR
	MOV	AX,DS	;Function returns Data Segment base
	RET
SaData	ENDP

SaStack	PROC	FAR
	MOV	AX,SS	;Function returns Stack Segment base
	RET
SaStack	ENDP

Disable	PROC	FAR
	CLI		;Disable interrupts
	RET
Disable	ENDP

Enable	PROC	FAR
	STI		;Reenable interrupts
	RET
Enable	ENDP

Input	PROC	FAR
	PUSH	BP
	MOV	BP,SP
	MOV	DX,WORD PTR [BP+6]
	LOCK IN	AL,DX
	POP	BP
	RET	2
Input	ENDP

Output	PROC	FAR
	PUSH	BP
	MOV	BP,SP
	MOV	AL,BYTE PTR [BP+6]
	MOV	DX,WORD PTR [BP+8]
	LOCK OUT AL,DX
	POP	BP
	RET	4
Output	ENDP

InWord	PROC	FAR
	PUSH	BP
	MOV	BP,SP
	MOV	DX,WORD PTR [BP+6]
	LOCK IN	AX,DX
	POP	BP
	RET	2
InWord	ENDP

OutWord	PROC	FAR
	PUSH	BP
	MOV	BP,SP
	MOV	AX,WORD PTR [BP+6]
	MOV	DX,WORD PTR [BP+8]
	LOCK OUT AX,DX
	POP	BP
	RET	4
OutWord	ENDP

IoSubs	ENDS

	END
