;****************************** INCLUDE HEADER (_ALL.ASM) *******************;
;*                                                                          *;
;* Include file: Kernel_all.asm                                             *;
;*                                                                          *;
;* Machine: NGen/SGen         Language: Assembler           OS: CTOS        *;
;*                                                                          *;
;* Description:                                                             *;
;*                                                                          *;
;*        This include file defines ...                                     *;
;*                                                                          *;
;* History:                                                                 *;
;*                                                                          *;
;* MM/DD/YY VVVV/MM Programmer  / Description of change (Most recent first) *;
;*                                                                          *;
;*                                                                          *;
;* Title:  CTOS III OS Software                                             *;
;*                                                                          *;
;* ************************************************************************ *;
;*                                                                          *;
;* COPYRIGHT (C) 1992 UNISYS CORPORATION.  ALL RIGHTS RESERVED.             *;
;* UNISYS PROPRIETARY.                                                      *;
;*                                                                          *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE      *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH THE APPLICABLE   *;
;* PROGRAM LICENSE OR UPON WRITTEN AUTHORIZATION OF THE OFFICE OF THE       *;
;* GENERAL COUNSEL, PATENT AND TECHNOLOGY DIVISION, BLUE BELL,              *;
;* PENNSYLVANIA, 19424, USA.                                                *;
;*                                                                          *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND     *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,     *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF  *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO        *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                *;
;*                                                                          *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          *;
;*                                                                          *;
;*************************** END OF MODULE HEADER ***************************;
;	Kernel_all.asm
;
;	This file generates the following object modules depending on switches:
;
;	Module			Switches
;
;	Kernel_v   		workstation protected mode
;	Kernel_MFv   	Icc MF
;	Kernel_Icc   	Icc

%SET(UnlockAtWait, 1)

%IF(NOT %*IsDef(%MF)) THEN (%SET(MF,0))FI
%SET(NGen, NOT %MF)
%IF(NOT %*IsDef(%Icc)) THEN (%SET(Icc,0))FI

%IF(NOT %*IsDef(%Tracker)) THEN (%SET(Tracker,0FFh))FI
%IF(NOT %*IsDef(%instrument)) THEN (%SET(instrument,0))FI
%IF(NOT %*IsDef(%instrumentTrace)) THEN (%SET(instrumentTrace,0))FI
%IF(NOT %*IsDef(%suspendOffRunQ)) THEN (%SET(suspendOffRunQ,0FFh))FI
%IF(NOT %*IsDef(%Debug)) THEN (%SET(Debug,0FFh))FI
%IF(NOT %*IsDef(%ctosv)) THEN (%SET(ctosv,0))FI
%IF(NOT %*IsDef(%bsac)) THEN (%SET(bsac,0))FI
%IF(NOT %*IsDef(%kernelHooks)) THEN (%SET(kernelHooks,1))FI
%IF(NOT %*IsDef(%ConsistencyCheck)) THEN (%SET(ConsistencyCheck,1))FI

%'SET(rDeviceFilter, 1)
; rDeviceFilter enables global handle mapping for RequestDirect/ForwardRequest

$Include(:f1:Kernel.mdf)
$Include(:f1:fadstypesasm.edf)
$Include(:f1:descriptors.mdf)

%SET(Statistics,1)

%IF(%NGen) THEN (
wEarNewgenGc003Fake equ 0FFFFh	;* to fake ear on Gc003
newgenVideoBit equ 2			;* ParityEnablePortNGen bit
)FI

ARG0		EQU	10			;stack argument
argbSlot	EQU 14
argExchDirect	EQU 14
AXOFFSET	EQU	14
csRet equ 8
cws			EQU	1			;value of clusterConfig for cws
cws186		EQU 7			;processorType value for CWS workstation
Desc286_limit     equ word ptr es:[bx+0]
Desc286_base      equ word ptr es:[bx+2]
Desc386_base      equ es:[bx+2]
Desc286_baseHi    equ byte ptr es:[bx+4]
Desc286_access    equ byte ptr es:[bx+5]
Desc386_baseLimitMsb equ word ptr es:[bx+6]
Desc386_baseMsb   equ byte ptr es:[bx+7]
ercRet		EQU	8
exchg		EQU	14
exchResp	EQU	6			;in request block

exPcboSoftVecHead	EQU	0
exPcbDeltaPriority	EQU	2
exPcbSavedPriority	EQU	3
exPcbEar			EQU 4		;For Mp Ngen, Ear register is stored here
exPcbVectorState	EQU	8
exPcboVector		EQU	6
exPcbnwVectors		EQU	8
exPcbpVectorArea	EQU	10
exPcboNextPcb		EQU	14

FALSE		EQU	0
fDebug		EQU	16
bitSwapped	EQU	1			;contextStatus
bOp			EQU	10			;stack argument
bOpEnable	EQU	0
bOpDisable	EQU	1
bOpEoi		EQU	2
bOpEnableRst	EQU 3
fh			EQU	12			;file handle offset in request block
fSys		EQU	13			;stack argument
id			EQU	16
iExchg		EQU	14			;stack argument
initFlagV86Msb	EQU	0002H
initFlag	EQU	0200H
iRemote		EQU 1			;routeCase index
led			EQU	44H
; msgWait offsets
loMsgRaMsg		EQU	2
loMsgSaMsg		EQU	4
loMsgUserNum	EQU	6
loMsgWStatus	EQU	8

; msgType (in msgWait.wStatus)
lMsgRequest	EQU	8000h
lMsgRespond	EQU	4000h
lMsgSend	EQU	0
lMsgSendP	EQU	1000h
lMsgDealias	EQU	5000h	;Respond or SendP needs dealias
%if (%Tracker) then(%'
lMsgWantRes	EQU	0800h	;Want Respond (Request[Direct]--rgcRq bumped)
lMsgWait	EQU	0400h	;Rq picked up via Wait
lMsgAlt		EQU	0200h	;issuer isn't originator (msgWait.userNum <> rq.userNum)
)fi%'


lCarry 			EQU 1 	; FL carry bit

maskiExch	EQU 03FFh	; 1024 exchanges max
maskRealMode equ 1
maskLdt equ 4
maskSlot    EQU 03FFH       ;1024 usernums max
maskUserNum EQU 0FC00H
maskSrpSlot EQU 7Fh
maskRouteCase EQU 0Fh
mPswd		EQU 10h
mSpec		EQU 7
mCloseFh	EQU 6
NewGen		EQU 9			;processorType value for NewGen
nReqPbCb	EQU	2			;Offset in Rq
nRespPbCb	EQU	3			;Offset in Rq
newPriority	EQU	10			;stack argument
offsetPASCB	EQU	4
oMsgHead	EQU	0
oMsgTail	EQU	2
oPcbHead	EQU	4
oPcbTail	EQU	6
pBufferRet	EQU	18
pcbEar		EQU 16			; For Sp Ngen, Ear register is stored here
pcbSize		EQU	18

pcbStatus	EQU	2
ready		EQU	01h
suspends	EQU	1Eh
aSuspend	EQU	2
pcbfSem		EQU	20h		;Process is waiting for critical section semaphore
pcbbSem		EQU 5		;pcbfSem for use with BT instruction
pcbfSys		EQU	40h
pcbUsed		EQU	80h

pcbPriority	EQU	3
pcbExchgSync	EQU	12
pcbUserNum	EQU	14
pcboExPcb	EQU	16

sParDesc		EQU 42
parDescfLocked	EQU 30

pMsg		EQU	10			;stack argument
saMsg		equ 12
raMsg		equ 10
pOPcbCurrent	EQU	024Ch
pParamBlk	EQU	250h
ppMsgRet	EQU	10			;stack argument
raPMsgRet equ 10
saPMsgRet equ 12
pTyDevRet	EQU	10			;stack argument
Priority	EQU	12
prioOS		EQU	40h			;deltaPriority application lower limit
prioNeverRun	EQU	0ffh	;deltaPriority application upper limit
pRq			EQU	10			;stack argument
sgSend  equ 18h
saRq		equ 12
raRq		equ 10
sgGdt   equ 8
RaCode		EQU	0

rAX			EQU	18			; in processStruct
rBX			EQU	20			; in processStruct
rCX			EQU	22			; in processStruct
rDX			EQU	24			; in processStruct
rSI			EQU	26			; in processStruct
rDI			EQU	28			; in processStruct

; ldt segment header
roRgLdtLink			equ 0	
rsgMpSlSgIpc		equ 2
roSLAliasHead       equ 4
roCodeAliasHead     equ 6


PdhCPar   equ word ptr [si+rPdhCPar]
PdhPla    equ [si+rPdhPla]
PdhPlaV86 equ word ptr [si+rPdhPlaV86]

respExch	EQU	6
rqCode		EQU	10
rqUserNum	EQU	4
rtInfo EQU 1; offset in Rq

; routing info structure
rtiExch EQU 0
rtRtInfo EQU 2
rtSrpInfo EQU 2
rtNetInfo EQU 3

SaCode		EQU	2
SaData		EQU	4
SaExtra		EQU	6
saLowBound	EQU	4
SaStack		EQU	8
sCntInfo EQU 0			;offset in Rq
sgIdt equ 10h
sgVirtualLowMem equ 28h
sgLowMem  EQU 60h
oGpVector equ 104
oGpVectorReal equ 52
bAccessTaskGate equ 0E5h
csMediatedRet equ 0FFFEh
ipMediatedRet equ 0FFFCh
SizeStack	EQU	10
pTss		EQU	4H
SpSave		EQU	4H
sgLdt 		EQU	4H
sRqHeader	EQU 12
ssSave		EQU	6H
sgTss		EQU 6H
stackLimWord	EQU	5A5Ah

TRUE		EQU	1
tyDev		EQU	12			;stack argument
userNumInitial	EQU 2


;ercs
ercInconsistency		EQU	3
ercInternalError		EQU	8
ercExchOutOfRange		EQU	10
ercBadPointer			EQU	11
ercBadOpCode			EQU 28
ercDivideOverflow		EQU	27
ercNoMsgWait			EQU	12
ercNoMessage			EQU	14
ercNoPcb				EQU	18
ercNoSuchBus			EQU	36
ercNoSuchModule			EQU	35
ercNoSuchRequest		EQU	31
ercInconsistentRq		EQU	16
ercInvalidPid			EQU	39
ercMismatchedRespond	EQU	17
ercNoSuchVolume			EQU	215
ercBadFh				EQU 210
ercNotImplemented	   	EQU	7
ercBadRespExch			EQU	20
ercServiceNotAvail		EQU	33
ercOverflow				EQU	85
ercStackOverflow		EQU	90
ercStrayInterrupt		EQU	26
ercSwapping				EQU	37
ercBadRouting			EQU 159
ercBadPartitionHandle	EQU	803
ercPartitionVacant		EQU	805
ercLineNotConfigured	Equ	8602
ercNoFixupAvail			EQU 156
ercNoGhAvail			EQU 157
ercBadTyDev				EQU	441
ercRequestIncomplete	EQU	282
ercInterruptCantBlock	EQU	130
ercSemHandleInvalid EQU 13953
ercSemLocked EQU 13958
ercSemCannotWait EQU 13959
ercSemNotLocked EQU 86
ercSemNotOwned EQU 13955


EXTRN	Crash: FAR
EXTRN	ErrorExit:FAR 
EXTRN   FreeSoftVec:FAR
EXTRN	KResetTimerInt:FAR
EXTRN	KSetTimerInt:FAR 
EXTRN	RestoreDefaultTss:FAR
EXTRN	CheckErcBreak:FAR
EXTRN 	EnterV86:far
EXTRN 	IntraSegHeapAlloc:FAR
EXTRN 	IntraSegHeapDeAlloc:FAR

%if (%debug) then(%'
PUBLIC	ApplyDeltaPriorityBx
PUBLIC	Disp
PUBLIC	IDisp
PUBLIC	IntRet
PUBLIC	MediateInterrupt
PUBLIC	OsSubEntry
PUBLIC	SuspendPcb
PUBLIC	UnlinkPcb
PUBLIC	UnSuspendPcb
PUBLIC	VerifyPid
)fi%'

EXTRN UnThreadSg:FAR
EXTRN ThreadSg:FAR

EXTRN SC_LockRqPages:FAR
EXTRN SC_UnLockRqPages:FAR

%if (%bsac) then (
EXTRN CheckTrustLevel:FAR
EXTRN FetchUserNum:FAR
)fi

%IF(%CheckRqPointers) THEN (
PUBLIC	BadPointer
PUBLIC	BadPointerIndex
PUBLIC	pRqBadPointer
PUBLIC	BadPointerCb
PUBLIC	BadPointerRqCode
)FI

PUBLIC  baselinearOffset
PUBLIC	DeallocPcb
PUBLIC	Disp 
PUBLIC	fCheckRequestBlockConsistency	;used by RqLoadInit
PUBLIC	fCheckStackOverflow		;used by OSInit

PUBLIC pSCHeap
PUBLIC oSCHeapEntriesLimit
PUBLIC oSCHeapTCode

PUBLIC  IntRet
PUBLIC  SIntRet
PUBLIC  ResumeTaskWait
PUBLIC  KSendP
PUBLIC  sgTssGpFault
PUBLIC	KernelKillUser
PUBLIC	KernelJmpTable
PUBLIC	KPSend
PUBLIC	msgWaitCount 
PUBLIC	MsgWaitFree 
PUBLIC	nRqTiming
PUBLIC	nStackLim
PUBLIC	oExchRqTracker
PUBLIC	oFreePcb
PUBLIC	oIntSwTblLast
PUBLIC	oPcbrun 
PUBLIC  oPcbNull
PUBLIC	oRgExchg 
PUBLIC	oRgMsgWait
PUBLIC	oRgoStackLim
PUBLIC	oRgOUserPcb
PUBLIC	oRgPTiming 
PUBLIC	oRgPTimingUserNum
PUBLIC	pRgPTimingSwap
PUBLIC  prgcRq
PUBLIC  orgDeltaPriority
PUBLIC	ONextUserPcb
PUBLIC	OsSubEntry
PUBLIC	OsSubErrorExit

PUBLIC	RespondCheckSwap; for icc
PUBLIC	RespondCommon	; for icc
PUBLIC	rgMinSP			;used by OSInit
PUBLIC	RouteRequestLocal	; icc
PUBLIC	Runq 
PUBLIC	saDataOS
PUBLIC	saSemiMax
PUBLIC	saTempMin 
PUBLIC  wMsw287
PUBLIC	ServiceNotAvail	; for icc
PUBLIC	sgTssIntRetLast
PUBLIC	sysErrorBuf 
PUBLIC	sysTime 
PUBLIC	ThreadPcb
PUBLIC	UnthreadPcb
PUBLIC	userSignOn


PUBLIC	cAllctdParDesc
PUBLIC	oAllctdParDesc
PUBLIC	oParDesc
PUBLIC	orgExchgUserNum
PUBLIC	oRgExPcb
PUBLIC	oSoftVecRun
PUBLIC	softVecFree
PUBLIC	nSoftVecFree
PUBLIC	userNumSwap
PUBLIC	userNumPrimary
PUBLIC	vfRqTracker
PUBLIC	orgParDesc, orgIpcAliasHead
PUBLIC cwKernelJumpTable



KCode	SEGMENT	PUBLIC 'Code'
KCode	ENDS

;	OEMSeg is the OEM Common Area, allocated in Sysgen.mdf
OEMSeg SEGMENT PARA PUBLIC 'OEMSeg'
OEMSeg ENDS
NameCommon SEGMENT PARA PUBLIC 'OEMSeg'
NameCommon ENDS

%if (%instrument) then(%'
PUBLIC	Instrumentalist
PUBLIC	kiCounters
%if (%instrumentTrace) then(%'
PUBLIC	kiBuf
PUBLIC	vfKiTrace
)fi%'
KiSeg	SEGMENT WORD PUBLIC 'OEMSeg'
KiSeg	ENDS
)fi%'

;	non-DGroup data segs (above) get relocated to high memory by
;	RelocateOrphanData (initOsSubs)

DGroup	GROUP	Const, OsSubSeg, Data
Const	SEGMENT PUBLIC 'Const'
Const	ENDS

OsSubSeg SEGMENT PUBLIC 'Data'
OsSubSeg ENDS


Data	SEGMENT	PUBLIC	'Data'

EXTRN	bMySlot: BYTE
EXTRN	iMySlot: BYTE
%IF(%Icc) THEN (
EXTRN	mpbSlotiSlot: BYTE
EXTRN	mpiSlotbSlot: BYTE
EXTRN	routeCase: WORD
)FI
EXTRN	myLedPort: WORD

EXTRN	cbNodeName: BYTE
EXTRN	nodeName: BYTE
EXTRN	Config: BYTE
EXTRN	clusterConfig: BYTE
EXTRN	exchNet:WORD
EXTRN	exchAgent:WORD
EXTRN	HardwareType: BYTE
EXTRN	nExchg: WORD
EXTRN	nPcb: WORD
EXTRN	nSysRequest: WORD
EXTRN	nUcb: WORD
EXTRN	nUsrRequest: WORD
EXTRN	userNumLast: WORD
EXTRN   wMySlotBits: WORD
EXTRN   cpuLedState: BYTE
EXTRN   bLedCpu: BYTE

%if(%Statistics) then (
EXTRN TaskSwitch: DWORD
EXTRN IntTaskSwitch: DWORD
)fi

extrn sgTssIntLast: word
extrn sgTssPit:word
extrn pRgoGdtLink: dword
EXTRN ipRealDispatcher:word
EXTRN sgRealInterface:word
extrn sgRqInterface:word
extrn userNumPitMedInt:word
extrn nParDesc:word
extrn pRgSgLdt:dword
extrn vf:byte
$include(:f1:vfequ.idf)

EXTRN	fMulpar: BYTE
EXTRN	rgsgAsib:WORD

EXTRN	oRgPcb: WORD
extrn 	rgoOssubDesc:word
EXTRN	rgPrgLocalServiceCode: DWORD
EXTRN	rgPrgRouting: DWORD
EXTRN	rgRcMax: WORD
EXTRN	wsType: BYTE

%if(%kernelhooks)then(
EXTRN	rgbkernelhookinfo:	DWORD
)fi

%IF(%CheckRequestBlockConsistency) THEN (
EXTRN	prgNReqRespPbCbSys: DWORD
EXTRN	prgNReqRespPbCbUsr: DWORD
EXTRN	prgSCntlInfoSys: DWORD
EXTRN	prgSCntlInfoUsr: DWORD
)FI

EXTRN	saEndMemory: WORD
EXTRN	qChecksumSync: DWORD  ; needed for AlarmRaw int 6 handling
EXTRN	cpOsSubTable: WORD
EXTRN	osSubTable: DWORD
EXTRN	sgLdtOs: WORD
EXTRN	OCW2_8259: WORD
EXTRN   Ext8259_OCW1: WORD
EXTRN   Ext8259_OCW2: WORD
EXTRN	cascadeOCW2_8259: WORD
EXTRN   mAHighest: BYTE
EXTRN   mACascade: BYTE
EXTRN	mptyDevMask: WORD
EXTRN	tyDevMax: WORD
EXTRN   identityPdh: BYTE ; actually a pdh
EXTRN   videoPdh: BYTE    ; actually a pdh
EXTRN	pSemNodeFirst: DWORD; 


PUBLIC tssIdOnly, rgUserNumCritical, cUserNumCritical, cUserNumCriticalMax
PUBLIC userNumPS
tssIdOnly DW 0
cUserNumCriticalMax DW 8			;Allows 6 cluster user numbers
; NOTE: cUserNumCritaical and rgUserNumCritical form a structure
; accessed by GetpStructure
cUserNumCritical    DW 2			;Starts out with OS and PS
rgUserNumCritical   DW 0			;UserNum OS -- slot bits go here
userNumPS			DW 0			;Set by PsInterface
					DW 6 DUP(0)		;InstallAgent searches for zero entry
PUBLIC sKernelStack
sKernelStack DW 192	; configurable

	orgExchgUserNum	DW	?
	oParDesc		DW	0
	cAllctdParDesc	DW	0
	oAllctdParDesc	DW	0

	orgParDesc		DW	?
	orgIpcAliasHead	DW	?
	oExchRqTracker	DW	?	;exch assigned by sysgen, offset set in initKernel
	sgTssIntRetLast	LABEL WORD
	oIntSwTblLast	DW	0	;for debugging crashes
	oFreePcb		DW	0	;pcb free list
	oRgOUserPcb		DW	0	;pcb list heads, indexed by (local) userNum

fCheckRequestBlockConsistency	DB	%CheckRequestBlockConsistency ;used in RqLoadInit

%IF(%CheckRqPointers) THEN (
BadPointer		DW	2 DUP(0)	;To save bad pointer if bad pointer detected
pRqBadPointer	DW	2 DUP(0)	;To save pointer to rq if bad pointer detected
BadPointerIndex	DW	0
BadPointerCb	DW	0
BadPointerRqCode	DW	0
)FI

	rgMinSP		LABEL WORD
	fCheckStackOverflow	DB	0

				EVEN
MsgWaitFree		DW	2		DUP	(?)
Runq			DW	2		DUP	(0)
oPcbrun			DW	0
saDataOS		DW	DGroup	;(oPcbRun,saDataOS) forms a pointer

;NOTE: userNumPrimary and userNumSwap MUST be in this position following oPcbRun and saDataOs.
;LockCursor uses the pointer to oPcbRun to access oPcbRun UserNumPrimary, and userNumSwap.
	userNumPrimary	 DW	 userNumInitial
	userNumSwap		 DW	 0FFFFh

sgTssGpFault dw 0
baselinearOffset db 0h

vfRqTracker		DB	0			; Set by InitConfig, dynamic set via debugger 

EVEN
	msgType			DW	0

	;Soft Vector Data Structure

	oSoftVecRun		DW	0		; Initially no soft vectors.
	softVecFree		DW	0
	nSoftVecFree		DW	0
	fVectorUserRun	DB	FALSE

;Real Time Clock Data Structure

EVEN
sysTime			DW	4	DUP	(0)
sysErrorBuf		DW	8	DUP	(0)
userSignOn		DB	12	DUP	(0)
oRgPTiming		DW	?
nRqTiming		DW	0
oRgPTimingUserNum	DW	?
pRgPTimingswap	DD	?
prgcRq	DD	?		;Set up by InitKernel
orgDeltaPriority	DW	?

; public variables for memory management

				EVEN

pSCHeap dd 0
oSCHeapEntriesLimit dw 0
oSCHeapTCode dw 0

PUBLIC sgSpecHeap
sgSpecHeap DW 0

%IF(%NGen) THEN (
floppyChkBdWordAddr	DW	0
					DW	0
pFloppyChkBdBuffer	DD	0
floppyIoByteAddr	DW	0
					DW	0
pFloppyIoBuffer	DD	0
)FI

orgExchg		DW	0
orgMsgWait		DW	0
msgWaitCount	DW	0
saSemiMax		DW	0
saTempMin		DW	0
fReplaceAllTasks	DB	0
oRgExPcb		DW	0
oRgoStackLim	DW	0
nStackLim		DW	0
oPcbNull		DW  0

PUBLIC oPcbCriticalSection
oPcbCriticalSection DW 0
	
%IF (not(%Icc)) THEN (
PUBLIC sgTermTable	
sgTermTable DW 0	; dummy for non-icc OS's
)FI


%IF (%trace) THEN (
PUBLIC  TraceUserNum
PUBLIC  pTraceBuffer
PUBLIC  TraceRqCode
PUBLIC  TraceExchg
PUBLIC  TraceIndex
PUBLIC  cbTraceBuffer
sKernelTraceEntry	EQU	16
DummyTraceBuffer	DB   sKernelTraceEntry	 DUP (?)
pTraceBuffer    	DD 	DummyTraceBuffer
TraceUserNum    	DW 	0
TraceRqCode			DW	0
TraceExchg			DW	0
TraceIndex			DW	0
cbTraceBuffer		DW	sKernelTraceEntry
)FI

%if (%instrument) then(%'
;
; Kernel Instrumentation Segment (kiSeg)
;
kiSeg	SEGMENT

%if (%instrumentTrace) then(%'
;
; each time a kiCounter is bumped (see Instrumentalist), an entry is added to
; a circular trace buffer.  This buffer is a "pseudo stack"--it has a valid
; stack structure so that the debugger's CODE-T may be used to get a formatted
; symbolic display of recent kernel activity (e.g. '*1,0,kiBuf^t').
; Each entry in the trace buffer (pseudo stack frame) contains:
;
;  0  offset of next entry (= .+sKiFrame)
; +2  ip
; +4  cs
; +6  if ctosP then current tss else if fProcess then oPcbRun else 0
; +8  kiCounters offset
; +9  an ascending sequence number
;
sKiFrame		EQU 10
nKiFrames		EQU	32

kiBuf			DB	nKiFrames*sKiFrame DUP (0)
kiBufEnd		EQU THIS WORD
oKiBuf			DW	kiBuf				;offset to next kiBuf entry
kiBufSeq		DW	0					;seq # for next kiBuf entry
vfKiTrace		DB	0FFh				;trace enable switch
EVEN
)fi%'
kiCounters		LABEL WORD				;array of counters follow

kiSeg	ENDS


%set (oNextInst,0)

%*define (defInstrument(inst)) (%'		;define a kiCounter
lo%Inst	EQU	%oNextInst
kiSeg	SEGMENT
c%Inst			DW	0
kiSeg	ENDS

%set (oNextInst,%oNextInst+2)%'
)%'
%defInstrument(Wait)			%'00 calls to wait, check, waitlong
%defInstrument(WaitBlock)		%'02 waits that blocked
%defInstrument(WaitWU)			%'04 waitLongs that sent wakeUp
%defInstrument(SendMsgWait)		%'06 send, request, etc to vacant exchange
%defInstrument(SendMsg)			%'08 send, request, etc to waiting process
%defInstrument(Dispatch)		%'0A switched to task
%defInstrument(ResumeTaskWait)	%'0C switched to task to pickup incoming msg
%defInstrument(SuspendPcb)		%'0E suspended a task
%defInstrument(UnSuspendPcb)	%'10 unsuspended a task

%*define(IncInstrument(inst)) (%'		;increment a kiCounter
	PUSH	lo%Inst
	CALL	Instrumentalist
)%'
) else (%'
%*define(defInstrument(inst))()%'
%*define(IncInstrument(inst))()%'
)fi%'


;*****************************************************************************
;   Kernel Call Switch Table
;*****************************************************************************

cwKernelJumpTable					DW  KernelTableSize/2 
	    DW  Kernel						; kernel CS

KernelJmpTable	LABEL	WORD
		DW	GSend						;0
		DW	GWait						;1 
		DW	GCheck						;2 
		DW	GCreateProc					;3 
		DW	GRequest					;4 
		DW	GRespond					;5 
		DW	GSend						;6 PSend
		DW	GSetTimerInt				;7 
		DW	GResetTimerInt				;8 
		DW	MediateInterrupt			;9 
		DW	GChangePriority				;A 
		DW	GRequestDirect				;B 
		DW	GRequestRemote				;C  
		DW	GSendRemote					;D  
		DW	GSetDeltaPriority			;E 
		DW	GChangeProcessPriority		;F
		DW	GNewProcess					;10
		DW	GKillProcess				;11
		DW	GRescheduleProcess			;12
		DW	GForwardRequest				;13 
		DW	GFork						;14
		DW	GWait						;15 WaitLong = Wait
		DW	GSetDispMsw287				;16
		DW	GControlInterrupt			;17
		DW	GDeviceInService			;18
		DW	GSuspendUser				;19
		DW	GUnSuspendUser				;1A
		DW	GSuspendProcess				;1B
		DW	GUnSuspendProcess			;1C
; kernel calls below are not supported from RMOS
KernelTableSizeRMOS	EQU	OFFSET THIS WORD - OFFSET KernelJmpTable
		DW	GKernelLockCritical			;1D
		DW	GKernelClearCritical		;1E
		DW  GQueryProcessInfo			;1F
		DW  GProcessControl				;20
		DW  GSetKernelMode				;21
		DW  GSendRequest				;22

KernelTableSize	EQU	OFFSET THIS WORD - OFFSET KernelJmpTable
; Used in run-time bounds check.


DateTimeZero	DD	 0			; for bogus AddQueueEntry requests
wMsw287 DW 0		        ; for multiple 80287 process dispatching
Data	ENDS



KGroup  GROUP Kernel

Kernel	SEGMENT	PUBLIC	'Code'
ASSUME	CS: KGroup, DS: Dgroup
$MOD286

%IF(%Icc) THEN (
EXTRN	GRequestRemote: Near
EXTRN	GSendRemote: Near
EXTRN	RespondToSlot: Near
EXTRN	RespondAlias: Near
EXTRN	RequestToSlot: Near
)FI
EXTRN   ExpandRqSpecs:NEAR
EXTRN   FreeRqSpecs:NEAR

%if (%rDeviceFilter) then (
EXTRN	MapGlobalHandle:NEAR
)fi


; kernel exit jump table
KernelExitJmpTable PROC FAR	
PUBLIC KernelExitJmpTable
KernelExitJmpTableT LABEL WORD

DW KRet0, KRet2, KRet4, KRet6, KRet8, KRet10, KRet12, KRet14

KRet0:	RET
KRet2:	RET 2
KRet4:	RET 4
KRet6:	RET 6
KRet8:	RET 8
KRet10:	RET 10
KRet12:	RET 12
KRet14:	RET 14

KernelExitJmpTable ENDP




PUBLIC pCEntry
pCEntry:
;*****************************************************************************
; This routine is the common RMOS entry point for all Kernel calls. 
; Called from RmosSwitch
;	
; on entry:
;	BX = encoded IP
;	SI = encoded CS
;	SS:SP ->	FL
;				IP
;				CS
;				args
;*****************************************************************************
	NOT		SI
	AND		BX, 0Ch
	ADD		BX, SI
	SHR		BX,1
	CMP		BX, KernelTableSizeRMOS
	JAE		CEntryErrorExit
	MOV		AX, Dgroup
	MOV		ES, AX
	POPF
	JMP		ES:WORD PTR KernelJmpTable[BX]	

CEntryErrorExit:
; don't know how many arguments to pop - must kill user.
	MOV		AX, ercServiceNotAvail
	JMP		KillUser		; In KernelKillUser, below.





;*****************************************************************************
;	MediateIntHandler: PROCEDURE(fDeviceInt) ErcType PUBLIC
;
;	Convert raw interrupt handler into mediated interrupt handler.   
;	There is one argument on the stack. If fDeviceInt = 1, the
;	interrupt handler services device generated interrupts; otherwise
;	it services software generated interrupts.
;*****************************************************************************
MediateInterrupt:
; Just set up kernel return address on interrupt stack.
; NOTE: Interrupt DS in effect, not OS DGroup


; WARNING - protected mode master (mstrlph_all.asm) depends on BP
; being preserved across a call to MediateIntHandler
	cli
	pop dx ; ret IP
	pop si ; ret CS
	pop cx ; fDeviceInt
	add sp, 18 ; discard parameters
	mov ss:[csMediatedRet], cs
; if fDeviceInt then use IntRet
	mov ax, offset IntRet
	or cx, cx
	jne SetupIntRet
	mov ax, offset SIntRet
SetupIntRet:
	mov ss:[ipMediatedRet], ax
	PUSH	SI		; ret CS
	PUSH	DX		; ret IP
	XOR		BX, BX	; Zero ES to avoid double-fault on task switch ...
	MOV		ES, BX	; ... if we are interrupted and must resume.
	STI				; enable interrupts
MediateRet	PROC	FAR
	RET
MediateRet	ENDP

;*****************************************************************************
;
;	SetTimerInt: PROCEDURE(pTPIB) ErcType PUBLIC
;
;*****************************************************************************
%EnterKernel(SetTimerInt, l2Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     pTpib

	mov		bx, oPcbRun
	mov		bx, word ptr [bx+pcbUserNum]

	str		ax
	cmp		ax, sgTssIntLast
; if take jump, bx is user num from caller's pcb
	ja		DoSetTimerIntAliasing

; Called from an interrupt handler on behalf of an unknown user.
; Determine if real or protected caller.

	mov		ax, word ptr [bp+csRet]
	cmp		ax, sgRealInterface
	jne     CheckForGdt

; SetTimerInt from a real mode interrupt handler works only if
; userNumPitMedInt is set up (that is, from a RMOS PIT interrupt).

	str		ax
	cmp		ax, sgTssPit
	je		RealModePitOK
	jmp		SetTimerIntFailure
RealModePitOK:
	mov		bx, userNumPitMedInt
	cmp		bx, 0FFFFh
	jne		DoSetTimerIntAliasing
	jmp		SetTimerIntFailure

CheckForGdt:
; Check the CS of the caller.  If the caller is GDT based, no
; need to do any aliasing.
	test	ax,maskLdt				;ax = CSret
	jz		CallKSetTimerIntOS

; If handler is LDT based, get user number in bx and
; do aliasing.  
	sldt	ax					;Assert AX = sgLdt
	cmp		ax,sgLdtOs
	je		CallKSetTimerIntOS
	les		di, pRgSgLdt
	mov		cx, nParDesc
	mov		bx, cx
	cld
	repnz	scasw
; if zero flag not set, means lookup failed
	jnz		SetTimerIntFailure
; user number = nParDesc - number of iterations not done - 1
	sub		bx, cx
	dec		bx
DoSetTimerIntAliasing:
; alias pTPIB
    OR      BX, wMySlotBits     ;blast slot info into user number
	mov		ax, word ptr [bp+saRq]
	call 	CreateIPCAliasBxUser
; Set es:si to point to tpib
	mov		es, ax
	mov		si, word ptr [bp+raRq]
	xchg	word ptr [bp+saRq], ax	;ax has unaliased saRq

; Check to see if message option is being used.

	raRqBlkRet equ 16
	saRqBlkRet equ 18
	csIntHandler equ 10
	cmp		word ptr es:[si+csIntHandler],0
	jne		SetTimerIntOption
; If cs of pIntHandler = 0, then message option is being used.  
; If so, don't alias pRqBlkRet.  Store unaliased pRqBlk in this field.
	mov		es:[si+raRqBlkRet],si	;si = raRq
	mov		es:[si+saRqBlkRet],ax	;ax = unaliased saRq
	jmp		short SetTimerPushUserNum
SetTimerIntOption:
; alias pRqBlkRet in timer pseudointerrupt block
	mov		ax, word ptr es:[si+saRqBlkRet]
	call 	CreateIPCAliasBxUser
	mov		es:[si+saRqBlkRet], ax
SetTimerPushUserNum:
	push	BX					;userNum parameter for KSetTimerInt

; push fRealCaller flag
	mov		bx, sgRealInterface
	cmp		bx, word ptr [bp+csRet]
	jne		CallKSetTimerIntProtected
CallKSetTimerIntReal:
	push	0FFFFh	;fRealCaller = true
	jmp		SHORT CallKSetTimerInt
CallKSetTimerIntOS:
; Check to see if message option.
	les		si,dword ptr [bp+raRq]	;es:si points to tpib
	cmp		word ptr es:[si+csIntHandler],0
	jne		CallKSetTimerUserNum0
; Store pRqBlk in pRqBlkRetField.
	mov		es:[si+raRqBlkRet],si	;si = raRq
	mov		es:[si+saRqBlkRet],es	;es = saRq
	
CallKSetTimerUserNum0:
	push	0		;userNum = 0
CallKSetTimerIntProtected:
	push	0		;fRealCaller = false
	
CallKSetTimerInt:
	CLI				;Disable interrupts
	CALL	KSetTimerInt
	SUB     SP, 14	;KSetTimerInt pops entire stack frame
SetTimerIntRet:
	MOV		DI, l2Argw
	JMP		KernelRet

SetTimerIntFailure:
	mov		ax, ercNotImplemented
	jmp		short SetTimerIntRet


;*****************************************************************************
;
;	ResetTimerInt: PROCEDURE(pTPIB) ErcType PUBLIC
;
;*****************************************************************************
%EnterKernel(ResetTimerInt, l2Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     pTpib

	mov		ax, word ptr [bp+saRq]
	call 	CreateIPCAlias
	mov		word ptr [bp+saRq], ax
	CALL	KResetTimerInt
	SUB     SP, 14	;KReSetTimerInt pops entire stack frame
	MOV		DI, l2Argw
	JMP		KernelRet


;
;	KSendP: PROCEDURE(iExchg, pMsg) REENTRANT;
;
;	Ala KSend, but pMsg is presumed to be a valid pointer (sg, sl, sr).
;
;	If pMsg is an sg, it will be dealiased by the receiving user; pMsg
;	need not be marked present (main feature of this proc).
;
;	If pMsg is an sl or sr (real mode caller), an sg alias is created
;	(currently no clients of this mode).
;
;	This procedure is used instead of FarDealiasIPCSelector & KSend to allow
;	the sending of absent selectors and migration of dealiasing overhead into
;	the client's task.  Currently only used by RTCInterrupt.
;
KSendP		PROC FAR
	MOV		DI, l3Argw+lSysEntry
	CLC		;  reset stack-switched bit in saved flags
	PUSHF
	PUSH	BP
	PUSH	DS
	MOV		AX, DGroup
	MOV		DS, AX
	MOV		BP,SP

	MOV		SI, [BP+iExchg]

; send-from-process-to-special-exchange behavior (ala Send, below) isn't needed

	MOV		CX, [BP+saMsg]
	JCXZ	SendPBadPointer
	MOV		BX, [BP+raMsg]
	XOR		AX, AX
	MOV		ES, AX
%if (0) then (%' RTCInterrupt really our only client, so optimize for that usage
    MOV		AX, [BP+csRet]
    CMP		AX, sgRealInterface
    JE		SendPAlias
    TEST	CL, maskLdt
    JNZ		SendPAlias
)fi%'
	; sendPing sg, dealias at destination
	JMP		DoSendP
    
SendPAlias:
	; pMsg is sl/sr--make alias and send it
	MOV		AX, CX
	CALL	CreateIPCAlias
	MOV		CX, AX
	JMP		DoSend

SendPBadPointer:
	MOV		AX, ercBadPointer		;unlike send, we require a valid selector
	JMP		KernelExit				;i.e. crash

KSendP		ENDP

;*****************************************************************************
;
;	KSend: PROCEDURE(iExchg, qMsg) REENTRANT;
;	KPSend: PROCEDURE(iExchg, qMsg) REENTRANT;
;
;*****************************************************************************

%EnterKernel(Send, l3Argw + lExchArg, fStackSwitch+fKCall, lSendHook) 
KPSend EQU KSend
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     high(qMsg)
;			 low(qMsg)
;			 exch

	MOV		SI, [BP+iExchg]
; if Send from a process to exchNet or exchAgent, this is really a request
	cmp		si, exchAgent
	je		SendProcessCheck
	cmp		si, 12
	je		SendProcessCheck
	test	exchNet, 0FFFFh
	jz		ContinueSend
	cmp		si, exchNet
	jne		ContinueSend
SendProcessCheck:
	str		ax
	cmp		ax, sgTssIntLast
	jbe		ContinueSend
	or		di, lNoRqLookup
	jmp		RequestDirectEntry
ContinueSend:
	xor		ax, ax
	mov		es, ax
	mov		cx, word ptr [bp+saMsg]
	mov		bx, word ptr [bp+raMsg]
	JMP		DoSend


RespondBadPointer:
	JMP		BadPointerRet


;*****************************************************************************
;
;	KRespond: PROCEDURE(pRq) REENTRANT;
;	Respond: PROCEDURE(pRq) ErcType REENTRANT;
;
;*****************************************************************************
; GRespond: (pRq)
; KRespond: (pRq)
%EnterKernel(Respond, l2Argw + lcRqDec + lMsgRqUsernum, fStackSwitch + fKCall, lRespondHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snRq
;			 raRq

%IF(%Icc) THEN (
;	DL is the bSlot that returned the request.
;	Used in RespondAlias for global handle building.
	MOV		DL, bMySlot
)FI
RespondCommon:; RespondFromRemote comes here with DL = remote slot.
	PUSH		[BP+4]
	POPF						;Set user flags (enable)
%if(0)then(%' Respond pRq must already be aliased to gdt.
	mov		ax, word ptr [bp+saRq]
	or		ax, ax
	jz		RespondBadPointer
	call 	CreateIPCAlias
	mov		es, ax
	mov		[bp+saRq], ax		; so later LES BX, [BP+saRq] will work.
	mov		bx, word ptr [bp+raRq]
)else(
	LES		BX, DWORD PTR [BP+pRq]	;ES:BX points to request block
	MOV		CX, ES				
	JCXZ	RespondBadPointer
	CMP		ES: WORD PTR [BX+ercRet], 0
	JE		ercRetOk	

	PUSHF
; Save pointer to request block.  This also makes it easier to find
; the request block from a CODE-T because it appears in the stack trace.
	PUSH	ES
	PUSH	BX
	PUSH	ES: [BX+ercRet]					;ercRet
; Disable because if we go to the Debugger from the file system, and
; the Debugger tries to use the file system, the system hangs.
	CLI
	CALL	CheckErcBreak
	POP		BX					;Restore pointer to request block
	POP		ES
	POPF

ercRetOk:
)fi
			
%IF(%Icc) THEN (
	MOV		AL, BYTE PTR ES: [BX+respExch+1]
	SHR		AL, 2
	JZ		RespondCheckAlias
	CMP		AL, iMySlot
	JE		RespondCheckAlias
;	Respond to another cpu
%if (%Tracker) then (%'
	TEST	vfRqTracker, 1
	JZ		RespondRqTrackerDone
	PUSH	ES					;saMsg
	PUSH	BX					;raMsg
	CLI							;disable
	CALL	RqTrackerRemoveMsg
	PUSH	[BP+4]
	POPF						;enable maybe
RespondRqTrackerDone:
)fi%'
	JMP		RespondToSlot	;(AL=iSlot)

RespondCheckAlias:
	JMP		RespondAlias
)FI

RespondCheckSwap:
; free spec heap
	CALL 	FreeRqSpecs

	MOV		SI, ES: [BX+respExch]
	JMP		DoSendRespond


;***************************************************************************** ;
;	SendRequest: PROCEDURE(exch,pRq) REENTRANT;
;		Like ForwardRequest was supposed to work.  No routing, link block
;		gets rq.userNum for termination (important for exchanges terminated
;		using ReclaimMsg).
;*****************************************************************************
;SendRequest:
;KSendRequest:

%EnterKernel(SendRequest, l3Argw + lExchArg + lNoRqLookup + lMsgRqUsernum, fStackSwitch + fKCall, lForwardRequestHook)

; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snMsg
;			 raMsg
;			 exch
	mov		ax, word ptr [bp+saRq]
	or		ax, ax
	jz		BadPointerRetJmp
	mov		es, ax
	mov		bx, word ptr [bp+raRq]
	JMP		ForwardRequestEntry

BadPointerRetJmp:
	JMP		BadPointerRet

;***************************************************************************** ;
;	RequestDirect: PROCEDURE(exch,pRq) REENTRANT;
;*****************************************************************************
;RequestDirect:
;KRequestDirect:

%EnterKernel(RequestDirect, l3Argw + lExchArg + lcRqInc, fStackSwitch + fKCall + fECall, lRequestDirectHook) 

; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snMsg
;			 raMsg
;			 exch
	JMP		RequestDirectEntry


;***************************************************************************** ;
;	ForwardRequest: PROCEDURE(iExch,pRq) ErcType REENTRANT;
;
;	ForwardRequest is not quite like RequestDirect -- 
;	we do not call LockRqPages
;
;*****************************************************************************
;GForwardRequest:
;KForwardRequest:

%EnterKernel(ForwardRequest, l3Argw + lExchArg, fStackSwitch + fKCall, lForwardRequestHook) 

; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snMsg
;			 raMsg
;			 exch

%if (%bsac) then (
	call	FetchUserNum
	call	CheckTrustLevel
	or		ax,ax
	jnz		ForwardRequestFail
)fi

	mov		ax, word ptr [bp+saRq]
	or		ax, ax
	jz		BadPointerRet
	call 	CreateIPCAlias
	mov		es, ax
	mov		bx, word ptr [bp+raRq]
	JMP		ForwardRequestEntry


BadPointerRet:
%IF(%CheckRqPointers) THEN (
	MOV		pRqBadPointer,BX	
	MOV		pRqBadPointer+2,ES						;Save pointer to request
	MOV		AX,ES:[BX+rqCode]
	MOV		BadPointerRqCode,AX
)FI
	MOV		AX, ercBadPointer
ForwardRequestFail:
	JMP		KernelExit

NoSuchRequest:
	TEST	DI, lExchArg
	JNZ		NoSuchRequestButKnowExch
; Route to node or exchange according to CX,DX.  No fascist ercs.
	MOV		DH, BYTE PTR ES:[BX+rtInfo]
	TEST	DH, 0Fh
	JNZ		NoSuchRequestButKnowExch
	MOV		AX, ercNoSuchRequest
	JMP		KernelExit

NoSuchRequestButKnowExch:
; CX = exchange to route to, zero if Request.
; DL = srp info, iRemote if Request.
; DH = net info from request block.
	JMP		DoSendRequest

AgentExpress:
	CMP		clusterConfig,cws
	JE		NotExpress
	OR		DI, lExpress
	JMP		UserNumOk


;*****************************************************************************
;
;	KRequest: PROCEDURE(pRq) REENTRANT; 
;	Request: PROCEDURE(pRq) ErcType REENTRANT; 
;
;*****************************************************************************
;GRequest: (pRq)
;KRequest: (pRq)

%EnterKernel(Request, l2Argw + lcRqInc, fStackSwitch + fKCall + fECall, lRequestHook) 

; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snMsg
;			 raMsg

PUBLIC RequestDirectEntry
RequestDirectEntry:
	TEST	DI, lExpress
	JNZ		UserNumOk
	mov		ax, word ptr [bp+saRq]
	or		ax, ax
	jz		BadPointerRet
	call 	CreateIPCAlias
	mov		es, ax
	mov		[bp+saRq], ax		; so later LES BX, [BP+saRq] will work.
	mov		bx, word ptr [bp+raRq]
; Express service for MstrAgent
	MOV		AX, ES:[BX+exchResp]
	CMP		AX, 12
	JE		AgentExpress
	CMP		AX, exchAgent
	JE		AgentExpress
NotExpress:

; After we alias the pointers, DI will tell us we need to call LockRqPages
	OR		DI,lLockRqPages		;

;	If rq.userNum is zero, replace it with pcbRun.userNum.
;	If rq.userNum is one, replace it with userNumPrimary.
%if (%Icc) then(%' SRP
;	If rq.userNum has slot bits set, leave it alone.
;	If rq.userNum is greater than one and has no slot bits, add my slot bits.
	MOV		AX, ES: [BX+rqUserNum]
	TEST	AX, maskUserNum
	JNZ		UserNumOk			; Slot bits are set -> leave userNum be
	CMP		AX, 1
	JA		SetUserNumSlot
	MOV		SI, oPcbRun
	MOV		AX, [SI+pcbUserNum]
	JNE		SetUserNumSlot			; userNum=0 -> userNumPcb
	MOV		AX, userNumPrimary	; userNum=1 -> userNumPrimary
	OR		AX, wMySlotBits
	MOV		ES: [BX+rqUserNum], AX
	JMP		UserNumOk
SetUserNumSlot:					; userNum <> 1,  add my slot bits
	OR		AX, wMySlotBits

)else(%' WS
	CMP		WORD PTR ES: [BX+rqUserNum], 1
	JA		UserNumOk
	MOV		SI, oPcbRun
	MOV		AX, WORD PTR [SI+pcbUserNum]
	JNE		UserNumPcb	; <> 1 -> = 0 then jmp
	MOV		AX, userNumPrimary
	MOV		ES: [BX+rqUserNum], AX
	JMP		UserNumOk
)fi%'

UserNumPcb:
; RequestDirect doesn't get the rq.userNum=pcbRun.userNum treatment. Filters
; need the original userNum propogated.
	TEST	DI, lExchArg	; RequestDirect
	JNZ		UserNumOk
	MOV		ES: [BX+rqUserNum], AX

UserNumOk:
	MOV		WORD PTR ES: [BX+ercRet], 0

PUBLIC ForwardRequestEntry
ForwardRequestEntry:
	XOR		CX, CX	; Build (CX,DX) = (exch,rtInfo) from tables.
	MOV		DX, iRemote	; CX,DX set here in case of NoSuchRequest.
	TEST	DI, lExchArg
	JZ		CalcLevel
	MOV		CX, [BP+argExchDirect]

$MOD386
CalcLevel:
;	Calculate level, request code from request #

	DB 66h			; when everybody uses .latest assembler, remove db 66h
	MOVZX	EAX, ES: WORD PTR [BX+rqCode]	

	MOV		ESI, EAX
	SHR		AH, 4
	MOV		AL, AH
	CBW						;AX is request level

	XCHG	AX, SI			;SI=level, AX=req #
	CMP		AX, 0FFE0h		;>= -32 ?
	JB		NotUsr
	MOV		SI, 16			;Usr is "level 16"
	NOT		AX				; ,indexes in reverse order.

NotUsr:	
	AND		AH, 0fh			;Strip away level bits

;EAX=rcode and 0fffh,  ESI=level

	TEST    DI, lNoRqLookup
	JZ		CheckTables
; Send to exchAgent or exchNet - bypass rcMax, localServiceCode checks and
; routing lookup. exch is on stack, no net routing neccessary.
	AND		DI, lRqLookup	; reset noLookup bit 
	XOR		DX, DX
	JMP		DoSendRequest

CheckTables:
	CMP		AX, rgRcMax[ESI*2]		;IF rcode > rgRcMax(level)
	JB		SetIndex
	JMP		NoSuchRequest		

SetIndex:
	PUSH	BX
	LGS		BX, rgPrgLocalServiceCode[ESI*4];prgLocalServiceCode(level)
	AND		EBX, 0ffffh						; high(ebx)=0
	CMP		WORD PTR GS:[EBX][EAX*2], 0A3D1h
	JNE		NotDummyRequest					;if localServiceCode = lDummyLSC
	POP		BX
	JMP		NoSuchRequest

NotDummyRequest:
; AX=rcode and 0fffh, ESI=level
	LGS		BX, rgPrgRouting[ESI*4]			;@rgPrgRouting(level)
	MOV		EBX, GS:[EBX][EAX*4]
; EBX = rtInfo
; RequestRemote only needs rtRtInfo in DH
	TEST	DI, lExchArg
	JZ		RequestCXDX
; RequestDirect, ForwardRequest, RequestRemote
	SHR		EBX, 16		; rtInfo

%if (%rDeviceFilter) then (
	MOV		DX, BX
	PUSH	DX
	AND		DX, 807h
	CMP		DX, 807h	; rDevice + rFh?
	JNE		MapDone
	LES		BX, DWORD PTR [BP+pRq]
	TEST	BYTE PTR ES:[BX+fh+1], 80h	; net handle?
	JNZ		MapDone

; RequestDirect or ForwardRequest on rDevice/rFh request code. map the
; handle to a global handle.
	PUSH	AX	; rc level
	PUSH 	SI  ; rc and 3ffh
	CALL 	MapGlobalHandle
; MapGlobalHandle returns carry set if handle routes remotely (if so, we
; still route by exch argument). otherwise returns with carry clear and
; erc (ercBadFh, ercNoGhFixup) in AX.
	JC		MapDoneRestore
	OR		AX, AX	; erc = ercOk?
	JZ		MapDoneRestore
	ADD		SP, 8	; pop si, ax, dx, bx
	JMP		KernelErrorExitDI
MapDoneRestore:
	POP		SI	; rc level
	POP		AX	; rc and 3ffh

MapDone:
	POP		DX
	MOV		DL, iRemote	; route by exch bits
	JMP		SHORT RequestCXDXDone
)else(
	MOV		DH, BH
	JMP		Short RequestCXDXDone
)fi
	
RequestCXDX:
	MOV		CX, BX
; CX = rtInfo.exch	
	SHR		EBX, 16
	MOV		DX, BX
; DH = rtInfo.netInfo
; DL = rtInfo.srpInfo 

RequestCXDXDone:
	pop		bx				
; ES:BX points to request block
	TEST	CH,80H
	JNZ		ServiceNotAvail

;
; Check for broken AddQueueEntry requests:
;
	CMP		AX, 137					; IF rcAddQueueEntry = 137
	JE		ChkAddQue
ChkAddQueDone:

%IF(%CheckRequestBlockConsistency) THEN (
SysRequest:
; AX=rqcode and 0fffh, ESI=level
	CMP		SI, 0			;level 0 checked
	JNE		DoSendRequest		
	TEST	DI, lExpress
	JNZ		DoSendRequest
	LGS		SI, prgNReqRespPbCbSys
	MOV		SI, GS:WORD PTR [ESI][EAX*2]
	XOR		SI, ES:[BX+2]
	JNZ		InconsistentRq

	LGS		SI, prgScntlInfoSys
	MOV		AL, GS:BYTE PTR [ESI][EAX]
	XOR		AL, BYTE PTR ES: [BX] ;sCntlInfo
	JZ		DoSendRequest

InconsistentRq:
;	ES:BX points to Rq
%IF(%CheckRqPointers) THEN (
	MOV		pRqBadPointer,BX	
	MOV		pRqBadPointer+2,ES						;Save pointer to request
	MOV		AX,ES:[BX+rqCode]
	MOV		BadPointerRqCode,AX
)FI
	MOV		AX, ercInconsistentRq
	JMP		KernelErrorExitDI

)ELSE(
	JMP		DoSendRequest
)FI


ChkAddQue:
	AND		SI,SI						; AND level = 0
	JNZ		ChkAddQueDone
	CMP		WORD PTR ES:[BX+32], 0		; AND pDateTime=0000:xxxx
	JNZ		ChkAddQueDone
	MOV		WORD PTR ES:[BX+30], OFFSET DGroup:DateTimeZero
	MOV		WORD PTR ES:[BX+32], DS		; THEN pDateTime=@DateTimeZero
	JMP		ChkAddQueDone


;****************************************************************
; AliasRealRequestBlock
;
; Creates aliases for real mode pointers in a request
; block. Called from RqInterface.
;
; on entry,
;   es:bx addresses pRq
;   DS is DGroup 
;
; only the PL/M registers are not corrupted
;
;****************************************************************

public AliasRealRequestBlock

AliasRealRequestBlock proc far

	push offset AliasIpcSr
CallProcessRequestBlock:
	call ProcessRequestBlock
	ret

AliasRealRequestBlock endp

;****************************************************************
; DealiasRealRequestBlock
;
; Dealiases request block pointers back into real mode srs.  If
; reference count goes to zero, deallocates selector.
;
; Called by RqInterface to deallocate selectors for RMOS users.
;
; on entry,
;   es:bx addresses pRq
;   DS is DGroup 
;
; only the PL/M registers are not corrupted
;
;****************************************************************

public DealiasRealRequestBlock

DealiasRealRequestBlock proc far

	mov di, oPcbRun ; required by DealiasToSr
	push offset DealiasToSr
	jmp short CallProcessRequestBlock

DealiasRealRequestBlock endp

;****************************************************************
; ProcessRequestBlock
;
; in real mode, validates request block pointers
;
; in ctosp, traverses request block and does aliasing/dealiasing
; of request block pointers
;
; on entry,
;   es:bx addresses pRq
;   word parameter on stack is offset of the aliasing procedure
;
; the following registers are corrupted
;   CX, SI, DX, AX
;
; WARNING: ProcessRequestBlock defines a local bp in order to
; call the aliasing procedure, hence, the aliasing procedure
; CANNOT be CreateIpcAlias, as this procedure depends on bp
; being the kernel frame bp.
;****************************************************************

ProcessRequestBlock proc near

oAliasProc equ word ptr [bp+4]

	push	bp
	mov		bp, sp

	MOV		AX, ES:[BX+sCntInfo]
	MOV		CX, ES:[BX+nReqPbCb]
	ADD		CL, CH
	XOR		CH, CH				;CX is nPbCb.

%IF(%MF) THEN (
	;If rtInfo set might be remoteDma request.
	CMP		AH, 20h				;Might be bSlot?
	JBE		ProcessPointers
	JCXZ	PointersOk			;If no pbcb, musn't DEC CX.
; Be sure this is a remoteDma request - rq.rtInfo might be net routing.
	XCHG	AX, DX				;DX is sCntInfo saved.
	MOV		AX, ES:[BX+rqCode]
	%RtInfo	AL, rtSrpInfo using SI default 0
	XCHG	AX, DX				;AX is sCntInfo again. DX is rtSrpInfo.
	TEST	DX, maskRtDma
	JZ		ProcessPointers
; Definitely remoteDma rq.
	ADD		AL, 6				;Treat 1st pbcb as more cntlInfo.
	DEC		CX					; It doesn't have a pb, it's a ba.
ProcessPointers:
)FI%' MF

	CBW							;AX is sCntlInfo.
	ADD		AL, 12
	XCHG	AX, SI				;SI is offset of first pb.sa.
	JCXZ	PointersOk

TestRequestPointers:
	MOV		DX,ES:[BX+4][SI]	;DX = cb
	OR		DX,DX
	JNZ		CheckRequestSn
; if cb = 0, not RMOS, and pb invalid, make request selector null
	cmp		oAliasProc, offset AliasIpcSr
	je		CheckRequestSn
	cmp		oAliasProc, offset DealiasToSr
	je		CheckRequestSn
; check for invalid selector
	verw	word ptr ES:[BX+2][SI]
	jz		CheckRequestSn
	mov		ES:[BX+2][SI], dx
	jmp		short NextRequestPair
CheckRequestSn:
	MOV		AX,ES:[BX+2][SI]	;AX = segment portion of pointer
	call 	oAliasProc
	mov		ES:[BX+2][SI], ax
NextRequestPair:
	ADD		SI,6				;Step SI to next pb/cb pair
	LOOP	TestRequestPointers

PointersOK:
	pop		bp
	ret		2

ProcessRequestBlock endp


ExchOutOfRange:
	MOV		AX, ercExchOutOfRange
KernelErrorExitDI:
	JMP		KernelExit
BadRespExch:
	MOV		AX, ercBadRespExch
	JMP		KernelExit


;*****************************************************************************
;	DoSend:  Come here from all procedures that send a message:
;	Request, RequestDirect, Send, PSend, Respond
;
;	ES: BX = pMsg  
;	SI = iExchg
;*****************************************************************************
			
			;Structure for the message exchange 

			;DECLARE ExchgType LITERALLY 'STRUCTURE (
			;  oMsgHead	ADDRESS
			; ,oMsgTail	ADDRESS
			; ,oPcbHead	ADDRESS
			; ,oPcbTail	ADDRESS)'

			; Structure for the message queue entry */

			;DECLARE MsgWaitType LITERALLY 'STRUCTURE (
			;  oMsgNxt	ADDRESS
			; ,pMsgUsr	POINTER
            ; ,userNum  WORD
            ; ,wStatus  WORD)';

;*****************************************************************************
;	Entry from Request and RequestDirect
;	CX = exchange to route to.
;	DH = Net Routing byte
;	ES:BX = pRq
;*****************************************************************************


Public DoSendRequest
DoSendRequest:
%IF(%CheckRequestBlockConsistency) THEN (
%IF(%Icc) THEN(
	MOV		AH, BYTE PTR ES:[BX+respExch+1]
	SHR		AH, 2
	JZ		DSRToMe				; No slot bits -> put my slot bits in respExch
	CMP		AH, iMySlot
	JNE		RespExchOk
	JMP		SHORT DSRDoIt		; RespExch slot bits = mySlotBits
DSRToMe:
	MOV		AX, wMySlotBits
	OR		ES:[BX+respExch], AX
DSRDoIt:
)FI
$MOD386
	XOR		EAX, EAX 		; clear high(eax), movzx leaves high word non-zero!
	MOV		AX, ES:[BX+respExch]
	AND		AX, maskiExch
	JE		BadRespExch			; iExchg = 0
	CMP		AX, nExchg
	JAE		ExchOutOfRange
	SHL		EAX, 1	;iWord
	ADD		AX, oRgExchgUserNum
	CMP		WORD PTR [EAX], 0FFFFh	;IF rgExchgUserNum(iExchg)=0FFFFh THEN
	JE		BadRespExch				;(should be = pcb.userNum)
RespExchOk:
$MOD286
)FI
	TEST	DI, lExpress
	JNZ		TestRtInfo


	PUSH	CX
	PUSH	DX
%IF (%Icc AND 0) THEN (%' lExpress does this now
; if request is from remote (in-bound icc), skip aliasing and spec expansion
; as all pb's are icc sg's and the first pb may be a ba (remote dma)
	MOV		AX, ES:[BX+respExch]
	AND		AX, NOT maskSlot
	CMP		AX, wMySlotBits
	MOV		AX, 0
	JNE		SpecsExpandedHop	;No aliasing nor spec expansion needed
)FI%'

; set up the aliasing procedure based on the mode of
; the caller
	mov		ax, [bp+csRet]
	cmp		ax, sgRealInterface
	mov		ax, offset AliasIpcSr
	je		PushAliasProc
	mov		ax, offset AliasIpcSl
PushAliasProc:
	push	ax

; Blast sCharRet field to 1 for kbd request, because some
; applications have it set to zero.
;	mov		ax, word ptr es:[bx+rqCode]					;AX = rqCode
;	cmp		ax, 53 ; ReadKbd
;	je		BlastKbdSCharRet
;	cmp		ax, 54 ; ReadKbdDirect
;	je		BlastKbdSCharRet
;	cmp		ax, 256; ReadActionKbd
;	jne		TestRqCode1
;BlastKbdSCharRet:
;	mov		word ptr es:[bx+22], 1
;
;TestRqCode1:

	call 		ProcessRequestBlock

PointersOK2:

; For paging, call LockRqPages to lock the pages referenced by this request
	test	di,lLockRqPages
	jz		DontLockRqPages
;
; In 1.0, the symmetrical UnLockRqPages was done at Respond. In 1.1,
; UNLOCKRqPages is done at Wait (when the the incoming msg is a response). 
; This was done because the ICC kernel does Respond on the TSS of an interrupt
; (Chime), and therefore may not wait for the PS sempahore which is required to
; locked non-identity mapped gla. 
;
; NB: in ICC, Request also runs on an interrupt TSS (Chime). It can
; therefore not attempt to get a semaphore. This case works because the PS
; does not get the semaphore for pages which are identity mapped, and Chime
; works strictly with identity mapped request buffers  (ICC and Shadow 
; buffers).
;
; NB: in ICC, Request no longer even attempts to lock pages.  The response
; exchange is off-board, so Request skips straight to the routing part.
; Respond doesn't unlock in the ICC case, so is symmetrical.
;

$MOD386
	push	di						;Save DI
	push	dword ptr [bp+pRq]
	call	SC_LockRqPages
	les		bx, dword ptr [bp+pRq] 	;Restore es:bx
	pop		di						;Restore DI
$MOD286
RqPagesLocked:
	and		di,lNotLockRqPages  	;clear flag
DontLockRqPages:

	POP	  DX	; rtInfo
	PUSH  DX
	XOR   AX, AX
	MOV  SI,WORD PTR ES:[BX+rqUserNum]
%IF (%Icc) THEN (
	XOR  SI, wMySlotBits
)FI
	CMP  SI, nUcb		; Yes, nUcb!  ExpandRqSpecs only works for those users.
	JAE  SpecsExpanded
	TEST DH, mSpec + mPswd
	JZ	 SpecsExpanded
	CMP  DH, mCloseFh	
	JE	 SpecsExpanded
	CMP  ES:BYTE PTR [BX+nReqPbCb], 0
	JE	 SpecsExpanded
	PUSH DI
	PUSH ES
	PUSH BX

	MOV  AL, 1			; Default: ExpandRqSpecs doesn't wait if heap full
	STR  DI
	CMP  DI, sgTssIntLast
	JBE  ExpandSpecs
	MOV  DI, oPcbRun
	TEST BYTE PTR [DI+pcbStatus], pcbfSys
	JNZ  ExpandSpecs
	MOV  AL, 0			; Non-system process, may wait if heap full
ExpandSpecs:

	CALL ExpandRqSpecs
	MOV  BX, Dgroup
	MOV  DS, BX
	POP  BX
	POP  ES
	POP  DI
SpecsExpanded:
	POP	 DX
	POP	 CX
	OR   AX, AX
	JE   TestRtInfo
	JMP	 KernelErrorExitDI

Public TestRtInfo
TestRtInfo:
;	DH = routing code 
;	CX = exchange to route to (zero if not served)
;	Depending on the low 4 bits of routing code,
;	we will route the request as follows:
;		0 =>	route to the specified exchange
;		1xxx =>	route by file handle
;		0xxx =>	where xxx <> 0, route by node spec	
;				If xxx = 5, then file spec is in p2 s2, otherwise p0 s0
;	Don't do net routing for RequestDirect or ForwardRequest.
;	Recognize them by DI count of arguments.
; 03/23/89 This is fascist.  Do net routing for RequestDirect and ForwardRequest
;          Otherwise we break the Queue mgr.
;	TEST	DI, lExchArg
;	JNZ		RouteRequestJmp

	TEST	DH, 0Fh
	JZ		RouteRequestHop
	TEST	DH, 8
	JNZ		RouteByFh
	CMP		BYTE PTR ES:[BX+nReqPbCb], 0
	JE		RouteRequestHop				;No ReqPbCbs = No Spec = Route local
	JMP		RouteByNodeSpec

RouteRequestHop:
	JMP		RouteRequest

RouteByFh:
;	Test the file handle for remote or local. 
$MOD386
	TEST	BYTE PTR ES:[BX+fh+1], 80h;			Test high bit of fh
	JZ		TestFhCws
;
$MOD286

RouteToNetAgent:
;	Store the net routing code in the rtInfo
;	field in the request block. This is how the NetAgent knows where the
;	request came from.
	
	MOV		ES:[BX+rtInfo],DH
	MOV		CX, exchNet
	OR		CX,CX
%IF(%Icc) THEN (
	JZ		NetAgentNotActive
	JMP		RequestToSlot
)ELSE(
	JNZ		RouteRequestHop
)FI

NetAgentNotActive:
; The NetAgent has not been installed. If we are running on a cluster 
; workstation, route this request to the master.
	CMP		ClusterConfig,cws
	JE		RouteToClusterAgent

ServiceNotAvail:
;	return ercServiceNotAvail from Request.
; 	free resources used by the request normally freed at Wait or 
;	Respond: spec heap, locked pages, and aliases.
	CALL	FreeRqResources		; frees heap and unlocks pages

; Set up the dealiasing procedure based on the mode of the caller.
	mov		ax, [bp+csRet]
	cmp		ax, sgRealInterface
	je		PushRealDealiasProc

	cmp		ax, sgRqInterface
	jne		PushLdtDealiasProc

	mov		si, oPcbRun
	test	word ptr [si+sgLdt], maskRealMode
	je 		PushLdtDealiasProc

; assert - request came from request procedural interface
;		 - client is rmos.
; trace stack and find out if request came from rmos.
; NB: checking pcb.sgLdt is insufficient - stack trace is done to detect calls 
; from protected mode system common on behalf of an rmos user.
$MOD386
	str		si
	sub		si, 8
	mov		fs, si
	mov     si, fs:word ptr [rTss386pUserStack+2]	; old ss
	mov		fs, si
	mov		si, word ptr [bp+2]    ;old BP
	mov		si, word ptr fs:[si]  	
	mov		ax, word ptr fs:[si+4] ;fetch CS of caller of RqInterface
	cmp		ax, sgRealInterface
	je		PushRealDealiasProc

PushLdtDealiasProc:
; don't dealias if process has no LDT. This occurs when RMOS calls
; (gdtprotected) system common which calls Request. - JM 02/27/92
	mov		si, oPcbRun
	test	word ptr [si+sgLdt], 0FFF8h
	jz		EarlyDealiasDone ; do nothing if no LDT for this user

	push	offset DealiasToLdt
	jmp		short EarlyDealias
PushRealDealiasProc:
	push	 offset DealiasToSr
$MOD286

EarlyDealias:
; dealias the request block and pRq
	mov		cx, es
	mov		dx, bx
	mov		bx, oPcbRun
	call	DealiasRequestBlock
EarlyDealiasDone:

	mov		ax, ercServiceNotAvail

; end of new logic
	JMP		KernelErrorExitDI
SendServiceNotAvail:
	MOV		AX, ercServiceNotAvail
	JMP		KernelErrorExitDI

TestFhCws:
; The request is routed by fh, and the high bit is zero. This request does
; not go to the Net, but if we are a cluster workstation, it could go to the
; master if any of the high four bits are set.
	CMP		ClusterConfig,cws
	JNE		RouteRequest

;	We are running on a cws, so test the high bit of fh
	TEST	BYTE PTR ES:[BX+fh+1], 0E0h;		Test high byte of fh
	JZ		RouteRequest

RouteToClusterAgent:
	MOV		CX,exchAgent			;Route to Agent
	MOV		DL, 0					;rLocal

Public RouteRequest
RouteRequest:
;	DH		= net info
;	CX		= exchange
;	ES:BX	= pRq
%IF(%Icc) THEN (
;	DL		= srp info
;		0	= rLocal, fileSpec
;		1	= rRemote
;		2	= master FP
;		3	= rHandle
;		4	= rFileID
;		5   = master CP
;		6	= rLine
;		7	= rDevice
;		8	= rBroadCast
; Minor hack: some folks use exch 12 to mean exchAgent.
	CMP		CX, 12
	JNE		RRCase
	MOV		CX, exchAgent
RRCase:

	MOV		[BP+saRq], ES			; Remember alias so LES BX, [BP+pRq] works.
;	MOV		[BP+raRq], BX			; no longer alias ra
	MOV		SI, DX
	AND		SI, maskRouteCase
	SHL		SI, 1
	JMP		WORD PTR RouteCase[SI]
)FI


RouteRequestLocal:
%if(%kernelhooks)then(
	cmp 	word ptr rgbKernelHookinfo[lRouteRequestLocalHook+2], 0
	jne		RouteRequestLocalHook
RouteRequestLocalContinue:
)fi

	MOV		SI,CX				;SI = exchange to route to
	TEST	SI, maskiExch
	JNZ		RequestServed
	JMP		ServiceNotAvail
RequestServed:
	CLI								;Disable
	MOV		msgType,lMsgRequest		;This will be ORed into userNum
	JMP		SHORT TestExch


%if(%kernelhooks)then(
RouteRequestLocalHook:
	mov		si, oPcbRun
	mov		ax, word ptr [si+pcbUserNum]	; actual usernum of user calling
											; request/forwardreq/requestdirect.
	call	rgbKernelHookInfo[lRouteRequestLocalHook]
	jmp		RouteRequestLocalContinue
)fi

DoSendRespond:
	CLI						;Disable
	MOV		msgType,lMsgRespond		;This will be ORed into userNum
	JMP		SHORT TestExch

DoSend:
	CLI						;Disable
	MOV		msgType,lMsgSend	;0
	jmp		short TestExch1

DoSendP:
	CLI
	MOV		msgType, lMsgSendP
	JMP		short TestExch1

TestExch:
	mov		cx, es
TestExch1:

; CX:BX are pMsg - if not Send, ES also is saMsg
; interrupts disabled

	AND     SI, maskiExch
	JZ		SendServiceNotAvail
	CMP		SI, nExchg			;IF iExchg >= nExchg THEN 
	JB		DoSendExchNotOutOfRange
	JMP		ExchOutOfRange		;RETURN(ercExchOutOfRange);
			
DoSendExchNotOutOfRange:
%if(%Tracker) then (%'
	TEST	vfRqTracker, 1
	JZ		DoSendRqTrackerDone
	TEST	msgType, lMsgRespond OR lMsgRequest
	JZ		DoSendRqTrackerDone
	TEST	msgType, lMsgRespond
	JZ		DoSendRqTrackerRequest
	PUSH	CX					;saMsg
	PUSH	BX					;raMsg
	CALL	RqTrackerRemoveMsg	;remove most recently q'd (frees a msgWait)
	JMP		DoSendRqTrackerDone
DoSendRqTrackerRequest:
	TEST	DI, lcRqInc + lcRqDec		; call affects rgcRq
	JZ		DoSendRqTrackerDone
	OR		msgType, lMsgWantRes	
DoSendRqTrackerDone:
)fi%'

	MOV		DX,BX				;Save offset of pMsg in DX

%IF (%trace) THEN (
	TEST	MsgType, lmsgRequest OR lmsgRespond
	JZ		NoTrace
	CALL	TraceHook
NoTrace:
)FI

	SHL		SI,3				;index dword array 
	ADD		SI, oRgExchg		;oExchg = rgExchg(iExchg);
	MOV		AX,[SI+oPcbHead]	;IF(exchg.oPcbHead # 0) THEN 
	OR		AX,AX
    JZ      NoTaskWaiting
	JMP		TaskWaiting			;task is waiting

NoTaskWaiting:			
	OR		AX,msgWaitFree		;AX = msgWaitFree & set condition code
    JNZ     FreeMsg
	JMP		NoMsgWait			;IF msgWaitFree = 0 THEN RETURN(ercNoMsgWait)

FreeMsg:
;	Keep count of rqs outstanding
;	These lines must be after all error checking.
	TEST	DI, lcRqInc + lcRqDec
	JZ		SendMsgRemoteUserNum
	MOV		BX, ES:[BX+rqUserNum]
%IF (%Icc) THEN (
	XOR		BX, wMySlotBits
	TEST	BX, maskUserNum
	JNZ		SendMsgRemoteUserNum
)FI
	CMP		BX, nUcb
	JAE		SendMsgRemoteUserNum
	ADD		BX,prgcRq
	PUSH	ES					;Save ES (saMsg)
	MOV		ES,pRgcRq+2
	TEST	DI, lcRqInc
	JNZ		InccRq
	DEC		BYTE PTR ES:[BX]	;DEC rgcRq
	POP		ES					;Restore ES
	JMP		SHORT SendMsgRemoteUserNum
InccRq:
	INC		BYTE PTR ES:[BX]	;INC rgcRq
	POP		ES					;Restore ES

SendMsgRemoteUserNum:
	MOV		BX, msgWaitFree		;BX points to new msg
	XOR		AX,AX
	XCHG	AX, [BX]			;newMsg.head = 0 (new msg is last in list)
	MOV		msgWaitFree, AX		;msgWaitFree.head = next message in queue;
	MOV		[BX+2], DX			;msg.pMsgUsr = pMsg;
	MOV		[BX+4], CX

	TEST	DI, lMsgRqUsernum
	JNZ		MarkLinkRqOwner	; Rq issuer owns link block so server term works

;Check if it is CALLed from an interrupt handler
	str		ax
	cmp		ax, sgTssIntLast
	ja		MarkLinkPcbRun
	xor		ax,ax
	jmp		short CheckRequest
MarkLinkPcbRun:
	PUSH	BX
	MOV		BX,oPcbRun
	MOV		AX,[BX+pcbUserNum]
	POP		BX
CheckRequest:

	MOV		[BX+6],AX           ;store userNum in message
	MOV		AX,msgType	     	;Request or RequestDirect different from Respond
    MOV     [BX+8],AX           ;so set status word
%IncInstrument(SendMsgWait)
	XOR		AX,AX
	CMP		[SI], AX			;IF oMsgHead(iExchg) = 0
	JZ		MsgListEmpty

	MOV		CX,BX				;CX points to new msg
	XCHG	BX, [SI+2]			;BX points to last msg in list
								;tail of list points to new msg
	MOV		[BX], CX			;last msg in list points to new msg

KernelExitDI:
PUBLIC KernelExitDI
	JMP		KernelExit


MarkLinkRqOwner:
;	Mark link block to belong to rq.user, NOT process causing the link.
	XCHG	BX, DX				;BX=oRq
	MOV		AX, ES:[BX+rqUserNum]
	XCHG	BX, DX
	JMP		SHORT CheckRequest

MsgListEmpty:
	MOV		[SI], BX			;head = msgWaitFree (first points to new msg)
	MOV		[SI+2], BX			;tail = msgWaitFree (tail points to new msg)
	JMP		KernelExitDI

NoMsgWait:
	MOV		AX, ercNoMsgWait
	JMP		KernelErrorExitDI							



DealiasRequestBlock proc near
; dealiases request block and pointer to request block
; on entry, cx:dx are pRequestBlock, bx is oPcbWaiting
; on exit, cx:dx is dealiased, bx is oPcbWaiting
	push	bp
	mov		bp, sp
	push	di		; kernel exit info
	mov		di, bx	; oPcbWaiting, needed by dealiasing routine
	mov		es, cx	; saRequestBlock
	mov		bx, dx	; raRequestBlock
	push	word ptr [bp+4] ; pointer to dealiasing routine
	call	ProcessRequestBlock
	mov		dx, bx	; raRequestBlock
	mov		ax, es	; saRequestBlock	
; zero es because saRequestBlock may be deallocated, which would
; cause a fault if es is reloaded
	xor		cx, cx
	mov		es, cx
	call	word ptr [bp+4]
	mov		cx, ax	; saRequestBlock, dealiased
	mov		bx, di  ; oPcbWaiting
	pop		di		; kernel exit info
; bx addresses receiving pcb
	pop		bp
	ret		2
DealiasRequestBlock endp


;There is at least one task waiting for a msg. 
;Unchain the first task that is waiting and make it ready.

PUBLIC TaskWaiting
TaskWaiting:
;	Keep count of rqs outstanding
;	These lines must be after all error checking.
;   AX = exch.oPcbhead
;   DX = raMsg
;	CX = saMsg
	PUSH	AX		; save oPcbHead
	TEST 	DI, lcRqInc + lcRqDec	
	JZ		TaskWaitingRemoteUserNum
; kernel call affects rgcRq
	MOV		BX, ES:[BX+rqUserNum]
%IF (%Icc) THEN  (
	XOR     BX, wMySlotBits
	TEST    BX, maskUserNum
	JNZ     TaskWaitingRemoteUserNum
)FI
	CMP		BX, nUcb
	JAE		TaskWaitingRemoteUserNum
	ADD		BX,prgcRq
	PUSH	ES					;Save ES (saMsg)
	MOV		ES,pRgcRq+2
	TEST	DI, lcRqInc
	JNZ		IncCount
	DEC		BYTE PTR ES:[BX]	;DEC rgcRq
	POP		ES					;Restore ES
	JMP		SHORT TaskWaitingRemoteUserNum
IncCount:
	INC		BYTE PTR ES:[BX]	;INC rgcRq
	POP		ES					;Restore ES

TaskWaitingRemoteUserNum:
%if (%Tracker) then (%'
	TEST	vfRqTracker, 1
	JZ		TaskWaitingRqTrackerDone
	TEST	msgType, lMsgWantRes
	JZ		TaskWaitingRqTrackerDone
	PUSH	msgType
	PUSH	AX					;filler
	PUSH	CX					;saMsg
	PUSH	DX					;raMsg
	CALL	RqTrackerAddMsg		;q it
TaskWaitingRqTrackerDone:
)fi%'

	POP		BX				;restore oPcbHead
	MOV		AX, [BX]		;AX = pcb.oPcblnk
	MOV		[SI+oPcbHead], AX	;exchg.oPcbHead points to next Pcb on the list

;
; Pass the pMsg, msgType, and msgRetAdd to the waiter via his regs (Tss) and
; cause waiter to dispatch at ResumeTaskWait
; Assert: the CS:IP of the waiting task is currently ResumeTask
;
;	BX    = oPcb
;	CX:DX = pMsg
;	use:    AX, ES, SI

	MOV		AX, [BX+sgTss]
	SUB		AX, 8
	MOV		ES, AX
;	MOV		AX, OFFSET ResumeTask		- already at ResumeTask
;	MOV		ES:[rTss386Ip], AX
	MOV		SI, msgType
	MOV		ES:[rTss386Ax], CX
	MOV		ES:[rTss386Cx], DX
	MOV		ES:[rTss386Si], SI
; if carry is set at ResumeTask, jmp to ResumeTaskWait. this furnishes a
; single dispatch point known by debugger.
	OR		ES:BYTE PTR [rTss386Flags], lCarry 	
	XOR		AX, AX

%IncInstrument(SendMsg)

;	Search the runq for the next task to run. This is similar to MakeReady,
;	but we make some assumptions to speed things up. We assume that the 
;	dummy task is the only task with a priority of 255, so we will never
;	come to a null pointer in the run queue.
;		BX points to Pcb to make ready
;		NOTE: we do not disturb AX

	OR		BYTE PTR [BX+pcbStatus], ready
%if (%suspendOffRunQ) then(%'
	test	byte ptr [BX+pcbStatus], suspends
	jnz		PastChainPcb
)fi%'
CheckNewPcbPrio:
	MOV		CL, [BX+pcbPriority]		;AL = priority of new pcb
	MOV		SI, Runq					;SI points to next pcb in runq
	CMP		[SI+pcbPriority],CL			;IF pcb.priority < nextPcb.priority
	JA		RunNewPcb

	MOV		DX, OFFSET DGroup: runq		;DX points to prev pcb

SearchRunQ:
	CMP		[SI+pcbPriority],CL			;IF pcb.priority < nextPcb.priority
	JA		ChainPcb

	MOV		DX, SI						;DX points to prev pcb
	MOV		SI, [SI] 					;SI points to next pcb in runq
	JBE		SearchRunQ

ChainPcb:
	MOV		[BX], SI					;new pcb points to next pcb in runq
	MOV		SI,DX						;SI points to prev pcb
	MOV		[SI], BX					;prev pcb points to new pcb
PastChainPcb:
	JMP		KernelExitDI		

			
;	Come here if the new pcb is to be chained to the head of the runq.
;	We know there will be a task switch if we were not called
;	by an interrupt routine.

RunNewPcb:
	MOV		[BX], SI					;new pcb points to next pcb in runq
	MOV		runq, BX					;prev pcb points to new pcb
	JMP		KernelRet


;	Come here if the routing code specifies route by node spec
;	DH = routing code
;	IF DH = x5, then spec is in p2 s2, otherwise p0 s0
;	We must not disturb CX

RouteByNodeSpec:
	PUSH	ES
	PUSH	BX
	PUSH	DI
	MOV		AL, cbNodeName
	CBW
	MOV		DI, AX						;DI = length of our node name

; if no request pbcb's give up. prevents faulting on requests with bogus
; definition. - JM 03/04/92
	CMP		BYTE PTR ES:[BX+nReqPbCb], 0
	JE		RestoreAndSend

;	Add sCntInfo to BX to access p0 s0
;	If spec is in p2 s2 add 12 to BX to fetch p2 instead of p0
	ADD		BL, BYTE PTR ES:[BX+sCntInfo]
	ADC		BH, 0						;ES:BX = @rq.p0-sRqHeader
	MOV		AL, DH
	AND		AL, 0Fh
	CMP		AL, 5
	JNE		TestVol
	ADD		BX, 12						;ES:BX = @rq.p2-sRqHeader

TestVol:
;	cb=0?
	MOV		AX, WORD PTR ES:[BX+sRqHeader+4]
	OR		AX, AX
	JZ		RestoreAndSend

;	Get pbFileSpec from the request block and see if a vol is specified.
	LES		BX,DWORD PTR ES:[BX+sRqHeader]		 ;ES:BX = pbFileSpec
	CMP		BYTE PTR ES:[BX],'['
	JE		RestoreAndSend					;no expansion if vol specified

;	See if a node is specified.  ExpandRqSpecs already applied default.
	CMP		BYTE PTR ES:[BX],'{'
	JNE		RestoreAndSend					;no explicit nor default node

;	A node has been specified in the file spec. See if the file spec
;	node is the name of our node -- we don't want to send to ourself.
;	Must first make sure the spec length (AX) is big enough so no fault occurs.

	CMP		AX, DI
	JBE		TestLocalOrMaster
	CMP		BYTE PTR ES:[BX+1][DI], '}'
	CALL 	TestSendToSelf
	JE		RestoreAndSend

TestLocalOrMaster:
;	A node has been specified in the file spec.  Test to see if the '}'
;	falls in the right place for {local} or {master} or {server}.
	CMP		AX, 6
	JBE		TestMasterLength
	CMP		BYTE PTR ES:[BX+6],'}'
	JE		TestLocalNode

TestMasterLength:
	CMP		AX, 7
	JBE		RouteToNet
	CMP		BYTE PTR ES:[BX+7],'}'
	JE		TestMasterNode
	JMP		SHORT RouteToNet

TestLocalNode:
;	ES:BX points to '{' of FileSpec node
	
	MOV		AX,ES:[BX+1]				;AL char 0, AH = char 1 of node
	OR		AX,2020h					;Force lower case
	CMP		AX,'ol'						;Test for 'lo'
	JNE		RouteToNet					;Node is not {local}

	MOV		AX,ES:[BX+3]				;AL = char 2 of node, AH = char 3
	OR		AX,2020h					;Force lower case
	CMP		AX,'ac'						;Test for 'ca'
	JNE		RouteToNet					;Node is not {local}

	MOV		AL,ES:[BX+5]				;AL = char 4 of node, AH = char 5
	OR		AX,2020h
	CMP		AL,'l'
	JE		RestoreAndSend				;Node is {local}

RouteToNet:
	POP		DI
	POP		BX
	POP		ES
	JMP		RouteToNetAgent

RestoreAndSend:
	POP		DI
	POP		BX
	POP		ES
	JMP		RouteRequest

RouteToCluster:
	POP		DI
	POP		BX
	POP		ES
	JMP		RouteToClusterAgent

CheckMasterDefault:
	CMP		ES:BYTE PTR [BX],6
	JNE		RouteToNet

TestMasterNode:
;	ES:BX points to '{' of FileSpec node.  Check for {master}.
	
	MOV		AX,ES:[BX+1]				;AL char 0, AH = char 1 of node
	OR		AX,2020h					;Force lower case
	CMP		AX,'am'						;Test for 'ma'
	JNE		TestServerNode				;Node is not {master}

	MOV		AX,ES:[BX+3]				;AL = char 2 of node, AH = char 3
	OR		AX,2020h					;Force lower case
	CMP		AX,'ts'						;Test for 'st'
	JNE		TestServerNode				;Node is not {master}

	MOV		AX,ES:[BX+5]				;AL = char 4 of node, AH = char 5
	OR		AX,2020h					;Force lower case
	CMP		AX,'re'						;Test for 'er'
	JE		RouteToMaster				;Node was {master}

TestServerNode:
;	ES:BX points to '{' of FileSpec node.  Check for {server}.

	MOV		AX,ES:[BX+1]				;AL char 0, AH = char 1 of node
	OR		AX,2020h					;Force lower case
	CMP		AX,'es'						;Test for 'se'
	JNE		RouteToNet					;Node is not {server}

	MOV		AX,ES:[BX+3]				;AL = char 2 of node, AH = char 3
	OR		AX,2020h					;Force lower case
	CMP		AX,'vr'						;Test for 'rv'
	JNE		RouteToNet					;Node is not {server}

	MOV		AX,ES:[BX+5]				;AL = char 4 of node, AH = char 5
	OR		AX,2020h					;Force lower case
	CMP		AX,'re'						;Test for 'er'
	JNE		RouteToNet					;Node is not {server}

RouteToMaster:
;	Route to the master. If we are running on a cluster ws, this means 
;	we route it to the agent. If we are running on a master or 
;	standalone, {master} or {server} is the same as {local}.
	CMP		ClusterConfig,cws
	JNE		RestoreAndSend
	JMP		SHORT RouteToCluster

TestSelfNode PROC NEAR
;	ES:BX points to '{' of file spec
;	DI contains cbNodeName (length of our local node name)
;	On entry, condition code is set zero if the length of the node in
;	question is the same as cbNodeName.
;	Return with condition code zero if we are sending to ourself

TestSendToSelf:
	JZ		TestNextNodeChar
	RET							;not sending to self
TestNextNodeChar:
	MOV		AL, BYTE PTR ES:[BX][DI]
	MOV		AH, cbNodeName[DI]
	OR		AX,2020h				;Force lower case for compare
	CMP		AH, AL
	JE		NextNodeChar
	RET							;not sending to self
NextNodeChar:
	DEC		DI
	JNZ		TestNextNodeChar
	RET							;sending to self
TestSelfNode ENDP


%if (not %Icc) then (

%EnterKernel(RequestRemote, l2Argw, fNoSwitch, lNoHook) 
	MOV		AX, ercNotImplemented
	JMP		KernelExit

%EnterKernel(SendRemote, l3Argw, fNoSwitch, lNoHook) 
	MOV		AX, ercNotImplemented
	JMP		KernelExit
)fi


;*****************************************************************************
;
;	Check:	PROCEDURE (iExchg, ppMsgRet) ErcType REENTRANT;
;
;*****************************************************************************

; GCheck: (exch, ppMsgret)
%EnterKernel(Check, l3Argw + lExchArg, fStackSwitch, lCheckHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snpMsgRet
;			 rapMsgRet
;			 exch

ASSUME ds: DGROUP
ASSUME es: NOTHING
	XOR		CX,CX						;CX = 0 => called by Check
	JMP		CheckMsgWaiting 



;***************************************************************************** ;
;	KWait:	PROCEDURE (iExchg, ppMsgRet) REENTRANT  PUBLIC;
;
;*****************************************************************************
; GWait: (exch, ppMsgret)
; KWait: (exch, ppMsgret)

%EnterKernel(Wait, l3Argw + lExchArg, fStackSwitch + fKCall, lWaitHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     snpMsgRet
;			 rapMsgRet
;			 exch


	MOV		CX,0FFh						;CX <> 0 => called by Wait

CheckMsgWaiting:
%IncInstrument(Wait)

	MOV		SI, [BP+iExchg]				;SI = exchange
	AND     SI, maskiExch
	JZ		WaitEOOR					;iExchg = 0
	CMP		SI, nExchg
	JB		ExchInRange
WaitEOOR:
	JMP		ExchOutOfRange

ExchInRange:
	MOV		AX, [BP+saPMsgRet]
	OR		AX, AX
	JE		WaitBadPointer				;RETURN(ercBadPointer);

; alias ppMsgRet ONLY if RMOS caller. Storing to ppMsgRet is now
; done on our thread - JM 01/15/92.
	MOV 	DX, [bp+csRet]
	CMP 	DX, sgRealInterface
	JNE		ppMsgRetAddressable
	
; clear ES before calling CreateIpcAlias which pushes and pops ES with ints 
; enabled. kernel makes ES valid before putting away a process but can't fix 
; segment registers saved on the stack.
	XOR		DX, DX
	MOV		ES, DX
	CALL 	CreateIPCAlias
	MOV		[BP+saPMsgRet], AX
	MOV		ES, AX				;insurance

ppMsgRetAddressable:
	CLI							;disable
	SHL		SI,3
	ADD		SI, oRgExchg
	MOV		BX,[SI]				;BX = exchg.oMsgHead 
	OR		BX,BX
	JNZ		CheckMsgWaiting1
	JMP		NoMsgWaiting		;BX points to the first msg in the list

WaitBadPointer:
	JMP		BadPointerRet

CheckMsgWaiting1:
	MOV		AX, [BX]			;AX = msg.oMsgNxt 
	MOV		[SI], AX			;Unchain this message from the exchange

	MOV		CX, [BX+loMsgRaMsg]		 	;AX:CX = pMsg
	MOV		AX, [BX+loMsgSaMsg]			
	MOV		DX, [BX+loMsgWStatus]		;DX = msgType

	AND		DX, lmsgRequest OR lmsgRespond OR lMsgSendp

	MOV		SI, msgWaitFree
	MOV		[BX], SI			;Chain this msg to msgWaitFree
	MOV		msgWaitFree, BX	

%if (%Tracker) then (%'
	TEST	vfRqTracker, 1
	JZ		WaitRqTrackerDone
	TEST	DX, lMsgWantRes
	JZ		WaitRqTrackerDone
	OR		DX, lMsgWait
	PUSH	DX							;msgType OR lMsgWait
	PUSH	[BX+loMsgUserNum]			;userNum
	PUSH	AX							;sgMsg
	PUSH	CX							;raMsg
	CALL	RqTrackerAddMsg				;q it (takes msgWait back)
WaitRqTrackerDone:
)FI
	PUSH	[BP+4]
	POPF								;enable maybe

; if the message is a response and the caller is real mode,
; dealias the pRq and the request block pointers
	push	di

	test	dx, lMsgDealias
	jz		WaitStorePMsg

; Master agent rqs all permanently locked, gdt.  Skip dealias etc.
	CMP		clusterConfig,cws
	JE		WaitShouldUnlock
	MOV		SI, [BP+iExchg]				;SI = exchange
	CMP		SI, exchAgent
	JE		WaitStorePMsg
WaitShouldUnlock:

%IF (%UnlockAtWait) THEN (
	test 	dx, lMsgRespond
	jz  	WaitResumeDealias
; msg is a respond, unlock it.
	push	dx			;save msgType
	push 	ax			;save sarq
	push	cx			;save raRq
	push	ax			;argue saRq
	push	cx			;argue raRq
	call	SC_UnlockRqPages
	pop		cx
	pop		ax
	pop		dx
WaitResumeDealias:
)FI

	mov		bx, [bp+csRet]
	cmp		bx, sgRealInterface
	jne		WaitCheckDealiasLdt

	push	dx
	push	offset DealiasToSr
	call	WaitDealiasRequestBlock
	jmp		short WaitStorePMsg

WaitCheckDealiasLdt:
	mov		bx, oPcbRun
	test	word ptr [bx+sgLdt], 0FFF8h
	jz		WaitStorePMsg ; do nothing if no LDT for this user

	push	dx
	push	offset DealiasToLdt
	call	WaitDealiasRequestBlock

WaitStorePMsg:
	pop		di
	LES		BX, DWORD PTR [BP+pPMsgRet]
	MOV		ES: [BX], CX
	MOV		ES: [BX+2], AX
	XOR		AX, AX

WaitRet:
	JMP		KernelExitDI


WaitDealiasRequestBlock proc near
; called when process is picking up a response
; ax:cx = pRq
	push	bp
	mov		bp, sp
	mov		di, oPcbRun
	test	word ptr [bp+6], lMsgSendP
	jnz		WaitDealiasSaMsg
	
	push	es
	push	bx

	mov		es, ax
	mov		bx, cx

; es:bx addresses pRq
	push	word ptr [bp+4]
	call	ProcessRequestBlock	

	mov		ax, es
	mov		cx, bx

	pop		bx
	pop		es

; finally, dealias the saMsg in ax
WaitDealiasSaMsg:
	call	word ptr [bp+4]
	pop		bp
	ret		4
WaitDealiasRequestBlock endp

InterruptCantBlock:
	MOV		AX, ercInterruptCantBlock
	JMP		KernelRet

NoMsgWaiting:
	MOV		AX, ercNoMessage
	JCXZ	WaitRet						;Return if Check
		
	;	Called from Wait 
	;	There is no message in the exchange, do wait 

	MOV		BX, oPcbRun					;BX points to pcb to enter wait state

	STR		AX
	CMP		AX, sgTssIntLast
	JBE		InterruptCantBlock

; threads with critical section locks can't block
	SUB		AX, 8
	MOV		ES, AX
	CMP		ES: WORD PTR [rTss386cCritSect], 0
	JNE		InterruptCantBlock

	CMP		WORD PTR [SI+oPcbHead], 0	;If this is the only pcb in the queue
	JZ		WaitQueueEmpty

	MOV		DX, BX
	XCHG	[SI+oPcbTail], BX			;tail points to new pcb
	MOV		[BX], DX					;prev points to new pcb
	JMP		FinishWait

WaitQueueEmpty:
	MOV		[SI+oPcbHead],BX			;Head of queue points to new pcb
	MOV		[SI+oPcbTail],BX			;tail points to new waiting pcb
	
FinishWait:
	CALL	MakeUnready					;doesn't disturb AX, does hose DX, SI

%IncInstrument(WaitBlock)

	JMP		SetUpForDispatch


KernelRet:
PUBLIC KernelRet	
;	common exit point for kernel calls.
;	switch back to user stack if switch occurred on entry.
;	return to caller if this thread is the head of the run queue,
;	otherwise dispatch from run queue if lDisp bit is set in exitcode 
;	DI = kernel exit code.
;	AX = erc.
;	carry bit of pushed flags is fStackSwitched

	STR		DX	; check if called from an interrupt handler
	CMP		DX, sgTssIntLast 	;dx used in SaveState below
	JBE		KernelExit
	MOV		SI, oPcbRun
	CMP		SI, runq
	JNE		SetUpForDispatch
	TEST	runQ, 0FFFFh		; if no background process then
	JZ		KernelExit			; in init (disable) code, so must return
	TEST	BYTE PTR [SI+pcbStatus], suspends
 	JNZ		SetUpForDispatch

KernelExit:
;   AX = ercRet
;	DS	<-SP, BP
;	BP
;	FL
;	IP
;	CS
;	args

	TEST  DI, lSysEntry
	JZ	  KernelExitOk
; system call (KWait, KSend, etc) - crash if erc <> ercOk
	OR    AX, AX
	JE    KernelExitOk
	PUSH  AX
	CALL  Crash

KernelExitOk:
	MOV   DS, [BP]
	MOV   CX, [BP+4]	; user FL
	MOV   BP, [BP+2]	; user BP
	TEST  CX, 1			; carry bit set => stack has been switched
	JZ	  StackReady	; no stack switch needed
$MOD386
	STR	  BX
	SUB   BX, 8
	MOV   FS, BX
; restore user SS:SP
	LSS   SP, FS:DWORD PTR [rTss386pUserStack]	
; resetting tss.pUserStack means the kernel stack is free to be used again
; on next entry. this supports nested kernel calls, see EnterKernel.
; now ss:sp -> FL
;			   IP
;			   CS
	MOV   FS:WORD PTR [rTss386pUserStack+2], 0   
	POPF
	JMP	  SHORT KernelRetN
$MOD286
StackReady:
	ADD		SP, 4
	POPF
KernelRetN:

	AND		DI, lCbArgs
; clear segment regsisters so user can't inadvertantly touch our segments
	XOR		CX, CX
	MOV		ES, CX
$MOD386
	MOV		FS, CX
	MOV		GS, CX
$MOD286
	JMP		KernelExitJmpTableT[DI]



SetUpForDispatch:
%if(%mf) then (
; Save external registers in Tss across process switch.
	str		dx
	sub		dx, 8	; dx is data alias for tss
	mov		es, dx
	xchg	ax, cx	; save return code
	mov		dx, Br0Port
	in		al, dx
	mov		ah, al
	mov		dx, RemoteSlotPort
	in		al, dx
	mov		es:[rTss386bSlot], ax
	xchg	ax, cx	; save return code
)fi

;	AX = ercRet
;	ss:sp->	DS
;			BP
;			FL
;			ipRet
;			csRet
;			args
;
	POP		BX
	POP		BP
	JMP		disp


;*****************************************************************************
;	This routine is used when the interrupt handler 
;	returns to the user process.
;*****************************************************************************

IDisp	PROC	NEAR
;*****************************************************************************
;  This routine is used when the Kernel returns to a task.
;*****************************************************************************

Disp	PROC	NEAR		; Disp:
;
; dispatch head of runq. save state in outgoing tss.
; assert DS = OS DS
;		 BX = user DS
;		 AX = ercRet
;		 BP = user BP
;		 DI = exitCode
;		 SS:SP -> FL
;				  IP
;				  CS
;		 carry bit in pushed FL is set if stack has been switched
;

	CLI		   ; New interrupt may change Runq. Also stack manipulation
			   ; requires disabling interrupts

	PUSH 	BX ; user DS
	PUSH	AX ; ercRet
	PUSH	BP ; users bp

; dispatch pcb in critical section ahead of runq
	CMP		oPcbCriticalSection, 0
	JZ		DispRunq
	XOR		BX, BX
	XCHG	BX, oPcbCriticalSection
	JMP 	DispBx
DispRunq:	
	MOV		BX, runq	;Dispatch the first process on the ready list

DispBx:

	MOV 	AX, wMsw287       ; force 287 interrupts if server installed
	OR 		AX, AX
	JZ		CheckSuspended
	LMSW 	AX

CheckSuspended:
	TEST	BYTE PTR [BX+pcbStatus], suspends
	JZ		NotSuspended
CheckNextSuspended:
	MOV		BX, [BX]
	JMP		CheckSuspended

NotSuspended:
;*****************************************************************************
;
;   Test to see if process is waiting for a critical section semaphore
;	On entry, BX points to pcb
;	Uses ES and SI and CX and FS
;
;*****************************************************************************
tss_oPcb		EQU 166		;0A6H
$MOD386

	CMP		tssIdOnly,0
	JE		TcTestWaiting
; If tssIdOnly is non zero, then we can only run userNum zero, 
; the paging service, the cluster service and the TSS specified by
; tssIdOnly.  When the Paging Service encounters a page fault with 
; interrupts disabled, it tells the Kernel: only run the Paging Service
; and critical user numbers until the fault has been resolved.  This permits
; critical sections to continue to work for applications.  
; If a process has the critical section semaphore locked, then the PS
; cannot run until that process releases the semaphore.  This process
; is specified by tssIdOnly.  If no process has the lock, then
; tssIdOnly is a non-zero non-tssId value.

	MOV		AX,[BX+pcbUserNum]
	MOV		CX,cUserNumCritical
; AX has the user number of the PCB that wants to run.
; CX has the number of critical section users.  This is always at least 2 --
; user number zero (the OS) and the paging service.  If the cluster is an
; installed system service, then there could be one or more user numbers
; that belong to the cluster service.
	PUSH	DI
	LEA		DI,rgUserNumCritical
	PUSH	DS
	POP		ES
	CLD
	REPNZ	SCASW
	POP		DI
	JZ		TcTestWaiting		;OK to run this userNum
	MOV		CX,[BX+sgTss]		;CX has TSS of process
	CMP		CX,tssIdOnly
	JNE		CheckNextSuspended

TcTestWaiting:
	BT		WORD PTR [BX+pcbStatus],pcbbSem
	JNC		TcDisp		;Not waiting
; This process is waiting for a critical section semaphore.
; Check to see if the semaphore is free.
	MOV		CX,[BX+sgTss]		;CX has TSS of process
	MOV		SI,CX
	SUB		SI,8				;Get data pointer to TSS
	MOV		FS,SI				;FS points to TSS
	LES		SI,DWORD PTR FS:rTss386pSem	;ES:SI points to semaphore
	PUSHF
; Critical section -- we must lock the semaphore and increment the
; count in one atomic operation.
	CLI
	LOCK BTS WORD PTR ES:[SI],0	;Test and set semaphore
	JNC		TcNotOwned			;Semaphore not already set
; BX points to PCB of Process is waiting for a semaphore.
; ES:SI points to semaphore.
; We must run the process that owns the semaphore.  Otherwise we could
; get into a deadlock situation.  For example:
;	Kbd process priority 2 is waiting for the semaphore.
;	Process A priority 81 own the semaphore, is ready to run.
;	Process B priority 80 is in a busy loop.
; In order to prevent this deadlock situation, we simply ignore
; priority and run the process that owns the semaphore.  By definition,
; the process that owns the semaphore must be ready to run.  If a
; process that owns a critical section semaphore attempts to wait,
; it crashes.
	MOV		CX, ES:[SI+2]		;CX has TSS id of semaphore owner
	SUB		CX,8				;Get data pointer to TSS
	MOV		FS,CX				;FS points to TSS of semaphore owner
	MOV		BX,FS:[tss_oPcb]	;BX points to pcb of semaphore owner
	POPF						;Enable
	JMP		TcDisp

TcNotOwned:
; Semaphore was not set before, but it is now.
	MOV		ES:[SI+2],CX		;Save TSS of new owner of semaphore
	AND		BYTE PTR [BX+pcbStatus],0FFh-pcbfSem
; Increment count of number of critical section semaphores owned by this user.
	INC		FS: WORD PTR [rTss386cCritSect]	
	POPF						;Enable
TcDisp:


;  cpuInUse LED off if dispatching null process, otherwise on
%if (not %mf)then(
	CMP		myLedPort, 0
	JE		CpuLedAbsent
)fi
	MOV	 	AL, bLedCpu
	OR		cpuLedState, AL
	CMP		BX, oPcbNull
	JNE		CpuLedOut
	NOT		AL
	AND		cpuLedState, AL
CpuLedOut:
	MOV		AL, cpuLedState
	NOT		AL
	MOV		DX, myLedPort
	OUT		DX, AL
CpuLedAbsent:




;	Check OS stack boundaries. Make sure marker words
;	 have not been overwritten. That would indicate
;	 stack overflow for an OS process.
	CLD							; for string ops to follow
%IF (%CheckStackOverflow) THEN (
	MOV		SI, WORD PTR oRgoStackLim
	MOV		CX, nStackLim
	MOV		DX, stackLimWord
DispStackLim:
	LODSW				; Load AX with oStackBoundaryWord
	XCHG	AX, DI
	CMP		WORD PTR [DI], DX
	JNE		StackOverFlow
	LOOP	DispStackLim
)FI

	MOV		BP, [BX+pcboExPcb]
	TEST	fVectorUserRun, 0FFh
	JZ 		DispNewUser
	JMP		RecordVectors

DispNewUser:
	TEST	BYTE PTR DS: [BP+exPcbVectorState], 0FFh
	JZ		DispSoftVectors
	JMP		SetVectors
DispSoftVectors:
	MOV		SI, DS: [BP+exPcboSoftVecHead]
	CMP		SI, oSoftVecRun		; If same, leave vectors in place
	JE		DispGo
	CALL	RestoreUserPtrs
DispGo:
	MOV		oPcbrun, BX	
	str		si
	mov		ax, DGroup
	mov		es, ax
	pop		bp ; users bp
	pop		ax ; saved ercRet
	pop		ds ; so user DS will go in TSS for debugger
	cmp		si, es:[bx+sgTss]
	je		RetSameTss
; Special case interrupt tasks that are entered with error codes.
; All such tasks have sgTss <= sgTssGpFault.
	cmp		si, es:[sgTssGPFault]
	jbe		RetInterruptTask	

$MOD386
;increment the task switch counter here
%if(%Statistics) then (
	INC 	ES:DWORD PTR TaskSwitch
)fi

%if(%mf) then (
; Assert TSS external register state (not done by 80386, do in code).
	mov		si, es:[bx+sgTss]
	sub		si, 8		; data alias of Tss to dispatch
;	mov		fs, si		; es, fs, gs not preserved across kernel call anyway.
	db 8Eh,0E6h
	xchg	ax, cx		; save return code of Tss who is blocking
;	mov		ax, word ptr fs:[rTss386bSlot]
	db 64h				; fs:
	mov		ax, word ptr [rTss386bSlot]
	mov		dx, RemoteSlotPort
	out		dx, al
	xchg	al, ah			; rTss386Br0
	mov		dx, Br0Port
	out		dx, al
	xchg	ax, cx		; save return code of Tss who is blocking
)fi
$MOD286

	clc		; do not dispatch to ResumeTaskWait	when resumed
	jmp		dword ptr es:[bx+pTss]


ResumeTask:
PUBLIC ResumeTask
; dispatched process starts here
	jc		ResumeTaskWait

%IncInstrument(Dispatch)%'n.b. instrumentalist knows stack frame here

RetSameTss:
	CMP		DI, lIntRet
	JE		RetProc
	PUSH	BP
	PUSH	DS
	MOV   	BP, SP
	MOV		BX, Dgroup
	MOV		DS, BX
	JMP		KernelExit

RetProc proc far
	popf
	ret


ResumeTaskWait:
PUBLIC ResumeTaskWait

;******************************************************************************
; Process is dispatched here when a pMsg arrives while waiting at an exchange.
;
; If the message is a Respond or SendP, dealiasing is performed.
;
;	AX:CX = pMsg
;	SI    = msgType
;
; On entry, stack is ala ResumeTask and Wait args are on the stack;
; we set it back up ala CEntry
;******************************************************************************
	PUSH	BP
	PUSH	DS
	MOV		BP, SP
	MOV		DX, DGroup
	MOV		DS, DX
%IncInstrument(ResumeTaskWait)
	PUSH	[BP+4]
	POPF							;Enable

	TEST	SI, lMsgDealias
	JZ		ResumeTaskStorePMsg		;No Dealiasing

; Master agent rqs all permanently locked, gdt.  Skip dealias etc.
	CMP		clusterConfig,cws
	JE		ResumeShouldUnlock
	MOV		DX, [BP+iExchg]				;DX = exchange
	CMP		DX, exchAgent
	JE		ResumeTaskStorePMsg
ResumeShouldUnlock:

%IF (%UnlockAtWait) THEN (
	test 	si, lMsgSendP
	jnz  	ResumeDealias
; msg is a respond, unlock it.
	push	di			;save exit code
	push	si			;save msgType
	push 	ax			;save sarq
	push	cx			;save raRq
	push	ax			;argue saRq
	push	cx			;argue raRq
	call	SC_UnlockRqPages
	pop		cx
	pop		ax
	pop		si
	pop		di
ResumeDealias:
)FI

	MOV		DX, [BP+csRet]
	CMP		DX, sgRealInterface
	JNE		ResumeTaskCheckDealiasSl
	PUSH	DI
	PUSH	SI
	PUSH	OFFSET DealiasToSr
	CALL	WaitDealiasRequestBlock
	POP		DI
	JMP		ResumeTaskStorePMsg

ResumeTaskCheckDealiasSl:
	MOV		DX, SI		; save msgType
	MOV		SI, oPcbRun
	TEST	WORD PTR [SI+sgLdt], 0FFF8h
	JZ		ResumeTaskStorePMsg		;Gdt--do nothing	
	PUSH	DI
	PUSH	DX			; msgType
	PUSH	OFFSET DealiasToLdt
	CALL	WaitDealiasRequestBlock
	POP		DI

ResumeTaskStorePMsg:
	LES		BX, DWORD PTR [BP+pPMsgRet]
	MOV		ES:[BX], CX				;Deposit pMsg in pMsgRet
	MOV		ES:[BX+2], AX

	XOR		AX, AX					;ercOk 
;	MOV		ES, AX					;no free sg
	JMP		KernelExit



$MOD386
RetInterruptTask:
;increment the interrupt task switch here
%if (%Statistics) then (
	INC 	ES:DWORD PTR IntTaskSwitch
)fi
	jmp		dword ptr es:[bx+pTss]
$MOD286


; when Interrupt Task is reentered, the stack has an error code on it
	push	ds					;Save DS of interrupt task
	mov		ax,DGroup			; -- it may have different DS than OS
	mov		ds,ax
	test	vf_f386Tss, 1		; really want to know gate type
	pop		ds					;Restore DS of interrupt task
	jnz		Reenter386InterruptTask
	pop		dx ; error code
%IncInstrument(Dispatch)%'n.b. instrumentalist knows stack frame here
	popf
	pop		cx
	pop		bx
	push	dx ; push error code, cs, ip
	push	bx
	push	cx
	ret

$MOD386
Reenter386InterruptTask:
	db 66h
	pop		dx ; pop error code
%IncInstrument(Dispatch)%'n.b. instrumentalist knows stack frame here
	popf
	db 66h
	pop		cx ; pop cs:ip
	db 66h
	push	dx ; push error code
	db 66h
	push	cx ; push cs:ip
	ret
$MOD286

RetProc endp
pIret:
	clts
PUBLIC DmyISR
DmyISR:

	IRET
	jmp pIRet

%IF (%CheckStackOverflow) THEN (
StackOverFlow:
	PUSH	ercStackOverFlow
	CALL	Crash
)FI

RecordVectors:
;	Copy LowMem into Task Vector Area (TVA),
;	 for program like MSDOS which changes vectors
;	 without telling CTOS.
;	MOVW(0:oVector, pVectorArea+2*nwVectors, nwVectors)
	
	PUSH 	DI		; preserve kernel exitCode 
	MOV		SI, oPcbRun
	MOV		SI, [SI+pcboExPcb]
	MOV		CX, [SI+exPcbnwVectors]
	LES		DI, DWORD PTR [SI+exPcbpVectorArea]
	ADD		DI, CX
	ADD		DI, CX
	MOV		SI, [SI+exPcboVector]
	mov		ax, sgLowMem
	MOV		DS, AX

	REP	MOVSW		; Record TVA as process wants it.

;	Put Default Vector Area (DVA) back for other processes.
;	MOVW(pVectorArea, 0:oVector, nwVectors)

	MOV		ES, AX
	MOV		AX, DGroup
	MOV		DS, AX
	MOV		SI, oPcbRun
	MOV		SI, [SI+pcboExPcb]
	MOV		DI, [SI+exPcboVector]
	MOV		CX, [SI+exPcbnwVectors]
	LDS		SI, DWORD PTR [SI+exPcbpVectorArea]

	REP	MOVSW		; Put default vectors in table for next process.

	MOV		AX, DGroup
	MOV		DS, AX
	MOV		fVectorUserRun, FALSE
	POP 	DI		; pop kernel exitCode 
	JMP		DispNewUser


SetVectors:
;	Copy Task Vector Area (TVA) into LowMem,
;	 for program like MSDOS which changes vectors
;	 without telling CTOS.
;	MOVW(pVectorArea+2*nwVectors, 0:oVector, nwVectors)
	PUSH 	DI		; preserve kernel exitCode 
	mov		ax, sgLowMem
	MOV		ES, AX
	MOV		DI, DS:[BP+exPcboVector]
	MOV		CX, DS:[BP+exPcbnwVectors]
	LDS		SI, DWORD PTR DS:[BP+exPcbpVectorArea]
	ADD		SI, CX	;point to TVA
	ADD		SI, CX

	REP	MOVSW

	MOV		AX, DGroup
	MOV		DS, AX
	MOV		fVectorUserRun, TRUE
	POP 	DI		; pop kernel exitCode 
	JMP		DispSoftVectors


Disp	ENDP
IDisp	ENDP



RestoreUserPtrs PROC NEAR
;	Copy lowmem vectors into user soft vector chain,
;	in case application has altered a low memory vector directly.
;	Altered vector is copied back only if application had
;  previously called SetTrapHandler for that vector.
;
;	SoftVector:	
;	 0 	oLowMem      word
;	 2	raData       word
;	 4	saData       word
;	 6	oNextSoftVec word
;	 8	altRaData    word     (ctosp only)  
;	10	sg           selector (ctosp only)
;
;  In real mode CTOS, saData:raData is a low memory vector.
;
;  In CTOSp
;     for real mode tasks
;
;         saData:raData is a real mode scat pointer.
;
;         if sg <> 0FFFFh, sg:altRaData is the corresponding
;         protected mode scat pointer.
;  
;
;     for protected mode tasks
;
;         if saData<>0FFFFh, saData:raData are put in the IDT as
;         a trap gate.  altRaData holds the access byte.
;
;         if sg <> 0FFFFh, sg:altRaData is a protected
;         mode scat pointer.
;
; on entry, bx=target pcb,bp=oExPcbRun, si = target oSoftVec head
;			oSoftVecRun = previous oSoftVec head
;			oPcbRun = current pcb
	PUSH    DI		; save exitCode
	XCHG	SI, oSoftVecRun
; SI = old vectors
; oSoftVecRun = new vectors

	OR		SI, SI				; old list empty?
	JZ		SetUserPtrs
; only restore real mode SCAT pointers
	mov		di, oPcbRun
	test	word ptr [di+spSave], maskRealMode
	jz		short SetUserPtrs
	mov		ax, sgLowMem
	MOV		DX,DS 	; save till later
	MOV		ES,DX
	MOV		DS, AX
ASSUME	ES: DGroup, DS: Nothing

RestoreLoop:
	LODS	WORD PTR ES:[SI]	; AX=oLowMem
	XCHG	AX, SI				; AX=oSoftVec+2, SI=oLowMem
	XCHG	AX, DI				; DI=oSoftVec+2
	MOVSW						; Store lowmem DS:SI in softVec ES:DI
	MOVSW
	MOV		SI, ES:[DI]			; SI=oSoftVec=softVec.link
	OR		SI, SI
	JNZ		RestoreLoop

	MOV		DS,DX
;	jmp		short SetUserPtrs

;
; SetUserPtrs loop sets the real mode SCAT table
;
SetUserPtrs: ;	BX=oPcb
ASSUME DS: DGroup
	MOV		SI, oSoftVecRun
	or		si, si 	; new list = null?
	je  		CheckGPTaskInstalled
	test		word ptr [bx+spSave], maskRealMode
	jz		short SetUserPtrsProtected
	mov		ax, sgLowMem
	mov		es, ax
ASSUME	ES: Nothing

SetLoop:
	LODSW				; AX=oLowmem
	XCHG	AX, DI		; DI=oLowmem
	MOVSW
	MOVSW	
	MOV		SI, [SI]	; SI=oSoftVec=softVec.oNext
	OR		SI, SI
	JNZ		SetLoop

; assert oSoftVecRun non-null
	MOV		SI, oSoftVecRun

;
; SetUserPtrsProtected sets protected scat pointers or
; trap gates in the IDT.
;

SetUserPtrsProtected:
SetLoopP:
assume es: nothing
	cmp		word ptr [si+4], 0FFFFh
	je		CheckPScat
;
; set trap gate in IDT if protected mode task
;
	test		word ptr [bx+spSave], maskRealMode
	jnz		short CheckPScat
UpdateIdt:
	mov		ax, sgIdt
	mov		es, ax
	mov		di, word ptr [si]
	shl		di, 1
	mov		al, byte ptr [si+8]
	mov		byte ptr es:[di+5], al
	mov		ax, word ptr [si+2]; store ra
	stosw
	mov		ax, word ptr [si+4] ; store selector
	stosw	
	jmp		short NextPVec


CheckPScat:
	cmp		word ptr [si+10], 0FFFFh
	je		NextPVec
;
; Set protected scat pointer
;
	mov		ax, sgVirtualLowMem
	mov		es, ax
	mov		di, word ptr [si]
	mov		ax, word ptr [si+8] ; store ra
	stosw
	mov		ax, word ptr [si+10] ; store selector
	stosw	

NextPVec:
	MOV		SI, [SI+6]	; SI=oSoftVec=softVec.oNext
	OR		SI, SI
	jz  		CheckGPFaultVector
	jmp  		short	 SetLoopP


CheckGPFaultVector:	
CheckGpTaskInstalled:
SetReturn:
	POP		DI
	RET
RestoreUserPtrs ENDP


ASSUME	 CS: KGroup, DS: DGroup, ES: Nothing

;*****************************************************************************
;  This routine returns from the interrupt handler.
;*****************************************************************************

IntRet  PROC NEAR
			;In real mode, this CLI intruction is for debugging convenience
	CLI		;to prevent the interrupt stack being overflowed
			;by the same interrupt which is not cleared due to software bug
			;
			;In protected mode, CLI guarantees that next entry to this
			;interrupt task will be with interrupts off.

; push kernel entry address back on interrupt stack
	push cs
	push offset IntRet
	mov ax, DGroup
	mov ds, ax

	str  ax		; sgTss of this interrupt
	mov  sgTssIntRetLast, ax	; for debugging
	sub  ax, 8	; alias for the TSS
	mov  es, ax
	test vf_f386Tss, 1
	mov  di, rTss386tyDev
	mov  si, rTss386wDsInt
	jnz  TestEarlyEoi
	mov  di, rTss286tyDev
	mov  si, rTss286wDsInt
TestEarlyEoi:
; Assumption: tyDev is set in the TSS for all device interrupts.
; This is true for all SysGen'd interrupts, and we don't allow setting a 
; device handler for interrupts not in SysGen.  If this changes we'll still be 
; ok because tyDev=0 maps to a controller entry in mpTyDevMask, and lfEarlyEoi 
; is never set for controllers.
; Mask structure is (wPort, wEnableAnd, wDisableOr, oMem, iInt, f, oCount)
intPort EQU 0
intEnableAnd EQU 2
intDisableOr EQU 4
intoMem EQU 6
intiInt EQU 8
intF EQU 9
intoCount EQU 10
lfEarlyEoi EQU 2
	mov  bx, es:[di]
	mov  ax, 12
	mul  bl
	mov  bx, ax
	test byte ptr mpTyDevMask[bx+intF], lfEarlyEoi
	jz   DoEoi
; bOpEnable code cloned from ControlInterrupt
	mov  dx, mptyDevMask[bx+intPort]	;Read current interrupt mask value
	xor  ah, ah
	in   al, dx							;Byte register
	mov  di, mptyDevMask[bx+intoCount]	;Offset of mask count
	cmp  word ptr [di], 0				;Is mask count nonzero?
	je   UnMask							;No, unmask, leave count as is
	dec  word ptr [di]
	jnz  JmpDoIntRet					;Other user(s) still desire mask
UnMask:
	and  ax, mptyDevMask[bx+intEnableAnd]
	out  dx, al							;Byte register
	mov  di, mptyDevMask[bx+intoMem]	;Find mask memory copy
	or   di, di
	jz   JmpDoIntRet
	mov  [di], ax
JmpDoIntRet:
	jmp  DoIntRet
DoEoi:

	%DO_EOI

	jmp short DoIntRet

SIntRet:
; cli guarantees that next entry to this interrupt task will
; keep interrupts off.
	cli
; push kernel entry address back on interrupt stack
	push cs
	push offset SIntRet
	mov ax, DGroup
	mov ds, ax
	str ax		; sgTss of this interrupt
	mov sgTssIntRetLast, ax	; for debugging
	sub ax, 8	; alias for the TSS
	mov es, ax
	test vf_f386Tss, 1
	mov si, rTss386wDsInt
	jnz DoIntRet
	mov si, rTss286wDsInt
DoIntRet:	
; Nested interrupt?
	mov di, es:[rTssLink]
	cmp di, sgTssIntLast	
	ja ProcessRet

; yes - returning to an interrupt
; restore interrupt handler DS
	mov ds, es:[si]
	IRET
; restore interrupt handler DS again in case interrupt filter was removed.
	mov ds, es:[si]
; next interrupt begins here - restore flags for this interrupt task
	push es:[si+2]	; flags
	popf	
	jmp dword ptr es:[si+4]

ProcessRet:
; not nested interrupt - returning to a process
;
; build a dispatcher stack frame and goto dispatcher

	mov bx, es:[si]		; interrupt task ds
	push es:[si+6]		; interrupt task ip
	push es:[si+4]		; interrupt task cs
	push es:[si+2]		; interrupt task flags

; di is sgTSS of interrupted process - clear busy task bit
	mov ax, 8
	mov es, ax
	mov al, byte ptr es:[di+5]
	and al, 0FDh
	mov byte ptr es:[di+5], al

%if(%mf) then (
; Save external register state of interrupted process in case no longer on
; head of runq.
	sub di, 8		; data alias of Tss
	mov es, di
	mov dx, Br0Port
	in  al, dx
	mov ah, al
	mov dx, RemoteSlotPort
	in  al, dx
	mov es:[rTss386bSlot], ax
)fi
	mov di, lIntRet	; no args & no stack to switch
	jmp Disp

IntRet	ENDP

;*****************************************************************************
;	Dispatch routine for OS resident subroutines.
;	We come here from an INT 7	
;*****************************************************************************

; upon entry, stack looks like:
;
;      |  ARG 0  |
;      |   .     |
;      |   .     |
;      |  ARG n-1|
;      |  cs 1   |
;      |  ip 1   |
;      |  flag   |
;      |  cs 2   |
;      |  ip 2   |
;

; System Common Heap Entry offsets
sciProc  EQU 0
scpProc  EQU 2
scoTCode EQU 6
scSize   EQU 8


OsSubEntry PROC FAR
; this entry is taken in ctosp only if the caller is
; real mode
	POP		BX			; ip2
	POP		SI			; cs2
	POPF				; restore the process flag
	NOT		SI
	SUB		BX, 2		; ip is the return address
	AND		BX, 0Fh
	ADD		SI, BX
	SHL		SI, 1		; address into a table of double words

	MOV		AX, DGroup
	MOV		ES, AX
ASSUME ES: DGroup, DS:Nothing

; SI=iProc*4  ES=DGroup

	MOV		AX, cpOsSubTable
	SHL		AX, 2
	CMP		SI, AX
	JAE		OsSubNotInTable

; Check for a zero entry -- this is an indicator to look in heap
	MOV		AX, WORD PTR OsSubTable[SI+2]
	OR		AX, WORD PTR OsSubTable[SI]
	JZ		OsSubNotInTable

; cx:di = pRmwa_rgSgAlias, dx = rmwa_sgSS
	push	word ptr OsSubTable[SI+2] ;CS
	push	word ptr OsSubTable[SI]   ;IP
	shr		si, 1
	mov		bx, rgoOssubDesc[si]

AliasStackOsSub:

;REGISTER ASSUMPTIONS:
; 
; pProc CS:IP pushed    ES:BX -> TCode
; CX:DI = pRmwa_rgSgAlias, dx = rmwa_sgSS
;  AX = junk

ASSUME ES:Nothing, DS:Nothing
	push	bp
	mov		bp, sp
	add		bp, 4
	push	ds
	MOV		AX, DGroup
	mov		ds, ax
	PUSH		CX ; saRmwa_rgSgAlias
assume ds:DGroup, es:nothing
	or		bx, bx
	jz		ContinueOsSub ; KernelKillUser
	xor		cx, cx
NextOssubParam:
	mov		cl, byte ptr es:[bx]
	inc		bx
	jcxz	ContinueOsSub
	mov		si, cx
	mov		ax, ss:[bp][si]
; AliasIpcSr preserves registers (but assumes DS = DGroup)
	call	AliasIpcSr
; Ivolume II 1.0 passes a null pointer and expects it
; to work (actually clobbers lowmem) - so ctosp must allow it also
	or		ax, ax
	jnz		CheckForDGroup
	mov		ax, sgLowMem
	jmp		short StoreOssubSn
CheckForDGroup:
; Do not record alias if it is for DGroup, since the DGroup
; selector is never deallocated.
	cmp		ax, dx ; dx = rmwa_sgSS
	je		StoreOssubSn
; Records alias selector in rmwa_rgSgAlias so that
; deallocation can occur on return.

; Really want to do the following, but assembler won't allow it
;	XCHG		ES, word ptr ss:[bp-8] ;get saRmwa_rgSgAlias
; The following does the same thing:
	PUSH		AX
	MOV		AX, ES
	XCHG		AX, ss:[bp-8]
	MOV		ES, AX
	POP		AX

	mov		word ptr es:[di], ax

; Really want to do the following, but assembler won't allow it
;	XCHG		ES, word ptr ss:[bp-8] ;put back saRmwa_rgSgAlias
; The following does the same thing
	PUSH		AX
	MOV		AX, ES
	XCHG		AX, ss:[bp-8]
	MOV		ES, AX
	POP		AX

	add		di, 2
StoreOssubSn:
	mov		ss:[bp][si], ax
	jmp		short NextOssubParam	
ContinueOsSub:
	POP		ES
	mov		word ptr es:[di], 0 ; terminate rmwa_rgSgAlias

	pop		ds 
ASSUME DS:Nothing
	pop		bp
; Here is where code fixup would be done.
; If return address on stack (below CS:IP pushed) points just after
; 9A XX XX then change XX XX to be CS:IP pushed on stack.

	RET		;CS:IP had been pushed


OsSubNotInTable:

; Scan system common heap for iProc match
; SI = iProc*4  ES=DGroup   AX=DGroup
; CX:DI = pRMWA_rgSgAlias, DX = rmwa_sgSS:  Preserve them
ASSUME ES:DGroup
	PUSH		CX
	PUSH		DI
	SHR		SI, 1
	SHR		SI, 1
	MOV		CX, oSCHeapEntriesLimit
	LES		DI, pSCHeap
ASSUME ES:Nothing
OsSubHeapSearch:
	JCXZ		OsSubErrorExitClearStack
	CMP		ES:sciProc[DI], SI
	JE		OsSubFoundEntry
	ADD		DI, scSize
	SUB		CX, scSize
	JMP		SHORT OsSubHeapSearch

OsSubFoundEntry:
	MOV		BX, ES:scoTCode[DI]

	POP		AX  ; restore CX:DI.  Destroys DGroup value in AX
	POP		CX

	PUSH		ES:scpProc[DI+2]  ;CS
	PUSH		ES:scpProc[DI]    ;IP

	MOV		DI, AX
	JMP		AliasStackOsSub

OsSubErrorExitClearStack:
	POP		DI  ; get rid of stuff on stack
	POP		CX


OsSubErrorExit:
	MOV		AX, ercNotImplemented

ASSUME  ES: Nothing

OsSubEntry ENDP

;**********************************
;		KernelKillUser
;		Must follow OsSubErrorExit,
;		 so it falls through.
;
;**********************************

KernelKillUser	PROC	FAR
KillUser:
	PUSH	AX
	MOV		AX, DGroup
	MOV		ES, AX
ASSUME ES: DGroup, DS: Nothing
;Check if the CALL is from a task or an interrupt routine
	str		ax
	cmp		ax, sgTssIntLast
	JBE		DoCrash
	MOV		BX, oPcbRun
	TEST	BYTE PTR es:[BX+pcbStatus], pcbfSys
	JZ		DoErrorExit
DoCrash:
	CALL	Crash
DoErrorExit:
	CALL	ErrorExit	;Never returns.

ASSUME  DS: DGroup, ES: Nothing

KernelKillUser	ENDP

	
;*****************************************************************************
;		MakeReady
;		BX points to Pcb to make ready
;		NOTE: we do not disturb AX or BX
;		NOTE: This code is copied in InitKProcs.asm
;*****************************************************************************

MakeReady	PROC	NEAR
	OR		BYTE PTR [BX+pcbStatus], ready
%if (%suspendOffRunQ) then(%'
	test	byte ptr [BX+pcbStatus], suspends
	jnz		@72
)fi%'
LinkPcb:
	MOV		CL, [BX+pcbPriority]		;AL = priority of new pcb
	MOV		DX, OFFSET DGroup: runq		;DX points to prev pcb
	MOV		SI, runq					;SI points to next pcb in runq
@70:
	OR		SI, SI						;IF last pcb in runq
	JZ		@71

	CMP		[SI+pcbPriority],CL			;IF pcb.priority < nextPcb.priority
	JA		@71

	MOV		DX, SI						;DX points to prev pcb
	MOV		SI, [SI] 					;SI points to next pcb in runq
	JBE		@70

@71:
	MOV		[BX], SI					;new pcb points to next pcb in runq
	MOV		SI,DX
	MOV		[SI], BX					;prev pcb points to new pcb
@72:
	RET		

MakeReady	ENDP



;*****************************************************************************
;
;	MakeUnready: PROCEDURE(oPcb) REENTRANT;
;
;	NOTE: We do not disturb AX or BX
;	NOTE: This code is copied in InitKProcs.asm
;*****************************************************************************
MakeUnready	PROC	NEAR
	MOV		BX, oPcbRun					;BX points to pcb to make unready
MakeBXUnready:
	CALL		UnlinkPcb
	AND		BYTE PTR [BX+pcbStatus], NOT ready
	RET	

MakeUnready	ENDP


ApplyDeltaPriorityBx PROC NEAR

;	BX = oPcb
;	AL = new priority
	MOV		SI, [BX+pcboExPcb]			;Apply deltaPriority
	MOV		AH, [SI+exPcbDeltaPriority]

;**************************************************
;
;	ApplyDeltaPriority: PROCEDURE(wPrio) REENTRANT;
;
;	BX=oPcb SI=oExPcb
;	AL=priority, AH=deltaPriority
;
;	NOTE: We disturb only AX
;
;**************************************************
ApplyDeltaPriority PROC NEAR
	CMP		AL, prioOS
	JBE		ClearDelta
	CMP		AL, prioNeverRun
	JAE		ClearDelta
	ADD		AL, AH	; Adjust by deltaPriority
	CMP		AL, prioOS
	JA		LeaveDelta
	SUB		AL, AH	; Un-adjust
ClearDelta:
	MOV		AH, 0
LeaveDelta:
	MOV		[BX+pcbPriority], AL
	MOV		[SI+exPcbDeltaPriority],AH
	RET

ApplyDeltaPriority ENDP
ApplyDeltaPriorityBx ENDP


;
; Pcbs-by-UserNum
;
argOPcb		EQU 6 [BP]
sArgs		EQU 2

ThreadPcb PROC FAR
;
; ThreadPcb: PROCEDURE(oPcb)
;
; Thread the pcb onto the pcb.userNum's list.
; Mutual exclusion is caller's business.
;
; Assert: ds=DGroup.
; AX register corrupted.
;
	PUSH	BP
	MOV		BP, SP
	PUSH	BX
	PUSH	SI

	MOV		SI, argOPcb
	MOV		BX, pcbUserNum [SI]
	AND		BX, maskSlot
	SHL		BX, 1
	ADD		BX, oRgOUserPcb
	MOV		AX, [BX]
	MOV		[BX], SI
	MOV		BX, pcbOExPcb [SI]
	MOV		exPcbONextPcb [BX], AX

	POP		SI
	POP		BX
	POP		BP
	RET		sArgs
ThreadPcb ENDP


UnthreadPcb PROC FAR
;
; UnthreadPcb: PROCEDURE(oPcb)
;
; Unthread the pcb from the pcb.userNum's pcb list.
; Mutual exclusion is caller's business.
;
; Assert: ds=DGroup.
; AX register corrupted.
;
	PUSH	BP
	MOV		BP, SP
	PUSH	BX
	PUSH	SI

	MOV		SI, argOPcb
	MOV		BX, pcbUserNum [SI]
	AND		BX, maskSlot
	SHL		BX, 1
	ADD		BX, oRgOUserPcb
UnthreadPcbFrisk:
	CMP		SI, [BX]
	JE		UnthreadPcbFound
	MOV		BX, [BX]
	OR		BX, BX
	JZ		BogusPcb
	MOV		BX, pcbOExPcb [BX]
	ADD		BX, exPcbONextPcb
	JMP		SHORT UnthreadPcbFrisk
UnthreadPcbFound:
	MOV		SI, pcbOExPcb [SI]
	MOV		SI, exPcbONextPcb [SI]
	MOV		[BX], SI

	POP		SI
	POP		BX
	POP		BP
	RET		sArgs

BogusPcb:
	PUSH	ercInternalError
	CALL	Crash
UnthreadPcb ENDP


DeallocPcb PROC FAR
;
; DeallocPcb: PROCEDURE(oPcb) PUBLIC
;
; Unthread the pcb from whatever user it belongs to and then free the pcb.
; Mutual exclusion enforced.
;
; Assert: ds=DGroup.
; ONLY PLM registers preserved.
;
	PUSH	BP
	MOV		BP, SP

	PUSH	argOPcb
	CALL	RestoreDefaultTss

	MOV		BX, argOPcb
	PUSHF
	PUSH	BX
	CLI
	CALL	UnthreadPcb
	XOR		AX, AX
	MOV		pcbPriority [BX], AL
	MOV		raPMsgRet [BX], AX
	MOV		saPMsgRet [BX], AX
	MOV		pcbExchgSync [BX], AX
	MOV		pcbUserNum [BX], AX
	MOV		pcbStatus [BX], AL
	MOV		AX, oFreePcb
	MOV		[BX], AX
	MOV		oFreePcb, BX
	POPF

; reset tss.pUserStack
	MOV		BX, argOPcb
	MOV		AX, [BX+sgTss]
$MOD386
	SUB		AX, 8
	MOV		ES, AX
	MOV		ES:DWORD PTR [rTss386pUserStack], 0
	POP		BP
	RET		sArgs
$MOD286
DeallocPcb ENDP


ONextUserPcb PROC FAR
;
; ONextUserPcb: PROCEDURE(userNum, oPrevPcb) OFFSET PUBLIC
;
; If oPrevPcb=0, return AX=first pcb in chain.
; If end (or empty) chain, return ZF set and AX=0.
; Mutual exclusion is caller's business.
;
; Assert: ds=DGroup.
; No other registers corrupted.
;
argUserNum	EQU 8 [BP]
sArgs		EQU 4

	PUSH	BP
	MOV		BP, SP
	PUSH	BX

	MOV		BX, argOPcb
	OR		BX, BX
	JNZ		ONextUserPcbNext

	MOV		BX, argUserNum
	AND		BX, maskSlot
	CMP		BX, nUcb
	JAE		ONextUserPcbUhUh
	SHL		BX, 1
	ADD		BX, oRgOUserPcb
	MOV		AX, [BX]

ONextUserPcbRet:
	OR		AX, AX
	POP		BX
	POP		BP
	RET		sArgs

ONextUserPcbNext:
	MOV		BX, pcbOExPcb [BX]
	MOV		AX, exPcbONextPcb [BX]
	JMP		SHORT ONextUserPcbRet

ONextUserPcbUhUh:
	XOR		AX, AX
	JMP		SHORT ONextUserPcbRet

ONextUserPcb ENDP


;*****************************************************************************
;
;	GCreateProc: PROCEDURE(pProcDesc) REENTRANT;
;
;	DECLARE ProcDescType LITERALLY  'STRUCTURE(
;		 entry POINTER
;		,saData WORD
;		,saExtra WORD
;		,saStack WORD
;		,sStack WORD
;		,priority BYTE
;		,fSysProc BYTE
;		,exchg WORD
;		,fDebug BYTE
;		)';
;	DECLARE PcbType LITERALLY 'STRUCTURE(
;	  oPcbLnk       ADDRESS
;	 ,status        BYTE
;	 ,priority      BYTE
;	 ,spSave        WORD
;	 ,ssSave        WORD
;	 ,msgRetAddr    POINTER
;	 ,exchgSync     WORD
;	 ,userNum       WORD
;	 ,id            WORD (or oExPcb)
;	 )';
;*****************************************************************************

; GCreateProc: (pPdb) 
%EnterKernel(CreateProc, l2Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     pPdb
	CLI
	PUSH    DI		;save exit code
	MOV		AX, WORD PTR [BP+saRq]
; aliasing only required for real mode clients
	MOV 	DX, [bp+csRet]
	CMP 	DX, sgRealInterface
	JNE		cp_Addressable
	CALL 	CreateIPCAlias
cp_Addressable:
	PUSH	AX					;snRq
	PUSH	WORD PTR [BP+raRq]
	MOV		BX, oPcbRun
	PUSH	0					; old PDB - does not contain ax-dx,si,di
	CALL	CreateProc

	POP		DI	; exit code	
	JMP		KernelRet



;*****************************************************************************
;
;	CloneProcess: PROCEDURE(oPcbSource, pProcDesc) REENTRANT PUBLIC;
;
;   Called by Sched to create a process on behalf of LoadTask.
;
;*****************************************************************************

%EnterKernel(CloneProcess, l3Argw, fNoSwitch, lNoHook) 
CloneProcess EQU GCloneProcess
PUBLIC CloneProcess
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     pPdb
;			 oPcbSource
; CloneProcess is not user callable
$MOD386
	PUSH	DWORD PTR [BP+ARG0]	
	MOV		BX, WORD PTR [bp+14] ; oPcbSource
	PUSH	0		; old PDB - does not contain ax-dx,si,di
	CALL	CreateProc
	MOV		DI, l3Argw
$MOD286
	JMP		KernelExit ; doesn't dispatch


CreateProc PROC NEAR
PUBLIC CreateProc
;*****************************************************************************
;	CreateProc: PROCEDURE (pPdb, fOldPDB) REENTRANT;
;	on entry, bx points to source oPcb (ctosp only)
;	Returns with code in AX, BX points to new Pcb
;   In protected mode, BX is oPcbSource, the process on which to base the
;   process creation.
;*****************************************************************************
pPdb 	EQU DWORD PTR [BP+6]
fOldPdb EQU BYTE PTR [BP+4]
	PUSH	BP
	MOV		BP,SP
	push	bx ; save oPcbSource

; AllocPcb
	MOV		BX, oFreePcb
	OR		BX, BX
	JNZ		Found
	MOV		AX, ercNoPcb
CpErrorRet:
	MOV		SP, BP
	POP		BP
	RET		6
	
FOUND:
;have free one
$MOD386
	MOV		AX, [BX+sgTss]				
	SUB		AX, 8
	MOV		FS, AX	; tss data alias

%if (1) then (
; optimization:
; disable kernel stack switching for this thread if PS is not installed. prior 
; to PS user stacks are locked.
	TEST	vf_fPageServiceInstalled, 1	
	JNZ		CreatePcb
	CMP     FS:WORD PTR [rTss386pKernelStack+2], 0
	JZ		CreatePcb
; return thread's kernel stack selector to free list.
	PUSH	BX
	PUSH    FS
	PUSH    FS:WORD PTR [rTss386pKernelStack+2]
	CALL    ThreadSg 
	POP		FS
	POP		BX
	MOV     FS:DWORD PTR [rTss386pKernelStack+2], 0
CreatePcb:
)fi
$MOD286

	MOV		AX, [BX]
	MOV		oFreePcb, AX
	XOR		AX, AX
	MOV		[BX], AX
	MOV		AL, pcbUsed or pcbfSys
	LES		SI, pPdb
	TEST	BYTE PTR ES: [SI+fSys], 1
	JNZ		SST
	MOV		AL, pcbUsed
SST:	
	MOV		[BX+pcbStatus], AL
;Copy pcbUserNum, exPcb from pcbRun
	PUSH	BX
	mov		bx, word ptr [bp-2]
	MOV		CX,WORD PTR [BX+pcbUserNum]
	MOV		DI,WORD PTR [BX+pcboExPcb]
	MOV		AH, [DI+exPcbDeltaPriority]
	MOV		AL, ES:BYTE PTR [SI+Priority]
; if pdb.priority = 0 inherit caller priority
	OR		AL, AL
	JNZ		UsePdbPrio
	MOV		AL, [BX+pcbpriority]
	SUB		AL, AH		; un-apply delta 
UsePdbPrio:

	POP		BX
	MOV		WORD PTR [BX+pcbUserNum],CX
	MOV		SI, [BX+pcboExPcb]

	MOV		CX, DS
	MOV		ES, CX
	XCHG	SI, DI
	MOV		CX, exPcbpVectorArea+4	;Move includes pVectorArea
	CLD
	REP		MOVSB

	MOV		SI, [BX+pcboExPcb]	; Must applyDelta after MOVSB
	CALL	ApplyDeltaPriority	; AL=priority, AH=deltaPriority
	
	LES		SI, pPdb
	MOV		AX, ES: [SI+exchg]
	MOV		[BX+pcbExchgSync], AX

; check if it needs to be suspended
	
	MOV		AL, ES: [SI+fDebug]
	CMP		AL, 0
	JZ		@CreateProc0
	ADD		BYTE PTR [BX+pcbStatus], aSuspend	
@CreateProc0:

; ES:SI addresses process descriptor, bx is new pcb
;

$MOD386
; get LDT and sgStack of caller
	push	bx
	mov		bx, word ptr [bp-2]
	mov		di, [bx+sgLdt] 
	mov		cx, [bx+sgTss]
	sub		cx, 8 ; get data alias
	mov		gs, cx
	pop		bx ; oPcbCreating

; gs is data alias of calling TSS
; fs is data alias of TSS being created

	mov		cx, gs:[rTss386Ldt] 

; let sgStack be same as caller - save in di for real mode test
	mov		word ptr [bx+spSave], di	

	mov     fs:	word ptr [rTss386PcEmDebugExch], 0
	mov		fs:	word ptr [rTss386Ldt], cx ;LDTR
	xor		ecx, ecx
; zero a few 386 registers
	mov		fs:	word ptr [rTss386FS], ecx
	mov		fs:	word ptr [rTss386GS], ecx
	mov		fs:	word ptr [rTss386AX], ecx
	mov		fs:	word ptr [rTss386BX], ecx
	mov		fs:	word ptr [rTss386CX], ecx
	mov		fs:	word ptr [rTss386DX], ecx
	mov		fs:	word ptr [rTss386SI], ecx
	mov		fs:	word ptr [rTss386DI], ecx
	mov		fs:	word ptr [rTss386rmwaE8087], ecx
	mov		fs:	word ptr [rTss386cCritSect], cx
	mov		fs:	byte ptr [rTss386PendSuspend], cl
%if(%mf) then (
	mov		fs:	word ptr [rTss386bSlot], cx
)fi
	mov		cx, initFlag ; flags
	mov		fs:	word ptr [rTss386Flags], ecx
	mov		ecx, word ptr gs:[rTss386Cr3]
	mov		fs:	[rTss386Cr3], ecx

@E:
	xor		cx, cx ; zero the back link
	mov		fs:	word ptr [rTssLink], cx

	test	di, maskRealMode
	jnz		InitRealTss
	jmp		InitProtectedTss

InitRealTss:

; v series - ES:SI addresses process descriptor
	mov		cx, fs: word ptr [rTss386SS0]
	mov		ax, fs: word ptr [rTss386SP0]
; switch to level 0 stack
	mov		di, sp ; dx:di is saved pointer to caller's stack
	mov		dx, ss			;save SS 
	mov		ss, cx
	mov		sp, ax

	xor		eax, eax
	push	eax ; GS
	push	eax ; FS

	push	ax
	push	word ptr es:[si+saData] ; DS

	push	ax
	push	word ptr es:[si+saExtra] ; ES

	push	ax
	push	word ptr es:[si+saStack] ; SS

	push	ax
	push	word ptr es:[si+sizeStack] ; SP

	push	initFlagV86Msb ; FL
	push	initFlag

	push	ax
	push	word ptr es:[si+saCode] ; CS

	push	ax
	push	word ptr es:[si+raCode] ; IP

; switch back to caller's stack
	mov		ss, dx
	mov		sp, di

; finish TSS initialization

	xor		eax, eax
	mov		fs: word ptr [rTss386rmwaSgSS], ax
	mov		fs: word ptr [rTss386DS], eax
	mov		fs: word ptr [rTss386ES], eax
	mov		fs: word ptr [rTss386Sp], eax
	mov		ax,	word ptr es:[si+sizeStack] ; SP
	mov		fs: word ptr [rTss386Bp], eax  ; let bp = sp
	mov		ax, sgSend ; to prevent fault on initial task switch
	mov		fs: word ptr [rTss386SS], eax
	mov		ax, seg EnterV86
	mov		fs: word ptr [rTss386CS], eax
	mov		ax, offset EnterV86
	mov		fs: word ptr [rTss386Ip], eax
	xor		ecx, ecx
	jmp		TestForOldPdb

InitProtectedTss:
; protected mode process
	mov		cx, WORD PTR ES: [SI+SaData]	 ;DS
	mov		fs: word ptr [rTss386DS], cx
	mov		cx, WORD PTR ES: [SI+SaExtra]	 ;ES
	mov		fs: word ptr [rTss386ES], cx
	mov		cx, word ptr es: [SI+SaStack]	 ;SS
	mov		fs: word ptr [rTss386SS], cx
	xor		ecx, ecx
	mov		cx, word ptr es: [SI+SizeStack] ;SP and BP
	mov		fs: word ptr [rTss386Sp], ecx
	mov		fs: word ptr [rTss386Bp], ecx
	mov		cx, WORD PTR ES: [SI+SaCode]	 ;CS
	mov		fs: word ptr [rTss386CS], cx
	mov		cx, WORD PTR ES: [SI+RaCode]	 ;IP
	mov		fs: word ptr [rTss386Ip], ecx
TestForOldPdb:
	test	fOldPdb, 1
	je		OldPDB
; called from NewProcess, PDB contains ax,bx,cx,dx,si,di
	mov		cx, WORD PTR ES: [SI+rAx]	 
	mov		fs: dword ptr [rTss386Ax], ecx
	mov		cx, WORD PTR ES: [SI+rBx]	 
	mov		fs: dword ptr [rTss386Bx], ecx
	mov		cx, WORD PTR ES: [SI+rCx]	 
	mov		fs: dword ptr [rTss386Cx], ecx
	mov		cx, WORD PTR ES: [SI+rDx]	 
	mov		fs: dword ptr [rTss386Dx], ecx
	mov		cx, WORD PTR ES: [SI+rSI]	 
	mov		fs: dword ptr [rTss386SI], ecx
	mov		cx, WORD PTR ES: [SI+rDI]	 
	mov		fs: dword ptr [rTss386DI], ecx
OldPDB:
	
	;Thread Pcb to appropriate user chain, then insert Pcb into the RunQ.
	;The pcb's userNum gets set to the user owning the respExch (if extant);
	;this is primarily a convenience for the loader, which calls us on behalf
	;of the user being loaded.  If there is no respExch, then the new pcb
	;inherits the caller's userNum; this implies that the caller is a user
	;adding a process to his/her partition (applies to system init code, too).
	
Insert:	
	MOV		SI, [BX+pcbExchgSync]
	OR		SI, SI
	JZ		TidGenerate
	AND		SI, maskiExch
	SHL		SI, 1
	ADD		SI, oRgExchgUserNum
	MOV		AX, [SI]
	CMP		AX, 0FFFFh
	JE		TidGenerate
	MOV		[BX+pcbUserNum], AX

TidGenerate:
; generate OS/2-style thread id (tid) - each userNum has tids 0..n. The
; pcb list is not kept in tid order so multiple passes are made
; over list until a unique tid is found. This brute force approach is the
; tradeoff for not sorting the list (nb clients of the user pcb list require 
; it be lifo).
	MOV		CX, 0ffffh	; tid
TidSearchPcbList:
	XOR 	AX, AX
	INC		CX	
TidSearchNextPcb:
	PUSH 	WORD PTR [BX+pcbUserNum]
	PUSH	AX
	CALL	ONextUserPcb	; preserves registers
	OR		AX, AX			; oPcbNext
	JE		TidSearchDone	
	MOV		DI, AX
	MOV		DX, [DI+sgTss]
	SUB		DX, 8
	MOV		ES, DX			; tss alias
    CMP		ES:[rTss386Os2Tid], CX	; tid exist?
	JNE		TidSearchNextPcb
	JMP		SHORT TidSearchPcbList	; yes, restart list search with next tid
TidSearchDone:
;	CX = new tid
    MOV		FS:[rTss386Os2Tid], CX

ThreadNewPcb:
	PUSH	BX
	CALL	ThreadPcb

	PUSHF				
	CLI
	CALL	MakeReady	;BX points to Pcb to make ready
	POPF
	mov		sp, bp
	POP		BP
	XOR		AX, AX		;return ercOK
	RET		6

CreateProc ENDP

$MOD286

;*****************************************************************************
;
;	ChangePriority: PROCEDURE (newPriority) REENTRANT;
;
;*****************************************************************************

; GChangePriority: (prio)
%EnterKernel(ChangePriority, l1Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     prio
	CLI
	MOV		AL, [BP+newPriority]
	CALL	MakeUnready					;Does not disturb AX
	MOV		BX, oPcbRun
	CALL	ApplyDeltaPriorityBx
	CALL	MakeReady					;BX points to Pcb to make ready
	XOR		AX, AX
	JMP		KernelRet


;*****************************************************************************
;
;	SetDeltaPriority: PROCEDURE (userNum, deltaPriority) REENTRANT;
;
;	Set userNum's processes to different delta priority.
;
;*****************************************************************************

%EnterKernel(SetDeltaPriority, l2Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     prio
;			 userNum

argUserNum	EQU	12
argDeltaPrio	EQU	10
	
	cli
	mov		BX, [BP+argUserNum]
	cmp		BX, userNumPrimary
	jbe		@retOK4

	mov		DH, [BP+argDeltaPrio]	;set new delta
	AND		BX, maskSlot
	ADD		BX,orgDeltaPriority
	mov		[BX], DH

	xor		BX, BX				;prime the ONextUserPcb pump
@l1:
	push	[BP+argUserNum]
	push	BX					;oPrevPcb
	call	ONextUserPcb
	jz		@retOK4				;ZF->AX=0 (end of list)
	mov		BX, AX				;oPcbNext

	mov		SI, [BX+pcbOExPcb]
	mov		AH, [SI+exPcbdeltaPriority]
	mov		AL, [BX+pcbPriority]
	sub		AL, AH				;remove old delta
;	Use exPcb.deltaPriority instead of rgDeltaPriority because
;	pcbs created by loader don't reflect rgDeltaPriority of the user
;	the pcbs were created for.  Loader then uses this call to set
;	pcbs right.  Must remove delta of Loader (in exPcb, set by
;	CreateProcess), apply argDelta.

	mov		AH, [BP+argDeltaPrio]	;apply new delta
	CALL	ApplyDeltaPriority

	test	BYTE PTR [BX+pcbStatus], ready
	jz		@l1

	call	MakeBXUnready
	call	MakeReady
	jmp		@l1

@retOK4:
	XOR		AX, AX
	JMP		KernelRet	



ASSUME CS: KGroup, DS: DGroup

;*****************************************************************************
;	ChangeProcessPriority: PROCEDURE(pid, prio) ErcType
;       | pid   | +12
;       | prio  | +10
;       | CS    | +8
;       | IP    | +6
;       | flags | +4
;       | BP    | +2
;       | DS    | <--BP
;	
;*****************************************************************************

; ChangeProcessPriority: (pid, prio)
%EnterKernel(ChangeProcessPriority, l2Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     prio
;			 pid

	CLI
	MOV		BX, [BP+12]					;BX points to pcb to change priority
	CALL	VerifyPid
	JNZ		ChangePriorityExit					;AX = erc
	MOV		AL, [BP+10]					;AL = new priority
	CALL	ApplyDeltaPriorityBx
	XOR		AX,AX					;Set ercOk
	CALL	UnlinkPcb
	JZ		ChangePriorityExit					;if Pcb was not in run queue
; If the Pcb is in the run queue, remove it from the run queue, then
; link it into the run queue again according to its new priority.
	CALL	MakeReady
ChangePriorityExit:
	JMP		KernelRet	; dispatch runq


;*****************************************************************************
;	QueryProcessInfo: PROCEDURE(pid, pInfoRet, sInfoRet) ErcType
;	
;*****************************************************************************

; GQueryProcessInfo:
; KQueryProcessInfo:
%EnterKernel(QueryProcessInfo, 8, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     sInfoRet
;			 pInfoRet
;			 pid

	sInfoRet			EQU 16
	infoRet_prio		EQU BYTE PTR [BP-sInfoRet]
	infoRet_deltaPrio	EQU BYTE PTR [BP-sInfoRet-1]
	infoRet_tid			EQU WORD PTR [BP-sInfoRet-2] ;PM support
	infoRet_pid			EQU WORD PTR [BP-sInfoRet-4]
	infoRet_sgTss		EQU WORD PTR [BP-sInfoRet-6]
	infoRet_iPid		EQU WORD PTR [BP-sInfoRet-8] ;PM support
	infoRet_cSuspends	EQU WORD PTR [BP-sInfoRet-10]
	infoRet_pidRoot		EQU WORD PTR [BP-sInfoRet-12]
	infoRet_pidNext		EQU WORD PTR [BP-sInfoRet-14]

	SUB 	SP, sInfoRet
	CLI
	MOV		BX, [BP+16]	;BX points to pcb, if 0 use pcbRun
	OR      BX, BX
	JNZ     PidTest
	MOV     BX, oPcbRun
	JMP		PidOk
PidTest:
	CALL	VerifyPid
	JNZ		QpiRet
PidOk:
	MOV		infoRet_pid, BX
	MOV		AX, BX
	SUB		AX, orgPcb
	MOV		CL, pcbSize
	DIV		CL
	MOV		infoRet_iPid, AX
	MOV     AL, [BX+pcbPriority]
	MOV		SI, [BX+pcboExPcb]			
	MOV		AH, [SI+exPcbDeltaPriority]
	SUB     AL, AH
	MOV		infoRet_prio, AL
	MOV     infoRet_deltaPrio, AH
	MOV		AX, [BX + sgTss]
	SUB		AX, 8
	MOV		infoRet_sgTss, AX
	MOV		ES, AX
	MOV		AX, ES:[rTss386Os2Tid]
	MOV		infoRet_tid, AX
	MOV     AL, [BX+pcbStatus]
	AND		AL, suspends
	SHR		AL, 1
	CBW
	MOV		infoRet_cSuspends, AX

; get pidRoot and pidNext
	PUSH    [BX+pcbUserNum]
	PUSH    [BX+pcbUserNum]
	PUSH	BX
	CALL    ONextUserPcb
	MOV     infoRet_pidNext, AX
	PUSH	0
	CALL    ONextUserPcb
	MOV     infoRet_pidRoot, AX
	
	LES     DI, DWORD PTR [BP+12]	;pInfoRet
	PUSH	DS
	PUSH	SS
	POP		DS
	LEA		SI, infoRet_prio		;start of inforet
	MOV		CX, sInfoRet
	CMP		CX, WORD PTR [BP+10]	;cbInfoRet
	JBE		QpiMove
	MOV		CX, WORD PTR [BP+10]
QpiMove:
	REPNZ	MOVSB
	POP		DS
	XOR		AX,AX 	
QpiRet:
	ADD     SP, sInfoRet
	MOV		DI, 8		; 4 arguments
	JMP		KernelExit



$MOD386
GKernelLockCritical PROC FAR
PUBLIC GKernelLockCritical
;*****************************************************************************
;	KernelLockCritical: PROCEDURE(pSem) ErcType
;       | saSem | 
;       | raSem | 
;       | CS    | 
;       | IP    | 
; NOTE that we do not user the EnterKernel macro!
; This procedure is optimized for speed; does not require stack switch.
;*****************************************************************************
	STR		BX					;BX has TSS of task that is running
	MOV		DI,SP
	LES		DI,DWORD PTR SS:[DI+4]
	PUSHF
; Critical section -- we must increment the count and
; lock the semaphore in one atomic operation.
	CLI
	BTS WORD PTR ES:[DI],0		;Test and set semaphore
	JC		SlPcbUserAlreadyLocked
; We have the semaphore
	MOV		ES:[DI+2],BX		;Save tss of new owner of semaphore
; Increment count of number of critical section semaphores owned by this user.
; get data alias for current TSS
	SUB		BX,8 
	MOV		ES,BX				;ES points to TSS
	INC		ES: WORD PTR [rTss386cCritSect]	
	POPF						;Enable
	XOR		AX,AX				;erc = ercOk
	RET		4					;Exit

SlPcbUserAlreadyLocked:
; ES:DI point to critical section semaphore
; Check to see if the caller is an interrupt handler.
	MOV		AX,DGroup
	MOV		GS,AX
	CMP		BX,GS:sgTssIntLast
	JBE		SlIntUserAlreadyLocked
; The client is NOT an interrupt handler.
; Check to see if the process that is running already owns the lock.  
	CMP		BX, ES:[DI+2]
	JE		SlUserOwnsLock
; Set high byte of first word of semaphore to indicate
; a process is waiting for this semaphore.
	MOV		BYTE PTR ES:[DI+1],1
; get data alias for current TSS
	SUB		BX,8 
	MOV		FS,BX				;FS points to TSS
; Save pointer to critical section semaphore in TSS and set the bit in
; the pcb that says this process is waiting for a critical section semaphore.
	MOV		FS:[rTss386pSem],DI
	MOV		FS:[rTss386pSem+2],ES
	MOV		BX,FS:[rTssoPcb]	;GS:BX points to pcb
	OR		BYTE PTR GS:[BX+pcbStatus],pcbfSem
	XOR		AX,AX				;AX = ercOK
	JMP		SemExit

SlUserOwnsLock:
; If the user already owns the lock, report an error.
; Critical section semaphores do not have a use count.
	POPF						;Enable
	MOV		AX,ercSemLocked
	RET		4					;Exit

SlIntUserAlreadyLocked:
; An interrupt handler can't wait for the semaphore, so return an erc.
	POPF
	MOV		AX,ercSemCannotWait
	RET		4					;Exit
GKernelLockCritical ENDP



GKernelClearCritical PROC FAR
PUBLIC GKernelClearCritical
;*****************************************************************************
;	GKernelClearCritical: PROCEDURE(pSem) ErcType
;       | saSem | +12
;       | raSem | +10
;       | CS    | +8
;       | IP    | +6
; NOTE that we do not user the EnterKernel macro!
; This procedure is optimized for speed; does not require stack switch
;	We decrement the critical section semaphore count, if the count is zero
;	we apply any pending suspends to the process. Then we dispatch the next 
;	process in the runq.
;*****************************************************************************
	MOV		BX,SP
	LES		DI,DWORD PTR SS:[BX+4]
; ES:DI point to critical section semaphore
	STR		BX					;BX has TSS of task that is running

; get data alias for current TSS
	SUB		BX,8 
	MOV		FS,BX				;FS points to TSS
	XOR  	AX,AX				;Assume erc = ercOK
	XOR		DX,DX
	PUSHF
; Critical section -- 
; We must unlock and decrement the count in one atomic operation.
	CLI
	XCHG	DX,ES:[DI]			;Clear semaphore
; DL should have low bit set if semaphore was locked.
; DH will be set if another task is waiting for semaphore.
; Decrement count of number of critical section semaphores owned by this user.
	DEC		WORD PTR FS:[rTss386cCritSect]
	JNZ		ScCheckOverflow
; The number of crtical section semaphores has gone to zero.
; Check to see if this user should be suspended.
	MOV		CL, FS: BYTE PTR [rTss386PendSuspend]
	OR		CL, CL				; bits 1..5 of pcb.Status
	JNZ		ScSuspend
ScCheckWaiting:
; Check to see if another process is waiting for this semaphore.
; If not, we return to the caller.
; If another process is waiting, we must dispatch because the waiting
; process could have a higher priority.
	OR		DH,DH
	JNZ		SemClearWaiting
	POPF						;Enable
	RET		4					;AX has erc 

SemClearWaiting:
; A process is waiting for this semaphore.
; AX has ercOK
; Check to see if the caller is an interrupt handler.
	MOV		CX,DGroup
	MOV		FS,CX
	CMP		BX,FS:sgTssIntLast
	JA		SemExit				;Not interrupt handler
; An interrupt handler is clearing the semaphore, and a process is waiting.
; Turn the process waiting bit back on.
	MOV		WORD PTR ES:[DI],100H
; We do not dispatch.  We always return.
	POPF
	RET		4

ScCheckOverflow:
; Count of semaphores has not yet gone to zero.  
; If count has not gone negative, return ercOK to caller
	JNS		ScCheckWaiting
	POPF
	MOV     AX, ercOverflow
	RET		4

ScSuspend:
	MOV		BX,FS:[rTssoPcb]	;BX points to pcb
	PUSH	DS					;Save process DS
	MOV		DI,DGroup
	MOV		DS,DI
	OR		BYTE PTR [BX+pcbStatus], CL
	CALL	UnlinkPcb			; remove from run queue
	POP		DS					;Restore process DS
SemExit:
; AX has erc
	POP		DX					;DX = user flags
	POP		DI					;DI = user IP
	POP		CX					;CX = user CS
	ADD		SP,4				;Clear 2 arg words
	PUSH	CX					;process return cs
	PUSH	DI					;process return ip
	PUSH	DX					;process flags
	MOV		BX,DS				;process DS
	MOV		CX,DGroup
	MOV		DS,CX
	MOV		DI, lIntRet	; no args & no stack to switch
	JMP		Disp

GKernelClearCritical ENDP


$MOD286

;*****************************************************************************
;	NewProcess(pProcessStruct, userNum, pPidRet) ErcType
;       | pProcessStruct | +16.
;       | userNum        | +14.
;       | pPidRet        | +10.
;       | CS             | +8
;       | IP             | +6
;       | flags          | +4
;       | BP             | +2
;       | DS             | <--BP
;*****************************************************************************

; GNewProcess: 
%EnterKernel(NewProcess, 10, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;			 pPidRet
;			 userNum
;			 pPdb

	cli
; load pProcessDescriptor	 into ES:SI		
	mov		ax, word ptr [bp+18]
; aliasing only required for real mode clients
	MOV 	DX, [bp+csRet]
	CMP 	DX, sgRealInterface
	JNE		np_Addressable
	call 	CreateIPCAlias
np_Addressable:
	mov		es, ax
	mov		si, word ptr [bp+16]

; Set bx to a pcb of the specified user.  In protected
; mode, a process is created by cloning off of an existing
; process, so that Ldts, page tables, mode can be inherited.
	mov		bx, oPcbRun
	mov		ax, [bp+14] ; argUserNum
	or		ax, ax
	jz		GotCloneProcess
	cmp 	ax, 1	;userNumPrimary may pass 1 as userNum arg
	jne		FindCloneProcess
	MOV		ax, userNumPrimary
FindCloneProcess:
	cmp		ax, word ptr [bx+pcbUserNum]
	je		GotCloneProcess
;
; Distrix is not currently supported in CTOS/VM, hence, do not
; allow a NewProcess unless the userNum is the caller.
;
; userNum is not caller so search pcbs
;	mov  cx, nPcb
;	mov  bx, orgPcb
;NewProcessLoop:
;	test byte ptr [bx+pcbStatus], pcbUsed
;	jz   NewProcessNextPcb
;	cmp  word ptr [bx+pcbUserNum], ax
;	je   GotCloneProcess	
;NewProcessNextPcb:
;	add  bx, pcbSize
;	loop NewProcessLoop
; if usernum not found, then return error
	mov	ax, 206 ; bad user num
	jmp	short ClearStack5ArgWords
GotCloneProcess:
	PUSH	ES
	PUSH  	SI
	PUSH	1		; new PDB, contains ax-dx, si, di
	CALL	CreateProc
	OR		AX,AX
	JNZ		ClearStack5ArgWords		; if erc not OK

; create alias for return pid			
	mov		ax, word ptr [bp+12]		
	call	CreateIpcAlias
	mov		es, ax
	mov		si, word ptr [bp+10]
	xor		ax, ax ; erc = ercOk
	MOV		ES:[SI], BX					; Return pid

ClearStack5ArgWords:
	MOV		DI, 10		; 5 arg words
	JMP		KernelRet


;*****************************************************************************
;	KillProcess: PROCEDURE(pid) [ErcType]
;       | pid   | +10.
;       | CS    | +8
;       | IP    | +6
;       | flags | +4
;       | BP    | +2
;       | DS    | <--BP
;
;	Complements CreateProcess--deletes the process specified by pid.
;	The process to be deleted must be that of the caller (pid = oPcbRun).
;	If this is the last process in the partition and the partition isn't
;	locked, cause the user to Exit (n.b. user can't Vacate self, and a useful
;	side effect of using Exit is to protect from the patholigical case of
;	userNumPrimary killing self).
;*****************************************************************************

; GKillProcess:
%EnterKernel(KillProcess, l1Argw, fStackSwitch, lNoHook) 
argPid		equ	10
	CLI

	mov		BX, [BP+argPid]					;BX points to pcb to kill
	call	VerifyPid
	jz		kpDoit
	jmp		KernelErrorExitDI				;AX=erc

kpDoIt:
; Verify pid is pcbRun and that we're not called by an interrupt handler
	cmp		BX, oPcbRun
	jne		kpNoCanDo
	str		AX
	cmp		AX, sgTssIntLast
	jbe		kpNoCanDo

; If this is the only extant process in the partition and the partition isn't
; locked (it is if process is fSys), then cause the user to exit.
	push	[BX+pcbUserNum]
	push	0
	call	ONextUserPcb
	push	[BX+pcbUserNum]
	push	AX
	call	ONextUserPcb
	jnz		kpKeepUser						;second pcb exists	
	and		DX, 3FFh
	mov		AX, sParDesc
	mul		DX
	add		AX, parDescfLocked
	mov		DI, oRgParDesc
	add		DI, AX
	test	byte ptr [DI], 1
	jnz		kpLoseSoftVecs

; Killing last process for user and partition not locked: exit
	push	[BP+4]
	popf									;enable maybe	
	push	0
	call	ErrorExit						;never returns

kpLoseSoftVecs:
	push	di 	; save exit code
; Killing last process for user and partition locked: lose softVecs
	push	[BP+4]
	popf									;enable maybe	
	push	BX								;save

	mov		DI, [BX+pcboExPcb]
	push	word ptr [DI+exPcboSoftVecHead]
	call	FreeSoftVec

	pop		BX								;restore
	pop		DI
	cli										;disable

kpKeepUser:
; N.B. we don't deallocate the response exchange--this preserves symmetry with
; CreateProcess (caller supplies exchSync), et al.

; Reset pcb to unused (ala Termination) and remove it from runQ
	call	UnlinkPcb						;hoses SI, DX
	push	DI
	push	BX
	call	DeallocPcb
	pop		DI
	xor		AX, AX
	jmp		KernelRet

kpNoCanDo:									;pid not pcbRun or isr calling
	mov		AX, ercNotImplemented
	jmp		KernelRet



;*****************************************************************************
;	RescheduleProcess: PROCEDURE(pid) ErcType
;
;	Puts pid ahead of all processes at the same priority except for caller.
;*****************************************************************************

; GRescheduleProcess:
%EnterKernel(RescheduleProcess, l1Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;			 pid
	PUSH 	DI		; save exitCode
	CLI

	MOV		BX, [BP+10]
	CALL	VerifyPid
	JNZ		RescheduleExit					;AX = erc
	CALL	UnlinkPcb
	JZ		RescheduleExit					;if Pcb was not in the run queue

; Search the runq until the priority of
; the pcb in the run queue is >= the priority of our pcb to be rescheduled AND
; pcb in the run queue <> oPcbRun. oPcbRun points to the pcb of the caller, 
; and we don't want to link our pcb ahead of the pcb of the caller.
	MOV		CL, [BX+pcbPriority]		;CL = priority of pcb to reschedule
	MOV		SI, OFFSET DGroup: runq					
NextPcb:
	MOV		DI, SI					;DI points to prev pcb
	MOV		SI, [SI] 					;SI points to next pcb in runq
	CMP		SI, oPcbRun
	JE		NextPcb					;if this pcb belongs to caller
	OR		SI, SI				
	JZ		RelinkPcb					;if last pcb in runq

	CMP		[SI+pcbPriority],CL			 
	JB		NextPcb
RelinkPcb:
	MOV		[BX], SI					;new pcb points to next pcb in runq
	MOV		[DI], BX					;prev pcb points to new pcb
RescheduleExit:
	POP		DI
	JMP		KernelRet					;dispatch


VerifyPid PROC NEAR
;*****************************************************************************
;	Make sure pid in BX is a valid, allocated Pcb.
;	Return with erc in AX and condition code set to zero if OK.
;	CX, DX hosed.
;*****************************************************************************
	XOR		DX, DX
	MOV		AX, BX
	SUB		AX, orgPcb
	MOV		CX, pcbSize
	DIV		CX					;DX:AX / CX -> AX=quotient, DX=remainder	

	OR		DX, DX
	JNZ		InvalidPid			;((pid-orgPcb) mod pcbSize) <> 0

	CMP		AX, nPcb
	JAE		InvalidPid			;((pid-orgPcb) div nPcb) >= nPcb

	TEST	byte ptr [BX+pcbStatus], pcbUsed
	JZ		InvalidPid			;valid, but unallocated

	XOR		AX,AX				; Set ercOk
	RET
InvalidPid:
	MOV		AX, ercInvalidPid
	OR		AX, AX
	RET
VerifyPid ENDP


;*****************************************************************************
;	erc=Fork(pChildStack);
;	Suspend caller, wake up Forking code (in process Sched).
;	If not VP OS return ercNotImplemented.
;*****************************************************************************

; GFork:
%EnterKernel(Fork, l2Argw, fNoSwitch, lNoHook) 
	MOV		AX, ercNotImplemented
	JMP		KernelExit


;*****************************************************************************
;	erc=ControlInterrupt(tyDev,bOp);
;	bOp
;		0	enable interrupt.
;		1	mask interrupt.
;		2	eoi, tyDev ignored.
;		3	enable interrupt and reset disable count.
;
;	NB: Similar code in FilterDeviceInterrupt and IntRet for speed reasons.
;	    Changes here may require changes in those places as well.
;*****************************************************************************

; GControlInterrupt:
%EnterKernel(ControlInterrupt, l2Argw, fNoSwitch, lNoHook) 
	CLI
	MOV		BX,[BP+tyDev]
	CMP		BX,tyDevMax
	JB		@checkMask
	JMP		BadtyDev
@checkMask:
	MOV		AX,12						;Index into table
	MUL		BL
	MOV		BX,AX
	MOV		AX,mptyDevMask[BX+intEnableAnd]
	OR		AX,mptyDevMask[BX+intDisableOr]
	JNZ		@tyDevOk					;Both And and Or can't be 0
	JMP		BadtyDev

@tyDevOk:
	CMP		BYTE PTR [BP+bOp],bOpEoi
	JE		CIEoi

	MOV		DX,mptyDevMask[BX+intPort]	;Read current interrupt mask value
	XOR		AH,AH
	IN		AL,DX		;Byte register

	MOV		SI,mptyDevMask[BX+intoCount]	;Offset of mask count
	CMP		BYTE PTR [BP+bOp],bOpEnableRst	;What kind of operation?
	 JE		CIEnableRst
	CMP		BYTE PTR [BP+bOp],bOpDisable
	 JE		CIDisable
	CMP		WORD PTR [SI],0			;Is mask count nonzero?
	 JE		CIEnable				;No, unmask interrupt, leave count as is
	DEC		WORD PTR [SI]
	 JNZ	CIExitOk				;Other user(s) still desire mask

CIEnable:
	AND		AX,mptyDevMask[BX+intEnableAnd]
	JMP		SHORT CIExit

CIEnableRst:
	MOV		WORD PTR [SI], 0
	AND		AX,mptyDevMask[BX+intEnableAnd]
	JMP		SHORT CIExit

CIDisable:
	INC		WORD PTR [SI]
	OR		AX,mptyDevMask[BX+intDisableOr]

CIExit:
	OUT	DX,AL		;Byte register

	MOV		SI,mptyDevMask[BX+intoMem]		; find mask memory copy
	OR		SI,SI
	 JZ		CIExitOk
	MOV		[SI],AX

CIExitOk:
	XOR		AX,AX
	JMP		KernelExit

BadtyDev:
	MOV		AX,ercBadtyDev
	JMP		KernelExit

CIEoi:
;	Clear the current highest priority device in-service interrupt.
	%DO_EOI
	JMP		CIExitOk


;*****************************************************************************
;	erc=DeviceInService(ptyDevRet);
;	Read the interrupt state, return the tyDev of current interrupt in service.
;	tyDevRet = 0 means no interrupt in service.
;*****************************************************************************

; GDeviceInService:
%EnterKernel(DeviceInService, l2Argw, fNoSwitch, lNoHook) 
	
	CLI
	STR		AX
	SUB		AX, 8
	MOV		ES, AX
	MOV		AX, ES:[rTss386tyDev]
	LES		BX, DWORD PTR [BP+pTyDevRet]
	MOV		ES:[BX], AX
	XOR		AX, AX
	JMP		KernelExit



;*****************************************************************************
;	ProcessControl: PROCEDURE(oPcb, wFlags) ercType
;	  wFlags bits:
;		0 - set=suspend, reset=resume
;		1 - set=pend suspend if in crit section, reset=unconditional suspend
;		2 - set=clear tssIdOnly
;	
;*****************************************************************************

; GProcessControl:
; KProcessControl:
%EnterKernel(ProcessControl, l2Argw, fNoSwitch, lNoHook) 
	CLI	
	MOV		BX, [BP+12]	;BX points to pcb, use pcbRun when 0
	OR      BX, BX
	JNZ     pc_PidTest
	MOV     BX, oPcbRun
	JMP		pc_PidOk
pc_PidTest:
	CALL	VerifyPid
	JNZ		pc_Ret
pc_PidOk:
	XOR		AX, AX					; ercOk
	MOV		DL, BYTE PTR [BP+10]
	MOV		DH, DL
	SHR		DH, 1					; fRespectCriticalSection
	TEST	DL, 1					; suspend/resume bit
	JNZ		pc_Suspend
	CALL	UnSuspendPcb
	JNE		pc_UnSuspendRet
	MOV		AX, ercOverFlow			; wasn't suspended 
pc_UnSuspendRet:
	TEST    BYTE PTR [BP+10], 4		; clear tssIdOnly?
	JNZ		pc_ResumeAndClear
pc_Ret:
	JMP		KernelRet

pc_Suspend:
	call	SuspendPcb
	JNZ		pc_Ret
	MOV		AX, ercOverFlow			; too many suspends
	JMP     pc_Ret


pc_ResumeAndClear:
	MOV		tssIdOnly, 0			

; if tss to be resumed is interrupt disabled then dispatch the tss 
; immediately, possibly ahead of runq, to preserve the critical section
	MOV     CX, [BX+sgTss]
	SUB     CX, 8
    MOV     ES, CX
	TEST    ES: WORD PTR [rTss386Flags], 200h
	JNZ		pc_Ret		; int-enabled, just return
	CMP		WORD PTR [BX], 0	; must be on runq, not suspended
	JZ		pc_Ret
; oPcbCriticalSection is dispatched before the runq
	MOV		oPcbCriticalSection, BX	

	JMP		KernelRet


;*****************************************************************************
;	SetKernelMode: PROCEDURE(userNum, wFlags) ercType
;	  wFlags bits:
;		0 - set = set tssIdOnly.  If userNum <> 0, then run only userNum 0 
;			and tssIdOnly.  If = 0, OK to run all users again.
;	
;*****************************************************************************

; GSetKernelMode:
%EnterKernel(SetKernelMode, l2Argw, fNoSwitch, lNoHook) 
	CLI
	MOV		AX, [BP+12]				;AX has userNum that is OK to run
	MOV		tssIdOnly,AX
	XOR		AX,AX					;erc = ercOK
	JMP		KernelExit




SuspendPcb		PROC	NEAR
;*****************************************************************************
; BX = pcb to suspend
; DH = fRespectCriticalSection
; return cc = (did suspend)
; assert: int disable, ds=dgroup
; corrupts DX, SI: NOT AX
;*****************************************************************************
	mov		DL, [BX+pcbStatus]
	and		DL, suspends
	cmp		DL, suspends
	jne		supNoOF
	ret										;ccE -> not suspended
supNoOF:
	TEST	DH, 1		; fRespectCriticalSection
	JZ		supPcb
; if the pcb is in a critical section semaphore, mark it so that when it
; releases the semaphore the suspend will be applied.
$MOD386
	MOV		SI, [BX+sgTss]
	SUB		SI, 8
	MOV		FS, SI
; Critical section -- we must test the count and set the suspend pending
; in one atomic operation
;	PUSHF	- ints already disabled
;	CLI
	CMP		FS: WORD PTR [rTss386cCritSect], 0
	JE		supNoCritSections
	ADD		FS: BYTE PTR [rTss386PendSuspend], aSuspend
;	POPF						;Enable
	JMP		supRet
supNoCritSections:
;	POPF						;Enable
$MOD286

supPcb:
%if (%suspendOffRunQ) then(%'
	test	byte ptr [BX+pcbStatus], suspends
	jnz		supSup
	test	byte ptr [BX+pcbStatus], ready
	jz		supSup
	call	UnlinkPcb						;ready->suspended: remove from runQ
supSup:
)fi%'
	add		byte ptr [BX+pcbStatus], aSuspend
supRet:
%IncInstrument(SuspendPcb)
	ret										;ccNE -> suspended
SuspendPcb		ENDP


UnSuspendPcb	PROC	NEAR
;*****************************************************************************
; BX = pcb to unsuspend
; DH = fRespectCriticalSection
; return cc = (did unsuspend)
; assert: int disable, ds=dgroup
; corrupts DX, SI, CL, FS: NOT AX
;*****************************************************************************
; if the pcb is in a critical section semaphore, apply the unsuspend to the
; pending count.
	TEST    DH, 1 	;fRespectCriticalSection
	JZ		usupPcb
	MOV		SI, [BX+sgTss]
	SUB		SI, 8
$MOD386
	MOV		FS, SI
; Critical section -- we must test the count and set the pending bit 
; in one atomic operation
;	PUSHF	- ints already disabled
;	CLI
	CMP		FS: WORD PTR [rTss386cCritSect], 0
	JE		usupNoCritSections
	CMP		FS: BYTE PTR [rTss386PendSuspend], 0
	JE		usupEnableRet	; treat overflow as below
	SUB		FS: BYTE PTR [rTss386PendSuspend], aSuspend
usupEnableRet:
;	POPF						;Enable
	JMP		usupRet
usupNoCritSections:
;	POPF						;Enable

$MOD286
usupPcb:
	mov		DL, [BX+pcbStatus]
	and		DL, suspends
	jnz		usupNoOF
	ret										;ccE -> not unsuspended
usupNoOF:
	sub		byte ptr [BX+pcbStatus], aSuspend
%if (%suspendOffRunQ) then(%'
	test	byte ptr [BX+pcbStatus], suspends
	jnz		usupNoLink
	test	byte ptr [BX+pcbStatus], ready
	jz		usupNoLink
	call	LinkPcb							;suspended->ready: add to runQ	
usupNoLink:
)fi%'
usupRet:
%IncInstrument(UnSuspendPcb)
	or		BX, BX							;set ccNE
	ret										;ccNE -> unsuspended
UnSuspendPcb	ENDP


;*****************************************************************************
;	[K]SuspendProcess:	procedure( pid )	[ercType]
;
;	Suspend the specified process.
;*****************************************************************************
; GSuspendProcess:
; KSuspendProcess:

%EnterKernel(SuspendProcess, l1Argw, fStackSwitch+fKCall, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     pid

argPid		EQU	10
	cli
	mov		BX,	[BP+argPid]
	test	DI, lSysEntry		; trusted caller
	jnz		spDoIt
	call	VerifyPid
	jnz		spRet

spDoIt:
	xor		AX, AX							;ercOk
	mov		DH, true						;fRespectCriticalSection
	call	SuspendPcb
	jne		spRet
	mov		AX, ercOverFlow					;too many suspends
spRet:
	jmp		KernelRet				



;*****************************************************************************
;	[K]UnSuspendProcess:	procedure( pid )	[ercType]
;
;	Un-Suspend the specified process.
;*****************************************************************************

; GUnSuspendProcess:
; KUnSuspendProcess doesn't crash if erc <> ercOk. 
KUnSuspendProcess:
PUBLIC KUnSuspendProcess

%EnterKernel(UnSuspendProcess, l1Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     pid

	cli
	mov		BX,	[BP+argPid]
	or		DI, DI
	jz		uspDoIt							;system entry
	call	VerifyPid
	jnz		uspRet							;AX=erc

uspDoIt:
	xor		AX, AX							;ercOk
	mov		DH, true						;fRespectCriticalSection
	call	UnSuspendPcb
	jne		uspRet
	mov		AX, ercOverFlow					;wasn't suspended
uspRet:
	jmp		KernelRet				


;*****************************************************************************
;	[K]SuspendUser:	procedure( userNum )	[ercType]
;
;	Suspend all processes of the designated user.
;	userNum=0 -> self, userNum=1 -> userNumPrimary.
;   userNum=0ffffh -> self except calling thread (support for
;		OS/2 DosEnterCritSec)
;*****************************************************************************
; GSuspendUser:
; KSuspendUser:

%EnterKernel(SuspendUser, l1Argw, fStackSwitch + fKCall, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     userNum

argUserNum	EQU	10

	cli
	mov		SI,	[BP+argUserNum]
	cmp		SI, 0ffffh
	je     	suMe
	cmp		SI, 1
	ja		suGUN
	jb		suMe
	mov		SI, userNumPrimary
	jmp		suGUN
suMe:
	mov		SI, oPcbRun
	mov		SI, [SI+pcbUserNum]
suGUN:
	;no further checking--either pcb found or not

;	mov		CX, 0FFFFh						;cPcbSuspended-1
	xor		BX, BX							;prime the ONextUserPcb pump
	cli										;disable

suLoop:
	push	SI								;userNum
	push	BX								;oPrevPcb
	call	ONextUserPcb
	jz		suDone							;ZF->AX=0
	mov		BX, AX
	cmp		word ptr [BP+argUserNum], 0ffffh;if userNum = 0ffffh then
	jne     suDoIt							;	don't suspend caller
	cmp     bx, oPcbRun						;
	jne 	suDoIt
	jmp		short suLoop
suDoIt:
;	inc		CX								;found one
	mov		DH, true						;fRespectCriticalSection
	call	SuspendPcb
	jmp		short suLoop

suDone:
;	inc		CX
;	jz		suNotFound						;ercOk even if no pcbs found

	jmp		KernelRet

;suNotFound:								;bad userNum, vacant par, data par
;	mov		AX, ercNoPcb					;no process found to suspend
;	jmp		KernelRet


;*****************************************************************************
;	[K]UnSuspendUser:	procedure( userNum )	[ercType]
;
;	Un-Suspend all processes of the designated user.
;	userNum=0 -> self(?!), userNum=1 -> userNumPrimary.
;   userNum=0ffffh -> self except calling thread (support for
;		OS/2 DosEnterCritSec)
;*****************************************************************************
; GUnSuspendUser:
; KUnSuspendUser doesn't crash if erc <> ercOk. 
KUnSuspendUser:
PUBLIC KUnSuspendUser

%EnterKernel(UnSuspendUser, l1Argw, fStackSwitch, lNoHook) 
; DS = OS Dgroup
; DI = exit code
; ints enabled 
; SS:SP,BP-> DS
;		  	 BP
;			 FL
;		     userNum

	cli
	mov		SI,	[BP+argUserNum]
    cmp		SI, 0ffffh
	je		usuMe
	cmp		SI, 1
	ja		usuGUN
	jb		usuMe
	mov		SI, userNumPrimary
	jmp		usuGUN
usuMe:
	mov		SI, oPcbRun
	mov		SI, [SI+pcbUserNum]
usuGUN:
	;no further checking--either pcb found or not

;	mov		CX, 0FFFFh						;cPcbUnSuspended-1
	xor		BX, BX							;prime the ONextUserPcb pump
	cli										;disable

usuLoop:
	push	SI								;userNum
	push	BX								;oPrevPcb
	call	ONextUserPcb
	jz		usuDone							;ZF->AX=0
	mov		BX, AX
	cmp		word ptr [BP+argUserNum], 0ffffh;if userNum = 0ffffh then
	jne     usuDoIt							;	don't unsuspend caller
	cmp     bx, oPcbRun						;
	jne 	usuDoIt
	jmp		short usuLoop
usuDoIt:
;	inc		CX								;found one
;	push	CX								;save
	mov		DH, true						;fRespectCriticalSection
	call	UnSuspendPcb
;	pop		CX
	jmp		short usuLoop					;did unsuspend

usuDone:
;	inc		CX
;	jz		usuNotFound						;ercOk even if no pcbs found
	jmp		KernelRet

;usuNotFound:								;bad userNum, vacant par, data par
;	mov		AX, ercNoPcb					;no process found to unsuspend
;	jmp		KernelRet


;
; ***************  DEALIASING CODE ******************
;

OPcbFromUserNum proc near

; on entry, BX is usernum, DS is OS DGroup
; on exit,  DI is oPcb

	push	ax					;save
	push	bx					;userNum
	push	0					;prime the pump
	call	ONextUserPcb		;hoses ax, not bx 	
	jz		OPcbFromUserNumCrash;ZF->AX=0 (empty list)
	mov		di, ax				;oUserPcbHead
	pop		ax					;restore
	ret

OPcbFromUserNumCrash:
; if usernum not found, then crash(ercInconsistency)
	push ercInconsistency
	call Crash

OPcbFromUserNum endp

DealiasToLdt proc near
;
; Converts a IPC alias selector into a ldt selector.
;
; Can be called indirectly from ProcessRequestBlock (does not
; depend on BP being the kernel frame bp).
;
; On entry, AX is sg to dealias, DI is oPcb
; DS is OS DGroup.
;
; On exit, AX is returned sa.
;
; NO registers are corrupted.
;
; Algorithm:
;
;	if sg = 0 then return sg;
;	sl = rgGdtLink(iSg).sa
;	if sl = 0 then return sg;
;   if pSeries and mpSlSg(iSl) = sg then
;		return sl
;   else if vSeries and rgGdtLink(iSg).userNum = pcb.userNum then
;		return sl
;	else
;		return sg		

	or ax, ax
	jnz DoDealiasToLdt
	ret
DoDealiasToLdt:
	push es
	push bx
	push si
	push cx
	push dx
	pushf
	cli		; begin critical region

	mov		cx, word ptr [pRgoGdtLink+2]
	mov		es, cx
	mov		bx, ax ; bx,ax = sg
	and		bx, maskSelector ; optimized iSg*sGdtLink
; ax = sg, bx = .rgGdtLink(iSg)
	mov		cx, es:[bx+rGdtLinkSa] ; cx = rgGdtLink(iSg).sa
	jcxz	DoneDealiasToLdt

; gdtLinkUserNum is a local userNum, does not contain slot bits
	mov		si, word ptr [di+pcbusernum]
	and		si, maskSlot
	cmp		si, es:[bx+rGdtLinkUserNum]

	jne		DoneDealiasToLdt
	mov		ax, cx ; sg = sl
	or		ax, 4
DoneDealiasToLdt:
	popf		; end critical region
	pop dx
	pop cx
	pop si
	pop bx
	pop es
	ret
DealiasToLdt endp


public FarDealiasToSr
FarDealiasToSr proc far
;
; Converts an IPC alias selector into a real mode sr and deallocates
; the selector if the reference count becomes zero.
;
; Called by real interface code after return from a system common
; subroutine to deallocate IPC selectors.
;
; On entry, AX is sg to dealias.
;
; On exit, AX is returned sr.
;
; AX, BX registers corrupted.

	push ds
	push di
	mov bx, DGroup
	mov ds, bx
	mov di, oPcbRun
	call DealiasToSr
	pop di
	pop ds
	ret
FarDealiasToSr endp

public DealiasToSr

DealiasToSr proc near
;
; Converts an IPC alias selector into a real mode sr and deallocates
; the selector if the reference count becomes zero.
;
; Can be called indirectly from ProcessRequestBlock (does not
; depend on BP being the kernel frame bp).
;
; On entry, AX is sg to dealias, DI is the real mode pcb,
; DS is OS DGroup.
;
; On exit, AX is returned sa.
;
; NO registers are corrupted.

; guard against dealiasing OS DGroup, which gets put in
; request block in case of bogus AddQueueEntry pDateTime pointer
	cmp		ax, DGroup
	jne		NotDGroup
	ret
NotDGroup:
	push	bx
	mov 	bx, word ptr [di+pcbUserNum]
	jmp		short CheckNullDealias

DealiasToSrBxUser:
	push	bx

CheckNullDealias:
	or		ax, ax
	jnz		DoDealias
	pop		bx
	ret

; traverse gdt links until selector is found
DoDealias:
	push	es
	push	cx
	push	dx
	push	si
	pushf
	cli ; ********** begin critical region **********

	shr		ax, 3 ; iSg = shr(sg,3)

    AND     BX, maskSlot
	shl		bx, 1
	add		bx, orgIpcAliasHead
	mov		bx,[bx]
	
	mov		cx, word ptr [pRgoGdtLink+2]
	mov		es, cx
	mov		cx, ax ; cx = iSg
FindDealias:
	cmp		cx, bx
	je		FoundDealias

	mov		ax, bx ; ax, bx = iSg
	mov		dx, sGdtLink
	mul		dx     ; ax = .rgGdtLink(iSgNext)
	mov		si, ax ; si = .rgGdtLink(iPrev) for selector deallocation
	mov		bx, word ptr es:[si] ; bx = rgGdtLink(iSgNext).link
	or		bx, bx
	jnz		FindDealias

	push	ercInconsistency
	call	Crash

FoundDealias:
	mov		ax, bx
	mov		dx, sGdtLink
	mul		dx
	mov		bx, ax
	mov		ax, word ptr es:[bx+2]
;decrement cReference (if not 0FFh)
	cmp		byte ptr es:[bx+rGdtLinkCRef], 0FFh
	je		DealiasRet
	dec		byte ptr es:[bx+rGdtLinkCRef]
; if cReference = 0 then deallocate selector
	jnz		DealiasRet
; ax = srRet, cx = iSg
; remove selector from GdtLinks, rgGdtLink(iPrev).link = rgGdtLink(iSg).link
	mov		bx, word ptr es:[bx]
	mov		word ptr es:[si], bx
; thread selector back on free list
	push	ax
	shl		cx, 3
	push	cx
	call	ThreadSg
	pop		ax
DealiasRet:
	popf ; ************* end critical region ***********
	pop		si
	pop		dx
	pop		cx
	pop		es
	pop		bx
	ret

DealiasToSr endp
;
; ***************  ALIASING CODE ******************
;
public FarAliasIpcSlUser

FarAliasIpcSlUser proc far
; procedure (sl, userNum)
; 
; sl is a valid ldt selector.
;
; Do IPC aliasing for LDT selector.
;
	push bp
	mov bp, sp
	mov bx, word ptr [bp+6]
	call OPcbFromUserNum
	mov bx, di ; oPcb
	mov si, word ptr [bp+8] ; ldt selector
	call FarAliasIpcSlLocal
	pop  bp
	ret 4

$MOD386
FarAliasIpcSlLocal:
	push si
	push es
	push ebx
	jmp CommonLdtAlias
$MOD286
FarAliasIpcSlUser endp

public AliasIpcSl

AliasIpcSl proc near
; Aliasing procedure when pointer contains a selector
;
; Can be called indirectly from ProcessRequestBlock (does not
; depend on BP being the kernel frame bp).

	or	ax, ax
	jz	EarlyRet
	push si
	jmp CheckLdtAlias
AliasIpcSl endp

public FarAliasIpcSr

FarAliasIpcSr proc far
	call AliasIpcSr
	ret
FarAliasIpcSr endp

public AliasIpcSr

AliasIpcSr proc near
; Aliasing procedure when pointer contains a real mode sr.
; oPcbRun will own the alias.
;
; Can be called indirectly from ProcessRequestBlock (does not
; depend on BP being the kernel frame bp).

	or	ax, ax
	jz	EarlyRet
	push si
	jmp DoRealAlias
AliasIpcSr endp

AliasIpcSrPcb proc near
; Aliasing procedure when pointer contains a real mode sr.
; BX contains oPcb that will own the alias.
;
; Can be called indirectly from ProcessRequestBlock (does not
; depend on BP being the kernel frame bp).

	or	ax, ax
	jz	EarlyRet
	push si
	push es
	push bx
	push cx
	mov si, bx
	jmp DoRealAliasPcb
AliasIpcSrPcb endp

public CreateIPCAliasBxUser
CreateIpcAliasBxUser proc near
;
; Special aliasing entry point that works from mediated interrupt handlers
;
; On entry, BX is the usernum, AX is the segment address to alias.
; Assume DS is OS DGroup.
; 
; First, find oPcb for this user.
;
	push di
	push si
	push bx

	call OPcbFromUserNum

; dirty laundry - during exitList processing real mode users have a protected 
; mode thread, the exitlist thread, which if present is first in the 
; OPcbUserNum list. We don't want to use that one as a clue for aliasing! The 
; hack below is to always try the next pcb to determine the mode. 	
	push  ax 	; save sa
	push  bx
	push  di	
	call  ONextUserPcb
	jz	  SingleThread		; no other threads
	mov   di, ax
SingleThread:
	pop   ax	; restore sa
; end dirty laundry.


; di is oPcb, ax is segment address to alias, bx is userNum.
; if real mode, call AliasIpcSrPcb
; else if ldt, call FarAliasIpcSlLocal
; else if gdt, do nothing.

	test word ptr [di+SpSave], maskRealMode
	jz CreateIpcAliasBxUserNotReal
	mov bx, di
	call AliasIpcSrPcb
	jmp short CreateIpcAliasBxUserExit

CreateIpcAliasBxUserNotReal:
	test ax, maskLdt
	jz CreateIpcAliasBxUserExit
	mov  bx, di
	mov  si, ax
	call FarAliasIpcSlLocal

CreateIpcAliasBxUserExit:
	pop bx
	pop si
	pop di
	ret

CreateIpcAliasBxUser endp


public CreateIPCAlias
CreateIPCAlias proc near
;
; Creates an alias in the GDT for an LDT selector or
; real mode sa, depending onthe mode of the user.
;
; On entry, ax is selector to alias, DS is OS DGroup.
;
; BP is bp of kernel frame. THIS PROCEDURE CANNOT BE CALLED
; INDIRECTLY FROM ProcessRequestBlock because ProcessRequestBlock
; uses a local bp.  Use of kernel frame bp follows CheckRealAlias.
;
; If the selector is already in the GDT, returns the selector in 
; ax.  Otherwise, returns the GDT alias in ax.
;
; NO registers are corrupted.

assume ds:dGroup
; no aliasing for sa=0
	or   ax, ax
	jz   EarlyRet
	push si

; no aliasing for interrupt handlers (no user num available)
	str  si
	cmp  si, sgTssIntLast
	ja   CheckRealAlias
	pop  si
EarlyRet:
	ret

CheckRealAlias:
	mov si, [bp+csRet]
	cmp si, sgRealInterface
	je DoRealAlias
	jmp CheckLdtAlias

DoRealAlias:
; ax is a real mode sa
; BP is unknown at this point (several entry points to this label)	
	push es
	push bx
	push cx

$MOD386
	mov si, oPcbRun
DoRealAliasPcb:
	mov bx, word ptr [si+pcbUserNum]
    AND BX, maskSlot
	shl bx, 1
	mov si,orgIpcAliasHead
	mov si, [si][bx]
	pushf
	push ds
	push dx
	push ecx 
	xor  ecx, ecx
	push bx   ; save shifted user num
	mov cx, ax
 ; cx is real mode sa

;*** begin critical region
	cli	

; let ds address gdt links
; - si is the iSg of the first link
; - gdt link is
;      link word (an iSg)
;      sa   word
;      cReference byte
;      userNum word (v series only)

	mov bx, word ptr [pRgoGdtLink+2]
	mov ds, bx
NextRealAlias:
	mov ax, si ; si = iSgNext
	shl ax, 3
	mov bx, ax ; bx = .rgGdtLink(iSgNext)

	cmp [bx+2], cx
	jne TryNextRealAlias
; found alias, increment cReference, max at 0FFh
	inc byte ptr [bx+4]
	jne JmpFoundRealAlias
	dec byte ptr [bx+4] ; 0FFh case
JmpFoundRealAlias:
	pop bx  ; discard saved shifted user num
	pop ecx ; restore 32-bit register
	mov bx, si
	shl bx, 3 ; sg = shl(iSgNext,3)
	jmp FoundRealAlias

TryNextRealAlias:
	mov si, [bx] ; iSgNext = rgGdtLink(iSgNext).link
	cmp si, 0
	jne NextRealAlias

; end of thread and alias not found - allocate a new alias
	mov si, bx ; save tail of thread
	push cx    ; save real mode sa

	push ds
	mov cx, DGroup
	mov ds, cx
	call UnThreadSg ; returns sg in ax, corrupts es,bx
	pop ds

	mov bx, ax   ; ax = sgNew
	shr bx,3     ; bx = iSgNew
	mov [si], bx ; add link to end
	xchg ax, bx  ; ax = iSgNew, bx = sgNew
	shl ax, 3
	mov si, ax   ; si = .rgGdtLink(iSgNew)
	xor cx, cx
	mov [si], cx           ; rgGdtLink(iSgNew).link = 0
	pop cx   ; real mode sa
	mov [si+rGdtLinkSa], cx         ; rgGdtLink(iSgNew).sa = saReal
	mov byte ptr [si+rGdtLinkCRef], 1 ; rgGdtLink(iSgNew).cReference = 1

	pop ax ; shifted user num
	push ax ; will need later
	shr ax, 1
; gdtLinkUserNum is a local userNum, does not contain slot bits
	and ax, maskSlot
	mov word ptr [si+rGdtLinkUserNum], ax

; bx is .gdt(isgNew)
; cx is the real mode sa
BuildRealAliasDescriptor:
	mov ax, sgGdt
	mov es, ax
; address the user's asib
	mov ax, Dgroup
	mov ds, ax
	pop si    ; saved shifted user num
	mov ax, rgSgAsib [si]
	mov ds, ax
	push ds

; The real mode reference must be translated to a global linear
; address.  V86 addresses are organized as hypersegments.
;
;         OS identity space (up to plaMemMin)
;         U structure
;         LL/hole/SL
;         video character map
;
;  Each hypersegment is aliased to a different span of global linear
;  addresses.  The task is to find the right hypersegment and its gla.
;  The algorithm interates through the hypersegments and checks bounds.
;  If a hypersegment is not located, have the alias point to
;  the beginning of SL so that a server will not GP fault.

	mov si, lrLLAsib			; check partition memory
	mov dx, [oAsibCParMax]
	jmp short BuildRealAliasCheckPdhHaveCPar

BuildRealAliasCheckPdh:
	mov dx, PdhCPar				; (dx is pdh.cPar) 
BuildRealAliasCheckPdhHaveCPar:
	cmp cx, PdhPlaV86			; if sa >=pdh.plaV86 then
	jb BuildRealAliasNextPdh	; (else not this pdh)
	mov ax, cx					;    (ax is rSa)
	sub ax, PdhPlaV86			;    rSa = sa - pdh.plaV86
	cmp ax, dx					;    if rSa > pdh.cPar then
	ja BuildRealAliasNextPdh	;       not this pdh
								;    else
	sub dx, ax					;       limit = pdh.cPar - rSa
	mov cx, ax
	add ecx, PdhPla				;       gla = pdh.pla + rSa
	jmp short BuildRealAliasInitDescriptor

BuildRealAliasNextPdh:
	cmp si, lrLLAsib
	jne @@U
	mov si, lrUserAsib					; check user second
	jmp short BuildRealAliasCheckPdh
@@U:
	cmp si, lrUserAsib
	jne @@Identity
	mov si, offset IdentityPdh			; check identity third
	mov ax, DGroup
	mov ds, ax
	jmp short BuildRealAliasCheckPdh
@@Identity:	
	cmp si, offset IdentityPdh
	jne BuildRealAliasBogusSa
	mov si, offset VideoPdh				; check video last
	jmp short BuildRealAliasCheckPdh

BuildRealAliasBogusSa:
; point to partition memory and let user clobber himself - this
; is done so that a server will not GP fault.
	pop ds			; sgAsib
	mov si, lrLLAsib
	mov ecx, pdhPla
	mov dx,  pdhCPar
	jmp short BuildRealAliasInitDescriptorAfterPop

BuildRealAliasInitDescriptor:
	pop ax			; discard sgAsib
BuildRealAliasInitDescriptorAfterPop:
	shl ecx, 4
	mov Desc386_base, ecx
	mov Desc286_access, 92h ; writable data
	shr ecx, 16
	xor cl, cl
	mov Desc386_baseLimitMsb, cx
	cmp dx, 1000h
	jb BuildRealAliasComputeLimit
	mov dx, 0FFFFh
	jmp short BuildRealAliasSetLimit
BuildRealAliasComputeLimit:
	shl dx, 4
	dec dx
BuildRealAliasSetLimit:
	mov Desc286_limit, dx

	pop ecx  ; restore 32-bit register

FoundRealAlias:
	mov ax, bx
	pop dx
	pop ds
	jmp FoundAlias

CheckLdtAlias:
; BP is unknown at this point (several entry points to this label)	
	mov si, ax
	test si, maskLdt
	jnz DoLdtAlias
	jmp CreateIPCAliasRet
DoLdtAlias:
	push es
	push ebx
	mov bx, oPcbRun
CommonLdtAlias:
	push ecx
	and si, 0FFF8h
	mov ax, word ptr [bx+spSave] ; sgLdt
	and ax, 0FFF8h

; in v series, ldt aliases are maintained in gdtLinks
;
	push di
	push ax ; sgLdt

; cx = next gdt alias
	mov di, word ptr [bx+pcbUserNum]
	push di ; userNum
    AND di, maskSlot
	shl di, 1
	add di,orgIpcAliasHead		; di = .rgIpcAliasHead(userNum)

	mov bx, word ptr [pRgoGdtLink+2]
	mov es, bx

; ax - available
; bx - was oPcb, will be used to address gdtLinks
; cx - isgAliasNext
; dx - reserved
; si - ldt selector
; di - .rgIpcAliasHead(userNum)
; ds - OS DGroup
; es - sgGdtLink

; - gdt link is
;      link word (an sg)
;      sa   word
;      cReference byte - not used for ldt aliases
;      userNum   word

; *** begin critical region 1
	pushf
	cli
	mov cx, [di]	;rgIpcAliasHead

CommonLdtAliasSearch:
	jcxz CommonLdtNewAlias
	mov bx, cx  ; bx = .rgoGdtLinks(iSg) 
	shl bx, 3  ; optimized iSg*sGdtLink
	cmp si, word ptr es:[bx+rGdtLinkSa]
	je CommonLdtFoundAlias
	mov cx, word ptr es:[bx]
	jmp short CommonLdtAliasSearch

CommonLdtNewAlias:
	popf
; *** end critical region 1
	push es ; sgGdtLinks
	call UnThreadSg          ; returns sg in ax, corrupts es,bx
	pop es  ; sgGdtLinks
	mov bx, ax ; optimized iSg*sGdtLink
	and bx, maskSelector
	shr ax, 3

	mov es:[bx+rGdtLinkSa], si ; gdtLinks(iSg).sa = ldt selector
	xor cx, cx
	mov es:[bx+rGdtLinkOPdh], cx
	pop cx ; userNum
; gdtLinkUserNum is a local userNum, does not contain slot bits
	and cx, maskSlot
	mov es:[bx+rGdtLinkUserNum], cx 

; *** begin critical region 2
	pushf
	cli
	mov cx, [di]	;rgIpcAliasHead
	mov es:[bx], cx   ; gdtLinks(iSg).link = rgIpcAliashead(userNum)
	mov [di], ax ; rgIpcAliasHead(userNum) = new alias
	popf
; *** end critical region 2
	shl ax, 3

; copy ldt descriptor to gdt descriptor
CommonCopyAliasDesc:
	pop es ;sgLdt
	pushf
	cli
	mov ebx, es:[si]
	mov ecx, es:[si+4]
	mov si, sgGdt
	mov es, si
	mov si, ax
	mov es:[si], ebx
	mov es:[si+4], ecx
	popf 
	jmp short CommonLdtAliasExit

CommonLdtFoundAlias:
	popf
; *** end critical region 1
	mov ax, cx
	shl ax, 3
	pop cx  ; userNum - discard
	jmp short CommonCopyAliasDesc  ;!!! Hack for SDK - causes the LDT descriptor
                                   ; to be copied to the GDT on every alias
	pop cx  ; sgLdt - discard

CommonLdtAliasExit:
	pop di
	pop ecx
	pop ebx
	pop es
	pop si
	ret

FoundAlias:
	popf
;*** end critical region
	pop cx
	pop bx
	pop es

CreateIPCAliasRet:
	pop si
	ret

CreateIPCAlias endp

$MOD286

FreeRqResources PROC NEAR
;*****************************************************************************
; free spec expansion heap and unlock request block and pbcb pages
; on entry, es:bx addresses request block
; preserves es, bx, di
;*****************************************************************************
	MOV  	AX, WORD PTR ES:[BX+rqUserNum]
%IF (%Icc) THEN (
	MOV		SI, ES: [BX+respExch]
	AND		SI, maskiExch
	XOR		AX, wMySlotBits
	TEST	AX, maskUserNum
	JNZ  	SpecsFreed
)FI
	CMP  	AX, userNumLast
	JAE  	SpecsFreed
	CALL	FreeRqSpecs
SpecsFreed:
; For paging, call UnlockRqPages to unlock the pages referenced by this request

	push	es
	push	bx
	push	di
	push	es			;saRq
	push	bx			;raRq
	call	SC_UnlockRqPages
	pop		di
	pop		bx
	pop		es
FreeRqResourcesRet:
	ret
FreeRqResources ENDP


UnlinkPcb PROC NEAR
;*****************************************************************************
;	BX points to Pcb to find and unlink
;	On return, condition code = 0 if Pcb was not in run queue
;*****************************************************************************
	MOV		SI, OFFSET DGroup: runq						;SI points to runq
FindPcb:
	CMP		[SI], BX					;Does SI point to pcb?
	JZ		FoundPcbToUnlink			;Yes, go dequeue pcb
	MOV		SI, [SI]					;No, SI points to the next pcb
	OR		SI,SI
	JNZ		FindPcb	
	RET							;Return if Pcb not in run queue
FoundPcbToUnlink:
; If the Pcb is in the run queue, remove it from the run queue.
	XOR		DX,DX
	XCHG	DX,[BX]					;pcb.oPcblnk = 0
									;DX = pcb.oPcblnk
	MOV		[SI], DX				;Move pcb.oPcblnk to prev.oPcblnk
	OR		SI,SI					;Set condition code -- Pcb found and unlinked
	RET
UnlinkPcb ENDP



;*****************************************************************************
;	SetDispMsw287 PROCEDURE(msw) ErcType
;       | msw   | +10.
;       | CS    | +8
;       | IP    | +6
;       | flags | +4
;       | BP    | +2
;       | DS    | <--BP
;*****************************************************************************

; GSetDispMsw287:
; KSetDispMsw287:
%EnterKernel(SetDispMsw287, l1Argw, fNoSwitch, lNoHook) 

	CLI
	MOV		AX, WORD PTR [BP+10]
	and		ax, 0FFFEh ; do not allow setting of PE
	MOV		wMsw287, AX
	XOR		AX, AX                  ; return ercOK
	JMP		KernelRet




%IF(%Tracker) THEN (

;*****************************************************************************
;
;                             Rq Tracker Code         
;
;*****************************************************************************

loArgMsgType	EQU	10
loArgUserNum	EQU	8
loArgSaMsg		EQU	6
loArgRaMsg		EQU	4

ASSUME	DS:	DGroup
ASSUME	ES:	Nothing

RqTrackerAddMsg		PROC	NEAR
;
; Allocates a msgWait and adds a request to exchRqTracker.
; Assert: int disabled, ds=dgroup
; NO Registers are corrupted.
;
	PUSH	BP
	MOV		BP, SP
	PUSH	AX
	PUSH	BX
	PUSH	SI
	PUSH	ES

	TEST	WORD PTR [BP+loArgMsgType], lMsgWait
	JNZ		RqTrackerAddMsgAlt

;set up userNum for msgWait as if there had not been a task waiting
	XOR		AX, AX
	STR		BX
	CMP		BX, sgTssIntLast
	JBE		RqTrackerAddMsgUserNum
	MOV		BX, oPcbRun
	MOV		AX, [BX+pcbUserNum]

RqTrackerAddMsgUserNum:
	MOV		[BP+loArgUserNum], AX

;flag msgAlt if appropriate
RqTrackerAddMsgAlt:
	LES		BX, DWORD PTR [BP+loArgRaMsg]
	MOV		AX, [BP+loArgUserNum]
	CMP		AX, ES:[BX+rqUserNum]
	JE		RqTrackerAddMsgWait
	OR		WORD PTR [BP+loArgMsgType], lMsgAlt

;get a msgWait
RqTrackerAddMsgWait:
	MOV		BX, msgWaitFree			;oMsgWait = msgWaitFree
	OR		BX, BX
	JZ		RqTrackerAddMsgExit		;aw, shucks
	XOR		AX, AX
	XCHG	AX, [BX]				;msgWait.oMsgNxt = 0
	MOV		msgWaitFree, AX			;msgWaitFree = msgWait.oMsgNxt

;fill in Rq info
	MOV		AX, [BP+loArgRaMsg]		;msgWait.pMsgUsr = pMsg
	MOV		[BX+loMsgRaMsg], AX
	MOV		AX, [BP+loArgSaMsg]
	MOV		[BX+loMsgSaMsg], AX
	MOV		AX, [BP+loArgUserNum]	;msgWait.userNum = userNum
	MOV		[BX+loMsgUserNum], AX
	MOV		AX, [BP+loArgMsgType]	;msgWait.wStatus = msgType
	MOV		[BX+loMsgWStatus], AX

;push onto exchRqTracker (push-down list--exch.oMsgTail=0 always)
	MOV		SI, oExchRqTracker
	MOV		AX, BX
	XCHG	AX, [SI]				;exch.oMsgHead = oMsgWait
	MOV		[BX], AX				;msgWait.oMsgNxt = oMsgHead

RqTrackerAddMsgExit:
	POP		ES
	POP		SI
	POP		BX
	POP		AX
	POP		BP
	RET		8
RqTrackerAddMsg		ENDP


RqTrackerRemoveMsg	PROC	NEAR
;
; Finds matching request on exchRqTracker and removes it.
; Assert: int disabled, ds=dgroup
; NO Registers are corrupted.
;
	PUSH	BP
	MOV		BP, SP
	PUSH	BX
	PUSH	AX
	PUSH	CX
	PUSH	SI

	MOV		AX, [BP+loArgRaMsg]			;CX:AX = pMsg
	MOV		CX, [BP+loArgSaMsg]
	MOV		SI, oExchRqTracker
	MOV		BX, [SI]					;oMsgWait = exch.oMsgHead
RqTrackerRemoveMsgTest:
	CMP		BX, 0
	JZ		RqTrackerRemoveMsgExit		;end of list
	CMP		AX, [BX+loMsgRaMsg]
	JNE		RqTrackerRemoveMsgNext
	CMP		CX, [BX+loMsgSaMsg]
	JE		RqTrackerRemoveMsgHit
RqTrackerRemoveMsgNext:
	MOV		SI, BX						;oMsgPrev = oMsgWait
	MOV		BX, [BX]					;oMsgWait = msg.oMsgNxt
	JMP		RqTrackerRemoveMsgTest

RqTrackerRemoveMsgHit:	
	MOV		AX, [BX]
	MOV		[SI], AX					;msgPrev.oMsgNxt = msg.oMsgNxt
	MOV		AX, msgWaitFree
	MOV		[BX], AX					;msg.oMsgNxt = msgWaitFree
	MOV		msgWaitFree, BX				;msgWaitFree = oMsg

RqTrackerRemoveMsgExit:
	POP		SI
	POP		CX
	POP		AX
	POP		BX
	POP		BP
	RET		4
RqTrackerRemoveMsg	ENDP

)FI

PUBLIC WakeupSched
WakeupSched PROC FAR
	XOR 	AX, AX
	RET
WakeupSched ENDP


%if (%instrument) then(%'

Instrumentalist proc near
;
; kiCounter bumper & kiBuf tracer
;
; No registers corrupted
;
argOKiCounter	EQU	4
sArgs			EQU	2

	push	BP
	mov		BP, SP
	pushf
	push	AX
	push	BX
	push	CX
	push	SI
	push	DS
	mov		BX, kiSeg
	mov		DS, BX
assume DS: kiSeg
assume ES: Nothing

	lea		BX, kiCounters
	add		BX, [BP+argOKiCounter]
	inc		word ptr [BX]

%if (%instrumentTrace) then(%'
	test	vfKiTrace, 0FFh
	jz		KiTraceDisabled

;record sequence number and kiCounters offset
	mov		BX, oKiBuf
	inc		kiBufSeq
	mov		AL, [BP+argOKiCounter]
	mov		AH, byte ptr kiBufSeq
	mov		[BX+8], AX
;record identity of process/interrupt task
	str		AX
	mov		[BX+6], AX

;record cs:ip
	cmp		word ptr [BP+argOKiCounter], loDispatch
	je		DispatchHack
	;get cs:ip from the kernel frame 
	mov		SI, [BP]
	mov		AX, SS:[SI+csRet]
	mov		CX, SS:[SI+csRet-2]
	jmp		short PastHack
DispatchHack:
	;get cs:ip from the stack below us (hack alert!)
	mov		SI, BP	
	mov		AX, SS:[SI+10]
	mov		CX, SS:[SI+8]
PastHack:
	mov		[BX+4], AX
	mov		[BX+2], CX

;wrap buffer & fix bpLink
	mov		SI, BX
	add		BX, sKiFrame
	lea		AX, kiBufEnd
	cmp		BX, AX
	jb		DeadPigsInABucket
	lea		BX, kiBuf
DeadPigsInABucket:
	mov		oKiBuf, BX
	mov		[SI], BX
KiTraceDisabled:
)fi%'
	pop		DS
assume DS: Nothing
	pop		SI
	pop		CX
	pop		BX
	pop		AX
	popf
	pop		BP
	ret		sArgs

Instrumentalist endp
)fi%'



%IF (%trace) THEN (
TraceHook PROC NEAR
	Mov	AX, TraceExchg
	OR	AX, AX
	Jz	TryUserNum
	Cmp	AX,SI
	Je	DoTrace
	Inc	AX
	Jz	DoTrace		;Trace Everything if  TraceExchg = 0FFFFh
	XOR	AX,AX
TryUserNum:
	OR	AX, TraceUserNum
	Jz	TryRqCode
	CMP	AX, ES:[BX+rqUserNum]
	Je	DoTrace
	XOR	AX,AX
TryRqCode:
	OR	AX, TraceRqCode
	Jz	SkipTraceHook
	CMP	AX, ES:[BX+rqCode]
	Jne	SkipTraceHook
DoTrace:
	Push	CX
	Mov	AX,ES:[BX+rqCode]
	Mov	CX,ES:[BX+rqUserNum]
	Push 	SI
	Push	ES
	Push	BX
	Push	SI
	Push	AX
	Mov	AX,ES:[BX+ErcRet]
	Push	AX
	XOR	AX,AX
	CMP	BYTE PTR ES:[BX],2
	Jl	NoFhInfo
	Mov	AX,ES:[BX+12]
NoFhInfo:
	Push	AX
	MOV	SI, oPcbRun
	MOV	AX, WORD PTR [SI+pcbUserNum]
%IF (not(%Icc)) THEN (
; I don't know who uses this trace mechanism, but overloading userNum 
; wont work on the SRP. -JM 
	OR	AX, msgType
	TEST DI, lcRqInc + lcRqDec
	JNZ StoreRequestingUser 
	OR	AX,2000h
StoreRequestingUser:
)FI
	Mov	SI, TraceIndex
	LES	BX, pTraceBuffer
	Mov	WORD PTR ES:[BX][SI+4], AX	;Calling User Num
	Mov	WORD PTR ES:[BX][SI+6], CX	;rq.UserNum
	Pop	AX
	Mov	WORD PTR ES:[BX][SI+14], AX	; Maybe Fh
	Pop	AX
	Mov	WORD PTR ES:[BX][SI+12], AX	;ErcRet
	Pop	AX
	Mov	WORD PTR ES:[BX][SI+8], AX	;rqCode
	Pop	AX
	Mov	WORD PTR ES:[BX][SI+10], AX	;exchg
	Pop	AX				;BX
	Mov	WORD PTR ES:[BX][SI], AX	;Offset of pRq
	Pop	CX				;ES
	Mov	WORD PTR ES:[BX][SI+2], CX	;Selector of pRq
	Mov	BX, AX
	Mov	ES, CX
	Add	SI, sKernelTraceEntry
	Cmp	SI, cbTraceBuffer
	Jl	ResetIndex
	XOR	SI,SI
ResetIndex:
	Mov	TraceIndex,SI
	Pop	SI	
	Pop	CX
SkipTraceHook:	
	RET
TraceHook ENDP

)FI

Kernel		ENDS
;
; LOG
; 1/8/80  RH,  handle service not available case
; 4/29/80 RH,  error return in wait, remove bad pointer checks in SEND & PSEND
; 12/15/82 by Jim Frandeen: test request codes for valid range; 
; return ercNoSuchRequest if out of bounds.
; 12/16/82 by Jim Frandeen: general rewrite -- this module replaces the
;	following modules: Msg.asm, Create.asm, Kentry.asm, IJoint.asm, KIntF.asm,
;	AwsKen.asm, AwsIJ.asm, MpKentry.asm, MpCreate.asm, MpMsg.asm, MpKintF.asm,
;	MpAwsKen.asm
; 3/7/83 by Jim Frandeen: Initialize id in Pcb; Add conditional code to
;	check for stack overflow.
; 3/24/83 by Jim Frandeen: Check for remote user to see if he has a Ucb.
;	fixes bug where SRP agent opens file on behalf of WS user.
; 4/14/83 by Jim Frandeen: Add test for load font buffer in pointer checking.
;4/18/83 by Jim Frandeen: Test for OpenTape request in pointer checking.
;4/19/83 by Jim Frandeen: Add InitNetAgent common subroutine; Put Crash
;	in common sub entries that are not used; When routing to NetAgent, 
;	store net routing code in high order or exchResp field of rq.
; 4/23/83 by Joe Altmaier: merge my request level code.
; 5/5/83 by Jim Frandeen: Add StringsEqual common subroutine
; 5/11/83 by Jim Frandeen: Fix AlarmRaw to report the correct CS:IP.
; 5/13/83 by Jim Frandeen: Check for stack overflow before saving SP in the 
;	pcb so we can see what was in the pcb bevore overflow occurred.
;5/20/83 by Jim Frandeen: On Wait, mask off routing code in high order byte
;	of response exchange
;/27/83 by Jim Frandeen: If we return ercServiceNotAvail instead of 
;	ercNoSuchRc, we can put termination requests and abort requests in levels ;	other than level 0.
;	Last update 5/6/83 by Jim Frandeen: Integrate Mike Ober's T1 changes
;	7/7/83 by JA: Set soft vectors when DISPatching and in CreateProcess.
;	7/20/83 by JA: LockVid.asm.
;7/15/83 by Jim Frandeen: Remove special case AddQueueEntry in CheckPointers
;	Remove Quad math external references
;8/7/83 by JA: pcb.oExPcb, ExPcb.oSoftVecHead in CreateProcess, Disp.
;8/15/83 by JA: SetDeltaPriority Kernel primitive (Mp only).
;8/17/83 by JA: Null GetProcInfo, GetSlotInfo for MegaFrame.
;8/21/83 by JA: KernelKillUser for CEntry, OsSubEntry.
;8/25/83 by Jim Frandeen: Fix pointer test for NGen and 240 master
;8/27/83 by Jim Frandeen; Don't crash on inconsistent Rq (erc 16). Return erc.
;	Save pointer to rq for erc 11.
;9/8/83 by JA: userNumVid
;9/13/83 by Jeff Krause: Fix up AddQueueEntry requests with bad date/time
;9/16/83 by JA: for swapping, put Responds on exchSwapping if rq.exchResp
;			belongs to userNumSwap and rq.ercRet=ercSwapping.
;			Mark link block owner = rq.userNum when exchResp=ercSwapping
;			so rq can be found when swapping in.
;			Request set rq.ercRet=ercOk.
;9/23/83 by Jim Frandeen: Put routing code in sRtInfo instead of in the high
;byte of the response exchange field.
;9/27/83 by Jim Frandeen: On change of context for NGen (at DispGo:)
;load contents of Ear register.
;9/28/83 by JA: When pcb.priority <= prioOS (40h) set deltaPriority=0.
;10/17/83 by JA: Keep rgcRq current upon Request(Direct), Respond.
;10/21/83 by JA: RestoreUserPtrs (softvecs) for MSDOS etc.
;11/1/83 by JA: RestoreVectors; SetVectors; CreateProcess copy exPcb.
;11/2/83 by JK: fix 11/1 fix
;11/4/83 by JA,JK: StackLim words checked in Disp.
;11/7/83 by JA: MSDOS VectorArea switch uses proper ExPcb.
;11/10/83 by Jim Frandeen: Fix Cs:IP on divide error.
;11/11/83 by JK: fix 508,509 crash bugs
;11/17/83 by JA: ercBadRespExch when rgrqExchg(rq.rqCode)=rq.exchResp.
;		BadExchg when exch not allocated (Mp only).
;11/19/83 by JK: undo ercBadRespExch when rgrqExchg(rq.rqCode)=rq.exchResp,
;		so that GetClusterStatus will work
;11/22/83 by Jim Frandeen: Don't route to NetAgent if destination node is
;	our node name, i.e., don't send request to ourself.
;11/12/83 by Jim Frandeen: Add ChangeProcessPriority, NewProcess, KillProcess, 
; RescheduleProcess, QueryPid, ForwardRequest 
;11/29/83 by Jim Frandeen: At RestoreUserPtrs, the stack must not be 
; distrubed. This causes interrupt routines to wipe out someone's stack.
;12/2/83 by JK/JA: Suspend if swapping in LockVideo. ERC7 MegaFrame primitives.
;	(Un)LockVideoForModify PUBLIC
;12/5/83 by JA: Setup ES in UnlockVideoForModify, as is called internally.
;12/8/83 by JK: Setup ES in all system common procs
;1/10/84 by Jim Frandeen: Zero pcb.userNum in KillProcess.
;1/30/84 by MO: add support for 8086 NGen and T2
;2/2/84  by MO: change hardwareType to processorType for NGen EOI code
;2/2/84  by MO: change EOI sequence to support special fully nested mode on T1
;2/9/84 by JA: add exPcb.savedPriority, SetUserPrio in LockVideo subrs.
;2/21/84 by Jim Frandeen: Add SetScreenControl
;2/29/84 by JA: un-apply deltaPriority in LockVidFMod. erc33 if Send(p, 0).
;3/8/84 by Jim Frandeen: Kernel runs with client flags (i.e., interrupts
; enabled) when state is in the stack.
;3/10/84 by JA: DI holds primitive type during message primitives.
;3/12/84 by JA: Fix CEntry, Exits to use new DI definition.
;3/13/84 by JA: ForwardRequest DI=3args, +0 to cRq.
;3/25/84 by Jim Frandeen: move DmaBytePtrClr into Kernel from Floppy_t1
; CTOS 10.0
;6/11/84 by Mike Ober: add EOI support for cws workstation
;9/7/84 by JA: Fork, LockForModify counter, userNumPrimary.
;9/14/84 by JA: Blent 54, DebuggerCleanup 55, DebuggerNub 56
;10/21/84 by JA: Respond link block belongs to rq issuer; when server
;	exits the block won't get cleaned up.
; 11/12/84 by Jim Frandeen: Add GetIBusData, LockCursor, and UnlockCursor to list os system common routines
; 11/25/84 by DR: softbus switch, removed debugger system common
; 11/29/84 by Jim Frandeen: Move userNumVid and userNumKbd to SysConfig so they can be accessed by installable video. Add system common 69 - 74 for 10.0 VAM.
; 12/10/84 by Jim Frandeen: Remove MoveFrameRectangle from OsSubs, move it to Ctos.lib
;12/14/84 by JA: WakeUpSched 74
;12/28/84 by JA: pop Fork args (2 words).
;1/12/85 by DR: add VP switch for WakeUpSched
;1/15/85 by DR: add system common 55/56 - Read/WriteCommLineStatus_sc
;1/16/85 by DR: fix ercs returned by video semaphore code 
;2/7/85 by JA: LockVidExch=2
;3/1/85 by JA: Add WakeupSched. Call it when Send puts swapped pcb on runq.
;3/14/85 by JA: WaitLong (DI=16)
;3/15/85 by JA: Make Fork Vp only. Check fWorkForSched. Make WaitLong #20
;3/21/85 by JA: Invent KSendAlwaysReschedule for Fork.
;3/26/85 by Jim Frandeen: Add MoveFrameRectangle, changes in OsSubTable for loadable video
;3/29/85 by Jim Frandeen: remove all Vam from OsSubTable -- now set up by InitVam
;4/2/85 by Mike Ober: add support for GWS
;4/4/85 by Jim Frandeen: Move LockVideo routines to LockVideo.asm. Move oRgPcb to System Common area of Sysgen.mdf. Move UserNumPrimary and userNumSwap so that they can be accessed by poPcbRun.
;4/10/85 by JA: ExitAndRemove 75
;4/24/85 by JA: QueryModel 76
;5/7/85 by JA: QueryLoadAddress 77
;5/14/85 by JA: fix QueryLoadAddress
;7/16/85 by JA: ContextState OR bitRqsPocketed
;9/23/85 by JM: add ercBadOpCode and kernel jump table addressing
;10/3/95 by Jim Frandeen: Make Lock/UnlockVideoForModify system common
;	subroutines

;12/5/85 by JM: GetUserNum returns 1 if user is in primary partition so
;			old servers will work.
;12/7/85 by JA: comment SetDeltaPriority.
;12/16/85 by JA: requestFlag value 8000h for Respond.
;1/12/85 by JM: change system common ULCMPB calls UserULCMPB.
;1/13/86 by JM: add 80287 TS bit at disp
;1/21/86 by JM: suspend bits
;1/21/86 by JA: nSoftVecFree
;2/5/86 by JM: set bitRqsPocketed only if the request code is the the
;				wakeup list
;3/18/86 by JA/RLM: cb=0 don't check for '{' or '['.
;3/24/86 by JA: lMsgRequest, lMsgRespond, lMsgSend; requestFlag -> msgType
;3/25/86 by MS: In QueryModel, delete check for AsibActive (partitions with
;					data only in mind)
;3/26/86 by JM: remove QuietForSwap from VP version.
;4/3/86 by JA: SetpStructure reserved.  11.0 Graphics calls 79-98.
;		Remove OsSubLabel macros.
;4/4/86 by JK:  Fix GetSar and friend to be not implemented
;4/4/86 by DR: add workaround in AlarmRaw for interrupt 6/386/Lock problem.
;4/10/86 by JA: remove [Sysin],[Sysout] support, make installable.
;4/21/86 by DR: ctosp
;4/16/86 by FW: support for NewGen.
;4/21/86 by DR: ctosp
;4/24/86 by JM: Fix NewProcess to make userNumPrimary check,
;		ReImplement WriteSar so CrashMessage works.
;7/17/86 by MS: move SwapXBEar here from PLM module. Re-write in assembler
;				because accesses OS data, must save-restore user DS.
;8/4/86 by MS: Fake output to EAR for NewGen video.
;9/29/86 by DR: CTOS II 2.0 merge.
;9/30/86 by PBC: FSCanon (107)
;10/16/86 by DR: ResumeTask label, interrupt stacks are grow down
;10/24/86 by JA: Subr (110-116) Log,LogFill,InPlm,OutPlm,InputPlm,OutputPlm,
;				ULCMPB.
;10/29/86 by JA: SetpStructure in real mode.
;10/30/86 by DR: 386 GpFault reentry
;11/3/86 by JA FloppyInterrupt (123).  PUBLIC disk int routines.
;12/10/86 by DR: Reserve space for NotifyVidMemLineUser (124).
;12/16/86 by DR: CreateProcessByUserNum
; 1/21/87 by WBE: Added ReUseAliasLarge
; 2/5/87 by JA/RLM: QueryModel don't fault on bad userNum.
; 2/9/87 by JM: add system common entry 127 - MapSgUserNum.
; 2/11/87 by JA: FSrpUpProc 128
; 2/17/87 by DR: bigger gdtLink size, add cReference processing to
;         RMOS aliasing/dealiasing.
; 2/21/87 by DR: support NewProcess in p-mode.
; 2/28/87 by DR: QueryLdtr system common
; 3/03/87 by DR: AliasIpcSrPcb
; 3/06/87 by DR: resurrect vector area processing for RMOS MS-DOS 2.11
; 3/12/87 by JA: fix FSrpUp.
; 3/17/87 by MS: add a new System Common Procedure GetDAinumber
; 3/23/87 by DR: in ProcessRequestBlock, cb=0 case, make selector null
;                only if client selector invalid.  Remove special case for
;                kbd request cb field.
; 3/24/87 by JA: FSCanon 107.
; 3/24/87 by MDE,JM: Add OEM Common Segment (OEMSeg) before CONST
; 4/01/87 by DR: SetDispMsw287 RMOS aware
; 4/02/87 by DR: Clone rmos ear in CloneProcess
; CTOS VM 3.0
; 4/09/87 by KEB: 2.1 source merge
; 5/07/87 by DR: RMOS Set/ResetTimerInt
; 5/13/87 by FW: Add dummy entries for hardware level 71(47h) and 87(57h) 
;                interrupts.
; 6/09/87 by DR: zero FS/GS in 386 TSS in CreateProcess
; 6/26/87 by JA: WriteIBusEvent 139.
; 7/6/87  by DR: If Send to exchgNet from process level, alias request
;                block.  Repair local node name test in NoFileSpecNode.
; 10/6/87 by TB:ja add FillBufferLp 140.
; 10/6/87 by JA: Asib,Arib now selector-based.
; 11/4/87 by TB: Add GetCommLineDmaStatus, ReceiveCommLineDma, 
;                TransmitCommLineDma.
; 11/5/87 by JA: make DoLdtAlias use long ptr to linkHead in asib.
; 11/13/87 by JA: merge 9.8 kernel -
	;6/7/85  by Mike Ober: add code for 9.5
	;7/30/85 by John McGinty: add ercBadOpCode in AlarmRaw
	;9/18/85 by JM: add kernel jump table
	; -- 9.7 --
	;2/27/86 by FW: add JMP $+2 to flush pipeline on consecutive IO operations.
	;3/6/86 by DR: add workaround in AlarmRaw for interrupt 6/386/Lock problem.
	;10/17/86 by GVW add shCPUSpeed.
	;9/9/87 by JM: nls support - system common ULCMPB calls UserULCMPB.
	;10/26/87 by JM: add installable system common calls,
	;add SystemCommonConnect, SystemCommonCheck for compatibility with Bull.
; 11/16/87 by WBE: add a new System Common Procedure GetLocalDAinumber
; 11/17/87 by JA: NoSuchRequest always try DoSendRequest so RequestDirect works even if rqCode not defined and rq.rtCode=0.
;11/17/87 by FW: 386i.
;11/19/87 by JA: SetTimerInt scan pcbs in ldt/interrupt case.
;12/17/87 by JA: add WriteIBusDevice.
;1/5/88 by JA: RouteByNodeSpec check cb before using pb.
; CTOS 2.3
;1/23/88 by JA: exchNet now public in sysgen.
;2/1/88 by JA: MFMp version.
;2/2/88 by JA: processorType.  Remove userNumKbd/Vid to sysgen.
;2/3/88 by JA: SetLedState syscomsubr if MF.
;2/8/88 by JA/RLM: public shCpuSpeed.
;2/10/88 by JM, move osSubtable to osSubInterface_all.asm, 
;				move misc code to ScUtil_all.asm,
;				move misc data to data_all.asm.
;2/19/88 by JA, YSeg for Srp.  OsSubSeg before Data.
;3/15/88 by JA, Srp routing.
;3/16/88 by JA, Request keep exchange in CX, net info in DH.
;3/23/88 by JA/RLM, allow Request,Respond from interrupt level, mark link blocks
;				correctly.  PUSHMF,POPMF for 386.
;3/28/88 by JM, mask slot bits of exch on Wait and Send
;4/05/88 by DR: support PIT from LDT-based interrupt handlers
;4/19/88 by JM, rgsCntlInfo & rgNReqrespPbCb out of dgroup.
;4/21/88 by JM, rgoUcb out of dgroup.
;5/19/88 by JM/RLM, test frRemote in RouteRequest before routing to slot.
;8/12/88 by JM, real mode installed system common.
;				don't test off board exchanges for validity.
;8/20/88 by JA, DO_EOI is in a macro, in Kernel.mdf.
;8/22/88 by JA, create SendEoi, SetInterruptMask.
;8/23/88 by JA, create DeviceInService.
;8/25/88 by JA, userNum 1 -> userNumPrimary.
;8/26/88 by JA, remove intSwTbl in ctosp.
;8/29/88 by AT, added wStatus field to msgWait, resolved 10-bit usernums.
;9/10/88 by MTR, add ResumeTaskWait (new send-to-waiting-process mechanism
;				 for pmos)--rcving task now (always) does msg dealiasing,
;				 add SendP (use instead of FarDealiasIPCSelector+Send),
;				 add pRgPTimingSwap, purge oExUcb,
;				 fix regression in Send(0,pMsg)--return erc instead of fault
;9/14/88 by JA, SendEoi,SetInterruptMask -> ControlInterrupt.
;9/19/88 by MTR, pm disp returns if no processes, fix GP fault in respond 
;9/26/88 by JA, use vf_f386...
;9/24/88 by MTR, add vfRqTracker, oExchRqTracker, RqTrackerAddMsg,
;				 RqTrackerRemoveMsg.  If vfRqTracker,
;				 outstanding Rqs are recorded on exchRqTracker.
;9/28/88 by MTR, enable interrupts in ResumeTaskWait, RqTrackerAddMsg preserves
;				 slot bits.
;10/04/88 by AT, userNumInitial always 2.
;10/05/88 by MTR, minimize disable time in Wait, obsolete pcb.msgRetAddr for
;				  pmos (use task stack instead), add debugging 'instrument's.
;10/12/88 by JM, add Broadcast routing.
;10/18/88 by JM, turn on CpuInUse led at Disp.
;10/22/88 by JA, ControlInterrupt -> K_ControlInterrupt so icc can extrn it.
;10/25/88 by JA, baseLinearOffset PUBLIC in mp.
;10/26/88 by MTR, [Un]SuspendUser
;10/27/88 by MTR, raise VerifyPid's IQ.  add [K][Un]Suspend{Process|User}.
;				  suspended processes now off runQ, pcb swapped+suspend+
;				  userSuspend -> pcb suspends (5 bit counter).
;				  use {k|cg}Entry macro (kernel.mdf).  fix WaitLong from rmode.
;11/1/88 by JA, ControlInterrupt don't trust memory mask.  Fixes PIT.
;11/15/88 by AT, Set DS to DGroup in KSend.
;11/18/88 by KH, EXTRN maHighest, maCascade for DO_EOI
;11/18/88 by JM, add file spec expansion in Request.
;11/21/88 by MTR, no suspendOffRunQ until CM & VAM privy to [Un]SuspendUser.
;11/21/88 by JA, icc separately compiled.
;12/5/88 by JA, Icc_Request/SendRemote so KernelNames no conflict.
;12/07/88 by MTR, default vfRqTracker TRUE for testing (change back pre-ship!).
;				  suspendOffRunQ enabled (CM now privy).  Add more instruments.
;12/07/88 by MTR, cs:ip in trace buffer, debugger code-t compatable.
;12/12/88 by JM rRemote, rMasterFp and rMasterCp are now routed via
;		the slot bits of the service exchange.
;12/14/88 by JM in SuspendPcb, don't take caller of runq.
;12/16/88 by PGJ Modify ControlInterrupt to count mask/unmask calls; unmask the
;				 interrupt ONLY when count is at zero or will reach zero
;12/27/88 by JA PUBLIC GRequestDirect for icc.
;12/28/88 by MTR UnSuspendPcb sets ccNE if target isn't marked ready
;1/3/88 by JA CLI oIntSwTblLast for debugging.
;1/12/89 by JA Respond free specs for users up to userNumLast.
;01/13/89 by MTR Make RqTracker work better with ICC, reduce msgWait use.
;01/16/89 by JA RouteRequestCX -> RouteRequestLocal.
;			RequestRemote shares code with Request so spec expansion works.
;01/17/89 by JA Request,RequestDirect,ForwardRequest and RequestRemote
;			 all the same code.
;01/19/89 by JA expunge DL from Respond.
;01/24/89 by MTR Nina Mauney's (Camarillo) fix to RouteByNodeSpec.
;				 Allow ForwardRequest/RequestDirect on non-MF OS, too.
;01/25/89 by JA Ha,ha, put DL back in Respond.
;02/09/89 by JM/RLM fix Net request routing
;02/22/89 by JA merge JM CTOS 2.3 Request ServiceNotAvail.
 ;1/5/89 by JM: in Request if ercServiceNotAvail, Respond with erc in rq.ercRet 
 ; instead of returning in AX. This allows the request to be properly dealiased.
;02/25/89 by MTR Suspend{Process|User} does IntraSegHeapLock iff called by
;				 process.  Default vfRqTracker FALSE for release.  Add debug
;				 code to Wait.
;03/14/89 by JA Save and restore GP bSlot,Br0 in Tss on process switch.
;03/23/89 by FW At TestRtInfo, don't bypass net routing for RequestDirect and
;               ForwardRequest.
;03/28/89 by MTR Delete HeapLock stuff.  Reinstate KillProcess.
;05/11/89 by JA CreateProc clear tss.bSlot,br0.
;05/25/89 by JA public rgcRqDelta.
;07/5/89 by JA invent sgTssIntRetLast.
;07/26/89 by MTR Request doesn't alias if from remote (via ICC)
;09/18/89 by MTR RouteByNodeSpec treats rq.nReqPbCb=0 like rq.cbSpec=0
;09/19/89 by MTR No longer get default node from ucb: ExpandRqSpecs does it
;09/21/89 by JA Always try RespondAlias, even if erc in respond.
;10/04/89 by MTR Add DeallocPcb, oFreePcb, ONextUserPcb, oRgOUserPcb,
;				 ThreadPcb, UnthreadPcb
;10/10/89 by JA Add KForwardRequest.
;10/24/89 by MTR/RLM DoSendRequest default slot bits in respExch.
;					 Wait on exch 0 not allowed.
;12/19/89 by JWF Add KernelLock/UnlockCritical. Change suspends from 5 bits to
;		4 so we can use bit 5 for pcbfSem.  Add CALL TestCriticalSemaphore in 
;		several places (in general, where we test pcbStatus for suspends). 
;		Add rTss386pSem, to TSS for critical section semaphore
;01/17/90 by JA expunge pCEntry.
;02/02/90 by JA add timerq.cLink.
;1/27/90 by JWF at RetInterruptTask, must set DS to DGroup in case Interrupt
;		Task has different DS than OS.  Call LockRqPages for requests,
;		call UnlockRqPages for response.  Change K_KernelLockCritical to save
;		TSS in semaphore instead of oPcb.
;02/26/90 by JA remove unreferenced fSrpUp; add public SigIsr to IRET list.
;				Also remove strange initialization of orgParDesc to .config-4.
;3/9/90 by DR, v series RMOS CreateProcess
;3/16/90 by JWF move Call LockRqPages after Alias. Use high byte of DI 
;		(exit code register) for flag maskLockRqPages
;3/17/90 by JC BTOS Merge: Added Kernel Trace for Tracing ForwardRequest,
;		RequestDirect, Request, and Respond, fix to zero ES before enabling
;		interrupts to avoid an invallid TSS interrupt, fix to see if message
;		sent via a KPSend when adding message to free list
;3/21/90 by DR - ammend maskLockRqPages logic so that rgcRq works
;3/24/90 by JA put pCEntry back temporarily.
;3/26/90 by JM move timerQ to Timer_all.
;3/29/90 by JC - Added Bsac Support
;4/12/90 by JA merged CTOS XE 3.0 -
; 11/06/89 by JA ProcessRequestBlock skip remoteDma ba in 1st pbcb.
; 11/26/89 by MTR Request default slot bits in rq.userNum.
; 11/29/89 by MTR Treat dummy (padded) request codes like no such request codes.
; 12/06/89 by MTR Oops--index rgLocalServiceCode as word not byte!
; 12/07/89 by JA DoSendRequest check respExch for remote rq, NOT userNum.
; 12/07/89 by MTR InterruptCantBlock no longer conditional debug code and calls
; 				 crash instead of NMIing.
; 12/29/89 by MTR [Un]SuspendUser tolerates suspend count {over|under}flow
; 				 (makes incremental LoadTask work)
; 01/11/90 by JMR Removed saving BR0 in createproc on CTOSp.
; 01/17/90 by JA expunge pCEntry.
; 02/02/90 by JA add timerq.cLink.
; 03/26/90 by MTR ONextUserPcb checks userNum first time through
; 4/10/90 by DR - v series uses gdtlinks for ldt aliasing
; 04/18/90 by JM add QueryProcessInfo; gdtLink includes userNum in p series.
; 05/01/90 by DR - use FadsTypesAsm.edf - v series sGdtLink = 8
; 05/16/90 by DR - return ercOk in Suspend/UnSuspendUser even if no pcbs -
;                  allows CM to remove its data partition with generic code
; 05/17/90 by JWF - Add LOCK prefix to BTS for semaphores
; 05/24/90 by JMR - Fix Mod to allow 286 code for kernel_p, except for
;                    386 only code.
; 06/06/90 by JM - fix p-series code aliasing.
; 06/11/90 by JWF - Move UnlockRqPages after call to FreeRqSpecs so that
;		we unlock the same pb/cb pairs that we locked.
; 07/05/90 by JM - don't apply delta priority when priority = 0ffh.
; 07/05/90 by JC - Added Statistics support
; 07/23/90 by GWH - Added mediated EOI support for SGEN ext. Interrupts
; 08/08/90 by DR - put userNum in gdtLinks for RMOS aliases
; 09/05/90 by JM - add OS/2 tid support.
; 09/21/90 by JM - fix p-series alias threading.
; 10/01/90 by JA Send to exchAgent or exchNet mask DI, leave only sys/usr bit.
; 10/24/90 by JM - return erc from Request when service not available instead 
;	of returning the erc in rq.ercRet (merge Louie's 2.4 changes plus release 
;	locked pages and spec heap).
; 11/13/90 by AT - DmyISR replaces dummy labels XINTR0,...,SigISR.
; 11/16/90 by JM - Send to exchAgent or exchNet does not net route.
; 11/29/90 by JM - NewProcess sets ax-dx,si,di as documented.
;				   Inherit caller's priority if pdb.priority = 0 in CreateProc.
; 11/29/90 by MTR- Update cpu led on SGen
; 12/03/90 by JWF- No need to save and restore EBX and ESI across 
;					LockRqPages for PC Emulator -- saves stack space
; 12/07/90 by BA - Treat {server} the same as {master} when parsing node name.
; 12/11/90 by DR - Hack for PM SDK following CommonLdtFoundAlias
; 01/02/90 by JM - FowardRequest doesn't modify rq.userNum if its equal to 0 
;	or 1. This is consistent with the 2.x kernel and allows OS requests to 
;	be filtered.
; 01/18/91 by JM - same treatment as above for RequestDirect.
; 01/19/91 by MTR- Update cpu led on b38lcw & 386i
; 01/23/91 by JMR - Make K_ControlInterrupt use byte IO because of SG2000
; 01/24/91 by JWF- We can't check for GDT based by checking LDTR for zero
;					with new trap handler.  
; 02/07/91 by AT - Add bOpEnableRst to ControlInterrupt.
; 02/14/91 by JM - Send to exchNet or exchAgent doesn't lookup routing.
; 02/19/91 by JM - add pidRoot and pidNext to QueryProcessInfo.
; 02/20/91 by JM - CreateProc resets tss.PcEmDebugExch.
; 03/07/91 by JF - At DoIntRet, fixup DS again in case interrupt filter was
;					removed. Also, push flags AFTER IRET for same reason
; 03/20/91 by JF - KSetTimerInt takes userNum as parameter
; 04/08/91 by JF - in KSetTimerInt, if message option, store unaliased pRq
;					in pRqBlkRetField
; 04/15/91 by JM - clear ES in Wait - prevents fault if selector is destroyed
;					while ES is saved on stack in CreateIpcAlias.
; 05/01/91 by JF - In Respond, call CheckErcBreak if erc not OK.
; 05/13/91 by AT - IntRet check for early EOI and unmask instead of EOI'ing.
; 05/14/91 by JF - Move lfEarlyEoi & friends up to avoid MOD386 error
;---3.3 shipped---
; 07/30/91 by JM - merge Affie's kernel hooks stuff.
; 08/21/91 by JM - SuspendUser suspends all threads but self if called with
;					usernum = ones.
; 09/24/91 by DR - Remove RestoreDefaultTraps code - obsolete.  In v series,
;                  Remove  gp fault handler save/restore code.
; 11/01/91 by JF&JM - Move critical section semaphores from object module to
;	KernelLock/ClearCriticalSection so that we can wait until process does not
;	own critical semaphores to suspend him.
; 11/07/91 by JM - new kernel call ProcessControl which unconditionally 
;	suspends/resumes.
; 11/07/91 by JF - new kernel call SetKernelMode permits PagingService to say
;	only run me and userNum 0 when it enounters a page fault with interrupts
;	disabled.  Permits critical section to continue to work for application.
; 11/14/91 by JF - recode SemLockCritical and SemClearCritical to make them faster.
; 11/18/91 by JM - leave critical section pcbs on run queue.
; 12/91 by JM - add stack switching. 
;		remove VP, Classic, and 286 code.
;		obsolete exchSwapping. 
;		return erc InterruptCantBlock instead of crashing.
; 01/24/92 JM - add case to ProcessControl to clear userNumOnly.
; 01/31/92 DR - Real mode NewProcess initializes AX,BX,CX,DX,SI,DI,BP
; 02/01/92 JM - turn on statistics.
; 02/27/92 JM - in ServiceNoAvail, don't DeAliasToLdt if process is
; 			    doesn't have LDT.
; 02/29/92 JM - use $MOD286 wherever possible to reduce code bloatation.
; 03/04/92 JM - don't try to route by spec when rq.nReqPbCb = 0.
; 03/09/92 JF - Remove temporary call crash from SemLockCritical
;   CTOS v 1.0
; 04/22/92 JA - Separated MF into MF and Icc.
; 04/30/92 JM - fix stack fault in ResetTimerInt.
; 05/05/92 JM - fix AddQueueEntry rq.pDateTime fixup.
; 05/21/92 JF - Make Lock/ClearCritical a little faster.
; 06/05/92 JA - invent SendRequest.
; 06/08/92 JA - lMsgRqUsernum for SendRequest, Respond.
; 06/29/92 JF - Change userNumOnly to tssIdOnly and change semantics.
; 07/28/92 JM - in ProcessControl when resuming interrupt-disabled threads
;				dispatch them immediately (oPcbCriticalSection).
; 10/29/92 DR - don't reinit ss0/sp0 in CreateProc, use values from TSS
; 11/13/92 by JF: Create prgContextStatus, prgContextState, prgcRq
;					orgDeltaPriority, orgUserReadCount, orgUserWaitCount,
;					orgIpcAliasHead to remove nPartitions dependency from 
;					sysgen.
; 01/13/93 VJM - Added header required for Unisys trademark bureaucracy.
;				 No code changes occurred.
; 02/11/93 JF - Move TestCriticalSemaphore inline. If process is waiting
;				for critical section semaphore, run the process that owns
;				the semaphore to prevent deadlock.
; 02/23/93 JM - CreateProc call to MakeReady must be int disabled.
; 03/05/93 JM - Unlock request block pages at Wait instead of Respond. Fixes
;				ICC case where Chime interrupt Responds.
; 03/12/93 JF - When testing for userNumOS, don't JCXZ, Test maskSlot
; 03/23/92 JM - gdtLinkUserNum does not contain slot bits.
; 03/29/93 JF - When critical section semaphore is locked, server must
;				be able to run as well as OS when server is installed from
;				the soft bus.
; 03/30/93 JM - fix 03/23/92 regression error.
; 04/09/93 JM - ICC Request didn't replace rq.userNum with pcbRun.userNum
;				when rq.userNum = 0.
; 04/15/93 JA - Merge CTOSXE:
 ;07/24/91 by AT RouteRequest save BX at [BP+raRq] when saving ES at [BP+saRq].
 ;09/17/92 by JM Added rDeviceFilter so RequestDirect/ForwardRequest can map
 ;				global handles
; 04/20/93 JF - Allow more than one cluster user number for installable cluster
; 04/??/93 ?? - RequestCXDXDone ercServiceNotAvail if exch.hi AND 80h ???
; 04/20/93 JA - FreeRqResources called from ServiceNotAvail unlock pages.
;				Other places just call FreeRqSpecs.
; 04/22/93 JA   Recant 07/24/91 (harmless)
; 04/23/93 JA - NoSuchRequest return erc if no exch arg (see 11/17/87).
; 05/20/93 JF - cUserNumCritical, rgUserNumCritical make a structure
;				accessed by GetpStructure.
; 05/25/93 JA - lExpress.  ForwardRequest,SendRequest don't 0 rq.ercRet.
; 05/26/93 JA - Request/Respond don't alias if exchAgent.
; 06/28/93 JA - exch 12 means exchAgent.
; 06/22/93 JM - ProcessControl did not set fRespectCriticalSection correctly
;				causing breakpoints in crit sects to fail.
; 07/07/93 JA - exchAgent express only for srvr, not cws.
; 07/14/93 JM - lExpress routing enforces slot bits on respExch.
; 07/23/93 SE - NoSuchRequest works for non-existent, net-routed rqs on Lfs.
; 07/24/93 JM - save/restore DI in RecordVectors & SetVectors - fixes 
;				antique RMOS programs which use SetVectorArea.
