;
;	crash.asm
;
$MOD286
%SET(OsCodeCliFaultHard, 1)

$INCLUDE(:f1:ioaddr1.edf)
$INCLUDE(:f1:descriptors.mdf)

coprocessorBusyReg  	EQU  0F0h    ; same as Busy80387Reg in ioaddr1.edf
pcbSize         		EQU  18
pcbUserNum      		EQU  14
pcbStatus       		EQU  2
pcbTss          		EQU  6
pcbfSys					EQU	40h
pcbInUse				EQU 80h
rTssrRgb87 				EQU 0B2h
slotMask				EQU 3FFh
initFlagV86Msb 			EQU 2
maskLdt 				EQU 4
ercDivisionOverflow 	EQU 27
ercInvalidOpcode    	EQU 28
ercCoprocessorNotPresent EQU 29
ercGPFault          	EQU 80
ercRmosGPFault      	EQU 81
ercStackFault       	EQU 82
ercPageFault        	EQU 84
ercOverflow         	EQU 85
ercBoundsCheck     	 	EQU 86
ercCoprocessorError 	EQU 87
ercCoprocessorOverrun 	EQU 88
ercDoubleFault      	EQU 89
ercInterruptStackFault 	EQU 92
ercNotPresentFault  	EQU  83
ercBusTimeout       	EQU  22
ercUnknownNonMask		EQU  25
ercBusError         	EQU  28

;
; imported functions
;
EXTRN DebuggerNub: FAR
EXTRN EnterBootRom: FAR
EXTRN ErcNmi: FAR
EXTRN ErcProcessSwap: FAR
EXTRN ErrorExit: FAR
EXTRN ErrorExitUser: FAR
EXTRN FinishCrash: FAR
EXTRN InitProcQuery:FAR
EXTRN sc_FloppyInterruptSubr: FAR



Data SEGMENT PUBLIC 'Data'
;
; imported data
;
EXTRN bootBlock: BYTE
EXTRN crashCR2: DWORD
EXTRN fIgnoreBusTimeout: BYTE
EXTRN iInitRun:WORD
EXTRN iInitRunNoReset:WORD
EXTRN oCoprocessor:WORD
EXTRN oPcbRun: WORD
EXTRN orgPcb: WORD
EXTRN pCoprocessorState:DWORD
EXTRN parityEnablePortNGen: WORD
EXTRN plaendmemory: DWORD
EXTRN prgContextStatus: DWORD
EXTRN sgTssIntLast:WORD
EXTRN sysErrorBuf: WORD
EXTRN vf: BYTE		
EXTRN vfNmiOccurred: BYTE
EXTRN vfNmiTest: BYTE

$INCLUDE(:f1:vfequ.idf)
sysErrorBufErc			EQU WORD PTR sysErrorBuf
sysErrorBufProcess		EQU WORD PTR sysErrorBuf+2
sysErrorBufNmiStatus	EQU WORD PTR sysErrorBuf+4
sysErrorBufConfigReg	EQU WORD PTR sysErrorBuf+6
sysErrorBufNmiReg0		EQU WORD PTR sysErrorBuf+8
sysErrorBufNmiReg1		EQU WORD PTR sysErrorBuf+10
sysErrorBufCs			EQU WORD PTR sysErrorBuf+12
sysErrorBufIp			EQU WORD PTR sysErrorBuf+14


;
; exported data
;

public vfEnterDebuggerOnfault, vfSuppressAutoDump
vfEnterDebuggerOnfault db 0
vfSuppressAutoDump db 0

public fKbdProcessRunning
fKbdProcessRunning db 0

PUBLIC fDelayBoot, fReboot
fDelayBoot	DB	0
fReboot	DB	0

PUBLIC sgOsCodeFirst, sgOsCodeLast
sgOsCodeFirst DW 0
sgOsCodeLast DW 0

; Following is a public structure for passing info. to the debugger
public sgTssGpFaultDbg
sgTssGpFaultDbg dw 0
ercForDebugger  dw 0
faultType       db 0	; used by debugger as fNoRestart

public vfHardFault
vfHardFault db 0

PUBLIC nmiFaultErc, crashNmiStatus
nmiFaultErc dw 0
crashNmiStatus DW 0

PUBLIC parityErrReg0, parityErrReg1, parityErrReg386i
parityErrReg0 DW 0
parityErrReg1 DW 0
parityErrReg386i DW 0

EVEN
PUBLIC crashTssStackInit, sgTssCrash, processorErrorCode
crashTssStack DW 30 DUP (0)			;stack for crash tss
crashTssStackInit DW 0
sgTssCrash 	DW 0

ercUser dw 0
processorErrorCode dw 0

PUBLIC fNmiStatus
fNmiStatus DB 0
fRecursed DB 0


PUBLIC vfSgenP1
vfSgenP1 DB 0

Data	ENDS
DGroup GROUP Data


SysTrapsCode SEGMENT PUBLIC 'code'
ASSUME cs:SysTrapsCode 

;
; Reboot: PROCEDURE PUBLIC REENTRANT;
; 	called from Crash and FinishCrash.
;	reboot system from the current sys device.
;	does not return.
PUBLIC Reboot, DbgRebootOs
Reboot PROC FAR
DbgRebootOs LABEL BYTE
	push bp
	mov  bp, sp
	mov	ax, DGroup
	mov	ds, ax
ASSUME DS:Dgroup
	MOV	AL, BYTE PTR BootBlock+9
	CMP	AL, 1
	JNE	CheckDisk
	MOV	BX, 2		;Reboot from floppy
	MOV	DL, 0
	JMP	RebootEnterRom
CheckDisk:
	CMP	AL, 2
	JNE	CheckComm
	MOV	BX, 2		;Reboot from disk
	MOV	DL, 1	
	JMP	RebootEnterRom
CheckComm:
	CMP	AL, 3
	JNE	CheckNecFloppy
	MOV	BX, 1		;reboot from comm
	MOV	DL, BYTE PTR [bootBlock+10]
	JMP	RebootEnterRom
CheckNecFloppy:
	CMP	AL, 6
	JNE	CheckSCSIDisk
	MOV	BX, 2		;Reboot from floppy
	MOV	DL, 0
	JMP	RebootEnterRom
CheckSCSIDisk:
	CMP	AL, 5
	JNE	BootBlockError
	MOV	BX, 2		;Reboot from disk
	MOV	DL, 1	
	JMP	RebootEnterRom
BootBlockError:
	MOV	BX, 2		;bootBlock is insane, reboot from disk
	MOV	DL, 1	

RebootEnterRom:
	push  bx ;			 bootrom es
	push  dx ;			 bootrom dx (wsType)
	test  vf_fb38lcw, 1				; parity and NMIs disabled in Enterbootrom
	jnz   EnterRom
	test  vf_fpcAT, 1			;PCAT covers SG3K,4K,6K,1K and PS2
	jnz   EnterRom
	test  vf_fSGen, 1
	jnz   EnterRom
NotB38Parity:
	MOV   DX, parityEnablePortNGen	; disable parity
	XOR   AX, AX
	OUT   DX, AX
EnterRom:
	CALL EnterBootRom
	HLT
Reboot ENDP



;
; Crash: PROCEDURE (erc) REENTRANT; (system common call)
;
PUBLIC Crash
Crash	PROC FAR
; 	store erc, and calling cs:ip in SysErrorBuf.
;	restore register state of caller so crashing TSS maybe debugged.
;	switch to sgTssCrash (FinishCrash) to continue crash (reporting, logging,
;	and dumping/rebooting.)
;
argErc 	EQU [BP+6]
ipCrash EQU [BP+4]
csCrash EQU [BP+2]
saProc	EQU [BP-8]
raProc  EQU [BP-10]
ASSUME ds:nothing, es:nothing, ss:nothing
	PUSH BP
	MOV BP,SP
	PUSH AX		
	PUSH ES
	PUSH BX
	MOV AX, DGroup
	MOV ES, AX
ASSUME ES:DGroup
; check if crashing a second time
	MOV AL, 0FFh
	XCHG AL, fRecursed
	RCR	AL, 1
	JNC	StoreErcCsIp
	CALL Reboot
StoreErcCsIp:
	MOV AX, argErc
	MOV sysErrorBufErc, AX
	MOV AX, ipCrash
	MOV sysErrorBufIp, AX
	MOV AX, csCrash
	MOV sysErrorBufCs, AX
	STR AX
	MOV sysErrorBufProcess, AX	;tss now, try to convert to iPcb later.
	MOV AX, sgTssCrash
	OR  AX, AX		; sgTssCrash initialized?
	JZ  FinishCrashNotReady
	MOV saProc,AX 
	XOR AX, AX
	MOV raProc,AX
	POP BX
	POP ES
	POP AX
ASSUME ES:NOTHING
	CALL DWORD PTR raProc	; CALL FinishCrash (switch to sgTssCrash)
	JMP $+0

FinishCrashNotReady:
; sgTssCrash not initiliazed yet. call FinishCrash as a subroutine on this
; tss.
	CALL FinishCrash
; doesn't return
Crash ENDP




ASSUME ds:nothing, es:nothing, ss:nothing
;****************************************************************
;
;  Default System Trap Handlers
;
;****************************************************************
PUBLIC CoprocessorTrap
CoprocessorTrap proc far
; In the v series, the coprocessor state save area is in the TSS.
; The OS variable oCoprocessor holds the TSS data alias of the TSS
; that currently has valid state in the coprocessor.

; msb of tss.rRgb87 is set if the tss contains the FPU state; the debugger
; reads this bit to determine whether the FPU state should be read from
; the chip or the tss.

	push	ds
	push	es
	push	ax
	push	bx
	pushf

	mov		ax, DGroup
	mov		ds, ax
assume ds:dgroup, es:nothing
	str		ax
	sub		ax, 8

	cli
	clts
	mov		bx, oCoprocessor
	cmp		ax, bx
	je		CoprocessorTrapExit
CoprocessorSwitch:
; if coprocessor state is valid (oCoprocessor <> 0), save it
	or		bx, bx
	jz		LoadCoprocessor
	mov		es, bx
	mov		bx, es:[rTssrRgb87]

; save FPU state to tss extension
	db		66h					;32bit format
	db		026h, 0ddh, 037h	;fnsave	es:byte Ptr[bx]

LoadCoprocessor:
	mov		oCoprocessor, ax
	mov		es, ax
	mov		bx, es:[rTssrRgb87]

; restore FPU state from tss extension
	db		66h					;32bit format
	db		026h, 0ddh, 027h	;fnrstor	es:byte ptr [bx], wait
	


CoprocessorTrapExit:
	popf
	pop		bx
	pop		ax
	pop		es
	pop		ds
assume ds:nothing
	db 66h
	iret	
CoprocessorTrap endp
public	CoprocessorNotAvailableTrap
CoprocessorNotAvailableTrap proc far
maskTS 					equ 8
	push ax
	smsw ax
	test ax, maskTS
	pop  ax
	jz  NoTaskSwitch
	clts
	db 66h
	iret
NoTaskSwitch:
	push ercCoprocessorNotPresent
	jmp short SystemTrapHandler
CoprocessorNotAvailableTrap endp

public BoundsCheckTrap
BoundsCheckTrap proc far
	push ercBoundsCheck
	jmp short SystemTrapHandler
BoundsCheckTrap endp

public OverflowTrap
OverflowTrap proc far
	push ercOverflow
	jmp short SystemTrapHandler
OverflowTrap endp

public DivideErrorTrap
DivideErrorTrap proc far
	push ercDivisionOverflow

public FarSystemTrapHandler
FarSystemTrapHandler label far

SystemTrapHandler:
	push ax
	push ds
	mov ax, DGroup
	mov ds, ax
assume ds: DGroup
	cmp vfEnterDebuggerOnFault, 0
	je  KillOrCrash
; Don't let partition 0 (kbd or debugger) enter debugger on fault.
	mov ax, oPcbRun
	cmp ax, oRgPcb
	je  KillOrCrash
	pop ds	
	pop ax
;
; Restore registers and call debugger. Debugger knows the address 
; DebugSystemTrap and treats any int 3 at that address specially - it
; expects the stack to look like this:
; ss:sp	->	erc
;			ip
;			cs
;			fl
; on v-series, the debugger expects a 386 stack format
;
;
	int 3
PUBLIC DebugSystemTrap	
DebugSystemTrap:		

	push ax
	push ds
	mov ax, DGroup
	mov ds, ax
assume ds: DGroup

KillOrCrash:
; Error code on stack.  If userNum = 0 or user serving requests then
; crash, otherwise ErrorExit.

	mov bx, oPcbRun
	mov bx, word ptr [bx+pcbUserNum]
	and bx, slotMask
	LES SI,prgcontextStatus
	test byte ptr es:[bx][si], 4
	pop ds
	pop ax
	jnz CallCrash
	or  bx, bx
	jz  CallCrash
	call ErrorExit
CallCrash:
	call Crash
assume ds:nothing
DivideErrorTrap endp

$MOD386
public SegmentNotPresentTrap
SegmentNotPresentTrap PROC FAR
; stack format on entry
;	low(errorcode)
;	high(errorCode)
;	low(ip)
;	high(ip)
;	low(cs)
;	0
;	low(fl)
; 	high(fl)
	snFault			equ word ptr [bp+36]
	ipFault			equ word ptr [bp+40]
	csFault			equ word ptr [bp+44]
; init proc registers - change format here and in load_v
	ipr_pProc		equ dword ptr [bp-18]
	ipr_ip			equ word ptr [bp-18]
	ipr_cs			equ word ptr [bp-16]
	ipr_ax			equ word ptr [bp-14]
	ipr_bx			equ word ptr [bp-12]
	ipr_cx			equ word ptr [bp-10]
	ipr_dx			equ word ptr [bp-8]
	ipr_si			equ word ptr [bp-6]
	ipr_di			equ word ptr [bp-4]
	ipr_ds			equ word ptr [bp-2]
	sLocals			equ 18

; save caller's registers
	pushad
	push es
	push ds
	mov  ebp, esp

; query initproc for this selector
	sub  esp, sLocals
	push snFault
	push ss
	lea  ax, ipr_ip
	push ax
	call InitProcQuery
	or   ax, ax
	jnz  OverlayFault
; pInitProc = 0 if global init proc has already run. Don't dispatch again.
; InitProcQuery has made all segs present, just return.
	cmp  ipr_pProc, 0
	je   Dispatchret

; dispatch initproc	
	mov  ax, ipr_ax
	mov  bx, ipr_bx
	mov  cx, ipr_cx			
	mov  dx, ipr_dx
	mov  si, ipr_si			
	mov  di, ipr_di	
	push ipr_ds
	pop  ds
	call ipr_pProc

DispatchRet:
	add  esp, sLocals
DispatchRet2:
	pop  ds
	pop  es
	popad
	add  sp, 4	;pop errcode
	db 66h
	iret
	
OverlayFault:
; overlay faults occur in v-series if the page service is not installed
	add  esp, sLocals
	push 0
	push snFault   ; errorcode
	push csFault   ; cs of faulting segment
	push 5         ; tyServiceSwapFault
	call ErcProcessSwap
	or   ax, ax
	jz   DispatchRet2
	
FaultError:
	pop  ds
	pop  es
	popad
	add  esp, 4 ; error code 
	push ercNotPresentFault
	jmp SystemTrapHandler
SegmentNotPresentTrap ENDP	
$MOD286


;****************************************************************
;
; System Fault Handlers
;
;****************************************************************

ASSUME DS:DGroup

; Fault types
lSoft           EQU 0		; Restartable, wait for user to Action-Finish, etc.
lHard           EQU 1		; Always crash
lSoftNoRestart  EQU 0FFh	; Maybe enter debugger but don't return


; On the SG5000 the XBus timeout and XBus floppy interrupts are shared.
; If a XBus timeout occurred, set vfNmiOccurred and possibly crash depending on
; fIgnoreBusTimeout.  If no timeout then call the floppy ISR.
public XBusTimeout
XBusTimeout proc far
	mov  dx, lXBusAdapterStatusSGen
	in   al, dx						; Reading status clears interrupt.
	test al, lXBusStatusTimeoutSGen
	jz   FloppyInt
	mov  vfNmiOccurred, 0FFh		; TSS born with correct DS
	test vfNmiTest, 1
	jnz  XBTRet
	test fIgnoreBusTimeout, 1
	jnz  XBTRet
	mov  ercUser, ercBusTimeout
	mov  faultType, lSoftNoRestart
	jmp  FaultTaskNoErc
FloppyInt:
	sti								; ISR expects to run interrupts enabled
	call sc_FloppyInterruptSubr
XBTRet:
	ret
XBusTimeout endp


public NmiTaskFault
NmiTaskFault proc far

	mov  vfNmiOccurred, 0FFh
	test vfNmiTest, 1		; set by init code when nmi is expected
	jnz  NmiRet
	cmp  word ptr plaendmemory[2], 1h ; if booted in 1m, ignore nmis 
	jbe  NmiRet					;

ReadNmiStatus:	
	call ErcNmi		; returns type of nmi erc (parity, power fail, etc)
					; sets parityErrReg0, parityErrReg1 from nmi status regs
	mov  fNmiStatus, 0ffh ; if we crash, set sysErrorBuf nmi status words
	cmp  ax, ercBusTimeout
	je   BusTimeout
	cmp  ax, ercBusError	; similar to timeout on GP board, non-fatal
	je   BusTimeout
	cmp  ax, ercUnknownNonMask	; If we can't tell, it's probably an int 2
	jne  NotBusTimeout

; Handle a software nmi (INT 2) as a soft fault.  Some machines allow us to 
; detect software nmi and we ErrorExit with ercUnknownNonMask.  On others we 
; can't tell the difference and we ErrorExit with ercBusTimeout.  This is 
; strange, but we don't document what INT 2 will do so it's good enough.  See 
; ErcNmi for erc info.  A side-effect is fIgnoreBusTimeout also ignores INT 2.

BusTimeout:
	test fIgnoreBusTimeout, 1	; set by init code when timeout is expected
	jnz  NmiRet
	mov  faultType, lSoftNoRestart
	jmp  NmiCrashOrExit

NotBusTimeout:
	mov  faultType, lHard	; non-timeouts are always fatal

NmiCrashOrExit:
	mov  ercUser, ax		; ax returned by ErcNmi
	jmp  FaultTaskNoErc

NmiRet:
	test vf_fComarch, 1
	jz   NmiDone
	mov  dx, parityEnablePortNGen
	mov  al, 3	; clear  parity nmi
	out  dx, al
	mov  al, 13	; enable parity nmi
	out  dx, al
	mov  al, 7	; clear nmi; now armed
	out  dx, al
NmiDone:

; pcbs not setup yet, can't mediate
	iret
	jmp  NmiTaskFault

NmiTaskFault endp


public CoprocessorOverrun
CoprocessorOverrun proc far
	push ercCoprocessorOverrun
	jmp  short CommonCoprocessorError
CoprocessorOverrun endp

; This is for PS2
; IGNORE THIS FOR NOW - JWF 2/17/93
public Coprocessor2Error
Coprocessor2Error proc far
	mov ercUser, ercCoprocessorError
	jmp short CommonCoprocessorError
Coprocessor2Error endp

public CoprocessorError
CoprocessorError proc far
	push ercCoprocessorError
CommonCoprocessorError:
	push ax
	push ds
	mov ax, DGroup
	mov ds, ax
	push es
	push bx
	push si
	push dx
	clts
	dw   0E3DBh     ; finit - clear the error condition
; need some code here ????
	xor  ax, ax
	test vf_fSGen, 1
	jz   CETerminateUser
	mov  dx, coprocessorBusyReg
	out  dx, al
CETerminateUser:
	pop  dx
	pop  si
	pop  bx
	pop  es
	pop  ds
	pop  ax
	jmp SystemTrapHandler
CoprocessorError endp


public DoubleTaskFault
DoubleTaskFault label far
	mov  ercUser, ercDoubleFault
	mov  faultType, lHard
	db   0Fh, 20h, 010h		; mov eax, cr2
	db   66h
	mov  word ptr crashCR2, ax	; mov crashCR2, eax
	jmp  short FaultTaskErc

public StackTaskFault
StackTaskFault label far
	mov  ercUser, ercStackFault
	mov  faultType, lSoft
	jmp  short FaultTaskErc

public PageTaskFault
PageTaskFault label far
	mov  ercUser, ercPageFault
	mov  faultType, lSoft
	db   0Fh, 20h, 010h		; mov eax, cr2
	db   66h
	mov  word ptr crashCR2, ax	; mov crashCR2, eax
	jmp  short FaultTaskErc


public InvalidTssFault
InvalidTssFault label far
	nop
	jmp short GPHandlerRestored


public GPTaskFault
GPTaskFault proc far

; restore the 386 trap gate for the V86 emulator
	mov ax, sgIdt
	mov es, ax
	mov word ptr es:[6Ah], slJumpTable
	mov byte ptr es:[6Dh], access386TrapGate
GPHandlerRestored:
	mov  ercUser, ercGPFault
	mov  faultType, lSoft


; Common code for fault handlers,  all are born with DS = OS DGroup.

FaultTaskErc:
	pop  dx						; error code pushed by chip
	test vf_f386Tss, 1			; we really want to know gate type
	jz   FaultTask
	pop  ax						; discard high word of 386 error code
	jmp  FaultTask

FaultTaskNoErc:
	xor  dx, dx					; no processor error code

FaultTask:
; ercUser set, dx = errorCode if any
	mov  processorErrorCode,DX	; save processor error code

; get back link to faulting TSS in bx
	str  bx
	sub  bx, 8					; data alias of this task's TSS
	mov  es, bx
	mov  bx, word ptr es:[0]	; tssBackLink = faulting TSS

	cmp  bx, sgTssIntLast		; always crash an interrupt handler
	ja   CheckFaultType			; 'greater than' means not an interrupt TSS
	cmp  ercUser, ercStackFault
	jne  HardFaultJmp
	mov  ercUser, ercInterruptStackFault	; die with correct erc

HardFaultJmp:
	jmp  HardFault

CheckFaultType:
	cmp  faultType, lHard				; some faults always end in a crash
	je   HardFaultJmp

$MOD386
; crash if faulting the tss is in a critical section
	mov  di, bx
	sub  di, 8
	mov  fs, di
	cmp  fs: word ptr [rTss386cCritSect], 0	
	jne  HardFaultJmp
$MOD286

	mov  di, iInitRun					; crash during initialization
	cmp  di, iInitRunNoReset
	jb   HardFaultJmp

	mov  di, oPcbRun
	mov  si, word ptr [di+pcbUserNum]	; or the OS (userNum = 0)
	test si, slotMask
	jz   HardFaultJmp

%if (%OsCodeCliFaultHard) then (
; Faults in os code with ints disabled are always hard faults.
	mov  ax, bx
	sub  ax, 8							; Data alias for faulting task's TSS
	mov  es, ax
	test vf_f386Tss, 1
	jnz  OsCliTest386

; OsCliTest286
	test word ptr es:[rTss286Flags], 200h	; Interrupt flag 1 = enabled
	jnz  SoftFault
	mov  cx, word ptr es:[rTss286CS]
	jmp  CsCheck

OsCliTest386:
	test word ptr es:[rTss386Flags], 200h	; Interrupt flag 1 = enabled
	jnz  SoftFault
	mov  cx, word ptr es:[rTss386CS]

CsCheck:
	test cx, maskLdt					; Ldt can't be OS sgCode.
	jnz  SoftFault
	cmp  cx, sgOsCodeFirst
	jb   SoftFault
	cmp  cx, sgOsCodeLast
	jbe  HardFaultJmp
)fi

; di = oPcbRun, si = userNum, bx = faulting TSS, dx = error code

SoftFault:
	test vfEnterDebuggerOnFault, 1
	jnz  EnterDebugger

; Allow system services et. al. to enter debugger, but crash them otherwise
	test byte ptr [di+pcbStatus], pcbfSys	; a system service
	jnz  HardFault
	mov  di, si								; di gets userNum index
	and  di, slotMask
	add  di,prgcontextStatus
	mov  es,prgContextStatus+2
	test byte ptr es:[di], 4				; an application containing an ISR
	jnz  HardFault							; and/or serving requests

; Soft fault, not entering the debugger, so terminate the user
; for GP faults, give different status code if from RMOS
	cmp ercUser, ercGPFault
	jne DoErrorExitUser
	mov  ax, bx
	sub  ax, 8							; Data alias for faulting task's TSS
	mov  es, ax
	test word ptr es:[rTss386EFlags], initFlagV86Msb
	jz DoErrorExitUser
	mov ercUser, ercRmosGPFault
DoErrorExitUser:
	push ercUser					; error code
	push si							; UserNum to kill
	push 0ffh						; TRUE means return
	push 0							; fRemove
	call ErrorExitUser
	mov  fNmiStatus, 0				; nmi status info no longer current
	ret 							; mediated interrupt return to kernel

EnterDebugger:
	mov  sgTssGpFaultDbg, bx		; sgTss for debugger
	mov  bx, ercUser				; ercUser for debugger
	mov  ercForDebugger, bx			; faultType (fNoRestart) already set
	push 13							; dbrcFault
	push 0							; sa of pMsg is 0 for debugger
	push dx							; processor error code
	call DebuggerNub				; Nub will kill user if no debugger
									; or fNoRestart = TRUE
	mov  fNmiStatus, 0				; nmi status info no longer current
	ret								; return to kernel


HardFault:
	mov sysErrorBufProcess, bx		
	mov al, vfHardFault
	rcr al, 1
	jc  .+0 ; loop forever if recursed
	mov vfHardFault, 0FFh
	mov  ax, ercUser
	mov sysErrorBufErc, ax	
; put cs:ip regs in sysErrorBuf
	mov bx, sysErrorBufProcess
	sub  bx, 8			; Data alias
	mov  es, bx
	mov  ax, es:[rTss386Cs]
	mov  cx, es:[rTss386Ip]
	mov  sysErrorBufCs, ax
	mov  sysErrorBufIp, cx
	call FinishCrash  ;sets up rest of SysErrorBuf and may or may not print msg.
	jmp short .+0     ;freeze

GPTask endp

SysTrapsCode ENDS
END

;  LOG
;  8/12/80  by JK
;  8/28/80  by RH
;  9/2/80   by JK
;  11/18/80 by JK ... add comm crash handler.
;  3/23/81  by HR
;  4/6/81   by JK ... New boot interface.
;  4/10/81  by HR ... iop Crash fix
;  5/05/81  by RH     fix HR's bug
;  4/19/82  by RH     save User logon
;  4/29/82  by RH     crash 301
;  6/2/82   by TAS    DisableGraphics
;  3/2/83   by MO     combine crash.asm, awscra.asm and NGen code into 1 module
;  8/6/83   by MO     don't clobber DL before jumping into NGen boot rom
; 8/4/83 JA  Don't use pcb.id
; 9/20/83 by Jim Frandeen: Save registers if fDevelopment
;  9/27/83  by JK     check for recursion, add timeout
; 10/20/83 by Jim Frandeen:  Split into different modules for different
; hardware to save memory if fDevelopment
; 1/29/84 by Mike Ober:  Make parityEnable port a variable instead of a 
; literal to support T2 and 8086 NGens
;  8/18/86  by JA     use SCAT ptr for ioErrorLog - not in DGroup
; 9/18/86 by JA merge _MF -
;  10.15.82 Dcc - Shaved down for server;
;  04.25.84 SAR - Display full error code; don't enter ROM
;  06.06.85 SAR - Converted for Fp or Dp as Master
; 10/22/86 by JA merge Hfs -
;  4/10/86  by DR  use ReadScat
;  7/19/86  by WBE added code to InvalidOpcodeTrap to restart if op = opLock 
;  9/19/86  by DR  repaired InvalidOpcodeTrap
;  1/06/87  by DR  crash on illegal opcode
;  1/7/87   by FW  cleanup crash handling.
;  2/26/87  by DR  new EnterBootrom interface
;  2/27/87  by DR  DivideErrorTrap
;  3/18/87  by JA  Don't call readscat if not fReboot.
;  3/26/87  by JM  test contextStatus as byte array, not word array.
;  3/29/87  by DR  CoprocessorOverrunTrap, ercInterruptStackFault
;  3/31/87  by DR  Cleanup exit from NotPresentTrap
;  4/16/87  by MDE Merge vfNmiTest change by JM
;  6/09/87  by DR  Double fault gets erc 89
;  8/03/87  by DR  ErrorExit on application bus time out NMI
;  11/3/87  by JM	  put NmiPort0 and NmiPort1 at offset 8 and 10 of
;					  syserrorbuf (like the documentation says).
;  11/9/87  by JA/RLM Merge 9.9.
;  11/17/87 by FW  386i.
;  12/9/87  by JA  if fRecursed then check fReboot.
;  1/4/88   by JM  system traps enter debugger.
;  1/11/88  by JA  merge srp 1.4.
;  2/10/88  by JA  remove fKludgeAvail.
;  2/19/88  by JA  add Dbg calls in Mp.
;  3/2/88   by JM  servers enter debugger on fault if vfEnterDebuggerOnFault. 
;  9/26/88  by JA  use vf_f386, vf_f386Tss
;  10/6/88  by KH  PS2 support
;  10/10/88 by JM  don't do video stuff (ReportTaskFault) on Srp.
;  10/24/88 by KH finger_pidCoprocessor has owning process' offset from start
;           of   rgPcb, not segment, so that toggling MSB(it) is safe 
;  11/07/88 by MTR suspend->pcbSuspends, pcb.status is a BYTE
;  12/07/88 by MTR use KSuspendUser
;  12/09/88 by AT  Don't reboot at init time, check fReboot.
;  12/16/88 by JA/RLM clear NMI before iret.
;  2/7/89   by JA/MTR faults are hard if cli and in os code.
;  2/9/89   by JA		... and sg not Ldt; or iInitRun < iInitRunNoReset.
;  3/3/89   by MTR		... and test tss of faulting task not GPTaskFault's tss!
;  4/6/89   by JA/RLM NmiTaskFault re-arm latches.
;  05/19/89 by AT, use fIgnoreBusTimeout.
;  06/28/89 by JA, ErrorExitUser has fRemove argument.
;  06/29/89 by AT, Mask slot bits from userNum for EnterDebuggerCheck {1715}.
;  07/10/89 by AT, Fix DebugSystemTrap AX and DS usage.
;  08/15/89 by AT, Read nmi status before disabling.  Save dmaRemoteSlot.
;  09/07/89 by MTR, Cli'd OS code faults only hard for debugging (SET
;					OsCodeCliFaultHard).
;  09/17/89 by AT, Reading nmiSourcePort clears Nmi.  jmp NmiTaskFault after
;                  iret.  Setup sysTime and sysError SCAT for early MF crashes.
;  09/18/89 by AT, Fixed bug in SCAT changes.  Bootrom expects sa:ra, not pa.
;  12/18/89 by MTR, Save dmaTargetAddress5, dmaByteCount5
;  01/05/89 by AT, Don't EnterDebuggerOnFault if debugger (or kbd) running.
;  01/25/90 by AT, pCdt is es:bx, not ds:bx, when checking bFrontPanel.
;  02/20/90 by DR, v series doesn't use finger area, but what about coprocessor?
;  03/15/90 by JM, obsolete ReportTaskFault; general weeding.
;  07/16/90 by MTR, CallErrorExitUser addresses oPcbRun so we don't GP fault
;  09/06/90 by SG, Add B38lcw support
;  11/05/90 by AT,  Add XBusTimeout.
;  01/19/91 by MTR, DisplayInfoOnLeds for workstations
;  02/04/91 by JM, call DebuggerNub for gp faults.
;  02/05/91 by JF, Make SegmentNotPresent a 386 trap gate if running on 386.
;  02/07/91 by AT,  XBusTimeout interrupt shared with XBus floppy.
;                   Cleaned up fault handling, enter debugger on NMI.
;  02/13/91 by SG, fixup B38lcw support
;  02/23/91 by AT, declare oCoprocessor under CtosV so module will compile.
;  02/23/91 by AT, enable interrupts before calling sc_FloppyInterruptSubr
;  03/26/91 by SG, enable SG5000 enterbootrom
;  04/12/91 by JM, put true nmi status in sysErrorBuf.
;  04/22/91 by MTR, add vfSGenP1 stuff
;  05/02/91 by SG, hack so that nmis during dump (booted in < 1m ) are ignored.
;  05/13/91 by JF, add label for InvalidTssFault
;  05/13/91 by GWH, Removed vfSgenp1 hack.
;  06/24/91 by JM, v-series segment not present handler dispatches DLL init
;				   procs.
;  09/24/91 by DR, In v series, restore trap gate in GPTaskFault, support
;				   ercRmosGpFault.
;  10/22/91 by DR, For PC, save crash info in CMOS
;  11/06/91 by JM, crash on faults within critical section.
;  11/08/91 by DR, Back out of 10/22/91
;  11/14/91 by DR, For PC, let sysTime be magicT
;  11/18/91 by JF, save processor error code
;  12/05/91 by JM, in v-series, use 386 trap gates for all exceptions
;  05/26/92 by DR, repair bug in coprocessor state restoration
;  10/22/92 by DR, remove WAITs from CoprocessorTrap 
;  11/16/92 by JF, Make ContextStatus BASED
;  01/19/93 by JA, COMARCH merge
;  03/02/93 by SE, If not fComArch don't assume boot from disk.
;  03/26/93 by JM, move FinishCrash to Fault.plm.
;				   remove non-ctosv and mf code.
;  06/02/93 by JM, save/restore 32-bit FPU state
;  06/23/93 by FW, Use correct vf flags for SG5k

