;CommonSubs_all.asm
;
;Miscellaneous procedures used primarily to shorten code in PLM modules
;Created 1/11/82 by Jim Frandeen
;12/21/82 by Jim Frandeen: Add PointersEqual Procedure
;1/14/83 by Jim Frandeen: Change oVhb to come from file spec.
;6/7/83 by Jeff Krause: Change XXXifErcNotOK to use stack, not ax
;7/19/83 by Jim Frandeen: Change checksum routines to use fhBuff
;9/2/83 by Jim Frandeen: Add Min procedure
; 10/22/83 by JK: add RequestKWait, KRequestKWait,shorten DWordMul
; 4/10/86 by DR: move PointersEqual to CompatibleSubs.asm
;8/20/86 by JA, invent _all, _Cws, _FS
;8/25/86 by JA, add MDiv32, DateTimeD.
;10/15/86 by JA, merge Hfs.
;11/3/86 by JA, merge KUtil2.asm.
;11/14/86 by JA, ResetDs.
;12/10/86 by JA/RLM, MF version
;7/21/87 by JA Hash use Nls tables, GetpStructure.
;	CTOS 2.3
;1/25/88 by JA remove LogFillSubr.
;1/29/88 by JA remove MF version.
;2/29/88 by JA add SetDSOsDGroup
;4/15/88 by PGJ added alias KSend for KPSend
;6/01/88 by PGJ removed MDiv32 (include Math32.Obj in .Fls instead)
;               added ResetStack (previously in Math32.Asm)
;9/7/88 by JA remove baroque saData,XchgDs,ResetDs.  Use SetDSOsDGroup,SetDS.
;12/30/89 by MTR Reduce SetDS stack requirements.
;2/24/90 by JA add %Cl switch for separately linked cluster.
;5/03/91 by JA cld in Hash, LogUser.
;
$MOD186
%DEFINE(ESPrefix)(	DB	26h
)

%IF(NOT %*IsDef(%Cl)) THEN (%*Define(Cl)(0))FI

;
; Externals imported by this module
;
DGroup GROUP DATA
Data SEGMENT PUBLIC 'DATA'
%IF(%FS) THEN (
		EXTRN fhBuff: WORD
		EXTRN spec: WORD
		oVhb  EQU spec+110
		EXTRN hashPageNum: WORD
		EXTRN pSysNetServerData: DWORD
) ELSE (
		EXTRN processorType: BYTE
)FI
Data ENDS

%IF(NOT %Cl) THEN (
EXTRN Error: FAR
)FI
EXTRN Crash: FAR
EXTRN Request: FAR
EXTRN Wait: FAR
EXTRN Send: FAR
EXTRN Respond: FAR
%IF(%FS) THEN (
EXTRN GetpStructure: FAR
)FI
%IF(NOT %FS AND NOT %Cl) THEN (
EXTRN Log:FAR
)FI
;
; Publics exported by this module
;
PUBLIC Min
;PUBLIC PointersEqual
PUBLIC ListDelete, ListInsert
%IF(NOT %Cl) THEN (
PUBLIC ErrorIfErcNotOK
)FI
PUBLIC CrashIfErcNotOK
PUBLIC DWordMul
%IF(%FS) THEN (
PUBLIC DateTimeD
PUBLIC Hash
PUBLIC CalcFhBuffChecksum
PUBLIC CheckFhBuffChecksum
PUBLIC CheckVhbChecksum
PUBLIC CalcVhbChecksum
)FI
%IF(%FS OR %Cl) THEN (
PUBLIC KWait, KRequest, KRespond, KPSend, KSend
) ELSE (
PUBLIC LogUser, GetProcessorType
PUBLIC ResetStack
)FI
PUBLIC SetDS, SetDSOsDGroup
PUBLIC RequestKWait
PUBLIC KRequestKWait

CommonSubs_Code	SEGMENT	PUBLIC 'CODE'     
ASSUME CS:CommonSubs_Code, DS:DGroup

;		Min: PROCEDURE(w1, w2) WORD REENTRANT;
w1		EQU		WORD PTR SS:[BX+6]
w2		EQU		WORD PTR SS:[BX+4]

Min				PROC		FAR
	MOV		BX,SP
	MOV		AX, w2
	CMP		w1, AX
	JA		MinRet			;w2 is less
	MOV		AX, w1			;w1 is less
MinRet:
	RET		4
Min		ENDP

;		PointersEqual: PROCEDURE(p1, p2) FLAG;
p1Low		EQU		WORD PTR [BP+6]
p1High		EQU		WORD PTR [BP+8]
p2Low		EQU		WORD PTR [BP+10]
p2High		EQU		WORD PTR [BP+12]

PointersEqual				PROC		FAR
	PUSH		BP				;Save BP
	MOV		BP,SP
	MOV		SI,p1High
	MOV		CL,4
	MOV		AX,p1Low
	SHR		AX,CL
	ADD		SI,AX				;SI = address p1 shifted right 4
	MOV		DI,p2High
	MOV		AX,p2Low
	SHR		AX,CL
	ADD		DI,AX				;DI = address p2 shifted right 4
	CMP		SI,DI
	JNE		PointersNotEqual

	MOV		AX,0FFh				;Assume pointers are equal
	MOV		DX,p1Low
	AND		DX,0FH
	MOV		BX,p2Low
	AND		BX,0FH
	CMP		BL,DL
	JZ		PointersAreEqual
PointersNotEqual:
	XOR		AX,AX
PointersAreEqual:
	POP		BP
	RET		8
PointersEqual				ENDP
;
; ListDelete: procedure (pEnt)
;
; Remove the entry from a doubly-linked list.  Pointers are sn:ra16.
; Selector$Of (pEnt.pNext) = 0, to mark as deleted (and trap double-delete).
;
; GP fault on bogus linkage.
; Mutual exclusion is caller's business.
; All registers hosed.
;
ListDelete proc far

pEnt        equ dword ptr [bp+6]
sArgs       equ 4

    push    BP
    mov     BP, SP
    push    DS

    lds     SI, pEnt                ;ds:si = pEnt
    les     DI, dword ptr DS:[SI]   ;es:di = pNext

    mov     BX, DS:[SI+4]           ;ax:bx = ent.pPrev
    mov     AX, DS:[SI+6]

    mov     word ptr DS:[SI+2], 0   ;selector$of(ent.pNext) = 0
    
    mov     ES:[DI+4], BX           ;next.pPrev = ent.pPrev
    mov     ES:[DI+6], AX
    
    mov     DS, AX                  ;ds:bx = pPrev
    
    mov     DS:[BX], DI             ;prev.pNext = ent.pNext
    mov     DS:[BX+2], ES

    pop     DS
    pop     BP
    ret     sArgs
ListDelete endp

;
; ListInsert: procedure (pPrev, pEnt)
;
; Append an entry onto a doubly-linked list.  Pointers are sn:ra16.
;
; GP fault on bogus linkage or if Selector$Of (pEnt.pNext) <> 0 (double-insert).
; Mutual exclusion is caller's business.
; All registers hosed.
;
ListInsert proc far

pPrev       equ dword ptr [bp+10]
pEnt        equ dword ptr [bp+6]
sArgs       equ 8

    push    BP
    mov     BP, SP
    push    DS

    lds     SI, pPrev               ;ds:si = pPrev
    les     DI, pEnt                ;es:di = pEnt
    mov     BX, DS:[SI]             ;ax:bx = prev.pNext
    mov     AX, DS:[SI+2]
    
    cmp     word ptr ES:[DI+2], 0   ;if selector$of(ent.pNext) <> 0
    jne     ListInsertBogus
    
    mov     ES:[DI], BX             ;ent.pNext = prev.pNext
    mov     ES:[DI+2], AX
    
    mov     DS:[SI], DI             ;prev.pNext = pEnt
    mov     DS:[SI+2], ES
    
    mov     ES:[DI+4], SI           ;ent.pPrev = pPrev
    mov     ES:[DI+6], DS
    
    mov     DS, AX                  ;ds:bx = pNext
    mov     DS:[BX+4], DI           ;next.pPrev = pEnt
    mov     DS:[BX+6], ES

ListInsertRet:
    pop     DS
    pop     BP
    ret     sArgs

public ListInsertBogus
ListInsertBogus:
    mov     CX, DS
    mov     CS, CX                  ;gp fault
    jmp     ListInsertRet
ListInsert endp

%IF(%FS) THEN (
; This routine is also in ClockFace.plm which is not used by FS.
;	DateTimeD: PROCEDURE DWORD REENTRANT PUBLIC;
DateTimeD PROC FAR
netpSysTime EQU 59
timeSeconds EQU 2
timeDayTimes2 EQU 4
timeChecksum EQU 6
	les BX, pSysNetServerData	; Contains pSysTime
	les BX, DWORD PTR ES:[BX+netpSysTime]
	pushf
	cli
	mov AX, ES:[BX+timeSeconds]
	mov DX, ES:[BX+timeDayTimes2]
	mov CX, ES:[BX+timeChecksum]
	popf
	cmp DX, 0
	je Ret0
	add CX, AX
	add CX, DX
	cmp CX, 1234
	jne Ret0
	ret			; (AX,DX) = DWORD time
Ret0:
	xor AX, AX
	mov DX, AX
	ret
DateTimeD ENDP
;		Hash: PROCEDURE (pb, cb, divisor) WORD;
;		erc=GetPStructure(25,0,@pTable);
;		IF erc = ercOk THEN
;			IF (i:=FINDW(Table.oRgId, lFSULCmpbTable, Table.cStructure))
;			 <> 0FFFFh THEN
;				 pXlatTable=table.rgoStruct(i);
;			ELSE erc=NOT ercOk;
;		x=0;
;		i = 0;
;		DO WHILE i < cb;
;		        b=bs(i);
;				IF erc = ercOk THEN b=rgXlatTable(b);
;				ELSE
;		         IF b >= 'a' THEN IF b <= 'z' THEN b=b-20h;
;		        x=73*x+b;
;		        i = i+1;
;				END;
;		hashPageNum=x MOD divisor;
;		RETURN(hashPageNum);
;
Hash		PROC		FAR
divisor	EQU		WORD PTR [BP+6]
cb		EQU		WORD PTR [BP+8]
pb		EQU		DWORD PTR [BP+10]
pTable	EQU		DWORD PTR [BP-4]
sLocal	EQU		4
lGetpNlsTables EQU 25

TableType SEGMENT AT 0
	wSignature			DW ?
	cbTable				DW ?
	cStructures			DW ?
	orgId				DW ?
	orgoStruct			DW ?
	fill				DW 3 DUP(?)
lFSULCmpbTable			EQU 1
lSigFSULCmpb			EQU 'FS'
TableType ENDS

	PUSH	BP
	MOV		BP,SP
	SUB		SP,sLocal
	PUSH	DS

	LEA		BX,pTable			;erc=GetpStructure(lGetpNlsTables,0,@pTable);
	PUSH	lGetpNlsTables
	PUSH	0
	PUSH	SS					;ppTable
	PUSH	BX
	CALL	GetpStructure
	OR		AX,AX
	JZ		FoundTable
NoTable:
	XOR		BX,BX
	JMP		DoHash

FoundTable:
	LDS		SI,pTable
ASSUME	DS:TableType
	MOV		DI,orgId[SI]
	MOV		AX,lFSULCmpbTable
	MOV		CX,cStructures[SI]
	CLD
	PUSH	DS
	POP		ES
ASSUME ES:Nothing
	REPNE SCASW
	JNE		NoTable
	SUB		DI,orgId[SI]
	ADD		DI,orgoStruct[SI]
	MOV		SI,[DI-2]			;DS:SI = pXlatTable
	LODSW						;first word is signature
	CMP		AX,lSigFSULCmpb
	JNE		NoTable
	MOV		BX,SI				;BX used in XLAT instruction

DoHash:
	XOR		DX,DX				;Total is in DX
	MOV		CX,cb				;CX = count in bytes
	JCXZ	HashFinished		;IF count is zero

	LES		SI,pb				;ES:SI = pointer to byte string to hash
ASSUME ES:Nothing
	CLD

HashLoop:
	MOV		AX,73
	MUL		DX					;DX..AX = total*73
	XCHG	AX,DX				;DX = total*73						
	XOR		AX,AX				;Zero AH so we can add to AX below
	%ESPrefix LODSB				;AL = next byte in the string to hash
	OR		BX,BX
	JZ		EnglishDefault
	XLAT
	ADD		DX,AX				;AX = total*73 + next byte
	LOOP	HashLoop
	JMP		Short HashFinished

EnglishDefault:
	CMP		AL,61H				;IF byte < 'a
	JB		AddNextHashByte
	CMP		AL,7AH				;IF byte > 'z
	JA		AddNextHashByte
	SUB		AL,20H				;IF byte IN['a..'z], subtract 20H

AddNextHashByte:
	ADD		DX,AX				;AX = total*73 + next byte
	LOOP		HashLoop

HashFinished:
	XCHG	AX,DX				;AX = total
	XOR		DX,DX				;Zero high order of dividend
	DIV		divisor
	POP		DS
ASSUME DS:DGroup
	MOV		hashPageNum,DX		;Store result
	XCHG	AX,DX				;Return result in AX
	MOV		SP,BP
	POP		BP
	RET		8
Hash			ENDP
)FI
%IF(NOT %Cl) THEN (
ErrorIfErcNotOK				PROC FAR
;
; Routine to check an erc and call Error if not 0:
;
;	call ErrorIfErcNotOK(erc);
;		or
;	call ErrorIfErcNotOK(Procedure(params));
;
; This procedure is called to check an erc for the file system process.  The
; functionality is the same as the following:
;
;	erc=Proc;
;	if erc<>ercOK then call error(erc);
;
	MOV		BX, SP
	MOV		AX, WORD PTR SS:[BX+4]
	OR		AX,AX			;Test AX for zero
	JNZ		ErcNotZero
	RET		2			;Throw away the argument on the stack

ErcNotZero:
;	Jump to Error so that CS:IP will look like Error
;	was called by our caller.
	JMP		Error			;no return from Error
ErrorIfErcNotOK				ENDP
)FI
CrashIfErcNotOK				PROC FAR

;
; Routine to check an erc and crash if not 0:
;
;	call CrashIfErcNotOK(erc);
;		or
;	call CrashIfErcNotOK(Procedure(params));
;
; This procedure is called to check an erc.  The
; functionality is the same as the following:
;
;	erc=Proc;
;	if erc<>ercOK then call Crash(erc);
;
	MOV		BX, SP
	MOV		AX, WORD PTR SS:[BX+4]
	OR		AX,AX		;Test AX for zero
	JNZ		CrashErcNotZero
	RET		2			;Throw away the argument on the stack
CrashErcNotZero:
;	Jump to Crash so that CS:IP will look like Crash
;	was called by our caller.
	JMP		Crash		;no return from Crash
CrashIfErcNotOK				ENDP


DWordMul			PROC  FAR
;	DWordMul: PROCEDURE(wArg1, wArg2) DWORD PUBLIC;
; The only reason for the existence of this procedure is that the current
; version of the PLM compiler will not generate a 32-bit result from two
; 16-bit operands

;arguments as offset from SS:BP
; wArg1		EQU WORD PTR [BP+8]
; wArg2		EQU WORD PTR [BP+6]
; 	PUSH		BP			;Save BP
; 	MOV		BP,SP
; 	MOV		AX,wArg1
;	MUL		wArg2			;32 bit result is in AX and DX
;	POP		BP			;Restore BP
;	RET		4			;Return with result in AX and DX

wArg1		EQU WORD PTR SS:[BX+6]
wArg2		EQU WORD PTR SS:[BX+4]
	MOV		BX,SP
	MOV		AX,wArg1
	MUL		wArg2			;32 bit result is in AX and DX
	RET		4			;Return with result in AX and DX
DWordMul			ENDP

%IF(%FS) THEN (
CalcFhBuffChecksum					PROC		FAR
;This procedure calculates the checksum in fhBuff[1..255]
;and returns it in AX

	LEA		BX,fhBuff+2				;i = 1
	MOV		CX,255				;Initialize count
	JMP		InitChecksum

CheckFhBuffChecksum					PROC FAR
;This procedure calculates the checksum in fhBuff[0..255]
;and returns it in AX

	LEA		BX,fhBuff				;i = 0
	MOV		CX,256				;Initialize count
	JMP		InitChecksum


CheckVhbChecksum					PROC FAR
;This procedure checks the checksum in vhbBuff[0..127]
	MOV		BX,oVhb
	MOV		CX,128				;Initialize count
	JMP		InitChecksum

CalcVhbChecksum PROC FAR
;This procedure claculates the checksum in vhbBuff[1..127]
;and returns it in AX
	MOV		BX,oVhb
	INC		BX				;i = 1
	INC		BX
	MOV		CX,127				;Initialize count
Magic			EQU	7C39H			;magic is defined in FilSys.idf
       
InitChecksum:
	MOV		AX,Magic				;w = Magic
ChecksumLoop:
	SUB		AX,[BX]				;w = fhBuff(i)
	INC		BX				;i = i+1
	INC		BX
	LOOP		ChecksumLoop
	RET						;Return with w in AX

CalcFhBuffChecksum					ENDP
CheckFhBuffChecksum					ENDP
CheckVhbChecksum					ENDP
CalcVhbChecksum					ENDP
)FI
%IF(%FS OR %Cl) THEN (
;*****************************************************************************
;
;	KRequest: PROCEDURE(pRq) PUBLIC REENTRANT;
;	KRespond: PROCEDURE(pRq) PUBLIC REENTRANT;
;	KSend:    PROCEDURE(exch, pRq) PUBLIC REENTRANT;
;
;*****************************************************************************

KTable DD Request, Respond, Wait, Send

KRequest PROC FAR
	MOV  SI, 0
KCall:
	PUSH BP
	MOV  BP, SP
	LES  BX, DWORD PTR [BP+6]
	PUSH ES
	PUSH BX
	CALL  DWORD PTR KTable[SI]
	OR   AX, AX
	JZ   RequestWaitErrorExit
	JMP  SHORT RequestWaitCrash
KRequest ENDP

KRespond PROC FAR
	MOV  SI, 4
	JMP  SHORT KCall
KRespond ENDP

;	KSend:   PROCEDURE(exch, pRq) PUBLIC REENTRANT;
;	KWait:   PROCEDURE(exch, ppRqRet) PUBLIC REENTRANT;
exchWait EQU [BP+10]
ppRetWait EQU DWORD PTR [BP+6]

KWait    PROC FAR
	MOV  SI,8
WaitCall:
	PUSH BP
	MOV  BP, SP
	PUSH exchWait
	LES  BX, ppRetWait
	PUSH ES
	PUSH BX
	CALL  DWORD PTR KTable[SI]
	OR   AX, AX
	JNZ  RequestWaitCrash
	POP  BP
	RET  6
KWait    ENDP

KPSend	LABEL FAR
KSend   PROC FAR
	MOV  SI, 12
	JMP  SHORT WaitCall
KSend   ENDP
)FI
;*****************************************************************************
;
;	KRequestKWait: PROCEDURE(prq) PUBLIC REENTRANT;
;
;	RequestKWait: PROCEDURE(prq) ErcType PUBLIC REENTRANT;
;
;*****************************************************************************

ercWrongRqSync EQU 32

ASSUME DS:Nothing

RequestKWait PROC FAR
	MOV  CX, 0
	JMP  SHORT RequestWait1

KRequestKWait LABEL FAR
	MOV  CX, 1

RequestWait1:
	PUSH BP
	MOV  BP, SP
	PUSH CX
	PUSH CX

	LES  BX, DWORD PTR [BP+6] ; save exchange
	PUSH WORD PTR ES:[BX+6]
	PUSH CX

	PUSH ES
	PUSH BX
	CALL Request
	POP  CX

	CMP  AX, 0
	JE   RequestWait3

	RCR  CX, 1
	JB   RequestWaitCrash
	JMP  SHORT RequestWaitErrorExit

RequestWait3:
;	POP  AX
;	PUSH AX
	LEA  AX, DWORD PTR SS:[BP-4]
	PUSH SS
	PUSH AX
	CALL Wait
	CMP  AX, 0
	JNE  RequestWaitCrash

	LES  BX, DWORD PTR SS:[BP-4]
	PUSH ES
	PUSH BX
	LES  BX, DWORD PTR SS:[BP+6]
	PUSH ES
	PUSH BX
	CALL PointersEqual
	RCR  AL, 1
	JB   RequestWaitExit

	MOV  AX, ercWrongRqSync

RequestWaitCrash:
	PUSH AX
	CALL Crash

RequestWaitExit:
	XOR  AX,AX

RequestWaitErrorExit:
	MOV  SP, BP
	POP  BP
	RET  4
RequestKWait ENDP


ASSUME	DS: Nothing, ES: Nothing

SetDSOSDGroup PROC FAR
	mov ax, DS
	mov bx, DGROUP
	mov DS, bx
	ret
SetDSOSDGroup ENDP


SetDS	PROC	FAR
	mov	BX, SP
	mov DS, SS:[BX+4]
	ret	2
SetDS	ENDP

%IF (NOT %FS AND NOT %Cl) THEN (
ResetStack PROC FAR

           PUSH    BP
           MOV     BP,SP

           MOV     BX,[BP+6]
           CMP     WORD PTR [BX],0
           JE      FirstTime
           MOV     AX,[BP+2]     ;ip
           MOV     CX,[BP+4]     ;cs
           MOV     SP,[BX]
           ADD     SP,4
           PUSH    CX
           PUSH    AX
           MOV     BP,[BX+2]

           RET     2


FirstTime: POP     BP

           MOV     [BX],SP
           MOV     [BX+2],BP

           RET     2

ResetStack ENDP

GetProcessorType	PROC	FAR
	mov	AX, DGroup
	mov	ES, AX
ASSUME ES:DGroup
	mov	AL, processorType
	ret
ASSUME ES:Nothing
GetProcessorType	ENDP


; Interface to Log

LogUser	PROC	FAR
	push	BP
	mov	BP, SP
	push	DS

	lds	SI, DWORD PTR [BP+6]	; pLogRec -> STRUC(sRec BYTE, rgb(1) BYTE)
	cld
	lodsb	; AL=sRec
	xor	AH, AH
	dec	AX	; AX=sRgb
	push	DS	; pRgb
	push	SI
	push	AX	; sRgb

	mov	AX, DGroup
	mov	DS, AX
ASSUME DS:DGroup
	call	Log	; (pb, cb)
	pop	DS
	pop	BP
	ret	4
ASSUME DS:Nothing
LogUser	ENDP
)FI

CommonSubs_Code				ENDS
END
