/***
*dos.h - definitions for MS-DOS interface routines
*
*	Copyright (c) 1985-1990, Microsoft Corporation.  All rights reserved.
*	Copyright (c) 1991, Unisys Corporation.
*
*Purpose:
*	Defines the structs and unions used for the direct DOS interface
*	routines; includes macros to access the segment and offset
*	values of far pointers, so that they may be used by the routines; and
*	provides function prototypes for direct DOS interface functions.
*
*	CTOS:	Removed all prototypes for functions in xLIBCR, the
*		Real Mode C Library version.
*
****/


#ifndef _REGS_DEFINED

/* word registers */

struct WORDREGS {
		unsigned int ax    ;
		unsigned int bx    ;
		unsigned int cx    ;
		unsigned int dx    ;
		unsigned int si    ;
		unsigned int di    ;
		unsigned int cflag ;
		} ;


/* byte registers */

struct BYTEREGS {
		unsigned char al, ah ;
		unsigned char bl, bh ;
		unsigned char cl, ch ;
		unsigned char dl, dh ;
		} ;


/* general purpose registers union -
 *  overlays the corresponding word and byte registers.
 */

union REGS {
		struct WORDREGS x ;
		struct BYTEREGS h ;
	   } ;


/* segment registers */

struct SREGS {
		unsigned int es ;
		unsigned int cs ;
		unsigned int ss ;
		unsigned int ds ;
	     } ;

#define _REGS_DEFINED

#endif


/* dosexterror structure */

#ifndef _DOSERROR_DEFINED

struct DOSERROR {
		int exterror ;
		char class   ;
		char action  ;
		char locus   ;
		} ;

#define _DOSERROR_DEFINED

#endif


/* File attribute constants: N/A to CTOS */

#define _A_NORMAL	0x00	/* No read/write restrictions */
#define _A_RDONLY	0x01	/* Read only file             */
#define _A_HIDDEN	0x02	/* Hidden file                */
#define _A_SYSTEM	0x04	/* System file                */
#define _A_VOLID	0x08	/* Volume ID file             */
#define _A_SUBDIR	0x10	/* Subdirectory               */
#define _A_ARCH 	0x20	/* Archive file               */

/*
 *  Break C "far" pointers into their segment and offset components
 */

#define FP_SEG(fp)  (*((unsigned _far *)&(fp)+1))
#define FP_OFF(fp)  (*((unsigned _far *)&(fp)))


/* external variable declarations */

extern unsigned int _near _cdecl _osversion ;


/* function prototypes */

void _cdecl segread( struct SREGS * ) ;

