$MOD286
; assembly routines for protected mode initialization

extrn BuildGdtSlot: far
extrn CallVideoRom: far
extrn Crash: far
extrn NmiDisableAll: far
extrn NmiEnableAll: far
extrn PaFromP: far
extrn RealDispatcher:far
extrn ReportInitFault: far
%if(%ctosv)then(
extrn V86Emulator:  far
)else(
extrn RmosRet: far
)fi
extrn SoundBeeper: far

ercInconsistency   equ  3
ercMemProtect      equ 21
ercBusTimeOut      equ 22
ercParity          equ 23
ercPowerFail       equ 24
ercUnKnownNonMask  equ 25
ercStrayInterrupt  equ 26
ercDivideOverflow  equ 27
ercBusError        equ 28
ercGpFault         equ 80
ercStackFault      equ 82
ercNotPresentFault equ 83
ercOverflow        equ 85
ercBoundsCheck     equ 86
ercDoubleFault     equ 89

desc286Limit equ word ptr es:[bx+0]
desc386BaseMsb equ byte ptr es:[bx+7]
sgGdt equ 8
sgIdentityLowmem equ 50h
sgLowMem     equ 60h
sgSpare      equ 68h
accessWritableData   equ 92h
maskET equ 10h
maskEM equ  4
maskMP equ  2
maskTSandMP equ 0Ah

%if (not %ctosv) then (
finger_saIntReturn  equ word ptr es:[606h]
finger_RmosMSW      equ word ptr es:[628h]
finger_pidCoprocessor equ word ptr es:[62Eh]
finger_f287ResetOnFinger equ byte ptr es:[630h]
) fi
cacheEnable			equ 8h
configPort			equ 150h
tagCompDisable		equ 0DFh
tagCompEnable		equ 20h

$INCLUDE(:f1:IoAddr1.edf)
%SET(GP,0FFh)
$INCLUDE(:f1:Srp386.mdf)

DGroup group data

data segment public 'data'

extrn bCoprocessorStatus:byte
extrn beeperPortNGen:word
extrn cascadeOcw2_8259: word
extrn crashEccSyndrome: word
extrn crashNmiStatus: word
extrn crashNmiAddrLow: word
extrn crashNmiAddrHigh: word
extrn ext8259_ocw2: word
extrn fIgnoreBusTimeout: byte
extrn fReboot: byte
extrn ipRealDispatcher:word
extrn ocw2_8259: word
extrn sgRealInterface:word
extrn vf:byte
extrn vfNmiOccurred: byte
extrn vfNmiTest: byte

$INCLUDE(:f1:vfequ.idf)

wSaveConfig			dw 0
pa_High				dd 0

dT dw 3 dup (0)

dpPi1 dw 4 dup (0)
dpPi2 dw 4 dup (0)
%if(not %ctosv)then(
pRmosRet dd RmosRet
)fi

; defined in SysGen.mdf (SAH)
extrn rgbGpFault: byte
extrn rgbDoubleFault: byte
extrn rgbDivideFault: byte
extrn rgbOverflowFault: byte
extrn rgbRangeFault: byte
extrn rgbBogusOpFault: byte
extrn rgbBogusTssFault: byte
extrn rgbNotPresentFault: byte
extrn rgbStackFault: byte
extrn rgbDefaultInt: byte
extrn rgbXBusTimeout: byte
extrn rgbNmiFault: byte
excx87              dw 0

data ends

%define(REPD)(%' instruction prefix must precede operand prefix
	db 0F3h
	db 066h
)
%define(LODSD)(
	db 0ADh
)
%define(MOVSD)(
	db 0A5h
)
%define(STOSD)(
	db 0ABh
)

InitP_code segment 'coed'

assume cs:InitP_code, ds:DGroup

public TestFor386
TestFor386 proc far

	push		bp
	mov		bp, sp

; on the 386, an IN with LOCK prefix generates an illegal
; opcode exception.  The exeception handler cause
; vf_f386 to be set to true

	mov		dx, beeperPortNGen
	lock		in al, dx
; if get here, not 386, set flag to false
	xor		ax, ax
End386Test:
	mov		vf_f386, al
	mov		sp, bp
	pop		bp
	ret		
TestFor386 endp

public Init386TestHandler

Init386TestHandler proc far
; get here only if 386
;
; zero FS/GS since they may contain garbage
	xor		ax, ax
;	mov		fs, ax
	db		8eh, 0E0h
;	mov		gs, ax	
	db		8eh, 0E8h

; set flags to true
	mov		al, 0FFh
	jmp		short End386Test
Init386TestHandler endp


public TestFor486
TestFor486 proc far
; execute a 486-only instruction, if InvalidOpCodeTrap is generated, clear
; vf.f486.
; Init486TestHandler has been installed by the caller of TestFor486.
	push		bp
	mov		bp, sp
	mov		vf_f486, 0ffh
	db 	0fh, 0c8h		; bswap eax
TestFor486Ret:
	mov		sp, bp
	pop		bp
	ret		
TestFor386 endp

public Init486TestHandler
Init486TestHandler proc far
	mov		vf_f486, 0
	jmp		short TestFor486Ret
Init386TestHandler endp




public TestForCoprocessor

TestForCoprocessor proc far
;  determine math coprocessor status
	push bp
	mov  bp, sp

;
; Better idea to always test for the chip, regardless of what
; kind of machine we are on.
;
;	test byte ptr vf_fPS2, 1 ;If a PS2, has a 386. The only supported 
;	jnz  TestFor387          ;coprocessor, a 80387, was init'ed by ROM
;	test byte ptr vf_fSGEN, 1 ;If a SGEN, has a 386 or 486. The only supported 
;	jnz  TestFor387          ;coprocessor, a 80387, was init'ed by ROM
;	test byte ptr vf_fpcAT, 1 ;If an AT, has a 386. The only supported 
;	jnz  TestFor387          ;coprocessor, a 80387, was init'ed by ROM

	xor  ax, ax
	lmsw ax  ; clear MP, EM (does not effect PE,TS,ET)
	clts
	dw   0E3DBh                              ; finit
	db   9Bh                                 ; wait
	dw   03EDDh, OFFSET DGROUP: EXCX87       ; fstsw EXCX87
	mov  ax, excx87
	or   al, al
	jnz  CoprocessorNotPresent

	mov  bCoprocessorStatus, 2 ; 80287 present

%if (not %ctosv) then (
	test byte ptr vf_f386, 1
	jnz  TestFor387

; on 286, see if coprocessor is reset when finger is given

	db		9Bh
	dw		0ECD9h					; fldpi

	mov		si, 0
	lea		bx, dpPi1
	db		09bh	; wait
	db		0DBh	; fstp long-real
	db		38h		; [bx][si]

	db		9Bh
	dw		0ECD9h					; fldpi

; give the finger and return
	mov		ax, sgLowMem
	mov		es, ax
	mov		ax, finger_saIntReturn
	mov		word ptr [pRmosRet+2], ax
; to give the finger, call a real mode procedure that just
; returns
	push	ax
	lea		ax, pRmosRet
	push	ax
	call	CallVideoRom ; not really calling rom

; read value from 287
	mov		si, 0
	lea		bx, dpPi2
	db		09bh	; wait
	db		0DBh	; fstp long-real
	db		38h		; [bx][si]

	xor     dx, dx
; compare for valid data
	push	ds
	pop		es
	lea		si, dpPi1
	lea		di, dpPi2
	mov		cx, 4
	cld
	repz	cmpsw
	jz		CoprocessorPresent

; if miscompare, then 287 was reset on finger
	mov		dl, 0FFh
	jmp  short CoprocessorPresent
) fi

TestFor387:
; on 386, determine if 287 or 387 using msw.et bit
	xor dx, dx ; f287ResetOnFinger = false
	smsw ax
	test ax, maskET
	jz   CoprocessorPresent
	mov  bCoprocessorStatus, 3 ; 80387 present

CoprocessorPresent:
	mov  ax, maskTSandMP
	jmp  short UpdateMSW
CoprocessorNotPresent:
	xor  ax, ax
	mov  dx, ax
UpdateMSW:
	lmsw ax
%if (not %ctosv) then (
	mov  bx, sgLowMem ; access to finger area
	mov  es, bx
	mov  finger_RmosMSW, ax
	xor  ax, ax
	mov  finger_pidCoprocessor, ax
	mov  finger_f287ResetOnFinger, dl
)fi
	pop  bp
	ret
TestForCoprocessor endp

public InitGPFault
InitGPFault proc far
	push ercGpFault
	push ax
	lea ax, rgbGpFault
	jmp InitFault
InitGpFault endp

public InitDoubleFault
InitDoubleFault proc far
	push ercDoubleFault
	push ax
	lea ax, rgbDoubleFault
	jmp InitFault
InitDoubleFault endp

public InitDivideFault
InitDivideFault proc far
	push 0			;CPU does not push status
	push ercDivideOverflow
	push ax
	lea ax, rgbDivideFault
	jmp InitFault
InitDivideFault endp

public InitOverflowFault
InitOverflowFault proc far
	push 0			;CPU does not push status
	push ercOverflow
	push ax
	lea ax, rgbOverflowFault
	jmp InitFault
InitOverflowFault endp

public InitRangeFault
InitRangeFault proc far
	push 0			;CPU does not push status
	push ercBoundsCheck
	push ax
	lea ax, rgbRangeFault
	jmp InitFault
InitRangeFault endp

public InitBogusTssFault
InitBogusTssFault proc far
	push ercGpFault		;there is no error code for this !
	push ax
	lea ax, rgbBogusTssFault
	jmp InitFault
InitBogusTssFault endp

public InitNotPresentFault
InitNotPresentFault proc far
	push ercNotPresentFault
	push ax
	lea ax, rgbNotPresentFault
	jmp InitFault
InitNotPresentFault endp

public InitStackFault
InitStackFault proc far
	push ercStackFault
	push ax
	lea ax, rgbStackFault
	jmp InitFault
InitStackFault endp

InitFault proc near
	push ax
	push ds
	mov ax, DGroup
	mov ds, ax
	push es
	push ss
	push bx
	push cx
	push dx
	push si
	push di
	push bp
	mov ax, 0A0A0h
	push ax
	mov bp, sp

	call ReportInitFault

InitFault endp

public InitXBusTimeout
InitXBusTimeout proc far
	push ds
	push ax
	mov  ax, DGroup
	mov  ds, ax
ASSUME DS:DGroup
	mov  vfNmiOccurred, 0FFh
	test fIgnoreBusTimeout, 1
	jnz  IXBTRet
	pop  ax
	pop  ds
	push 0                          ; InitFault expects selector from CPU
	push ercBusError
	push ax
	lea  ax, rgbXBusTimeout
	jmp  InitFault
IXBTRet:
	push dx
	mov  dx, lXBusAdapterStatusSGen ; Reading status clears interrupt.
	in   al, dx
	mov  dx, cascadeOcw28259PS2     ; Issue a non-specific EOI
	mov  al, 20h
	out  dx, al
	pop  dx
	pop  ax
	pop  ds
	iret
	jmp  InitXBusTimeout
InitXBusTimeout endp

; If CPU INT is asserted when ints are disabled, and the 8259 controller is 
; reset or the IMR is changed before the interrupt acknowledge, the 8259 may 
; return a default vector.  During boot this is ok so ignore it.  On some 
; machines the default vector is shared with a device, and a real device 
; interrupt which gets to one of these default handlers is fatal.  We can tell 
; the two apart because the ISR bit is not set when the 8259 returns a default 
; vector.  The device int case should never happen so the non-informative 
; ercInconsistency is good enough.  

public InitDefaultInt
InitDefaultInt proc far
	push dx
	push ax
	mov  dx, ocw2_8259		; Read ISR
	in   al, dx
	test al, 80h			; Bit set if real device interrupt
	jnz  DefaultIntFatal
	pop  ax
	pop  dx
	iret
	jmp  InitDefaultInt
DefaultIntFatal:
	pop  ax
	pop  dx
	push 0					; CPU does not push status
	push ercInconsistency
	push ax
	lea  ax, rgbDefaultInt
	jmp  InitFault
InitDefaultInt endp

public InitDefaultIntCascade
InitDefaultIntCascade proc far
	push dx
	push ax
	mov  dx, cascadeOcw2_8259
	in   al, dx
	test al, 80h
	jnz  DefaultIntFatal
	pop  ax
	pop  dx
	iret
	jmp  InitDefaultIntCascade
InitDefaultIntCascade endp

public InitDefaultIntExternal
InitDefaultIntExternal proc far
	push dx
	push ax
	mov  dx, ext8259_Ocw2
	in   al, dx
	test al, 80h
	jnz  DefaultIntFatal
	test vf_fSGen, 1
	jz   NoISP
	mov  dx, 9Ch			; Clear ISP interrupt block flip-flop
	mov  al, 0
	out  dx, al
NoISP:
	pop  ax
	pop  dx
	iret
	jmp  InitDefaultIntExternal
InitDefaultIntExternal endp

public InitNmiFault
InitNmiFault proc far
	push ax
	push ds
	mov  ax, DGroup
	mov  ds, ax
	mov  vfNmiOccurred, 0FFh
	test vfNmiTest, 1
	pop  ds
	pop  ax
	jnz  INFRet
	push 0DEADh		;signature for ReportInitFault
	push ercUnknownNonMask
	push ax
	lea  ax, rgbNmiFault
	jmp  InitFault
INFRet:
	call NmiEnableAll
	iret
InitNmiFault endp

; InitNmiHandler: procedure reentrant public;
;   Called from InitNmiFault, via ReportInitFault.
;   Use this instead of NmiTaskFault because the task has not yet been created.
;   This is a RAW interrupt handler, must IRET.

public InitNmiHandler
InitNmiHandler proc far

	push bp
	mov  bp, sp
	mov  vfNmiOccurred, 0FFh

	; Shouldn't get here if not SRP
	mov  bx, ercInconsistency
	test vf_fMF, 1
	jnz  WeAreSRP
	jmp  INHCrash

WeAreSRP:
	; Read status before disabling.	
	mov  dx, nmiSourcePort
	in   ax, dx
	mov  crashNmiStatus, ax
	mov  dx, nmiAddrLow
	in   ax, dx
	mov  crashNmiAddrLow, ax
	mov  dx, nmiAddrHigh
	in   ax, dx
	mov  crashNmiAddrHigh, ax
	call NmiDisableAll

	mov  ax, crashNmiStatus

	; BUS TIMEOUT
	mov  bx, ercBusTimeout
	test ax, busTimeoutBit
	jz   INHCrash

	; NON-EXISTENT LOCAL MEMORY
	mov  bx, ercMemProtect
	test ax, nonExistentMemoryBit
	jz   INHCrash

	; MAPPER WRITE VIOLATION, same erc as non-existent local memory
	test ax, writeViolationBit
	jz   INHCrash

	; BUS ERROR
	mov  bx, ercBusError
	test ax, busErrorbit
	jz  INHCrash

	; POWER FAILURE
	mov  bx, ercPowerFail
	test ax, powerFailBit
	jnz  NotPowerFail
	mov  fReboot, 0
	jmp  INHCrash

NotPowerFail:
	; PARITY ERROR
	mov  bx, ercParity
	test ax, doubleBitErrorBit
	jnz  NotParity
	mov  dx, eccSyndromePort
	in   ax, dx
	mov  crashEccSyndrome, ax
	jmp  INHCrash

NotParity:
	mov  bx, ercUnknownNonMask

INHCrash:
	push bx
	call Crash

InitNmiHandler endp

public EnableCache
EnableCache proc far

	push bp
	mov  bp, sp

	push sgSpare      ; pa 0, limit 0FFFFh, writeable
	push 0
	push 0
	push 0FFFFh
	push accessWritableData
	call BuildGdtSlot ; returns sgSpare in ax

	push ds
	push ax

	mov  dx, configPort
	in   ax, dx
	or   ax, cacheEnable		; cache enable, force miss
	and  ax, tagCompDisable
	out  dx, ax
	mov  cx, 07FFFh				; 64kb read to flush cache
	xor  si, si
	test byte ptr vf_f386, 1
	pop  ds
	jz	@10
	shr	cx,1					; dword count is 1/2 word count
%repd %lodsd					; address size = 16, operand size = 32
	jmp	@20
@10:	repz lodsw					; 286 compatible code
@20:	in   ax, dx
	or   ax, tagCompEnable		; allow normal hit/miss
	out  dx, ax

	pop  ds
	pop  bp
	ret
	
EnableCache endp


$MOD386
; FTestCache must be passed a pointer to a 64kb work area.
;
; FTestCache: procedure(pTestArea) flag public
; declare pTestArea pointer
; end FTestCache

pTestArea	equ	dword ptr [bp+6]

public FTestCache
FTestCache proc far

	push bp
	mov  bp, sp

; Determine pa of test area

	les  di, pTestArea
	push es
	push di
	call PaFromP
	mov  pa_High, dx			; this is the tag for the data

; Build pointer to tag ram

	push sgSpare				; sn, pa, limit 0FFFFh, writeable
	push 0D000h					; pa of tag ram = 0D000$0000h
	push 0
	push 0FFFFh
	push accessWritableData
	call BuildGdtSlot			; returns sgSpare in ax
	mov  fs, ax

; Initialize the memory locations to be used in cache test

	xor  edi, edi				; 32 bit writes
	les  di, pTestArea
	mov  cx, 4000h				; 16K dwords

@0:	mov  es:[di], edi			; write 64kb with 4*n in high word
	add  edi, 40004h			; offset + 4*n in low word
	loop @0

; Calculate the low order 16 bits of the addresses of this procedure's 
; instructions.  This is done because the instructions are cached during
; execution and the tags that correspond to the offsets of the
; instructions may not match the tags of the data cached. 

	mov  bx, offset TestStart
	push cs
	push bx
	call PaFromP				; returns pa of TestStart in dx,ax
	and  ax, 0FFFCh				; dword round down
	push ax

	mov  bx, offset TestEnd
	push cs
	push bx
	call PaFromP				; returns pa of TestEnd in dx,ax
	add  ax, 13h				; 16 byte prefetch, dword round up
	and  ax, 0FFFCh

	xor  esi, esi
	pop  si						; offset of TestStart
	shl  esi, 16
	mov  si, ax					; esi is TestStart,TestEnd

; Enable cache, force miss

	mov  dx, configPort
	in   ax, dx
	mov  wSaveConfig, ax
	or   ax, cacheEnable
	and  ax, tagCompDisable
	out  dx, ax

	xor  edi, edi
	les  di, pTestArea
	mov  ebx, edi				; save offset for later use
	mov  cx, 04000h
	mov  bp, pa_High			; for tag check

TestStart:
; Don't do DS or SS references while testing cache, messes up tag ram.

; Initialize the cache tags and data by reading 16k dwords from
; initialized memory with forced misses.

@1: mov  eax, es:[di]
	add  di, 4
	loop @1

; Allow normal hit/miss operation

	mov  dx, configPort
	in   ax, dx
	or   ax, tagCompEnable
	out  dx, ax

; Test the data in the cache

	mov  edi, ebx
	mov  cx, 04000h
ReadData:
	mov  eax, es:[di]			; read location, probably in cache
	cmp  eax, edi				; test value
	je   DataOk
	jmp  FTCFail
DataOk:
	add  edi, 40004h
	loop ReadData

;  Read the tag ram, and verify the contents of the cache

	mov  cx, 04000h
	xor  ebx, ebx

ReadTag:
	mov  eax, fs:[bx]			; read the tag ram
	and  eax, 07FFh				; only 11 bits
	cmp  bp, ax					; test the tag
	je   TagOk
	rol  esi, 16
	cmp  bx, si					; if Start < offset < End then ok
	jb   TagBad
	rol  esi, 16
	cmp  bx, si
	jbe  TagOk
TagBad:
	jmp  FTCFail
TagOk:
	add  bx, 4
	loop ReadTag

TestEnd:

	push 0FFh
	jmp  FTCRet

FTCFail:
	push 0

FTCRet:
	mov  dx, configPort
	mov  ax, wSaveConfig
	out  dx, ax
	pop  ax
	pop  bp
	ret  4
	
FTestCache endp

%if(%ctosp)then(
public Disable486Cache
Disable486Cache proc far
; 
; The code below needs to run under mod386 assembly
	db   0fh,08h					; invalidate cache
	MOV  EAX,CR0
	OR   EAX,060000000h				; turn on CD and NW bits in CR0 reg.
	MOV  CR0,EAX
	JMP	 $+2
	RET
Disable486Cache endp

public Enable486Cache
Enable486Cache proc far
	db	 0fh,08h					; invalidate cache
	MOV  EAX,CR0
	AND  EAX,9FFFFFFFh				; Turn off CD and NW bits in CR0 reg.
	MOV  CR0,EAX
	RET
Enable486Cache endp
)fi

$MOD286


public EnablePaging
EnablePaging proc far
; procedure (paPageMap)
paHigh equ word ptr [bp+8]
paLow  equ word ptr [bp+6]
	push bp
	mov  bp, sp
; load CR3 with address of page map
	db   66h 
	mov  ax, paLow     ; mov eax, paPagemap
	db 0Fh, 22h, 018h  ; mov cr3, eax


; turn on paging bit in CR0
	mov  ax, 8000h
	db   66h
    shl  ax, 16 ; shl eax, 16
	smsw ax
	or ax, 20h ; set NE bit to enable 486 coprocessor error interrupt
	db 0Fh, 22h, 000h  ; mov cr0, eax
	pop bp
	ret
EnablePaging endp


public LoadGDTR
LoadGDTR proc far

	push bp
	mov bp, sp
	les bx, dword ptr [bp+6]

	mov ax, es:[bx]
	mov [dT], ax
	mov ax, es:[bx+2]
	mov [dT+2], ax
	mov ax, es:[bx+4]
	mov [dT+4], ax

	test vf_f386, 1
	jz LoadGdtr286
	db 66h
LoadGdtr286:
	lgdt dt
DoneLoadGdtr:
	pop bp
	ret 4
LoadGDTR endp

public LoadIDTR
LoadIDTR proc far
	push bp
	mov bp, sp
	les bx, dword ptr [bp+6]

	mov ax, es:[bx]
	mov [dT], ax
	mov ax, es:[bx+2]
	mov [dT+2], ax
	mov ax, es:[bx+4]
	mov [dT+4], ax

	test vf_f386, 1
	jz LoadIdtr286
	db 66h
LoadIdtr286:
	lidt dt
DoneLoadIdtr:
	pop bp
	ret 4
LoadIDTR endp

public LoadTR


LoadTR proc far

; procedure(sgTSS)
;
; loads TR with sgTSS

push bp
mov bp, sp
mov ax, word ptr [bp+6]

ltr ax

pop bp
ret 2
LoadTR endp

public FetchTR
FetchTR proc far

; procedure word
;
; Returns TR 

push bp
mov bp, sp
str ax

pop bp
ret 
FetchTR endp

public InitSgRealInterface
InitSgRealInterface proc far
assume ds:DGroup
%if(%ctosv)then(
	mov bx, seg V86Emulator
	and bx, 0FFF8h
	mov sgRealInterface, bx
; need limit of this code segment to be 0FFFFh so we can go back into
; true real mode for bootstrap
	mov ax, sgGdt
	mov es, ax
	mov desc286Limit, 0FFFFh
)else(
	mov bx, seg RealDispatcher
	mov sgRealInterface, bx
	test vf_f386, 1
	jz  InitIpRealDispatcher

; for 386 RMOs, set limit of real dispatcher to 0FFFFh
; and make linear address = physical address

	mov ax, sgGdt
	mov es, ax
	mov desc286Limit, 0FFFFh
	mov desc386BaseMsb, 0

	mov bx, sgIdentityLowMem
	mov desc386BaseMsb, 0

InitIpRealDispatcher:
)fi
	mov	ax, offset RealDispatcher
	mov ipRealDispatcher, ax
	ret
InitSgRealInterface endp

public MoveOsData
MoveOsData proc far
; procedure(pTarget,cwData)

pTarget equ dword ptr [bp+8]
sgTarget equ word ptr [bp+10]
cwData equ word ptr [bp+6]

	push	bp
	mov 	bp, sp
	pushf
	cli
	push	ds
	push	ss
; this is the stack that gets copied

; copy data
	xor		si, si
	mov		cx, cwData
	les		di, pTarget
	cld
	repnz	movsw
;copy descriptor
	mov		si, sgTarget
	and		si, 0FFF8h
	mov		di, ds
	and		di, 0FFF8h
	mov		ax, sgGdt
	mov		es, ax
	mov		ds, ax
	mov		cx, 4
	repnz	movsw
;update SS and DS caches
	pop		ss
	pop		ds
	popf
	pop		bp
	ret		6

MoveOsData endp

public Get287InitState
Get287InitState proc far
	push	bp
	mov		bp, sp
	pushf
	cli
	clts
	dw   0E3DBh                              ; finit
	les		bx, dword ptr [bp+6]
	db		09bh, 026h, 0ddh, 037h, 09bh		;fnsave	es: byte Ptr[bx], wait
	popf
	pop		bp
	ret		4
Get287InitState endp


;NonDestructiveScrub: procedure(pa, cPar) reentrant;
;declare pa paType;
;declare cPar word;
;declare pw pointer;
;
;pw = build$ptr(BuildGdtSlot(sgSpare,pa,shl(cPar,4)-1,accessWritableData),0);
;call movw(pw,pw,shl(cpar,3));
;end NonDestructiveScrub;

;This routine accomplishes the above PLM but uses quad moves for speed.

argcPar EQU [BP+6]
argpa   EQU [BP+8]

Public NonDestructiveScrub
NonDestructiveScrub PROC FAR
	PUSH BP
	MOV  BP, SP
	PUSH sgSpare
	PUSH argpa+2
	PUSH argpa
	MOV  AX, argcPar
	SHL  AX, 4
	DEC  AX
	PUSH AX
	PUSH accessWritableData
	CALL BuildGdtSlot
;	AX is sgSpare

	PUSH DS
	MOV  ES, AX
	XOR  DI, DI
	XOR  SI, SI
	XOR  CX, CX
	MOV  CX, argcPar
	CLD
	test byte ptr vf_f386, 1
	MOV  DS, AX
	jz	@11
	SHL  CX, 2        ; count of dwords
%REPD %MOVSD          ; address size = 16, operand size = 32
	jmp	@21
@11:SHL  CX, 3        ; count of words
	repz movsw					; 286 compatible code
@21:	POP  DS
	POP  BP
	RET  6
NonDestructiveScrub ENDP


;DestructiveWash: procedure(pa, cPar) reentrant;
;declare pa paType;
;declare cPar word;
;declare pw pointer;
;
;pw = build$ptr(BuildGdtSlot(sgSpare,pa,shl(cPar,4)-1,accessWritableData),0);
;call setw(0,pw,shl(cpar,3));
;end DestructiveWash;

;This routine accomplishes the above PLM but uses quad writes for speed.

Public DestructiveWash
DestructiveWash PROC FAR
	PUSH BP
	MOV  BP, SP
	PUSH sgSpare
	PUSH argpa+2
	PUSH argpa
	MOV  AX, argcPar
	SHL  AX, 4
	DEC  AX
	PUSH AX
	PUSH accessWritableData
	CALL BuildGdtSlot
;	AX is sgSpare

	MOV  ES, AX
	XOR  DI, DI
	test byte ptr vf_f386, 1
	jz  .+3
	db 66h
	XOR  AX, AX       ; xor EAX, EAX
	XOR  CX, CX
	MOV  CX, argcPar
	CLD
	test byte ptr vf_f386, 1
	jz	@12
	SHL  CX, 2        ; count of dwords
%REPD %STOSD          ; address size = 16, operand size = 32
	jmp	@22
@12:
	SHL  CX, 3        ; count of words
	repz stosw					; 286 compatible code
@22:	POP  BP
	RET  6
DestructiveWash ENDP


q		EQU dword ptr [BP+6]
pMem	EQU	dword ptr [BP+10]

$MOD386
Public CheckEccSub
CheckEccSub PROC FAR
	PUSH BP
	MOV  BP, SP
	MOV  EBX, q					; Setup for write while check bits enabled.
	LES  DI, pMem
	MOV  DX, nmiSourcePort		; Read ports to clear any NMIs and re-arm.
	IN   AX, DX
	MOV  DX, nmiAddr
	IN   EAX, DX
	MOV  DX, configPort			; Disable correction and check bits.
	IN   AX, DX
	AND  AX, notEccBitMask
	OR   AX, eccDisable
	OUT  DX, AX
	MOV  ES: dword ptr [DI], EBX	; Induce the bit error(s).
	IN   AX, DX						; Enable correction and check bits.
	AND  AX, notEccBitMask
	OR   AX, eccEnable
	OUT  DX, AX
	POP  BP
	RET  8
CheckEccSub ENDP
$MOD286


InitP_code ends

end

; Change log
;
; 4/18/86  DR  created
; 8/30/86  DR  RMOS support in InitSgRealInterface
; 10/13/86 DR  RelocateOsData
; 04/01/87 DR  determine coprocessor status
; 04/07/87 DR  TestForCoprocessor, Get287InitState
; 06/22/87 DR  if 386, zero FS/GS
; 09/15/88 JA  NonDestructiveScrub use 32-bit MOVW.
; 09/21/88 JA  Fix NonDestructiveScrub (CLD, XOR ECX).
; 09/26/88 JA  use vf_f386...
; 05/19/89 AT  Fix NonDestructiveScrub, (REP MOVSW).
;              Add DestructiveWash, EnableCache.
; 06/07/89 AT  TestCache.
; 12/06/89 AT  Moved InitNmiHandler from Nmi_all.plm.
; 12/28/89 AT  InitNmiFault returns if vfNmiTest is TRUE.
; 01/19/90 SAH moved strings to SysGen.mdf
; 02/20/90 DR  v series doesn't use finger area or 286 reset test.
; 02/28/90 AT  Add CheckEccSub to support CheckEcc in InitOsSubs_all.plm.
; 05/22/90 JMR 32 bit string opperations not on 286.
; 08/01/90 GWH Added routines to enable/disable 486 internal cache.
; 10/01/90 JA  NonDestructiveScrub bad label, SHL CX,3 put back.
; 10/13/90 AT  Add InitXBusTimeout.
; 11/05/90 AT  InitXBusTimeout display on LED for SuperGen P1 debugging.
; 04/04/91 AT  Add InitDefaultInt*.
; 05/15/91 AT  Cleaned up 'P1 debugging' code.
; 06/04/91 DR  In v series, set MSW in coprocessor test
; 07/31/91 FW  Std PC platform support.
; 02/14/92 DR  Always try and use coprocessor to see if it is there
; 06/05/92 DR  turn on NE bit in CR0 when enable paging - prevents a system
;              hang on the 486 following coprocessor error
