;	InitDev.asm
;
$INCLUDE(:f1:ioaddr1.edf)
 
;Constants used for the interval timer(8253)

INTVTIMER	EQU	030H
LATCH		EQU	0H
MCW53		EQU	02eH
COUNTER0	EQU	028H
; Hardware types
;IWS         EQU 0
NGen        EQU 4
; Processor types
;t1          EQU 4
t2          EQU 5
NGen86      EQU 6
;cws186      EQU 7
;Gws         EQU 8
NewGen      EQU 9
PS2         EQU 12
B38lcw      EQU 14
SG5000		EQU 15
PCAT        EQU 16
Comarch     EQU 17

;Constants used for the interrupt chip(8259)

NSEOI		EQU	020H
INIT1_8259_NGENMASTER	EQU	19H
INIT1_8259_PCATMASTER	EQU	11H    ;NOTE: sets up master as level triggered.
INIT3_8259_NGENMASTER	EQU	80H
INIT3_8259_PS2MASTER    EQU 04H  
INIT4_8259_NGENMASTER	EQU	1Dh
;INIT4_8259_PCATMASTER	EQU	01h    ;no special fully nested mode
INIT4_8259_PCATMASTER	EQU	011h   ;allow special fully nested mode  *FW*
INIT4_8259_PS2MASTER	EQU	11h	
INIT1_8259_NGENSLAVE	EQU	19H
INIT1_8259_PCATSLAVE	EQU	11H    ;NOTE: slave is edge-triggered too.
INIT3_8259_NGENSLAVE	EQU	07H
INIT3_8259_PS2SLAVE     EQU 02H   
INIT4_8259_NGENSLAVE	EQU	09h
INIT4_8259_PS2SLAVE		EQU	01h		
INIT_8259_OCW3		EQU	0Bh
IMASK_NGEN    		EQU	0FFh
Ext8259_ICW1	EQU 214h
Ext8259_ICW2	EQU 215h



;Constants used for PPI(8255)--for LED display

RETSIZE		EQU	4
CNTL55		EQU	046H
INT55		EQU	080H
PORTC		EQU	044H

;Constants used for USART(8251)--for Hazeltine terminal

RESET51		EQU	040H
TRENABLE51	EQU	026H
TxRDY		EQU	01
RxRDY		EQU	02
RateGenMode	EQU	0b6H
Counter2	EQU	02cH
UartMode	EQU	04eH
RcvEnable	EQU	026H
ForceToCommandMode EQU	082H

;Constants used for 6402 uart (NewGen Kbd)

reset6402  equ  20h

DGroup	Group	Data

Data	SEGMENT	PUBLIC	'Data'
EXTRN	hardwareType: BYTE
EXTRN	processorType: BYTE
EXTRN	fSFNM: BYTE
EXTRN	kbdControlReg: WORD
EXTRN	OCW1_8259: WORD
EXTRN	OCW2_8259: WORD
EXTRN	cascadeOCW1_8259: WORD
EXTRN	cascadeOCW2_8259: WORD
EXTRN	modeWord8254NGen: WORD
EXTRN	ioCommCtlA: WORD
EXTRN	ioCommCtlB: WORD
EXTRN	counter28254NGen: WORD
EXTRN	pcSarH: WORD
EXTRN	pcrH: WORD
EXTRN	vf: BYTE
EXTRN	cPort: WORD
EXTRN	DmaMask:WORD

EXTRN	bIntVectorBase:         BYTE
EXTRN	bIntVectorBaseCascade:  BYTE
EXTRN	bIntVectorBaseExternal: BYTE
Data	ENDS

$INCLUDE(:f1:VfEqu.idf)

EXTRN	InitHandleDefaultInts: FAR
EXTRN	OutSub:FAR

PUBLIC	init186, Init8259, InitCounter, Init8255, Init8251
PUBLIC	Init8237, Init8274, InitComm2
PUBLIC Init6402

InitDev	Segment	PUBLIC	'Coed'
ASSUME CS:InitDev, DS:DGroup

$EJECT
InitCounter	PROC	FAR
	mov	AL, INTVTIMER
	out	MCW53, AL
	ret
InitCounter	ENDP
InitDev	ENDS


InitDev	Segment	PUBLIC	'Coed'
ASSUME CS:InitDev, DS:DGroup

Init186	PROC	FAR


;	CMP	processorType, cws186
;	JE	@CWS
;	CMP	processorType, Gws
;	JNE	@Ngen186
;	JMP	@GWS
;@Ngen186:
;	MOV	DX, 0FFA0H	; Initialize UMCS
;	MOV	AX, 0F83BH	; 32K Block, 3 Wait States, Ext Rdy Used
;	OUT	DX, AX
;	MOV	DX, 0FFA4H	; Initialize PACS
;	MOV	AX, 0FBFH	; Peripherals Start at F800
;	OUT	DX, AX
;	MOV	DX, 0FFA8H	; Initialize MPCS
;	MOV	AX, 81BBH	; Peripherals in I/O Space, 7 PCS Lines
;	OUT	DX, AX
;	MOV	DX, 0FF38H	; Initialize INT0 Control Register (8259)
;	XOR	AX, AX
;	MOV	AL, 40h		; SFNM bit
;	AND	AL, fSFNM
;	OR	AX, 0032H	; Cascade Mode, Priority = 2, Masked, Maybe SFNM
;	OUT	DX, AX
;	MOV	DX, 0FF32H	; Initialize Timer Control Reg (RTC)
;	MOV	AX, 000BH	; Priority = 3, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF3AH	; Initialize INT1 Control Reg (Not Used)
;	MOV	AX, 000EH	; Priority = 6, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF3EH	; Initialize INT3 Control Reg (Floppy)
;	MOV	AX, 000CH	; Priority = 4, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF34H	; Initialize DMA 0 Control Reg (PTR)
;	MOV	AX, 000DH	; Priority = 5, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF36H	; Initialize DMA 1 Control Reg
;	MOV	AX, 000EH	; Priority = 6, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF2AH	; Initialize Priority Mask Reg
;	MOV	AX, 0005H	; Mask All Interrupts with Priority > 5
;	OUT	DX, AX
;	JMP	InitKbdBaud

;@CWS:
;	MOV	DX, 0FFA0H	; Initialize UMCS
;	MOV	AX, 0FC3BH	; 32K Block, 3 Wait States, Ext Rdy Used
;	OUT	DX, AX
;	MOV	DX, 0FFA4H	; Initialize PACS
;	MOV	AX, 0FBFH	; Peripherals Start at F800
;	OUT	DX, AX
;	MOV	DX, 0FFA6H	;
;	MOV	AX, 0F9F8H	;
;	OUT	DX, AX
;	MOV	DX, 0FFA8H	; Initialize MPCS
;	MOV	AX, 82BBH	; Peripherals in I/O Space, 7 PCS Lines
;	OUT	DX, AX
;	MOV	DX, 0FF38H	; Initialize INT0 Control Register (RS422)
;	MOV	AX, 19H		; Priority = 1, masked
;	OUT	DX, AX
;	MOV	DX, 0FF3AH	; Initialize INT1 Control Reg (FD/HD)
;	MOV	AX, 1CH		; Priority = 4, masked
;	OUT	DX, AX
;	MOV	DX, 0FF3EH	; Initialize INT3 Control Reg (RS232/KBD)
;	MOV	AX, 18H		; Priority = 0, masked
;	OUT	DX, AX
;	MOV	DX, 0FF32H	; Initialize Timer Control Reg (RTC)
;	MOV	AX, 0BH		; Priority = 3, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF34H	; Initialize DMA 0 Control Reg (RS422)
;	MOV	AX, 09H		; Priority = 1, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF36H	; Initialize DMA 1 Control Reg (FLOPPY)
;	MOV	AX, 0CH		; Priority = 4, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF2AH	; Initialize Priority Mask Reg
;	MOV	AX, 04H		; Mask All Interrupts with Priority > 4
;	OUT	DX, AX
;	JMP	SHORT InitKbdBaud

;@GWS:
;	MOV	DX, 0FFA0H	; Initialize UMCS
;	MOV	AX, 0FC38H	; 32K Block, 0 Wait States, Ext Rdy Used
;	OUT	DX, AX
;	MOV	DX, 0FFA4H	; Initialize PACS
;	MOV	AX, 0FBAH	; Peripherals Start at F800
;;	OUT	DX, AX
;	MOV	DX, 0FFA6H	;
;	MOV	AX, 0F9F8H	;
;	OUT	DX, AX
;	MOV	DX, 0FFA8H	; Initialize MPCS
;	MOV	AX, 82BCH	; Peripherals in I/O Space, 7 PCS Lines
;	OUT	DX, AX
;	MOV	DX, 0FF3AH	; Initialize INT1 Control Register (RS422)
;	MOV	AX, 19H		; Priority = 1, masked
;	OUT	DX, AX
;	MOV	DX, 0FF38H	; Initialize INT0 Control Reg 8259 SFN mode
;	MOV	AX, 74H		; Priority = 4, masked
;	OUT	DX, AX
;	MOV	DX, 0FF3EH	; Initialize INT3 Control Reg (RS232/KBD)
;	MOV	AX, 18H		; Priority = 0, masked
;	OUT	DX, AX
;	MOV	DX, 0FF32H	; Initialize Timer Control Reg (RTC)
;	MOV	AX, 0BH		; Priority = 3, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF34H	; Initialize DMA 0 Control Reg (RS422)
;	MOV	AX, 09H		; Priority = 1, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF36H	; Initialize DMA 1 Control Reg (FLOPPY/TAPE/HD)
;	MOV	AX, 0CH		; Priority = 4, Masked
;	OUT	DX, AX
;	MOV	DX, 0FF2AH	; Initialize Priority Mask Reg
;	MOV	AX, 04H		; Mask All Interrupts with Priority > 4
;	OUT	DX, AX
;	RET				; Gws use hardware to support kbd baudrate

;InitKbdBaud:
;	MOV	DX, 0FF5AH	; Initialize Timer 1 (Kbd Baud) Max Cnt
;	MOV	AX, 26		; 52 x 1MHz = 20KHz/2 For Two Count Reg
;	OUT	DX, AX
;	CALL OutSub
;	MOV	DX, 0FF5CH	; Initialize Timer 1 (Kbd Baud) Max Cnt
;	MOV	AX, 26		; 52 x 1MHz = 20KHz/2 For Two Count Reg
;	OUT	DX, AX
;	CALL OutSub
;	MOV	DX, 0FF5EH	; Initialize Timer 1 (Kbd Baud) Mode Word
;	MOV	AX, 0C007H	; Interrupts Disabled, Continously Running
;	OUT	DX, AX
;	CALL OutSub
	RET
Init186	ENDP
InitDev	ENDS

$EJECT
InitDev	Segment	PUBLIC	'COED'
init8259	PROC	FAR
	cli
	CMP  vf_f82380, 0ffh			; if 82380 present, do not init here
	JNE  @T2orNGen86
	JMP  @fini2
@T2orNGen86:
; Here we Check for a SuperGen External Interrupt Control system.  If so 
; intialize it
	CMP processorType, SG5000
	JNE NoExt8259
	; Put timers in one-shot so they won't interrupt
	MOV DX,modeWord8254RtcSGen
	MOV AL,52h
	OUT DX,AL
	JMP $+2
	MOV DX,counter18254PitSGen
	MOV AL,1
	OUT DX,AL
	JMP $+2
	MOV DX,modeWord8254RtcSGen
	MOV AL,92h
	OUT DX,AL
	JMP $+2
	MOV DX,rtcCounter8254SGen
	MOV AL,1
	OUT DX,AL
	JMP $+2
	; Clear latches, AL contents don't matter
	MOV DX,pitLatchSGen
	OUT DX,AL
	JMP $+2
	MOV DX,rtcLatchSGen
	OUT DX,AL
	JMP $+2
	; Initialize the external 8259
	MOV DX,Ext8259_ICW1
	MOV AL,01Bh
	OUT DX,AL
	JMP $+2
	MOV DX,Ext8259_ICW2
	MOV AL,bIntVectorBaseExternal
	OUT DX,AL
	JMP $+2
	MOV AL,0Dh
	OUT DX,AL
	JMP $+2
	MOV AL,0FFh				; Mask all channels initially
	OUT DX,AL
	JMP $+2
	MOV DX,Ext8259_ICW1
	MOV AL,INIT_8259_OCW3	; Setup to read In-Service  port.
	OUT DX,AL
	JMP $+2

NoExt8259:
	mov	AL, INIT1_8259_NGENMASTER
	cmp processortype, PCAT     ;PCAT's have level-triggered ints.
	jne not_a_PCAT
	cmp vf_fPS2, 0FFh           ;PS2 does have level triggered interrupts FWPS2
	je  not_a_PCAT              ; FWPS2
	mov	AL, INIT1_8259_PCATMASTER
not_a_PCAT:
	mov	DX, OCW2_8259
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, bIntVectorBase
	mov	DX, OCW1_8259
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, INIT3_8259_NGENMASTER
	cmp processortype, b38lcw      
	je  aB38lcw
	cmp processortype, PCAT     ;
	je  aPC
    cmp processortype,SG5000         
    jne NotPS2a                   
aPC:
aB38lcw:
    mov AL, INIT3_8259_PS2MASTER  
NotPS2a: 
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, INIT4_8259_NGENMASTER
	cmp processortype, b38lcw      
	je  aB38lcw2
	cmp processortype, PCAT     ;
	je  aPC1
	cmp processortype,SG5000         
    jne NotPS2aa                   
aPC1:
aB38lcw2:
    mov AL, INIT4_8259_PS2MASTER  
NotPS2aa:
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, IMASK_NGen
	out	DX, AL
	jmp	$+2                     ;flush pipe
;*AA*
	mov	DX, OCW2_8259
	cmp processortype, PCAT
	je testForEisa
	jmp samePr
testForEisa:
	cmp vf_fEisaBus, 0ffh		;don't do it for sg4k/6k
	je samePr
rotatePr:
	mov al, 0c2h				;IRQ#2 lowest, IRQ#3 highest
	out dx, al
samePr:
	mov	AL, INIT_8259_OCW3
;	mov	DX, OCW2_8259			;*AA*
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, INIT1_8259_NGENSLAVE
	cmp processortype, PCAT     ;
	jne not_aPC2
	cmp vf_fPS2, 0FFh           ;PS2 does have level triggered interrupts FWPS2
	je  not_aPC2                ; FWPS2
	mov AL, INIT1_8259_PCATSLAVE
not_aPC2:
	mov	DX, cascadeOCW2_8259
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, bIntVectorBaseCascade
	mov	DX, cascadeOCW1_8259
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, INIT3_8259_NGENSLAVE
    cmp processortype, b38lcw      
    je  aB38lcw3                   
	cmp processortype, PCAT     ;
	je  aB38lcw3
    cmp processortype,SG5000
    jne NotPS2b                   
aB38lcw3:
    mov AL, INIT3_8259_PS2SLAVE     
NotPS2b: 
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, INIT4_8259_NGENSLAVE
    cmp processortype, b38lcw      
    je  aB38lcw4
	cmp processortype, PCAT
	je  aB38lcw4
	cmp processortype,SG5000         	; 
    jne NotPS2bb
aB38lcw4:
  mov AL, INIT4_8259_PS2SLAVE     
NotPS2bb:

	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, IMASK_NGen
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, INIT_8259_OCW3
	mov	DX, cascadeOCW2_8259
	out	DX, AL

	cmp processorType,SG5000
	jne notSG5000
	mov dx,int1ELCRegSGen
	mov al,090h					; LPT,16551 are level triggered
	out dx,al
	jmp $+2
	mov dx,int2ELCRegSGen
	mov al,0C8h					; Floppy,SCSI,Voice are level triggered
	out dx,al
	jmp $+2
notSG5000:
	cmp processortype, PCAT
	jne @FINI
	test vf_fEisaBus, 0FFh      ; Non-EISA PCs don't have this register *FW*
	jz  @FINI                   ;
	mov dx,int2ELCRegSGen       ; This is port address 4D1h
	in  al,dx
	or  al,080h					; Eisa doorbell int is edge triggered
	jmp $+2
	out dx,al

@FINI:
	call InitHandleDefaultInts
@FINI2:
	ret
init8259	ENDP
InitDev	ENDS

$EJECT
InitDev Segment PUBLIC 'COED'
Init8237 PROC FAR
	push bp
	mov  bp,sp
	cmp  hardwareType,NGen
	je   IsNGen
	jmp  Init8237Ret
IsNGen:
	cmp  processorType,T2
	je   IsT2orT3
	jmp  NotT2orT3
IsT2orT3:
	; Put DMA Chip 1, Channel 0 in cascade mode on T2/T3
	; (Chip 0 cascades into Chip 1, Channel 0)
	mov  dx,0F828h      ; Command
	mov  al,10h			; R&B ... Put t2's (except B28Lcw) and t3's in 
	cmp  vf_fXbus, 0FFh	;    rotating priority mode.
	je   ContinueT2orT3
	mov  al,0
ContinueT2orT3:			; ... R&B
	out  dx,al
	jmp  .+2
	mov  dx,0F83Ah      ; Mode
	mov  al,0C0h        ; Cascade
	out  dx,al
	jmp  .+2
	mov  dx,0F82Ah      ; Single mask
	mov  al,0
	out  dx,al
	jmp  .+2
	mov  dx,0F82Ch      ; Byte pointer flip-flop clear
	mov  al,0
	out  dx,al
	jmp  .+2
	; Put DMA Chip 0,Channel 1 in cascade mode (for mode-3 masters)
	mov  dx,0F810h      ; Command
	mov  al,0
	out  dx,al
	jmp  .+2
	mov  dx,0F816h      ; Mode
	mov  al,0C1h        ; Cascade, verify
	out  dx,al
	jmp  .+2
	mov  dx,0F814h      ; Single mask
	mov  al,1
	out  dx,al
	jmp  .+2
	mov  dx,0F818h      ; Byte pointer flip-flop clear
	mov  al,0
	out  dx,al
	test vf_f286,1
	jnz  IsT2
	jmp  Init8237Ret
IsT2:
	; T2 Mode-3 channel word count must not count down to zero, 
	; initialized here and reset to ones when the clock ticks.
	mov  al,0FFh
	mov  dx,0F806h
	out  dx,al
	jmp  .+2
	out  dx,al
	jmp  Init8237Ret

NotT2orT3:
	cmp  processorType,SG5000
	je   IsSGen
	jmp  NotSGen
IsSGen:
	; Disable all DMA channels except internal cascade
	mov  dx,dma1MaskAllSGen     ; ISP DMA 1 mask all
	mov  al,0Fh                 ; Set all mask bits
	out  dx,al
	jmp  .+2
	mov  dx,dma2MaskAllSGen     ; ISP DMA 2 mask all
	mov  al,0Eh                 ; Set all mask bits except internal cascade
	out  dx,al
	jmp  .+2
	; Put cluster channel in 16-bit, count by words, type B timing mode
	mov  dx,dma1ExtModeSGen
	mov  al,extModeTypeB+extMode16Word+commDmaChanSGen
	out  dx,al
	jmp  .+2
	; Put floppy channel in 8-bit, count by bytes, type B timing mode
	mov  dx,dma1ExtModeSGen
	mov  al,extModeTypeB+extMode8Byte+floppyDmaChanSGen
	out  dx,al
	jmp  .+2
	; Put hard disk channel in 16-bit, count by words, type B timing mode
	mov  dx,dma2ExtModeSGen
	mov  al,extModeTypeB+extMode16Word+hDiskDmaChanSGen
	out  dx,al
	jmp  .+2
	; Put LPT channel in 8-bit IO, count by bytes, compatible timing mode
	mov  dx,dma2ExtModeSGen
	mov  al,extModeCompatible+extMode8Byte+lptDmaChanSGen
	out  dx,al
	jmp  .+2
	; Enable LPT DMA
	mov  dx,lptDmaEnableSGen
	mov  al,0h
	out  dx,al
	jmp  .+2
	; Enable RS232 Tx DMA
	mov  dx,rs232txEnableSGen
	mov  al,0h
	out  dx,al
	jmp  .+2
	; Enable RS232 Rx DMA
	mov  dx,rs232rxEnableSGen
	mov  al,0h
	out  dx,al
	jmp  .+2
	; Setup Cascaded DMA for comm
	mov  dx,dma1ModeSGen    ; Mode register for ISP DMA1
	mov  al,modeCascade+cascadeExtDmaChanSGen   ; Cascade mode for channel 1
	out  dx,al
	jmp  .+2
	mov  dx,dma1MaskSGen    ; Mask register for ISP DMA1
	mov  al,dmaMaskClear+cascadeExtDmaChanSGen      ; Enable for channel 1
	out  dx,al
	jmp  .+2
	; Set flip-flops to known state
	mov  dx,dma1BytePtrClrSGen  ; ISP DMA1 byte pointer flip-flop clear
	mov  al,0
	out  dx,al
	jmp  .+2
	mov  dx,dma2BytePtrClrSGen  ; ISP DMA2 byte pointer flip-flop clear
	mov  al,0
	out  dx,al
	jmp  Init8237Ret

NotSGen:
	cmp  processorType,NewGen
	je   IsNewGen
	jmp  NotNewGen
IsNewGen:
	; disable all dma channels
	mov  dx,801Eh       ; mask all
	mov  al,0Fh
	out  dx,al
	jmp  short Init8237Ret

NotNewGen:
	cmp  processorType,B38lcw
	je   aB38lcwDMA
	jmp  short NotaB38lcw
aB38lcwDMA:
	mov  dx,0D6h	; DMA1 is cascaded to DMA2 channel 0
	mov  al,0C0h
	out  dx,al
	jmp  .+2
	mov  dx,0D4h	; Enable cascade by resetting mask
	mov  al,0h
	out  dx,al
	jmp  .+2		; R&B ... Put DMA2 in rotating priority mode
	mov  dx,0D0h
	mov  al,10h
	out  dx,al		; ... R&B
	jmp  short Init8237Ret

NotaB38lcw:
	cmp  processorType,PCAT  ;
	jne  NotaPCAT
	xor  al,al
	mov  dx,0Dh     ; Reset DMA1 controller (write Master clear register)
	out  dx,al
	jmp  .+2

	mov  dx,08h     ; Clear DMA1 command register
	out  dx,al
	jmp  .+2

;	xor  al,al       ; AL already zero
	mov  dx,0DAh     ; Reset DMA2 controller (write Master Clear register)
	out  dx,al
	jmp  .+2

	mov  dx,0D0h     ; Clear DMA2 command register
	out  dx,al
	jmp  .+2

	mov  dx,0D6h    ; DMA1 is cascaded to DMA2 channel 0
	mov  al,0C0h
	out  dx,al
	jmp  .+2

	mov  dx,0D4h    ; Enable cascade by resetting mask
	xor  al,al
	out  dx,al

	jmp  Init8237Ret

NotaPCAT:
Init8237Ret:
	pop  bp
	ret
Init8237 ENDP
InitDev ENDS

$EJECT
InitDev	Segment	PUBLIC	'COED'
init8255	PROC	FAR
	mov	AL, INT55
	out	CNTL55, AL
	ret
init8255	ENDP
InitDev	ENDS

$EJECT
InitDev	Segment	PUBLIC	'COED'
Delay proc near
; cpu busy wait 
	push ax
;	push cx
;DelayLoop:
;	mov cx, 100h
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
	shl ax, 8
;	loop DelayLoop
;	pop cx
	pop ax
	ret
Delay endp

init8251	PROC	FAR
	cmp	processorType, t2
	je	@T2
	cmp	processorType, b38lcw
	je	@b38Lcw
;	cmp	processorType, NewGen
;	je	@Return
;	cmp	processorType, SG5000
;	je	@Return
	cmp processortype, PCAT     ;Need to set up speaker timer since BIOS
	jne @Return                 ;on some machines (ZDS) leaves it bogus.
	mov dx, modeWord8254NGEN    ;timer mode register
	mov al, 0B6h                ;free run, load both bytes
	out dx, al                  ;send command
	call delay                  ;flush pipe
	mov dx, counter28254NGen    ;timer data
	xor al, al                  ;
	out dx, al                  ;send command
	call delay                  ;flush pipe
	mov al, 5                   ;
	out dx, al                  ;send command
@Return:
	ret

@B38Lcw:
	mov	DX, modeWord8254B38LCWComm	;  keyboard timer
	mov	AL, 036H					;  timer 0, square
	out	DX, AL
	call Delay
	mov	DX, counter08254B38LCWComm 
	mov	AL, 0H						; low byte
	out	DX, AL
	call Delay
	mov	AL, 1						;  high byte = 256.
	out	DX, AL
	call Delay
	jmp	short IWSorT1

@T2:
;	MOV AX, 2			; reset EM bit in MSW
;	DB 0Fh,01h,0F0h		; LMSW AX

	mov	DX, modeWord8254NGen
	mov	AL, 0B6H
	out	DX, AL
	call Delay
	mov	DX, counter28254NGen
	mov	AL, 34H
	out	DX, AL
	call Delay
	mov	AL, 0
	out	DX, AL
	call Delay
	jmp	short IWSorT1

@8086NGen:
	mov	DX, modeWord8254NGen
	mov	AL, 0B6H
	out	DX, AL
	mov	DX, counter28254NGen
	mov	AL, 7FH
	out	DX, AL
	mov	AL, 01H
	out	DX, AL

IWSorT1:
	mov	BX, 3
	mov	DX, kbdControlReg
@1:
	cmp	BX, 0
	je	@2
	mov	AL, ForceToCommandMode	; 82h, Enter hunt mode, Data terminal ready
	out	DX, AL
	call Delay
	dec	BX
	jmp	@1
@2:
	mov	AL, RESET51	; 40h
	out	DX, AL

; The 8251 needs at least 7 uS to process the reset command.
	call Delay
	CALL Delay			; Extra delay for B38GXP
	mov	AL, UartMode	; 4eh, async mode (16Xbaud rate), 1 stop bit,
				;odd parity, parity-disable, 8-bit char
	out	DX, AL
	call Delay
	mov	AL, TREnable51	; 27h, command: RTS, DTR, RxEnable, TxEnable
				;but NOT TxEnable (so it won't interrupt) - 26h.
				;TxEnable is turned on and off dynamically.
	out	DX, AL
ExitAllDone:
	ret
init8251	ENDP
InitDev	ENDS


InitDev Segment PUBLIC 'COED'
Init6402 PROC FAR  ;6402 uart is used for Kbd in NewGen
;	MOV AX, 2			; reset EM bit in MSW
;	DB 0Fh,01h,0F0h		; LMSW AX
; First program rate counter.
	cli
	mov    DX, modeWord8254NGen
	mov    AL, 0B6H
	out    DX, AL
	jmp    $+2
	mov    DX, counter28254NGen
	mov    AL, 34H
	out    DX, AL
	jmp    $+2
	mov    AL, 0
	out    DX, AL
; Reset 6402 uart
	mov    DX, KbdControlReg
	mov    AL, reset6402
	out    dx, al
	mov    cx, 1000
@Reset6402:
	loop   @Reset6402
	xor    al,al
	out    dx, al
	mov    cx, 4000
@UnReset6402:
	loop   @UnReset6402
	mov    ax, 1Bh  ;8 data bits, 2 stop bits, parity disable, odd parity
	out    dx, ax
	ret
init6402 ENDP
InitDev  ENDS

$EJECT
%*Define(Reset(CtlReg))(
	mov	al, 18h
	mov	dx, %Eval(%CtlReg)
	out	dx, al
	jmp	$+2                     ;flush pipe
	nop
	nop
	nop
	nop
	mov	al, 18h
	mov	dx, %Eval(%CtlReg)
	out	dx, al
	jmp	$+2                     ;flush pipe
	nop
	nop
	nop
	nop
)
%*Define(Cmd(CtlReg,reg,val))(
	mov	al, %Eval(%reg)
	mov	dx, %Eval(%CtlReg)
	out	dx, al
	jmp	$+2                     ;flush pipe
	mov	al, %Eval(%val)
	mov	dx, %Eval(%CtlReg)
	out	dx, al
	jmp	$+2                     ;flush pipe
)

InitDev	Segment	PUBLIC	'COED'
Init8274	PROC	FAR
;	cmp	hardwareType, t1
;	jne	xAWS
;	cmp	processorType, Gws
;	jne @MustBeCWS
;	jmp xGws
;@MustBeCWS:
;	jmp	xCWS
;xAWS:
;	%Reset(62H)
;	%Cmd(62H, 4, 020h)
;	%Cmd(62H, 1, 0)
;	%Cmd(62H, 2, 031h)	; vector interrupt / 8086 mode / priority A>B / chan A-;DMA, chan B-interrupt
;	%Cmd(62H, 3, 0)
;	%Cmd(62H, 5, 0)
;	%Reset(66H)
;	%Cmd(66H, 4, 0C4h)	; x16 clock / 1 stop bit
;	%Cmd(66H, 3, 0C1h)	; Rx 8 bits / Rx enable
;	%Cmd(66H, 1, 015h)	; Int on all Rx chars/status affects vector/Tx Int ;Disable/Ext Int Enable
;	%Cmd(66H, 2, 8h)	; vector
;	%Cmd(66H, 5, 68h)	; Tx 8 bits / Tx Enable
;	ret
;xCWS:
;	%Reset(0FB04H)
;	%Cmd(0FB04H, 4, 4)
;	%Cmd(0FB04H, 1, 4)
;	%Cmd(0FB04H, 2, 10h)	; non vector interrupt / 8086 mode / priority A>B ;/ both chan interrupt
;	%Cmd(0FB04H, 3, 0)
;	%Cmd(0FB04H, 5, 0)
;	%Cmd(0FB04H, 0, 0C0H)
;	%Reset(0FB06H)
;	%Cmd(0FB06H, 4, 044h)	; x16 clock / 1 stop bit
;	%Cmd(0FB06H, 1, 4)		; status affects vector
;	%Cmd(0FB06H, 2, 0)		; Vector is zero
;	%Cmd(0FB06H, 3, 0C1h)	; Rx 8 bits / Rx enable
;;	%Cmd(0FB06H, 5, 0EAh)	; Tx 8 bits / Tx Enable / RTS / DTR
;	%Cmd(0FB06H, 0, 0C0H)
;	RET
;xGWS:
;	%Reset(0F8B4H)
;	%Cmd(0F8B4H, 4, 4)
;	%Cmd(0F8B4H, 1, 4)
;	%Cmd(0F8B4H, 2, 10h)	; non vector interrupt / 8086 mode / priority A>B ;/ both chan interrupt / Select Sync as the function
;	%Cmd(0F8B4H, 3, 0)
;	%Cmd(0F8B4H, 5, 0)
;	%Cmd(0F8B4H, 0, 0C0H)
;	%Cmd(0F8B6H, 4, 044h)	; x16 clock / 1 stop bit
;	%Cmd(0F8B6H, 1, 4)		; status affects vector
;	%Cmd(0F8B6H, 2, 0)		; Vector is zero
;	%Cmd(0F8B6H, 3, 0C1h)	; Rx 8 bits / Rx enable
;	%Cmd(0F8B6H, 5, 0EAh)	; Tx 8 bits / Tx Enable / RTS / DTR
;	%Cmd(0F8B6H, 0, 0C0H)
	RET
Init8274	ENDP
InitDev	ENDS

$EJECT
%*Define(ResetChannel)(
	mov	AL, 18h
	out	DX, AL
	jmp	$+2                     ;flush pipe
	nop
	nop
	nop
	nop
	mov	AL, 18h
	out	DX, AL
	jmp	$+2                     ;flush pipe
	nop
	nop
	nop
	nop
)
%*Define(ChannelCmd(reg,val))(
	mov	AL, %Eval(%reg)
	out	DX, AL
	jmp	$+2                     ;flush pipe
	mov	AL, %Eval(%val)
	out	DX, AL
)

InitDev Segment PUBLIC 'COED'
InitComm2 PROC FAR
	cmp  hardwareType,NGen
	jne  InitComm2Ret
	cmp  processorType, PCAT     ;DEBUGPC
	je   InitComm2Ret
	cmp  processorType, Comarch
	jne  InitCommContinue        ; do not initialize for IOPs
InitComm2Ret:
	ret                          ;DEBUGPC
InitCommContinue:
	mov  dx,ioCommCtlA
	%ResetChannel
	%ChannelCmd(4, 4)
	%ChannelCmd(1, 0)
	%ChannelCmd(2, 10h)
	%ChannelCmd(3, 0)
	%ChannelCmd(5, 0)
	mov  dx,ioCommCtlB
	%ResetChannel
	%ChannelCmd(4, 4)
	%ChannelCmd(1, 4)
	%ChannelCmd(2, 0)
	%ChannelCmd(3, 0)
	%ChannelCmd(5, 0)

; Reset cluster comm
idle EQU 08h  ; 2652
	MOV DX, pcSarH
	MOV AL, idle
	OUT DX, AL
	MOV  DX, pcrH
	XOR AL, AL
	OUT DX, AL
	MOV DX, cPort
	OUT DX, AL

commDmaDisable 	EQU 04
commDmaDisableB38 	EQU 07
	MOV  DX, dmaMask
	MOV  AL, commDmaDisable
	CMP  processorType, b38lcw
	JNE   @8237disable
	MOV  AL, commDmaDisableb38
@8237disable:
	OUT  DX, AL

	ret
InitComm2 ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;						SHADOW RAM SUBSYSTEM (Topcat/B38Lcw)
;
;  Six indexed configuration registers are provided to give complete control 
;  over each of the 64K memory segments between 640K and 1M. The registers
;  are called AAXS, BAXS, CAXS, DAXS, EAXS, AND FAXS. Each register contains
;  two bits for each 16K paragraph in the 64K segment controlled by that 
;  register. These registers are accessed by first enable configuration 
;  register by writing a dummy byte to port 0fbh, then output an indexed 
;  port to index register (0ech). Finally writing data to data port at 
;  address 0edh.
; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;-----------------------------------------------------------------------
;DATA PORT |              |              |              |              |
;EDH (R/W) |   D7    D6   |   D5    D4   |   D3    D2   |   D1    D0   |
;----------------------------------------------------------------------|
; AAXS     | AC000 ACCESS | A8000 ACCESS | A4000 ACCESS | A0000 ACCESS |
; BAXS     | BC000 ACCESS | B8000 ACCESS | B4000 ACCESS | B0000 ACCESS |
; CAXS     | CC000 ACCESS | C8000 ACCESS | C4000 ACCESS | C0000 ACCESS |
; DAXS     | DC000 ACCESS | D8000 ACCESS | D4000 ACCESS | D0000 ACCESS |
; EAXS     | EC000 ACCESS | E8000 ACCESS | E4000 ACCESS | E0000 ACCESS |
; FAXS     | FC000 ACCESS | F8000 ACCESS | F4000 ACCESS | F0000 ACCESS |
;-----------------------------------------------------------------------

public EnablePCMemory
EnablePCMemory proc far
	push	ax
	push	dx
	mov		dx,0fbh
    mov  	al, 0
	out		dx, al	; enable configuration register

;;; Enable 0a0000h to 0affffh

	mov		dx, 0ech; index register
	mov 	al, 0dh
	out		dx, al	; point to AAXS
	mov		dx, 0edh; data port 
	mov 	al, 0ffh; 
	out		dx, al	; enable 0a0000h - 0affffh
;

	mov		dx, 0ech; index register
	mov 	al, 0eh
	out		dx, al	; point to BAXS
	mov		dx, 0edh; data port 
	mov 	al, 0ffh; 
	out		dx, al	; enable 0b0000h - 0bffffh
;

	mov		dx, 0ech; index register
	mov 	al, 0fh
	out		dx, al	; point to CAXS
	mov		dx, 0edh; data port 
	mov 	al, 0ffh; 
	out		dx, al	; enable 0c0000h - 0cffffh
;

	mov		dx, 0ech; index register
	mov 	al, 10h
	out		dx, al	; point to DAXS
	mov		dx, 0edh; data port 
	mov 	al, 0ffh; 
	out		dx, al	; enable 0d0000h - 0dffffh
;

	mov		dx, 0ech; index register
	mov 	al, 11h
	out		dx, al	; point to EAXS
	mov		dx, 0edh; data port 
	mov 	al, 0ffh; 
	out		dx, al	; enable 0e0000h - 0effffh
;

	mov		dx, 0ech; index register
	mov 	al, 12h
	out		dx, al	; point to FAXS
	mov		dx, 0edh; data port 
	mov 	al, 0ffh; 
	out		dx, al	; enable 0f0000h - 0fffffh

    pop		dx
    pop		ax
  
    ret
EnablePCMemory  ENDP 



InitDev ENDS

END

; LOG
; 9/20/80 by RH, setup multibus dma channel
; 1/7/83  by MO, make module machine independent as part of NGen port
;                combine inidev.asm, awsidv.asm and NGen code
; 5/9/83  by MO, move to Proto 2 IO addr

; 1/11/84 by JA, use OutSub in NGEN Timer1 init
; 1/29/84 by MO, add support for t2 and 8086 NGens
; 3/5/84 by JA, fSFNM for 186's.
; 5/22/84 by MO, fix fSFNM word 0072->0032
; 6/11/84 by MO, add support for CWS workstation
; 10/15/84 by JA, TRENABLE51 27h->26h
; 3/20/85 by WH, add support for GWS workstation
; 1/30/86 by JM, reset EM bit in MSW on 286.
; 4/15/86  by FW, add support for NewGen
; 1/13/87 by DR, add Delay subroutine for Init8251 on 386
; 4/15/86  by FW: Add NewGen support.
; 4/24/86 by JM, Add InitMode3DmaCount.
; 10/191/88 by KH: PS2 support
; 6/12/89 by PGJ Runtime check for Init8259: Don't bother if CWS
; 10/31/89 by GWH: Added PS2 support in 8259 init sequence
; 08/31/90 by SG:  Added B38lcw support 
; 09/27/90 by JA:  Added InitComm2 reset cluster.
; 10/??/90 by AT:  Make Init8237 work on all hardware.
;                  Merged InitMode3DmaCount into Init8237.
; 10/24/90 by GWH: Added SG5000 processortype
; 11/05/90 by AT:  SCSI and floppy disk interrupts are level triggered.
; 11/09/90 by JMR: Add B38LCW cascaded DMA for LPT
; 11/14/90 by AT:  SGen SGV-100 Voice interrupt (XIRQ11-) is level triggered.
; 11/14/90 by JMR: LPT interrupt is level triggered
; 11/16/90 by DR:  EnablePCMemory for B39LCW
; 11/26/90 by JMR: Setup/Enable Comm DMA cascade channel in ISP
; 11/28/90 by AT:  Set SGen ISP extended mode registers for NGen compatibility.
; 12/06/90 by JMR: 16551 Serial port is now level trigered
; 02/07/91 by AT:  SG5000: HDisk and Floppy DMA in type B timing mode.
; 02/15/91 by AT:  Use dma literals from IoAddr1.edf to make changes easier.
; 02/19/91 by GWH: Added Counter28254Ngen to NgenPortsStructure.
; 02/24/91 by GWH: Removed AWS,IWS,GWS and CWS code.
; 03/12/91 by BA:  Put T2's and T3's slave 8237 in rotating priority mode.
; 04/04/91 by AT:  Use bIntVectorBase*, InitHandleDefaultInts.
; 04/24/91 by BA:  Put SG2000 DMA chip 2 in rotating priority mode and take 
;				B28Lcw out (priorities are correct so rotating not necessary).
; 05/01/91 by BA:  Fixed a bug in the above where rotating priority got turned 
;				off.
; 05/15/91 by AT:  Cleaned up 'P1 debugging' code.  Use more literals.
; 08/08/91 by FW   PCAT.
; 01/07/92 by GWH: Added extra delay for 8251 reset command processing - fixes
;				   B38 GXP Initializtion ERC 80.
; 11/24/92 by sg:  if vf.f82380 (comarch), skip init8259
; 02/19/93 by FW   Merge from 1.0:
;			-	10/29/92 by FW   Init8251 sets up the speaker timer on a PC.
; 03/10/93 by sg   Change Eisa bus interrupt (edge level) to IRQ16
; 03/22/93 by FW   Enable 8259 Special Fully Nested Mode on PCAT.
; 04/17/93 by FW   Be sure machine is EISA before blasting the edge/level
;                  interrupt configuration registers.
; 06/23/93 by FW   PS2 uses level triggered interrupts.
; 07/02/93 by RA   For PC/AT make interrupt priority of RS232 best.
;				   Corresponding change in InitIoAddr.plm. *AA*
; 07/09/93 by sg   If comarch, don't initcomm2.
