PROGRAM ADVENTURE(INPUT,OUTPUT);

{$INCLUDE:'BTOS.Edf'}

{$INCLUDE:'SAM.Edf'}

{$INCLUDE:'AdventureConstants.Edf'}

{ THE VIRTUAL FILE TRAVELFILE CONTAINS THE TRAVEL TABLE.
  THIS IS THE INFORMATION NEEDED TO MOVE FROM ONE LOCATION TO ANOTHER.
  THE LOGICAL FILE STRUCTURE IS:

    FOR EACH POSSIBLE TRAVEL PATH, THERE IS A RECORD OF TYPE TRAVELREC
    THAT DESCRIBES THE CONDITIONS REQUIRED TO MAKE THE JOURNEY.

    THE TRAVELREC RECORD IS FOLLOWED BY A VARIABLE NUMBER OF BYTES, EACH
    ONE BEING THE NUMBER OF A MOTION VERB THAT CAN AFFECT THE MOTION.

    THE MOTION VERB LIST IS TERMINATED BY THE BYTE 0255.}

type
   bswaType = array[0..129] of byte;
   shortBsaType = word;

VAR [PUBLIC]

   TravelFile :file of byte;
   TravelFileBSWA :bswaType;
   TravelRec: record
                 what,whatByte,how,howByte,howByte2: byte;
                 end;
   Travel: array[1..trvSiz] of shortBsaType;
   KTAB:  ARRAY[1..TABSIZ]
           OF INTEGER;                 {???}
   ATAB:  ARRAY[1..TABSIZ]
           OF ALFA;                    {VOCABULARY LIST}
   LText,SText :array[1..locSiz] of shortBsaType
   KEY,COND,ABB,ATLOC:  ARRAY[1..LOCSIZ] OF BYTE;
   PLAC,PLACE,FIXD,FIXED,LINK:  ARRAY[1..NOBJS] OF BYTE;
   PROP:  ARRAY[1..NOBJS] OF BYTE;
   PText :array[1..nObjs] of shortBsaType;
   ACTSPK:  ARRAY[1..VRBSIZ] OF BYTE;
   RText :array[1..rTxSiz] of shortBsaType;
   CText :array[1..clsMax] of shortBsaType;
   CVAL:  ARRAY[1..CLSMAX] OF BYTE;
   HINTS:  ARRAY[1..HNTSIZ,1..4] OF BYTE;
   HINTED:  ARRAY[1..HNTSIZ] OF BOOLEAN;
   HINTLC:  ARRAY[1..HNTSIZ] OF BYTE;
   MText :array[1..magSiz] of shortBsaType;
   InFile :text;
   SECT,CLSSES,LOC:  BYTE;
   I,J:  BYTE;
   KEYS,LAMP,GRATE,CAGE,ROD,ROD2,STEPS,BIRD,DOOR,PILLOW,SNAKE:  BYTE;
   TABLET,CLAM,OYSTER,MAGZIN,DWARF,KNIFE,FOOD,BOTTLE,WATER:  BYTE;
   PLANT2,AXE,MIRROR,DRAGON,CHASM,TROLL,TROLL2,BEAR,MESSAG:  BYTE;
   NUGGET,COINS,CHEST,EGGS,TRIDNT,VASE,EMRALD,PYRAM,PEARL,RUG:  BYTE;
   SPICES,BACK,LOOK,CAVE,NULL,ENTRNC,DPRSSN,SAY,SUSPEN,LOCK:  BYTE;
   TALLY2,TALLY,MAXTRS,MAXDIE,FIND,INVENT,CHLOC,CHLOC2,DALTLC:  BYTE;
   GAVEUP,SCORNG,LMWARN,BLKLIN:  BOOLEAN;
   FISSUR,PLANT,BATTER,CHAIN,THROW,OIL,VEND:  BYTE;
   WD1,WD2,MAGIC:  ALFA;
   WD1X,WD2X:  XALFA;
   HOLID,WKDAY,WKEND,HBEGIN,HEND,SHORT,MAGNM,LATNCY:  BYTE;
   NEWLOC,SETUP:  BYTE;
   HNTMAX:  BYTE;
   DSEEN:  ARRAY[1..6] OF BOOLEAN;
   IWEST,KNFLOC,DETAIL,ABBNUM,NUMDIE,DKILL,FOOBAR,BONUS,TURNS:  BYTE;
   DFLAG,SAVED:   BYTE;
   DTOTAL,K,KK,OLDLC2,OBJ,STICK,ATTACK:  BYTE;
   DLOC,ODLOC:  ARRAY[1..6] OF BYTE;
   TK:  ARRAY[1..20] OF BYTE;
   WZDARK,YEA:  BOOLEAN;
   VERB,SPK,HINT,KQ,OLDLOC,LL,K2:  BYTE;
   HOLDNG,SCORE,MXSCOR,FOO:  BYTE;
   CLOCK1,CLOCK2,LIMIT:  INTEGER;
   PANIC,CLOSNG,CLOSED:  BOOLEAN;
   filePoint :shortBsaType;
   SEED:  INTEGER;

procedure ErcCheck(erc :ercType) [public];
begin
   if erc <> 0 then ErrorExit(erc);
end;

function Lt(const b1,b2 :byte) :Boolean [public];
begin
   if b1 = 255
      then Lt := (b1 <> b2)
      else Lt := (b1 < b2);
end;
 
function Gt(const b1,b2 :byte) :Boolean [public];
begin
   if b1 = 255
      then Gt := (b1 <> b2)
      else Gt := (b1 > b2);
end;

function Le(const b1,b2 :byte) :Boolean [public];
begin
   if b1 = b2
      then Le := true
      else Le := Lt(b1,b2)
end;

function Ge(const b1,b2 :byte) :Boolean [public];
begin
   if b1 = b2
      then Ge := true
      else Ge := Gt(b1,b2)
end;

FUNCTION  CHOP (CONST I:INTEGER):BYTE [PUBLIC];
BEGIN
   CHOP := I;
END;
 
FUNCTION  MAX0 (CONST X,Y:INTEGER):INTEGER [PUBLIC];
BEGIN
   IF X > Y THEN
      MAX0 := X
   ELSE
      MAX0 := Y;
END; 
 
FUNCTION  MIN0 (CONST X,Y:INTEGER):INTEGER [PUBLIC];
BEGIN
   IF X<Y THEN
      MIN0:=X
   ELSE
      MIN0:=Y;
END;
 
FUNCTION  SHIFT (N:INTEGER; CONST NBITS:INTEGER):INTEGER [PUBLIC];
VAR I: INTEGER;
BEGIN
  FOR I := 1 TO NBITS DO
    N := N + N;         {SHIFT LEFT ONE BIT}
  SHIFT := N;
END;
 
FUNCTION  BITSET (CONST N,NBIT:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   BITSET := ODD(N DIV SHIFT(1,NBIT));
END;
 
FUNCTION  RAN (CONST RANGE: INTEGER): INTEGER [PUBLIC];
VAR R: INTEGER;
BEGIN
   SEED := SEED + 251;
   FOR I := 1 TO 8 DO 
      SEED := SEED+SEED+SEED;
   R := SEED+SEED+SEED;
   IF R < 0 THEN R := -R;
   IF R = 0 THEN R := 54321;
   R := R MOD RANGE + 1;
   RAN := R;
END;

FUNCTION  PCT (CONST N:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   PCT := RAN(100)<N;
END;
 
function Bsa(const shortBsa: shortBsaType) :bsaType [public]
begin
   Bsa.r := 0;
   Bsa.s := shortBsa;
end;
 
PROCEDURE  INVLRN (CONST F:FILEPTR; shortBsa :shortBsaType) [PUBLIC];
VAR bsa: bsaType;
BEGIN
   bsa.s := F;
   shortBsa.r := bsa.r;
END;
 
procedure ReadTravel(const L :byte) [public];
begin
   ErcCheck(SetBsLfa(ads TravelFileBSWA,Bsa(Travel[L])));
   with TravelRec do begin
      ErcCheck(ReadByte(ads TravelFileBSWA,ads what));
      if what <> 255 then begin
         ErcCheck(ReadByte(ads TravelFileBSWA,ads whatByte));
         ErcCheck(ReadByte(ads TravelFileBSWA,ads how));
         if not (how = hUnCond or how = hNoDwarves) then
            ErcCheck(ReadByte(ads TravelFileBSWA,ads howByte));
         if how = hProperty then
            ErcCheck(ReadByte(ads TravelFileBSWA,ads howByte2));
         end;
      writeln('Travel Record[',L,']=',what,whatByte,how,howByte,howByte2);
      end;
end;
 
{ READS THE NUMBER AT THE BEGINING OF THE LINE INTO CNT,
  THE TEXT LINE WILL BE IN L. (LEADING BLANKS SUPPRESSED)}

procedure ReadRec(l :textLine; cnt :integer) [public];
begin
   readln(InFile,cnt,l);
end;
 
{ PRINT OUT THE MESSAGE STARTING AT DISK ADDRESS D.  MULTIPLE LINE MESSAGES
  ARE DISTINGUISHED BY THE LOCATION NUMBER IN COLUMN 1 OF THE MESSAGE.}

procedure Speak(const d:shortBsaType) [public];
var
   count,oldCOunt :integer;
   line :textLine;

begin
   if d <> 0 then begin
      ErcCheck(SetBsLfa(ads InFileBSWA,Bsa(d)));
      if blkLin then writeln;
      ReadRec(line,oldCount);
      repeat
         if line[1] <> '>' then writeln(line);
         ReadRec(line,count);
         until count <> oldCount;
      end;
end;


{  FIND THE SKIP+1ST MESSAGE FROM MSG AND PRINT IT.  MSG SHOULD BE THE INDEX OF
   THE INVENTORY MESSAGE FOR OBJECT.  (INVEN+N+1 MESSAGE IS PROP=N MESSAGE).}

PROCEDURE  PSPEAK (CONST MSG,SKIP:BYTE) [PUBLIC];
VAR COUNT,I:INTEGER;
   VAR LINE:TEXTLINE;
BEGIN
   POSITION(INFILE,Bsa(PTEXT[MSG]));
{***} WRITELN('RSPEAK: MSG=',MSG,', SKIP=',SKIP);
   READREC(LINE,COUNT);
   IF (SKIP < 5) AND (SKIP >= 0) THEN
      FOR I := 0 TO SKIP DO READREC(LINE,COUNT);
   WRITELN(LINE);
END;


{ PRINT THE I-TH "RANDOM" MESSAGE (SECTION 6)}

PROCEDURE  RSPEAK (CONST I:INTEGER) [PUBLIC];
BEGIN
   IF I<>0 THEN Speak(RTEXT[I]);
END;

{PRINT THE I-TH "MAGIC" MESSAGE (SECTION 12 OF DATABASE).}

PROCEDURE  MSPEAK (CONST I:INTEGER) [PUBLIC];
BEGIN
   IF I<>0 THEN Speak(MTEXT[I]);
END;

{ SCAN OFF A WORD FROM L(80 CHAR LINE). STARTING AT I
  INTO W(5 CHARS) AND X(10 CHARS).}

procedure GetAWord(const l :textLine; i :integer; w :alfa; x :xalfa) [public];
var
   j :integer

begin
   W := '     ';
   X := '          ';
   WHILE L[I] = ' ' DO I := I + 1;
   J := 0;
   WHILE (L[I] <> ' ') AND (L[I] <> EL) DO BEGIN
      J := J + 1;
      IF J < 10+1 THEN X[J] := L[I];
      IF J <  6+1 THEN W[J] := L[I];
      I := I + 1
   END;
END;
 
{  GET A COMMAND FROM THE ADVENTURER.  SNARF OUT THE FIRST WORD, PAD IT WITH
   BLANKS, AND RETURN IT IN WORD1.  WORD1X AND WORD1Y WILL GET UP TO 10 CHARS
   IN LOWER CASE, FOR USE IN ERROR MESSAGES, ETC.
   ANY NUMBER OF BLANKS MAY FOLLOW THE WORD.  IF A SECOND WORD APPEARS,
   IT IS RETURNED IN WORD2 (LOWER CASE IN WORD2X, WORD2Y), ELSE WORD2 IS
   SET TO BLANKS.}

procedure GetIn [public];
var
   line :textLine;
   i :integer;

begin
   if BlkLin then begin
      writeln; BlkLin := false;
      end;
   readln; read(line);
   GetAWord(line,i,Wd1,Wd1X);
   GetAWord(line,i,Wd2,Wd2X);
   writeln('GetIn: Wd1=',Wd1,', Wd1X=',Wd1X,', Wd2=',Wd2,', Wd2X=',Wd2X);
end;

{ ASK QUESTION X.
  RETURN TRUE AND PRINT Y IF ANSWER=YES
  RETURN FALSE AND PRINT Z IF ANSWER=NO}
 
function yesx(const x,y,z :shortBsaType) :Boolean [public];
var
   answer :lstring(3);

begin
   Speak(x);
   repeat
      readln(answer);
      if not ((answer = 'Y') or (answer = 'N') or (answer = 'YES') or
            (answer = 'NO'))
         then writeln('Please answer the question');
      until ((answer = 'Y') or (answer = 'N') or (answer = 'YES')
            or (answer = 'NO'));
   if answer[1] = 'Y'
      then begin
         yesx := true; Speak(y);
         end;
      else begin
         yesx := false; Speak(z);
         end;
end;

FUNCTION  YES (CONST X,Y,Z:INTEGER):BOOLEAN [PUBLIC];
VAR X1,Y1,Z1 :shortBsaType;
BEGIN
   IF X=0 THEN X1:=0 ELSE X1 := RTEXT[X];
   IF Y=0 THEN Y1:=0 ELSE Y1 := RTEXT[Y];
   IF Z=0 THEN Z1:=0 ELSE Z1 := RTEXT[Z];
   YES := YESX(X1,Y1,Z1);
END;

FUNCTION  YESM (CONST X,Y,Z:INTEGER):BOOLEAN [PUBLIC];
VAR X1,Y1,Z1 :shortBsaType;
BEGIN
   IF X=0 THEN X1:=0 ELSE X1 := MTEXT[X];
   IF Y=0 THEN Y1:=0 ELSE Y1 := MTEXT[Y];
   IF Z=0 THEN Z1:=0 ELSE Z1 := MTEXT[Z];
   YESM := YESX(X1,Y1,Z1);
END;

{  LOOK UP ID IN THE VOCABULARY (ATAB) AND RETURN ITS "DEFINITION" (KTAB), OR
   -1 IF NOT FOUND.  IF INIT IS POSITIVE, THIS IS AN INITIALISATION CALL SETTIN
   UP A KEYWORD VARIABLE, AND NOT FINDING IT CONSTITUTES A BUG.  IT ALSO MEANS
   THAT ONLY KTAB VALUES WHICH TAKEN OVER 1000 EQUAL INIT MAY BE CONSIDERED.
   (THUS "STEPS", WHICH IS A MOTION VERB AS WELL AS AN OBJECT, MAY BE LOCATED
   AS AN OBJECT.)  AND IT ALSO MEANS THE KTAB VALUE IS TAKEN MOD 1000.}

FUNCTION  VOCAB (CONST ID:ALFA;INIT:INTEGER):INTEGER [PUBLIC];
VAR I:INTEGER;
{****} VAL:INTEGER;
BEGIN
   I := 1;
   WHILE (I<=TABSIZ)AND(ATAB[I]<>ID)AND(KTAB[I]<>-1) DO I:=I+1;
   IF ATAB[I]<>ID THEN BEGIN
      {VOCAB := -1;}
      VAL := -1
      END
   ELSE
      IF INIT >= 0 THEN BEGIN
        {VOCAB := KTAB[I] MOD 1000;}
         VAL := KTAB[I] MOD 1000
         END
      ELSE BEGIN
        {VOCAB := KTAB[I];}
         VAL := KTAB[I];
         END;
   VOCAB := VAL;
{****} WRITELN('VOCAB: ID=',ID,', VALUE=',VAL);
END;

FUNCTION  TOTING (CONST OBJ:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   TOTING := PLACE[OBJ] = 255;
END;
 
FUNCTION  HERE (CONST OBJ:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   HERE := (PLACE[OBJ]=LOC) OR TOTING(OBJ);
END;
 
FUNCTION  AT (CONST OBJ:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   AT := (PLACE[OBJ]=LOC) OR (FIXED[OBJ] = LOC);
END;
 
FUNCTION  LIQ2 (CONST PBOTL:INTEGER):INTEGER [PUBLIC];
BEGIN
   LIQ2 := TRUNC((1-PBOTL)*WATER+(PBOTL/2)*(WATER+OIL));
END;
 
FUNCTION  LIQ (CONST DUMMY:INTEGER):INTEGER [PUBLIC];
BEGIN
   LIQ := LIQ2(MAX0(PROP[BOTTLE],-1-PROP[BOTTLE]));
END;
 
FUNCTION  LIQLOC (CONST LOC:INTEGER):INTEGER [PUBLIC];
VAR T,U:INTEGER;
BEGIN
{  LIQLOC := LIQ2((((ABS(COND[LOC]/2)*2) MOD 8)-5)*(ABS(COND[LOC]/4) MOD 2)+1);}
   T := TRUNC(COND[LOC]/2);
   T := T*2;
   T := T MOD 8;
   T := T-5;
   U := TRUNC(COND[LOC]/4);
   U := U MOD 2;
   LIQLOC := LIQ2(T*U+1);
END;
 
FUNCTION  FORCED (CONST LOC:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   FORCED := COND[LOC] = 2;
END;
 
FUNCTION  DARK (CONST DUMMY:INTEGER):BOOLEAN [PUBLIC];
BEGIN
   DARK := ((COND[LOC] MOD 2)=0) AND ((PROP[LAMP]=0)OR NOT(HERE(LAMP)));
END;
 
{  START TOTING AN OBJECT, REMOVING IT FROM THE LIST OF THINGS AT ITS FORMER
   LOCATION.  INCR HOLDNG UNLESS IT WAS ALREADY BEING TOTED.  IF OBJECT>100
   (MOVING "FIXED" SECOND LOC), DON'T CHANGE PLACE OR HOLDNG.}

PROCEDURE  CARRY (CONST OBJ,WH:BYTE) [PUBLIC];
VAR T:INTEGER;
BEGIN
   IF (PLACE[OBJ]<>255)AND(OBJ<=100) THEN
      BEGIN
         IF OBJ<=100 THEN
            BEGIN
               PLACE[OBJ]:=255;
               HOLDNG:=HOLDNG+1;
            END;
         IF ATLOC[WH]=OBJ THEN
            ATLOC[WH]:=LINK[OBJ]
         ELSE
            BEGIN
               T:=ATLOC[WH];
               WHILE LINK[T]<>OBJ DO T:=LINK[T];
               LINK[T]:=LINK[OBJ];
            END;
      END;
END;

{  PLACE AN OBJECT AT A GIVEN LOC, PREFIXING IT ONTO THE ATLOC LIST.  DECR
   HOLDNG IF THE OBJECT WAS BEING TOTED.}

PROCEDURE  DROP (CONST OBJ,WH:BYTE) [PUBLIC];
BEGIN
{****} WRITELN('DROP: ',OBJ,' TO ',WH);
   IF OBJ<=100 THEN
      BEGIN
         IF PLACE[OBJ]=255 THEN HOLDNG := HOLDNG-1;
         PLACE[OBJ]:=WH;
         IF WH > 0 THEN
            BEGIN
               LINK[OBJ] := ATLOC[WH];
               ATLOC[WH] := OBJ;
            END
      END
   ELSE
      FIXED[OBJ-100]:=WH;
END;

{  PLACE ANY OBJECT ANYWHERE BY PICKING IT UP AND DROPPING IT.  MAY ALREADY BE
   TOTING, IN WHICH CASE THE CARRY IS A NO-OP.  MUSTN'T PICK UP OBJECTS WHICH
   ARE NOT AT ANY LOC, SINCE CARRY WANTS TO REMOVE OBJECTS FROM ATLOC CHAINS.}

PROCEDURE  MOVE (CONST OBJ,WH:BYTE) [PUBLIC];
VAR FROM:INTEGER;
BEGIN
   IF OBJ<=100 THEN
      FROM := PLACE[OBJ]
   ELSE
      FROM := FIXED[OBJ-100];
   IF (FROM>0)AND(FROM<=300) THEN CARRY(OBJ,FROM);
   DROP(OBJ,WH);
END;

{  PERMANENTLY ELIMINATE "OBJECT" BY MOVING TO A NON-EXISTENT LOCATION.}

PROCEDURE  DSTROY (CONST OBJ:BYTE) [PUBLIC];
BEGIN
   MOVE(OBJ,0);
END;

{  JUGGLE AN OBJECT BY PICKING IT UP AND PUTTING IT DOWN AGAIN, THE PURPOSE
   BEING TO GET THE OBJECT TO THE FRONT OF THE CHAIN OF THINGS AT ITS LOC.}

PROCEDURE  JUGGLE (CONST OBJ:BYTE) [PUBLIC];
VAR I,J:INTEGER;
BEGIN
   MOVE(OBJ,PLACE[OBJ]);
   MOVE(OBJ+100,FIXED[OBJ]);
END;

{  PUT IS THE SAME AS MOVE, EXCEPT IT RETURNS A VALUE USED TO SET UP THE
   NEGATED PROP VALUES FOR THE REPOSITORY OBJECTS.}

FUNCTION  PUT (CONST OBJ,WH,PVAL:INTEGER):INTEGER [PUBLIC];
BEGIN
   MOVE(OBJ,WH);
   PUT := (-1)-PVAL;
END;

 
 
 
BEGIN
   WRITELN('ADVENT - VER. A.A.a - SCS/RGH');
   OVERLAY('ADVINIT');
   OVERLAY('ADVMAIN');
END.
