
NAME FileCopy

; MODULE_DATA     SEGMENT WORD PUBLIC 'DATA'
; MODULE_DATA     ENDS

;******************************* MODULE HEADER *******************************;
;*																		     *;
;*																		     *;
;* MACHINE: B20		LANGUAGE: ASSEMBLER  OS: BTOS			 		 	     *;
;*																		     *;
;* DESCRIPTION:  														     *;
;*																		     *;
;* HISTORY:																     *;
;* 05/20/89   120B.03   V. Muppidi      /Added CT 12.0 changes               *;
;* 										/Added prefixes to include files     *;
;* 																		     *;
;* 01/09/89 II021E.02   R. BROOKES      /Added Code to continue on 301 error *;
;*										/Made BadBlk flag public.			 *; ;* 10/12/88 II021C.01   R. BROOKES      /Added BadBlkFilecopy to avoid 301   *;
;*                                      /errors while copying bad blks.      *;
;*																		     *;
;* TITLE:  B20 SYSTEM SOFTWARE											     *;
;*																		     *;
;*			PROPRIETARY PROGRAM MATERIAL								     *;
;*																		     *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE	     *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS	  	     *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.							     *;
;*																		     *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED    *; 
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED         *;
;* ************************************************************************* *;
;*																		     *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND	     *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.		         *;
;*																		     *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.						     *;
;*																		     *;
;*																		     *;
;*************************** END OF MODULE HEADER ****************************;
;
; FILE: FILECOPY.ASM.  Implements procedure FileCopy used in various programs:
;
;	erc := FileCopy(fhIn,fhOut,lfaFileSize,fVerifyCopy)
;
; MODS --
;	4/30/82	 JK	use large buffer, no asynch stuff
;	1/07/85 DR - use CheckErc from CTOS.lib
;	7/25/85 JM - changed ercDataMismatch to be a real erc (255)
;	3/26/86 JK - change SetLfaIoError to not use ES for data
;	           - add debug info for verify errors
;	           - Fix error return logic
;-- 11.0 --
; 8/11/86 DR - purge bogus use of ES as data register
; 11/4/86 JK - fix pointer arithmentic in I/O error retry for P-Mode
; 12/3/86 DR,FW - call WrapUp and entry to FileCopy, not exit.  Allows
;                 buffers to be printed by error reporting.
;
ASSUME CS:NOTHING, DS:NOTHING, ES:NOTHING, SS:NOTHING

PUBLIC FileCopy
PUBLIC LfaBadBlkTbl   					; RCB 9/6/88 M01 
PUBLIC errMode,errModeIoError,lfaIoError,fFileCopyIoError,fAutoRetry
PUBLIC ibMiscompare
PUBLIC fContOnError, fBadblk			; RCB 1/9/89 M02
;
; Public's for debugging only:
;
PUBLIC lfaCurrent,fLastIO
PUBLIC fMemA,fMemB,sBuff,cBytesCurrent,pCopyBufferA,pCopyBufferB

PUBLIC Initialize,UpdateLfa,UpDateBBLfa,ReadSrcA,ReadSrcB,ReadDstB,WriteDstA
PUBLIC ReadRetry,CompareAtoB,ShowBurst,WrapUp,SetLfaIoError
PUBLIC maskNoRetry
EXTRN  XErrorExit:far
$INCLUDE(:f1:FileCopy.edf)


%*Define(DoCheckErc)LOCAL tmp(
	or ax, ax
	jz %tmp
	jmp FileCopyExit
%tmp:
)

%*Define(DoCheckErcFatal)LOCAL tmp(
	or ax, ax
	jz %tmp
	push ax
	call XErrorExit
%tmp:
)

%IF(%Pass1)THEN(
$INCLUDE(:f0:CTOS.Mdf))FI
$INCLUDE(:f1:io.mdf)

Data SEGMENT PUBLIC 'Data'

errMode				DW ?	; 0 ==> ?;  1==> InSpec  2==> OutSpec
errModeIoError		DW ?
ibMiscompare 		DW ?
lfaIoError			DD ?
fFileCopyIoError 	DB ?
fContOnError		DB 0				; RCB 1/9/89 M02 - Set by user prog 
										; if required to ignore 301 errored 
										; sector and continue copying. 
fLastIO				DB 0
fMemA				DB 0
fMemB				DB 0
fBadBlk				DB 0				; RCB 9/6/88 M01 ;
index				DW 0				; RCB 9/6/88 M01 ;
LfaBadBlkTbl        DW 256 DUP(0)		; RCB 9/6/88 M01 ;
EVEN

sBuff				DW 15*8*512
sCopyBuffers		DW ?

cParRet				DW ?
pCopyBufferRetry	DD ?

lfaCurrent			DD ?
lfaCurrentTmp		DD ?				; RCB 9/6/88 M01 ;
cBytes				DD ?				; RCB 9/6/88 M01 ;
ercIOError			EQU 301
ercDataMismatch		EQU 255

maskNoRetry			DW ?
fAutoRetry 			DW 0

cBytesCurrent		DW ?
cBytesRetry			DW ?
lfaRetry			DD ?

pCopyBufferA		DD 0
pCopyBufferB		DD 0

sDataRet			DW ?
sDataRetRetry		DW ?

savedSP 			DW ?

Data ENDS

Dgroup GROUP Data

FileCopyCode SEGMENT PUBLIC 'Code'

ASSUME CS:FileCopyCode
ASSUME SS:Dgroup
ASSUME DS:Dgroup

FileCopy PROC FAR;:

		PUSH BP
		MOV BP, SP

;
; Variables are defined relative [BP] for use throughout module.  Note
; that BP never is changed.  This is important for correct reference to
; variables, plus for proper stack cleanup on errors.
;

fVerifyCopy      EQU  BYTE PTR [BP+6]
lfaFileSize      EQU  DWORD PTR [BP+8]
lfaFileSizeLow   EQU  WORD PTR [BP+8]
lfaFileSizeHigh  EQU  WORD PTR [BP+10]
fhOut            EQU  WORD PTR [BP+12]
fhIn             EQU  WORD PTR [BP+14]
sArgs            EQU  10


		cmp	fContOnError,0ffh					; RCB 1/9/89 M02
		je	ContOnError							; RCB 1/9/89 M02
		call Initialize
		cmp fBadblk, 0							; RCB 1/9/89 M02
		je FileCopyLoop							; RCB 1/9/89 M02
		call InitBadBlkFileCopy					; RCB 1/9/89 M02
FileCopyLoop:
		CALL UpDateLfa
		CALL ReadSrcA
		CALL WriteDstA

		CMP	fVerifyCopy,0
		JE	FileCopyNoVf

		CALL	ReadSrcB
		MOV	errMode,1
		CALL	CompareAtoB
		MOV	errMode,0
		CALL	ReadDstB
		MOV	errMode,2
		CALL	CompareAtoB
		MOV	errMode,0

FileCopyNoVf:
		CMP	fLastIO, 0
		JZ	FileCopyLoop
		XOR	AX, AX        ; RETURN ercOK

FileCopyExit:
		MOV fContOnError, 0						; RCB 1/9/89 M02
		AND  AX,AX
		JNZ  SkipWrapUp;
		CALL WrapUp       ; Deallocate buffers if no error
SkipWrapUp:
		MOV	SP, BP
		POP	BP
		RET	sArgs

ContOnError:								; RCB 1/9/89 M02
;
;	cBytesCurrent = lfaRetry - lfaCurrent;
;	ReadSrcA;
;	WriteDstA;
;	lfaCurrent = lfaRetry - sCopyBuffer + 512;
;	clear fFileCopyIoError;
;	jmp FileCopyLoop;

		mov ax, word ptr lfaRetry		;cBytesCurrent = lfaRetry - lfaCurrent;
		mov dx, word ptr lfaRetry+2
		sub ax, word ptr lfaCurrent
		sbb dx, word ptr lfaCurrent+2
		mov word ptr cBytesCurrent,ax
		mov word ptr cBytesCurrent+2,dx
		call ReadSrcA
		call WriteDstA
		mov ax, word ptr lfaRetry		;lfaCurrent = lfaRetry-sCopyBuffer+512;
		mov dx, word ptr lfaRetry+2
		sub ax,sCopyBuffers
		sbb dx,0
		add ax, 512
		adc dx,0
		mov word ptr lfaCurrent,ax
		mov word ptr lfaCurrent+2,dx 
		mov fFileCopyIoError,0
		jmp FileCopyLoop						; RCB 1/9/89 M02

FileCopy ENDP

InitBadBlkFileCopy PROC;:						; RCB 9/6/88 M01 ;
		mov index,0								;init index to bad blk table		
		xor ax,ax
		mov word ptr lfaCurrentTmp,ax			;initialize lfaCurrentTmp
		mov word ptr lfaCurrentTmp+2,ax
		ret
InitBadBlkFileCopy ENDP							; RCB 9/6/88 M01 ;

; UpDateBBLfa --								; RCB 9/6/88 M01 ;
;   if lfaBadBlkTbl(i) = 0 then
;		clear fBadBlk;
;		lfaCurrent = lfaCurrentTmp - sCopyBuffer;
;		jmp UpDateLfa
;	else
;		lfaCurrent = lfaCurrentTmp;
;		cBytes = lfaBadBlkTbl(i) - lfaCurrent; 		
;		if cBytes > sCopyBuffers then
;			cBytesCurrent = sCopyBuffers;
;			lfaCurrentTmp = lfaCurrent + sCopyBuffers;
;		else		
;			lfaCurrentTmp = lfaBadBlkTbl(i) + 512;
;			cBytesCurrent = cbytes;
;			inc i;
;		end;
;	end;

UpDateBBLfa	PROC;:								; RCB 9/6/88 M01 ;
		mov ax,index							;if lfaBadBlkTbl(i) = 0
		shl ax,2
		mov bx,ax
		mov ax, word ptr dgroup:LfaBadBlkTbl[bx]
		mov dx, word ptr dgroup:LfaBadBlkTbl+2[bx]
		xor ax,dx
		jnz UpBB1
		mov fBadBlk,0							;clear fBadBlk
		mov ax,word ptr lfaCurrentTmp	;lfaCurrent=lfaCurrentTmp-sCopyBuffer
		mov dx,word ptr lfaCurrentTmp+2
		sub ax,sCopyBuffers
		sbb dx,0
		mov word ptr lfaCurrent,ax
		mov word ptr lfaCurrent+2,dx 
		jmp	UpDateLfa

UpBB1:	mov ax,word ptr lfaCurrentTmp			;lfaCurrent=lfaCurrentTmp
		mov dx,word ptr lfaCurrentTmp+2
		mov word ptr lfaCurrent,ax
		mov word ptr lfaCurrent+2,dx 
		mov ax,index					;cBytes=lfaBadBlkTbl(i)-lfaCurrent; 		
		shl ax,2
		mov bx,ax
		mov ax, word ptr dgroup:LfaBadBlkTbl[bx]
		mov dx, word ptr dgroup:LfaBadBlkTbl+2[bx]
		sub ax, word ptr lfaCurrent
		sbb dx, word ptr lfaCurrent+2
		mov word ptr cBytes,ax
		mov word ptr cBytes+2,dx
		mov ax,dx								;if cBytes > sCopyBuffers
		cmp ax,0
		jne UpBB2
		mov ax, sCopyBuffers		
		cmp ax, word ptr cBytes
		jbe UpBB2
		jmp UpBB3
UpBB2:  mov	ax,sCopyBuffers						;cBytesCurrent = sCopyBuffers;
		mov cBytesCurrent,ax 
		mov ax,word ptr lfaCurrent	    ;lfaCurrentTmp=lfaCurrent+sCopyBuffer
		mov dx,word ptr lfaCurrent+2
		add ax,sCopyBuffers
		adc dx,0
		mov word ptr lfaCurrentTmp,ax
		mov word ptr lfaCurrentTmp+2,dx 
		jmp UpBB4
UpBB3:	mov ax,index						;lfaCurrentTmp=lfaBadBlkTbl(i)+512;
		shl ax,2
		mov bx,ax
		mov ax, word ptr dgroup:LfaBadBlkTbl[bx]
		mov dx, word ptr dgroup:LfaBadBlkTbl+2[bx]
		add ax, 512
		adc dx,0
		mov word ptr lfaCurrentTmp,ax
		mov word ptr lfaCurrentTmp+2,dx 
		mov ax, word ptr cBytes					;cBytesCurrent = cbytes
		mov cBytesCurrent,ax
		inc index								;inc i
UpBB4:  ret
UpDateBBLfa ENDP								; RCB 9/6/88 M01 ;


Initialize PROC;:

		MOV AX, 04000h
		CMP fAutoRetry, 0
		JE InitializeAutoRetry
		XOR AX, AX

InitializeAutoRetry:
		MOV maskNoRetry, AX

		call WrapUp ; Deallocate buffers from prior invocation.
				    ; Buffers must persist after exit from
                    ; this module so that they may be displayed by
                    ; error reporting.

		XOR	AX, AX
		MOV	errMode, AX
		MOV	fMemA, AL
		MOV	fMemB, AL
		MOV	fLastIO, AL
		MOV	fFileCopyIoError, AL
		MOV	AX, sBuff

		MOV	sCopyBuffers, AX

		%AllocMemorySL(sCopyBuffers,@pCopyBufferA)
		%DoCheckErcFatal
		MOV	fMemA, 0FFh

		MOV	AL, fVerifyCopy
		AND	AL, AL
		JZ	Initialize3

		%AllocMemorySL(sCopyBuffers,@pCopyBufferB)
		%DoCheckErcFatal
		MOV	fMemB, 0FFh

Initialize3:
		XOR	AX, AX
		MOV	BX, AX
		SUB	AX, sCopyBuffers
		SBB	BX, 0
		MOV	WORD PTR lfaCurrent+0, AX
		MOV	WORD PTR lfaCurrent+2, BX
		RET

Initialize ENDP

ReadSrcA PROC;:
		MOV	errMode, 1
		MOV AX, maskNoRetry
		OR	WORD PTR lfaCurrent+2, AX
		%Read (fhIn,pCopyBufferA,cBytesCurrent,lfaCurrent,@sDataRet)
		MOV BX, maskNoRetry
		XOR	WORD PTR lfaCurrent+2, BX
		CMP	AX, ercIOError
		JNE	ReadSrcA0
		CALL	SetLfaIoError 
		CALL	ReadRetryA

ReadSrcA0:
		%DoCheckErc
		MOV	errMode, 0
		RET
ReadSrcA ENDP

ReadSrcB PROC;:
		MOV	errMode, 1
		MOV AX, maskNoRetry
		OR	WORD PTR lfaCurrent+2, AX
		%Read (fhIn,pCopyBufferB,cBytesCurrent,lfaCurrent,@sDataRet)
		MOV BX, maskNoRetry
		XOR	WORD PTR lfaCurrent+2, BX
		CMP	AX, ercIOError
		JNE	ReadSrcB0
		CALL	SetLfaIoError 
		CALL	ReadRetryB
		CALL	CheckIoError

ReadSrcB0:
		%DoCheckErc
		MOV	errMode, 0
		RET
ReadSrcB ENDP
ReadDstB PROC;:
		MOV	errMode, 2
		MOV AX, maskNoRetry
		OR	WORD PTR lfaCurrent+2, AX
		%Read (fhOut,pCopyBufferB,cBytesCurrent,lfaCurrent,@sDataRet)
		MOV BX, maskNoRetry
		XOR	WORD PTR lfaCurrent+2, BX
		CALL	CheckIoError
		%DoCheckErc
		MOV	errMode, 0
		RET
ReadDstB ENDP
WriteDstA PROC;:
		MOV	errMode, 2
		MOV AX, maskNoRetry
		OR	WORD PTR lfaCurrent+2, AX
		%Write (fhOut,pCopyBufferA,cBytesCurrent,lfaCurrent,@sDataRet)
		MOV BX, maskNoRetry
		XOR	WORD PTR lfaCurrent+2, BX
		CALL	CheckIoError
		%DoCheckErc
		CALL	ShowBurst
		MOV	errMode, 0
		RET
WriteDstA ENDP
; UpDateLfa --
;
;	lfaCurrent := lfaCurrent + sCopyBuffers;
;
;	IF lfaFileSize <= lfaCurrent + sCopyBuffers THEN
;	    fLastIO := TRUE;
;	    cBytesCurrent := lfaFileSize-lfaCurrent;
;	ELSE
;	    cBytesCurrent := sCopyBuffers;
;
;	RETURN fLastIO;
;
UpDateLfa PROC;:
		mov al,fBadBlk					; RCB 9/6/88 M01 ;
		cmp al,0						; RCB 9/6/88 M01 ;
		je UpDt1						; RCB 9/6/88 M01 ;
		call UpDateBBLfa				; RCB 9/6/88 M01 ;
		jmp UpDtE						; RCB 9/6/88 M01 ;

UpDt1:	MOV	AX, sCopyBuffers
		MOV	cBytesCurrent, AX
		ADD	WORD PTR lfaCurrent, AX
		ADC	WORD PTR lfaCurrent+2, 0
		
;		LES	AX, lfaCurrent
;		MOV	BX, ES

		mov ax, word ptr [lfaCurrent]
		mov bx, word ptr [lfaCurrent+2]

		ADD	AX, sCopyBuffers
		ADC	BX, 0
		CMP	lfaFileSizeHigh, BX
		JA	UpDtE
		JB	UpDt0
		CMP	lfaFileSizeLow, AX
		JA	UpDtE
UpDt0:	MOV	fLastIO, 0FFh
		MOV	AX, lfaFileSizeLow
		SUB	AX, WORD PTR lfaCurrent
		MOV	cBytesCurrent, AX
UpDtE:	RET
UpDateLfa ENDP

ShowBurst PROC;:
		RET			; nop this out to see bursts
		MOV	DX, cBytesCurrent
		MOV	CL, 9
		SHR	DX, CL
		%nPrint(@(128 DUP ('.')),DX)
		RET
ShowBurst ENDP
;
; ReadRetry -- Read one sector (synch) at a time due to IO errors
;
; On entry, AX=0 ==> A, AX=0FF ==> B. This procedure in sync,
; and non reentrant.
;
; Comes in two flavors for each of the two buffers
;
ReadRetry PROC;:

ReadRetryA:	LES	BX, pCopyBufferA
		MOV	WORD PTR pCopyBufferRetry+0, BX
		MOV	WORD PTR pCopyBufferRetry+2, ES
		JMP	ReadRetryCom

ReadRetryB:	LES	BX, pCopyBufferB
		MOV	WORD PTR pCopyBufferRetry+0, BX
		MOV	WORD PTR pCopyBufferRetry+2, ES
;		JMP	ReadRetryCom

ReadRetryCom:	MOV	AX, cBytesCurrent
		MOV	cBytesRetry, AX
		mov bx, word ptr [lfaCurrent]
		MOV	WORD PTR lfaRetry+0, BX
		mov bx, word ptr [lfaCurrent+2]
		MOV	WORD PTR lfaRetry+2, BX
		MOV	sDataRet,0

ReadRetryLoop:	%Read (fhIn,pCopyBufferRetry,512,lfaRetry,@sDataRetRetry)
		AND	AX, AX
		JNZ	ReadRetryEnd
		ADD	sDataRet,512
		SUB	cBytesRetry, 512
		JZ	ReadRetryEnd
		ADD	WORD PTR pCopyBufferRetry+0, 512
		ADD	WORD PTR lfaRetry+0, 512
		ADC	WORD PTR lfaRetry+2, 0
		JMP	ReadRetryLoop

ReadRetryEnd:	RET

ReadRetry ENDP
;
; CompareAtoB
;
CompareAtoB PROC;:

		MOV	CX, cBytesCurrent
		SHR	CX, 1
		JCXZ	CmpAtoBRet
		LES	DI, pCopyBufferA

		PUSH	DS
		LDS	SI, pCopyBufferB
		ASSUME	DS: NOTHING
		CLD
		REPZ CMPSW
		POP	DS
		ASSUME	DS: DGroup

		JZ	CmpAtoBRet

;
; We got a miscompare, do set up.
;
; CX is remaining word count after miscompare, so increment it to be at
; failing word, then double and subtract from original count to get byte
; index into buffer.
;
		INC CX	
		SHL CX, 1
		MOV	AX, cBytesCurrent
		SUB	AX, CX
		MOV ibMiscompare, AX
		AND	AX, 0FE00h
		MOV	sDataRet, AX
		CALL	SetLfaIoError
		MOV	AX, ercDataMismatch
		%DoCheckErc
CmpAtoBRet:	RET

CompareAtoB ENDP
CheckIoError PROC;:
		CMP	AX, ercIoError
		JNE	CheckIoErrRet
		PUSH	AX
		CALL	SetLfaIoError
		POP	AX
CheckIoErrRet:	RET
CheckIoError ENDP

SetLfaIoError PROC;:
		MOV 	AX, word ptr lfaCurrent+0
		MOV BX, word ptr lfaCurrent+2
		ADD	AX, sDataRet
		ADC	BX, 0
		MOV	WORD PTR lfaIoError+0, AX
		MOV	WORD PTR lfaIoError+2, BX
		MOV	AX, errMode
		MOV	errModeIoError, AX
		MOV	fFileCopyIoError, 0FFh
		RET
SetLfaIoError ENDP

;
; WrapUp -- Free memory used.
;
WrapUp PROC;:
		PUSH AX
		CMP	fMemB, 0
		JE	WrapUp0
		MOV	fMemB, 0
		%DeAllocMemorySL(pCopyBufferB,sCopyBuffers)
		%DoCheckErcFatal

WrapUp0:
		CMP	fMemA, 0
		JE	WrapUp1
		MOV	fMemA, 0
		%DeAllocMemorySL(pCopyBufferA,sCopyBuffers)
		%DoCheckErcFatal

WrapUp1:
		POP	AX
		RET

WrapUp ENDP

FileCopyCode ENDS
END
