%IF(NOT %*IsDef(%VariablePoll)) THEN (%SET(VariablePoll,0FFh))FI
%IF(NOT %*IsDef(%Aug87JA)) THEN (%SET(Aug87JA,0))FI
%IF (not(%*Isdef(%fRawInt))) THEN (%Define(fRawInt)(0))FI%'Never set true

;*****************************************************************************
; MstrLph_all.asm
; Master Line Protocol Handler.
; This module contains code for the Megaframe.
;*****************************************************************************

;*****************************************************************************
;  PUBLIC PROCEDURES
;*****************************************************************************
	PUBLIC ActivateDct
	PUBLIC DeactivateDct
	PUBLIC Disconnect
	PUBLIC ProcessTRB
	PUBLIC ReleaseXBlock
	PUBLIC SendXBlock

;*****************************************************************************
;  EXTERNAL PROCEDURES
;*****************************************************************************
EXTRN ControlInterrupt:FAR
EXTRN Crash:FAR
EXTRN HandleFatalError:FAR
EXTRN MediateIntHandler:FAR
EXTRN PSend:FAR
EXTRN SetTimerInt:FAR
EXTRN UnchainXBlock:FAR			; in MstrAgentSubs

;*****************************************************************************
;  EXTERNAL DATA
;*****************************************************************************
DGroup GROUP DATA
Data SEGMENT PUBLIC 'DATA'

EXTRN exchMstrAgentReceiver:WORD
EXTRN fEnableCluster:BYTE, pfEnableCluster:DWORD
EXTRN nDct:WORD
EXTRN nRepollActive:BYTE
EXTRN rqDelayDisc:WORD
EXTRN sXBlk:WORD
EXTRN psystime:DWORD
      systimeLow EQU ES:WORD PTR 0
      systimeHigh EQU ES:WORD PTR 2
      systimeTicks EQU ES:BYTE PTR 0
      systimeMsec100 EQU ES:BYTE PTR 1
      systimeSecs EQU ES:WORD PTR 2
      systimeDayTimes2 EQU ES:WORD PTR 4
EXTRN timerNumber:WORD
EXTRN fGoingDown:BYTE
EXTRN fDisconnectAll:BYTE
EXTRN bMySlot:BYTE
EXTRN pStat:DWORD					;DHG... in Stat1 of Sysgen
nAvailX		EQU WORD PTR 38
nMinX		EQU WORD PTR 36
nWaitX		EQU DWORD PTR 50
nWaitXLow	EQU WORD PTR nWaitX
nWaitXHigh	EQU WORD PTR nWaitX+2	;...DHG
EXTRN pCachedFhs: DWORD

;*****************************************************************************
; Meter Buffer Definition
; The meterBuffer is pointed to by pMeterBuffer. This is allocated by
; ClusterStatus by the METER function. We know that the ra field of this
; pointer is zero, so we need only use the sa portion.
;*****************************************************************************
mbIndex        EQU WORD PTR ES:[0]
mbIndexMax     EQU WORD PTR ES:[2]
mbTrigger      EQU WORD PTR ES:[4]
mbPoint        EQU BYTE PTR ES:[DI+6]
mbLineState    EQU BYTE PTR ES:[DI+7]
mbPollNumber   EQU WORD PTR ES:[DI+8]
mbSystimeLow   EQU WORD PTR ES:[DI+10]
mbTicks        EQU BYTE PTR ES:[DI+10]
mbMs100        EQU BYTE PTR ES:[DI+11]
mbSecs         EQU WORD PTR ES:[DI+12]
mbRtc          EQU WORD PTR ES:[DI+14]
mbRtcLow       EQU BYTE PTR ES:[DI+14]
mbRtcHigh      EQU BYTE PTR ES:[DI+15]
mbStationFrame EQU WORD PTR ES:[DI+16]
mbStation      EQU BYTE PTR ES:[DI+16]
mbFrame        EQU BYTE PTR ES:[DI+17]
mbCount        EQU WORD PTR ES:[DI+18]
mbRqCode       EQU WORD PTR ES:[DI+20]
mbErcRet       EQU WORD PTR ES:[DI+22]
mbVariable     EQU WORD PTR ES:[DI+24]
mbEntrySize    EQU 26 - 6

;*****************************************************************************
;  GLOBAL DATA
;*****************************************************************************
PUBLIC fFixedId, nOutstandingMax
PUBLIC saFreeList, saFreeListSmall
PUBLIC timerInterruptsPerSnrm
PUBLIC pMeterBuffer
PUBLIC saXBlockFirst, saXBlockSmallFirst, saPerXBlock, saPerSmallRq
PUBLIC prevDayTimes2, maxXBlocksPerUser
PUBLIC oLcb, nUserNumOffset, pRgSbWsUserName
PUBLIC pPitRet
PUBLIC bSioClock, bSioClockSnrm
PUBLIC rgKHLineSpeed, rgSioClock
PUBLIC cPitTicksPollMax

; bootId is a temporary kludge that may or may not work. The NGen boot ROM has
; a bug. It should send us the WsType in the XID. In error recovery, it moves
; the WsType that it receives into its own WsType field (which is a bug!). We
; end up getting zero for a WsId, and disconnect the workstation because we
; don't have a boot file for it. So send bootId so we will get it back and make
; it  public so we can patch it. 

PUBLIC bootId
bootId 			DB 252


; This flag can be set to 0FFh for running NGen Masters in testing mode. This
; will allow workstations to boot in fixedID mode.
fFixedId DB 0

maxXBlocksPerUser 	LABEL BYTE	;Same as nOutstandingMax
nOutstandingMax 	DB 0		;Set up by init code depending on nXBlk

   EVEN
timerInterruptsPerSnrm DB 3
prevDayTimes2 		DW 0
pMeterBuffer 		DD 0
saMeterBuffer 		EQU WORD PTR pMeterBuffer+2
saFreeList 			DW 0		;List of free XBlocks
saFreeListSmall 	DW 0		;List of small free XBlocks
saXBlockFirst 		DW 0
saXBlockSmallFirst 	DW 0
oLcb				DW 0
nUserNumOffset		DW 0		; CDT offset
pRgSbWsUserName 	DD 0		;Set by InitClstr
pPitRet				DD ?
cPitTicksPollMax	DW 4000		;=200ms; Set in InitReadCnf, InitMaster.
bSioClock			DB ?		;Set after each new xid
bSioClockSnrm		DB ?		;Set at boot in InitClstr.
rgKHLineSpeed		DW 3680,1800,307, 0;KHLineSpeeds, 0 last,
rgSioClock			DB    2,   4, 24,24; .. corresponding sioClock values.
									   ; May change at boot in InitClstr.

;*****************************************************************************
; STATISTICS
;*****************************************************************************
PUBLIC nCrcError, nOverrunError, nSequenceError, nProtocolError, nAddressError
PUBLIC nLengthError, nTimeout, fResetCounters,nRcvError
PUBLIC nXBlocksFree, nXBlocksSmallFree, nWsActive, statIdleTicksLastSec
PUBLIC statIdleTicksLast10Sec, maxTicksBetweenPolls, nXBlockWaits
PUBLIC nPagesWritten, nPagesRead, nIFramesRrIn, nSnrm, nSnrmReply
PUBLIC nSnrmErrorReply, nFalseTimeout
PUBLIC nWsDumpRequest, nWsDumpComplete, nWsDownTimeout, nWsDownErrors
PUBLIC nWsBootRequest, nWsBootComplete, nWsTotal, nWsAccessLinkRequest,nUnderrun

PUBLIC masterStats, statsfHighSpeed, statsSbVerRun, ticksPerSecond
PUBLIC ticksSinceLastPoll, nXBlocksTotal, nXBlocksSmallTotal, nRnrIn, nRrIn
PUBLIC nXBlockSmallWaits, n4ByteRnr, ppMeterBuffer, oRgDct
PUBLIC ntimespolled,timelastpolled, lastSnrmSent
PUBLIC nYBlksMax, nYBlksMin, nYBlksAvail
PUBLIC nZBlksMax, nZBlksMin, nZBlksAvail
PUBLIC sMasterStats
PUBLIC fDisableCluster

;Beginning of structure needed for GetClusterStatus Request
;DO NOT Change the size of this without changing in CLU.Plm
;This should be moved to an EQU.edf file
masterStats 		LABEL WORD
fDisableCluster		DB 0
revisionLevel 		DB 2		;For ClusterStatus to check
nWsActive 			DW 0
nWsTotal 			DW 0
nXBlocksFree 		DB 0
nXBlocksSmallFree 	DB 0

; The following counts get zeroed when the clock strikes midnight unless
; fResetCounters = 0:
firstCountToZero 	LABEL WORD

nCrcError 			DW 0
nOverrunError 		DW 0
nSequenceError 		DW 0
nProtocolError 		DW 0
nAddressError 		DW 0
nLengthError 		DW 0
nTimeout 			DW 0
nWsDownTimeout 		DW 0
nWsDownErrors 		DW 0
nWsBootRequest 		DW 0
nWsBootComplete 	DW 0
nWsAccessLinkRequest 	DW 0
nWsDumpRequest 		DW 0
nWsDumpComplete 	DW 0
maxTicksBetweenPolls 	DW 0
nSnrm 				DD 0
nSnrmLow 			EQU WORD PTR nSnrm
nSnrmHigh 			EQU WORD PTR nSnrm +2
nSnrmReply 			DD 0
nSnrmReplyLow 		EQU WORD PTR nSnrmReply
nSnrmReplyHigh 		EQU WORD PTR nSnrmReply +2
nSnrmErrorReply 	DD 0
nSnrmErrorReplyLow 	EQU WORD PTR nSnrmErrorReply
nSnrmErrorReplyHigh	EQU WORD PTR nSnrmErrorReply +2
nFalseTimeout 		DW 0
nXBlockWaits 		DD 0
nXBlockWaitsLow 	EQU WORD PTR nXBlockWaits
nXBlockWaitsHigh 	EQU WORD PTR nXBlockWaits+2
nXBlockSmallWaits 	DD 0
nXBlockSmallWaitsLow 	EQU WORD PTR nXBlockSmallWaits
nXBlockSmallWaitsHigh 	EQU WORD PTR nXBlockSmallWaits+2
nIFramesRrIn 		DD 0
nIFramesRrInLow 	EQU WORD PTR nIFramesRrIn
nIFramesRrInHigh 	EQU WORD PTR nIFramesRrIn+2
nIFramesRnrIn 		DD 0
nIFramesRnrInLow 	EQU WORD PTR nIFramesRnrIn
nIFramesRnrInHigh 	EQU WORD PTR nIFramesRnrIn+2
nIFramesRrOut 		DD 0
nIFramesRrOutLow 	EQU WORD PTR nIFramesRrOut
nIFramesRrOutHigh 	EQU WORD PTR nIFramesRrOut+2
nIFramesRnrOut 		DD 0
nIFramesRnrOutLow 	EQU WORD PTR nIFramesRnrOut
nIFramesRnrOutHigh 	EQU WORD PTR nIFramesRnrOut+2
nPagesRead 			DD 0
nPagesReadLow 		EQU WORD PTR nPagesRead
nPagesReadHigh 		EQU WORD PTR nPagesRead+2
nPagesWritten 		DD 0
nPagesWrittenLow 	EQU WORD PTR nPagesWritten
nPagesWrittenHigh 	EQU WORD PTR nPagesWritten+2
statIdleTicksLastSec 	DW 0
statIdleTicksLast10Sec 	DW 0
statsSecondsLow 	DW 0		;Number of seconds
statsSecondsHigh 	DW 0		;we have been keeping statistics
ntimespolled		DD 0		; filled in from lcb_pollsequencenumber
nRnrIn 				LABEL WORD
nRnrInLow 			DW 0
nRnrInHigh 			DW 0
nRrIn 				LABEL WORD
nRrInLow 			DW 0
nRrInHigh 			DW 0
nRnrOut 			LABEL WORD
nRnrOutLow 			DW 0
nRnrOutHigh 		DW 0
nRrOut 				LABEL WORD
nRrOutLow 			DW 0
nRrOutHigh 			DW 0

lastCountToZero 	LABEL WORD

statsfHighSpeed 	DB 0	   ;set by InitClstr_Mstr
statsSbVerRun 		DB 31 DUP (0) ; set by InitClstr_Mstr
ticksPerSecond 		DB 0  ;set by InitClstr_Mstr
               		DB 0  ;word for GetClusterStatus
ticksSinceLastPoll 	DW 0
timelastpolled		DD 0  ; filled in by lcb_pollsystime(low/high)
nXBlocksTotal 		DW 0  ;set by InitClstr_Mstr
nXBlocksSmallTotal 	DW 0  ;set by InitClstr_Mstr
saPerXBlock 		DW 0		;Set by InitClstr_Mstr
saPerSmallRq 		DW 0		;Set by InitClstr_Mstr

PUBLIC nXBlockBoundary, nXBlockSmallBoundary
nXBlockBoundary		DW 0
nXBlockSmallBoundary	DW 0

fCountersReset 		DB 0
lastSnrmSent 		DB 0

; Pointer to pRgMeter. When ClusterStatus wants to turn on Meter, it stores a
; pointer in pRgMeter.

ppMeterBuffer 		DW OFFSET DGroup:pMeterBuffer
              		DW DGroup

; This pointer permits ClusterStatus to fetch status without having to use the
; Request interface. The Request interface slows the system down and thus
; changes what we want to observe.

pMasterStats 		DW OFFSET DGroup:masterStats
             		DW DGroup
oRgDct 				DW 0
filler				DW 0		;for ClusterStatus (was oRgSbWsUserName)

nYBlksMax			DW 0
nYBlksMin			DW 0
nYBlksAvail			DW 0
nZBlksMax			DW 0
nZBlksMin			DW 0
nZBlksAvail			DW 0

n4ByteRnr 			DW 0

; This flag can be set to zero to prevent the counters from being set to zero
; at midnight.

fResetCounters 		DB 0FFh
nRcvError 		DW 0		;not on ngen keep stats same for 
nUnderrun		DW 0            ;cluster status utility
syncC			DW 0		;RTC DOUBLE POLL SYNC FLAG

sMasterStats		DW OFFSET THIS WORD - OFFSET MasterStats + 2
;End of structure

;*****************************************************************************
; VARIABLES FOR DEBUGGING
;*****************************************************************************
%IF (%LogErrors) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC errorLog, errorLogIndex, errorLogDct, errorLogErc, errorLogStationFrame, errorLogLineState, errorLogStation, errorLogPollSequenceNumber, errorLogDctPollSequenceNumber
errorLogEntrySize 	EQU 12
errorLogSize 		EQU 100
errorLogIndexMax 	EQU (errorLogSize-1)*errorLogEntrySize
errorLogIndex 		DW errorLogIndexMax	;so we will start at zero
errorLog 		LABEL WORD
errorLogPollSequenceNumber 	DW 0
errorLogDctPollSequenceNumber 	DW 0
errorLogStation 	DB 0
errorLogLineState 	DB 0
errorLogErc 		DW 0
errorLogStationFrame 	DW 0
errorLogDct 		DW 0
			DB (errorLogSize-1)*errorLogEntrySize DUP (0)
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC fCrashIfWsDown, fCrashIfOldWs
PUBLIC maxTicksSystimePrev, maxTicksSystime
maxTicksSystimePrev 	LABEL WORD
maxTicksSystimePrevLow 	DW 0
maxTicksSystimePrevHigh DW 0
maxTicksSystime 	LABEL WORD
maxTicksSystimeHigh 	DW 0
maxTicksSystimeLow 	DW 0
maxTicksLineState 	DB 0

EVEN
fCrashIfWsDown		DB 0
fCrashIfOldWs		DB 0

; For testing, we can send a bad CRC every n frames
PUBLIC nSendBadCrc, nSendBadCrcReload
nSendBadCrc 		DW 0		;if zero, never send a bad CRC, else
					;every nth is bad
nSendBadCrcReload 	DW 500

PUBLIC nWaitDcd, nWaitingTooLong, nCannotPoll
nCannotPoll 		DW 0
nWaitDcd 		DW 0
nWaitingTooLong 	DW 0

PUBLIC logBuffer, logBufferIndex, logFrameOut, logFrameIn, logErc, logLineState, logFrameNumber, logPollCycle, logDct, logBadCrc
PUBLIC logIntIdle, logIntDcd, logIntWrite, logIntRead
PUBLIC logNXblocksFree
	EVEN
logEntrySize 		EQU 22
logBufferSize 		EQU 100
logBufferIndexMax 	EQU (logBufferSize-1)*logEntrySize
logBufferIndex 		DW logBufferIndexMax	;so we will start at zero
logBuffer 		LABEL WORD
logFrameNumber 		DW 0
logPollCycle 		DW 0
logIntDcd 		DB 0		;will be 0FFh if int on dcd change
logIntIdle 		DB 0		;will be 0FFh if int on idle
logIntRead 		DB 0		;will be 0FFh if int on read
logIntWrite 		DB 0		;will be 0FFh if int on write
logFrameOut 		DW 0
logFrameIn 		DW 0
logErc 			DW 0
logLineState 		DW 0
logBadCrc 		DW 0		; = BADC when bad crc sent
logNXBlocksFree 	DB 0
			DB 0
logDct 			DW 0
			DB (logBufferSize-1)*logEntrySize DUP (0)

%IF (%logXb) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC logXbBuffer, logXbFrameNumber, logXbPollCycle, logXbXBlockOut, logXbIndex, logXbLineState, logXbPollState
logXbEntrySize 		EQU 8
logXbBufferSize 	EQU 20
logXbIndexMax 		EQU (logXbBufferSize-1)*logXbEntrySize
logXbIndex 		DW logXbIndexMax	;so we will start at zero
logXbBuffer 		LABEL WORD
logXbFrameNumber 	DW 0
logXbPollCycle 		DW 0
logXbXBlockOut 		DW 0
logXbLineState 		DB 0
logXbPollState 		DB 0
			DB (logXbBufferSize-1)*logXbEntrySize DUP (0)
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%logTime) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC logTime, logTimeIndex
logTimeSize 		EQU 50
logTimeEntrySize 	EQU 16
logTimeIndexMax 	EQU (logTimeSize-1)*logTimeEntrySize
logTimeIndex 		DW 0
logTime 		LABEL WORD
logTimeInterruptNumber 	DW 0
logTimeCounter 		DW 0
logTimeSystimeLow 	DW 0
logTimeSystimeHigh 	DW 0
logTimeIdleLow 		DW 0
logTimeIdleHigh 	DW 0
logTimeTicks 		DW 0
logTimeLastSec 		DW 0
			DB (logTimeSize-1)*logTimeEntrySize DUP (0)
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

PUBLIC logMsgBuffer, logMsgBufferIndex
logMsgBufferSize 	EQU 50
logMsgEntrySize 	EQU 4
logMsgBufferIndexMax 	EQU (logMsgBufferSize-1)*logMsgEntrySize
logMsgBufferIndex 	DW logMsgBufferIndexMax
logMsgBuffer 		LABEL WORD
logMsgRa 		DW 0
logMsgSa 		DW 0
			DB (logMsgBufferSize-1)*logMsgEntrySize DUP (0)

%IF (%logIn) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC logIn, LogInIndex
logInSize 		EQU 50
logInEntrySize 		EQU 8
logInMax 		EQU (logInSize-1)*logInEntrySize
logInIndex 		DW logInMax
logIn 			LABEL WORD
logInFrame 		DW 0
logInNrNs 		DW 0
logInState 		DW 0
logInXBlock 		DW 0
			DB (logInSize-1)*logInEntrySize DUP (0)
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%logOut) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC logOut, LogOutIndex
logOutSize 		EQU 50
logOutEntrySize 	EQU 8
logOutMax 		EQU (logOutSize-1)*logOutEntrySize
logOutIndex 		DW logOutMax
logOut 			LABEL WORD
logOutNrNs 		DW 0
logOutAck 		DW 0
logOutAckErc 		DW 0
logOutXBlock 		DW 0
			DB (logOutSize-1)*logOutEntrySize DUP (0)
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

lineStateTable LABEL WORD
PUBLIC lineStateTable
;*****************************************************************************
; Line State Table Definition
; Each Dct entry contains an index to a lineStateTable entry. The 
; lineStateTable determines what frame to send next and what to do when a 
; frame has been read back from the workstation.
;*****************************************************************************
statePollingInactive 	EQU 0
lstState     DW RxPollingInactive  	;JMP here when read finished
lstFrameType DB frameTypeSNRM 		;type of frame to send
lstCbAckOut  DB 4             		;number of bytes to ack out
lstFlags     DB 0
lstSize      EQU 5

; Values of lstFlags:

fReadIntoXBlock 	EQU 1
fElseMasterNotReady 	EQU 2
; If we can't read into an XBlock, change the state to MasterNotReady if we
; have a frame ready to send to the workstation.

stateRespondingToRIM 	EQU 1*lstSize ;5
	DW RxRespondingToRIM
	DB frameTypeSIM
	DB 2    ;lstCbAckOut = 2
	DB 0    ;lstFlags

stateRespondingToNewXID EQU 2*lstSize ;0Ah
	DW RxRespondingToNewXID
	DB frameTypeXID
	DB 14   ;lstCbAckOut = 14
	DB 0    ;lstFlags

stateRespondingToXID 	EQU 3*lstSize ;0Fh
	DW RxRespondingToXID
	DB frameTypeXID
	DB 12   ;lstCbAckOut = 12
	DB 0    ;lstFlags

statePrepareToBootOrDump EQU 4*lstSize ;14h
	DW RxPrepareToBootOrDump
	DB frameTypeUP
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock    ;lstFlags

stateBooting 		EQU 5*lstSize ;19h
	DW RxBooting
	DB frameTypeUI
	DB 0    ;lstCbAckOut = 0
	DB 0    ;lstFlags

stateDumping 		EQU 6*lstSize ;1Eh
	DW RxDumping
	DB frameTypeUP
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock    ;lstFlags

stateDumpingError 	EQU 7*lstSize ;23h
	DW RxDumping
	DB frameTypeREJ
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock    ;lstFlags

stateAccessProtocolDone EQU stateDumpingError+1

stateMasterNotReady 	EQU 8*lstSize ;28h
	DW RxMasterNotReady
	DB frameTypeRNR
	DB 2    ;lstCbAckOut = 2
	DB 0    ;lstFlags

stateWorkstationReady 	EQU 9*lstSize ;2Dh
	DW RxWorkstationReady
	DB frameTypeRR
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock    ;lstFlags

stateWorkstationNotReady EQU 10*lstSize ;32h
	DW RxWorkstationNotReady
	DB frameTypeRR
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock + fElseMasterNotReady    ;lstFlags

stateAckIFrame 		EQU 11*lstSize ;37h
	DW RxAckIFrame
	DB frameTypeRR
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock + fElseMasterNotReady    ;lstFlags

stateSendIFrame 	EQU 12*lstSize ;3Ch
	DW RxSendIFrame
	DB frameTypeI
	DB 0    ;lstCbAckOut = 0 to send IFrame
	DB 0    ;lstFlags

stateDisconnecting 	EQU 13*lstSize ;41h
	DW RxDisconnecting
	DB frameTypeDISC
	DB 2    ;lstCbAckOut = 2
	DB 0    ;lstFlags

stateAckNotReady 	EQU 14*lstSize ;46h
	DW RxAckNotReady
	DB frameTypeRNR
	DB 2    ;lstCbAckOut = 2
	DB 0    ;lstFlags

stateSendIFrameMasterReady EQU 15*lstSize ;4Bh
	DW RxSendIFrameMasterReady
	DB frameTypeIMasterReady
	DB 0    ;lstCbAckOut = 0
	DB fReadIntoXBlock    ;lstFlags

stateErrorRecovery 	EQU 16*lstSize ;50h
	DW RxErrorRecovery
	DB frameTypeRR
	DB 2    ;lstCbAckOut = 2
	DB fReadIntoXBlock    ;lstFlags

lastLineState 		EQU stateErrorRecovery

Data ENDS

MstrLph SEGMENT PUBLIC 'CODE'
	ASSUME CS: MstrLph, DS: Dgroup

StartPollRet PROC NEAR
	RET
StartPoll:
PUBLIC StartPoll
;*****************************************************************************
; This is the machine independent portion of the poll routine.
; We get called by 
;	(1) The timeout process when it is time to start the next poll cycle.
;	(2) SendXBlock when we have a frame ready to transmit.
;	(3) The interrupt handler when a read has completed, and we wish to
;	    start the next poll.
;       pollState contains our current polling state.
;       pollState = idle means we are not doing anything. Otherwise:
;       listActive points to the list of dcts currently being polled.
;	dctCurrent points to the dct to poll next
;	pollState = NoPoll means we are enabling interrupts just before changing
;				the state to write.  We dont want anyother process or interrupt
;				to start a poll while we let comm run.
;	pollState = waitDcdDrop means we are waiting for the data carrier
;	            detect to drop so we can start a write.
;	pollState = writing means a write is currently in progress
;	pollState = reading means a read is in progress
; N.B. INTERRUPTS MUST BE DISABLED
;*****************************************************************************
;
;  BP must be set up here in all cases 
;
	CMP  lcb_pollState[BP],stateIdle	;Are we already polling?
	JNE  StartPollRet		;Yes, so exit
	MOV  BX,lcb_dctCurrent[BP]
	LEA  DX,lcb_listActiveHead[BP]	
	CMP  BX,DX				;Back at top of list?
	JNE  StartNewPollCycle	;No
	MOV  BX,[BX]			;BX = listActiveHead
	CMP  BX,DX				;Is listActive empty?
	JE   StartPollRet		;Yes, so exit
StartNewPollCycle:
; Calculate the number of idle ticks that elapsed since the end of the last
; poll cycle. We use this to calculate the amount of time that the line is not
; busy. 
	MOV  CX,lcb_startIdleTimeLow[BP]
	MOV  DX,lcb_startIdleTimeHigh[BP]

	CALL SystimeTicksDiff
	ADD  lcb_idleTicksLastSec[BP],AX
	ADD  lcb_idleTicksLast10Sec[BP],AX

; If startpoll was called because an IFrame was placed on a dct we only want 
; to poll active DCT's  not restart a pollcycle.
	CMP  lcb_fActivePollCycle[BP],0
	JNE  RestartorPollActive
	JMP  RestartPollCycle  

TestActiveDct:
; See if this dct could be polled again. nRepollActive tells how many times
; we should repoll an active dct.  This can be set by Sysgen.  If zero, we
; do not repoll.  Applications that are synchronous (that must wait for a 
; request to return before they will send another to the master), will run
; faster if nRepollActive is zero.
	MOV  AL,dctnRepollActive[BX]
	CMP  AL,0
	JE   TestNextActive
	DEC  AL
	MOV  dctnRepollActive[BX],AL
;	MOV  lcb_fActivePollCycle[BP],AL	; Cleared at cycle start only.
	JMP  StartActivePoll
TestNextActive:
	MOV  BX,dctNext[BX]
	LEA  DX,lcb_listActiveHead[BP]	
	CMP  BX,DX			;Back at top of list?
	JNE  TestActiveDct
EndOfListActive:
; We are back at the beginning of listActive, so we have completed one loop
; through the list of dcts to poll.
; BX points to listActiveHead
	MOV  lcb_dctCurrent[BP],BX
	MOV  BX,[BX]			;BX = listActiveHead
	LEA  DX,lcb_listActiveHead[BP]	
	CMP  BX,DX				;Back at top of list?
	JE   EndOfPollCycleJmp	;Yes, list empty

; We should come up for air once and a while and send a SNRM. See if it's 
; time.
	MOV  AL, timerInterruptsPerSnrm
	CMP  lcb_countSendSnrm[BP], AL
	JA   EndOfPollCycleJmp
; listActive is not empty. See if we should start another poll cycle. If we 
; did not get another timer interrupt during this poll cycle, wait for the 
; next timer interrupt to start a new cycle. 
RestartorPollActive:
	MOV  AX, lcb_timerNumber[BP]
	CMP  AX,lcb_curPollCycleNbr[BP]
	JNE  RestartPollCycleOverrun
; listActive is not empty, and we polled everybody before another timer
; interrupt. We have some spare time. See if anybody wants to be polled again.
	CMP  lcb_fActivePollCycle[BP],0
	JNE  TestDelayedActivePoll
EndOfPollCycleJmp:
	JMP  EndOfPollCycle

TestDelayedActivePoll:
%IF(%VariablePoll) THEN (%'
; Is this a delayed active repoll?
	MOV  AX, 0FFFFh
	XCHG AX,lcb_ActivePollCycleTimeout[BP]
	INC  AX			; Test for 0FFFFh
	JZ   ActivePollCycle
	CMP  lcb_fHighSpeed[BP],0
	JE   ActivePollCycle	; No delayed active @ 307 (TimerIsr can't fix time).
	CMP  lcb_pollCycleTimeout[BP],AX
	JBE  ActivePollCycle	; Not enough time left in cycle,
		;  then skip active poll, will have regular poll cycle very soon.

	SUB  lcb_pollCycleTimeout[BP],AX
	MOV  lcb_pitTimeout[BP],AX
	MOV  lcb_statePit[BP],statePitStartActivePollCycle
%SET(Snrm,1)
%IF(%Snrm) THEN (
	MOV  SI,lcb_listActiveHead[BP]	
	CMP  dctlinestate[SI],statePollingInactive ;Are we snrming?
	JNE  SnrmOk
	INT 2
SnrmOk:
)FI
	PUSH BX					; Save oDct
	PUSH DS
	LEA  AX,lcb_timerIntBlock[BP]
	PUSH AX
	CALL SetTimerInt		; When timer goes off, active poll cycle.
	POP  BX					; Restore oDct
	JMP  EndOfPollCycle

ActivePollCycle:
)FI%'
	
; There are stations that would like to be polled again since we have some 
; free time. Poll only stations that have dctnRepollActive > 0.
	MOV  lcb_fPollActiveOnly[BP],0FFh
	MOV  lcb_fActivePollCycle[BP],0
	JMP  TestActiveDct

RestartPollCycleOverrun:
; We got a timer interrupt during this poll cycle, so we should restart the
; cycle and poll everybody.

RestartPollCycle:
	MOV  AX, lcb_timerNumber[BP]
	MOV  lcb_curPollCycleNbr[BP],AX
	MOV  lcb_fActivePollCycle[BP],0
; Set to poll everybody this cycle.
	MOV  lcb_fPollActiveOnly[BP],0
	JMP  SHORT StartNextPoll

EndOfPollCycle:
PUBLIC EndOfPollCycle
; We are finished with this poll cycle. Save the sysTime so we can calculate
; the number of idle ticks when we get started up again. 
	pushf
	cli
	LES  BX, pSysTime
	mov  AX,sysTimeLow[BX]
	MOV  lcb_startIdleTimeLow[BP],AX
	mov  AX,sysTimeHigh[BX]
	MOV  lcb_startIdleTimeHigh[BP],AX
	POPF
; Set our state to idle. The only time pollState is idle is when we have
; finished a poll cycle and when a timeout occurs.
	MOV  lcb_pollState[BP],stateIdle
	MOV  lcb_ActivePollCycleTimeout[BP],0FFFFh
	RET

EndOfListActiveJmp:
	JMP  EndOfListActive
;*****************************************************************************
; This is the entry from the interrupt handler. A read has completed and we
; wish to start the next poll.
; BX = address of next dct to poll
;*****************************************************************************
PollCurrent:
PUBLIC PollCurrent

; Enable to reduce latency of higher priority interrupts (RS232 comm).
; Called from interrupts, PIT and other processes (via TestNeedXBlock).
; Thus, nested calls are possible.
; Can't get nested interrupts because we haven't sent EOI.
; Disarm cluster interrupt routines -
	MOV  lcb_pollState[BP],stateNoPoll
; PIT won't call nested because SNRM timer not set (stateIdle).
; All that is left is one process interrupting another.
	PUSHF
	STI
	JMP $+2
	POPF
	MOV  lcb_pollState[BP],stateIdle

TestEndOfList:
; See if dctCurrent is pointing to listActive. If so, we are at the end of
; listActive.
	LEA  DX,lcb_listActiveHead[BP]	
	CMP  BX,DX			;Back at top of list?
	JE   EndOfListActiveJmp
; See if we are only polling dcts that were marked "active".
	CMP  lcb_fPollActiveOnly[BP],0
	JE   StartNextPoll
; SNRM can occur in "active" poll cycles, must not delay answer to RIM etc.
	CMP  dctLineState[BX], stateRespondingToXID
	JBE  StartNextPoll
	JMP  TestActiveDct

StartNextPoll:
PUBLIC StartNextPoll
%IF(%VariablePoll) THEN (
	CMP  dctPollCycleNext[BX], 1	; subtract 1 if not already 0
	CMC
	SBB  dctPollCycleNext[BX], 0
	JZ   RipeDct
	CMP  dctLineState[BX],statePollingInactive
	JE   RipeDct
	MOV  BX,dctNext[BX]				; skip this dct.  Still counting down.
	JMP  TestEndOfList

ReloadDctInterval:
	MOV  CL, lcb_cPollCycleIntervalMax[BP]
	MOV  dctPollCycleInterval[BX], CL

RipeDct:
	MOV  CL, dctPollCycleInterval[BX]
	CMP  CL, lcb_cPollCycleIntervalMax[BP]
	JA   ReloadDctInterval
	MOV  dctPollCycleNext[BX], CL
	INC  CL							; wait longer.  Cleared if ws sends frame.
	MOV  dctPollCycleInterval[BX], CL
)FI%' VariablePoll

StartActivePoll:

;	CMP  dctLineState[BX],statePollingInactive
;	JE   JH0
; Boot roms need a minimum delay between polls.  Might be only dct; always
; delay when in link protocol.  Is this for t0 only?
;	CMP  dctLineState[BX],stateRespondingtoRIM ; delay might be a t0
;	JLE  JH
; If station to be repolled is a T0 family then delay repoll.  We can turn
; around the line faster than he can and we will time out on the read.
;JH0:
;%IF(0) THEN (
;	CMP  dcttype[BX],T0Type
;	JNE  JH2
;) ELSE (
;	JMP  Short JH2
;)FI%'
;JH:
;	MOV  CX,1D0h
;JH1:
;	MOV  DX,0
;	LOOP JH1
JH2:
; pollSequenceNumber gets incremented each time we start a poll. The timeout
; process knows if a poll timed out if pollSequenceNumber does not change
; between two timer interrupts.
	MOV  lcb_dctCurrent[BP],BX
	XOR  AX,AX
	ADD  lcb_pollSequenceNumber[BP],1
	ADC  lcb_pollSequenceNumberHigh[BP],AX
; dctPollSequenceNumber gets incremented each time this dct is polled. This is
; helpful when following the error log to know when errors occurred.
	ADD  dctPollSequenceNumber[BX],1
	ADC  dctPollSequenceHigh[BX],AX
	MOV  AL,dctLineState[BX]					
	XCHG SI,AX			;SI points to state table
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logBufferIndex
	ADD  DI,logEntrySize
	CMP  DI,logBufferIndexMax
	JBE  logBufferIndexOk
	MOV  DI,0
logBufferIndexOk:
	XOR  AX,AX
	MOV  logBufferIndex,DI
	MOV  lcb_logbufferindex[BP],DI
	MOV  logIntIdle[DI],AL
	MOV  logIntDcd[DI],AL
	MOV  logIntRead[DI],AL
	MOV  logIntWrite[DI],AL
	MOV  logFrameIn[DI],AX
	MOV  logFrameOut[DI],AX
	MOV  AX,lcb_pollSequenceNumber[BP]
	MOV  logFrameNumber[DI],AX
	MOV  AX,lcb_curPollCycleNbr[BP]
	MOV  logPollCycle[DI],AX
	MOV  logLineState[DI],SI
	MOV  logDct[DI],BX
	MOV  AL,nXBlocksFree
	MOV  logNXBlocksFree[DI],AL
	MOV  AX,lcb_iochannel[BP]
	MOV  logBadCrc[DI],AX
LineStateOk:
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; Zero the retry count if the last poll did not have an error.
	CMP  dctErc[BX],0
	JNE  SetupWrite1
	MOV  dctRetryCount[BX],0
SetupWrite1:
; Continue with hardware dependent code.
	JMP  SetupWrite

TestNeedXBlock:
PUBLIC TestNeedXBlock
;*****************************************************************************
; This is part of StartPoll.
; Come here from Machine dependent code when we are writing from ackOutBuf.
;*****************************************************************************
; We are writing from the ackOutBuf. Check to see if we need an XBlock.
	TEST BYTE PTR lstFlags[SI],fReadIntoXBlock
	JZ   OrSeqBits

TestXBlockAvail:
; We need an XBlock. Check to see if we have an XBlock to read into.
	CMP  lcb_saXBlockCurrent[BP],0
	JNE  OrSeqBits			;We have an XBlock in saXBlockCurrent
;See if an XBlock is available. If so, unchain it from the free list.
	CALL GetXBlock
	JNZ  OrSeqBits			;We have an XBlock in saXBlockCurrent
NoXBlockAvailable:
PUBLIC NoXBlockAvailable
; We don't have an XBlock. See if we can change the state to masterNotReady.
	ADD  nXBlockWaitsLow, 1
	ADC  nXBlockWaitsHigh,0
	LES  DI, pStat
	MOV  AX,nXBlockWaitsLow
	MOV  ES:nWaitXLow[DI],AX			;DHG... update Stat1 in sysgen
	MOV  AX,nXBlockWaitsHigh
	MOV  ES:nWaitXHigh[DI],AX			;...DHG
	TEST BYTE PTR lstFlags[SI],fElseMasterNotReady
	JNZ  ChangeToMasterNotReady

; We don't want to poll this workstation unless it is necessary in order to
; avoid a timeout.
	PUSH CX				;Save count of bytes
	MOV  CX,dctPollSystimeLow[BX]
	MOV  DX,dctPollSystimeHigh[BX]
	CALL SystimeTicksDiff
	POP  CX				;Restore count of bytes to write
	CMP  AX,maxWaitingTicks
	JAE  WaitingTooLong
DontPollDct:
	MOV  BX,dctNext[BX]
	MOV  lcb_dctCurrent[BP],BX
	JMP  PollCurrent

WaitingTooLong:
; If the workstation is booting or dumping, there is nothing we can do. If we
; send any frame other than UI, the workstation will enter searchID mode, so 
; we may as well wait and let the workstation time out. If the state is 
; greater than or equal to stateAccessProtocolDone, the dct is on line (not  
; booting or dumping).
	CMP  dctLineState[BX],stateAccessProtocolDone
	JB   DontPollDct
; The workstation is not booting or dumping, so change the state to
; stateMasterNotReady.

; Don't poll if we are in stateerrorrecover as the state will get coersed
; to statemasternotready and we will get out of sequence. GWH/JA 01/09/92
	CMP	 dctLineState[BX],StateErrorRecovery
	JE	 DontPollDct

ChangeToMasterNotReady:
	MOV  SI,stateMasterNotReady
	MOV  dctLineState[BX],stateMasterNotReady
OrSeqBits:
; OR in sequence number bits. dctNR will always be zero for frame types that 
; do not require a sequence number. Set up the buffer with the station  
; address and frame type.
	MOV  AH,lstFrameType[SI]	;get frame type
	TEST BYTE PTR lcb_SNRMall[BP],0FFh
	JNE  OrSeq20				;only snrm all at boot time
	CMP  AH,093h				;does type equal SNRM
	JNE	 OrSeq20
	INC  BYTE PTR lcb_SNRMnext[BP] ; can't snrm 0 so inc first
	MOV  AL,BYTE PTR lcb_SNRMnext[BP]
	CMP	 AL,63					; last snrm
	JB   OrSeq30				; not yet
	INC  BYTE PTR lcb_SNRMall[BP]	; set flag all done
	JMP  SHORT OrSeq30
OrSeq20:
	MOV  AL,dctStation[BX]		;AL = station we are polling
OrSeq30:
	OR   AH,dctNR[BX]						
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,lcb_logBufferIndex[BP]
	MOV  logFrameOut[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	MOV  ES,lcb_saAckOutBuf[BP]
	JMP  WriteFromAckOutBuf

; Continue with machine dependent code.
CalculatePollInterval:
PUBLIC CalculatePollInterval
; Calculate the time since the last poll for this workstation.
	MOV  CX,dctPollSystimeLow[BX]
	MOV  DX,dctPollSystimeHigh[BX]
	MOV  AX,CX
	OR   AX,DX
	JZ   SaveSystime
FindPollTicksDiff:
	CALL SystimeTicksDiff
	MOV  dctnTicksSinceLastPoll[BX],AX
	MOV  lcb_ticksSinceLastPoll[BP],AX
	CMP  AX,dctnTicksMax[BX]
	JBE  TestMaxPoll
	MOV  dctnTicksMax[BX],AX
TestMaxPoll:
	CMP  AX,maxTicksBetweenPolls
	JBE  SaveSystime
	MOV  maxTicksBetweenPolls,AX
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  CX,dctPollSystimeLow[BX]
	MOV  DX,dctPollSystimeHigh[BX]
	MOV  maxTicksSystimePrevLow,CX
	MOV  maxTicksSystimePrevHigh,DX
	pushf
	cli
	mov  AX,sysTimeLow - ES not loaded
	MOV  maxTicksSystimeLow,AX
	mov  AX,sysTimeHigh - ES not loaded
	MOV  maxTicksSystimeHigh,AX
	POPF
	MOV  AL,dctLineState[BX]
	MOV  maxTicksLineState,AL
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
SaveSystime:
	LES  DI, pSysTime
	pushf
	cli
	mov  AX,sysTimeLow[DI]
; Save systime in the dct so we can calculate the poll interval the next time
; around.
	MOV  dctPollSystimeLow[BX],AX
; Save the systime of the last poll so we can check for timeout.
	MOV  lcb_pollSystimeLow[BP],AX
	mov  AX,sysTimeHigh[DI]
	MOV  dctPollSystimeHigh[BX],AX
	POPF
	MOV  lcb_pollSystimeHigh[BP],AX
; Increment the number of times this workstation was polled.
	XOR  AX,AX
	ADD  dctnTimesPolledLow[BX],1
	ADC  dctnTimesPolledHigh[BX],AX
	CMP  saMeterBuffer,AX
	JE   TestCbWritten
	MOV  DL,1
	MOV  DH,dctLineState[BX]
	CMP  lstCbAckOut[SI],AL
	JNE  MeterAckOut
    MOV  ES,dctSaXblockOut[BX]
	CALL MeterXBlock
; TEMPORARY METER VARIABLE
	MOV  AX,saMeterBuffer
	OR   AX,AX
	JZ   TestCbWritten
	MOV  ES,AX
	MOV  AH,lcb_fActivePollCycle[BP]
	MOV  AL,lcb_fPollActiveOnly[BP]
	MOV  mbVariable,AX
; End temporary meter variable
	JMP  SHORT TestCbWritten
MeterAckOut:
	MOV  ES,lcb_saAckOutBuf[BP]
	MOV  AX,ES:[0]			;CX = stationFrame
	CALL MeterFrame
; TEMPORARY METER VARIABLE
	MOV  AX,saMeterBuffer
	OR   AX,AX
	JZ   TestCbWritten
	MOV  ES,AX
	MOV  AH,lcb_fActivePollCycle[BP]
	MOV  AL,lcb_fPollActiveOnly[BP]
	MOV  mbVariable,AX
; End temporary meter variable
TestCbWritten:
; we used to wait for write to complete if only two bytes but we can't
; do this for multiple lines
;
; R&B ...
	MOV  lcb_pollState[BP],stateWriting	;set state to Writing
	CMP  dctSioClock[BX],4		; Always return when running slower than 1.8M
	JG   WaitForWriteInterrupt
	CMP  lcb_cbWritten[BP],6	; Jump if message size was 6 bytes or less
    JBE  WaitForWrite1

WaitForWriteInterrupt:
;	MOV  lcb_pollState[BP],stateWriting	;set state to Writing
	RET  						; Wait for interrupt

WaitForWrite1:
	JMP  WaitForWrite
; ... R&B

PUBLIC ActivateDct
ActivateDct PROC FAR
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;           ActivateDct: Procedure(oDct)
; This procedure is called by the Agent when a dct is ready to be reactivated.
; The dct is not currently on any list. A dct is taken off the list and the
; Receiver process notified when a station needs the next pages of boot data
; or when a station has a page of dump data.
;       | oDct | +6
;       | CS   | +4
;       | IP   | +2
;       | BP   | <--BP
;*****************************************************************************
	MOV  BX,[BP+6]			;BX points to dct
	PUSHF
;	CLI				;Disable         
	CALL DisableRelatedInterrupts		; R&B - interrupt latency reducer
	CMP  dctActionCode[BX],actionBooting
	JNE  ReactivateDct
	MOV  ES,dctSaXBlockOut[BX]
	MOV  WORD PTR ES:[xbBootPageIndex],0	;first page in XBlock
	CALL PrepareNextBootPage
ReactivateDct:
%IF(%VariablePoll) THEN (%'
	MOV  dctPollCycleInterval[BX], 0
	MOV  dctPollCycleNext[BX], 0
)FI%'
	MOV  BP,dctoLcb[BX]		; get address of lcb
	MOV  DI,lcb_listActiveTail[BP]
	CALL ChainDct
	CALL StartPoll
	POPF				;Enable
	CALL EnableRelatedInterrupts		; R&B - interrupt latency reducer
	POP  BP
	RET  2
ActivateDct ENDP

PUBLIC DeactivateDct
DeactivateDct PROC FAR
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;           DeactivateDct: Procedure(oDct)
; This procedure is called by the Agent to return a dct to listInactive
; in two cases:
; (1) by HandleFatalError if no requests are outstanding, or 
; when the last outstanding request is returned.
; (2) When a boot has completed.
; This is also called by the init code to create listInactive
;       | oDct | +6
;       | CS   | +4
;       | IP   | +2
;       | BP   | <--BP
;*****************************************************************************
	MOV  BX,[BP+6]			;BX points to dct
	PUSHF			;Save int state
	CLI				;Disable
	MOV  BP,dctoLcb[BX]		; get address of lcb
	CALL ChainDctToInactive
	DEC  nWsActive
	POPF			;Restore int state
	POP  BP
	RET  2
DeactivateDct ENDP

PUBLIC Disconnect
Disconnect PROC FAR
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;           Disconnect: Procedure(oDct)
; This procedure is called by the Agent to disconnect a station. When the
; disconnect has completed, put the dct on listInactive.
; Disconnect is called when a dump has completed or
; because of an error condition during booting or dumping:
;	Open of boot file or dump file failed
;	Read of boot record or write of dump record failed
;	bad boot block or bad dump block
;       | oDct | +6
;       | CS   | +4
;       | IP   | +2
;       | BP   | <--BP
;*****************************************************************************
	MOV  BX,[BP+6]			;BX points to dct
	MOV  dctLineState[BX],stateDisconnecting
	MOV  dctNRNS[BX],0		;Zero NR and NS
	DEC  nWsActive 
	PUSHF
	CLI				;Disable
	JMP  ReactivateDct
Disconnect ENDP

PUBLIC ProcessTRB
ProcessTRB PROC FAR
;*****************************************************************************
; This routine gets called by TimerIsr when the timer 
; goes off. This is higher priority than any process.
; AX=f100ms
; BP=rbLcb
;*****************************************************************************
;
	MOV  syncC,AX
	CMP  saMeterBuffer,0		;Is meter on?
	JE   TestExecUp			;No
	MOV  DX,5			;5 = timer interrupt
	CLI
	CALL MeterFrame
	STI
TestExecUp:
	TEST fEnableCluster,1		;Wait for correct time in soft bus sequence
	JNZ  ExecUp
    LES  BX, pfEnableCluster
	MOV  AL,ES:[BX]
	MOV  fEnableCluster,AL
; If the Exec is not up yet, don't do anything except initialize the start of
; our idle time for the calculation of idle time.
	LES  BX, pSysTime
	pushf
	cli
	mov  AX,sysTimeLow[BX]
	MOV  lcb_startIdleTimeLow[BP],AX
	mov  AX,sysTimeHigh[BX]
	MOV  lcb_startIdleTimeHigh[BP],AX
	POPF
	JMP  ProcessTRBExit

ExecUp:
%IF (%XBlockAudit) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CLI				;Disable
	CALL XBlockAudit
	STI				;Enable
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; If the clock just chimed midnight, it is time to reset all the counters.
; Counters can't go forever. A master could be up for weeks.

	LES  BX, pSysTime
	MOV  AX,systimeDayTimes2[BX]
	CMP  AX,prevDayTimes2
	JE   TestClusterDown
	CMP  prevDayTimes2,0		;Is this the first time?
	MOV  prevDayTimes2,AX
	JE   TestClusterDown		;Yes
	TEST AX,1					;Did we just change from PM to AM?
	JNZ  TestClusterDown		;No
	CMP  fResetCounters,0 
	JE   TestClusterDown
	CALL ResetCounters			;We just turned into a pumpkin

TestClusterDown:
	CMP  fGoingDown,TRUE		 ; Is the cluster going down?
	JNE  IncrementCountSendSnrm	 ; No
	CMP  lcb_fDisableCl[BP],TRUE ; already disabled?
	JE   IncrementCountSendSnrm	 ; Yes so only do once
	CMP  rqDelayDisc, 0			 ; Have we counted down yet?
	JNE  DecrementDisconnectCount

DisconnectNext:
; We have counted down the number of ticks specified in the DisableCluster
; request. Now we disconnect all workstations.
	CMP  lcb_pollState[BP],stateIdle ;Are we still polling a workstation?
	JNE  IncrementCountSendSnrm	;Yes
	MOV  BX,lcb_listActiveHead[BP]
	LEA  AX,lcb_listActiveHead[BP]
	CMP  BX,AX
	JE   DisconnectFinished
	MOV  dctErc[BX],ercMasterGoingDown
	CALL UnchainDct
	STI				;Enable
	PUSH BX
	CALL HandleFatalError
	CLI				;Disable
	JMP  DisconnectNext

Disconnectfinished:  
	MOV  lcb_fDisableCl[BP],TRUE	;The cluster has been disabled
	MOV  fDisableCluster,1
	JMP  SHORT IncrementCountSendSnrm ;Don't dec rqDelayDisc, already 0

DecrementDisconnectCount:
%IF(0) THEN (%' This is done in TimerIsr.
; We are going down.
; Decrement the count of the number of ticks before we go down.
; If double polling only decrement every other time.
	TEST syncC, 0FFh
	JZ  IncrementCountSendSnrm
	DEC  rqDelayDisc
)FI%'

IncrementCountSendSnrm:
; Increment countSendSnrm each time through here. When the count gets above
; timerInterruptsPerSnrm, it is time to send a SNRM. countSendSnrm gets reset
; to zero when we receive a good reply or get a timeout. If we get an error on
; the reply, the count will not be reset so that we will send a SNRM again at
; the next opportunity.
	TEST BYTE PTR lcb_SNRMall[BP],0FFh
	JNE  IncSnrm10				; snrm fast at boot time
	MOV  AL, timerInterruptsPerSnrm
	MOV  lcb_countSendSnrm[BP], AL
IncSnrm10:
	TEST syncC,0FFh			; if 100ms inc count
	JZ   Inc2
	INC  lcb_countSendSnrm[BP]
Inc2:
	XOR  AX,AX
	MOV  lcb_dctTimedOut[BP],AX	;Assume no timeout
	MOV  lcb_fTimeout[BP],AL

;Reduce RS232 latency
;	CLI  				;Disable
	CALL DisableRelatedInterrupts	;Disable Cluster and Timer Interrupts

	TEST syncC,0FFh			; if double poll keep 10th sec
	JZ   TestTimeout		
	INC  lcb_counter1Sec[BP]
	CMP  lcb_counter1Sec[BP],10
	JNE  TestTimeout
; Each seconds increment the number of seconds the master has been up.
	LEA  DX,OFFSET DGROUP: rgLcb [0]
	CMP  BP,DX			; only do once to keep numbers right
	JNE  Statjump
	ADD  statsSecondsLow,1
	ADC  statsSecondsHigh,AX
Statjump:

; Each second, save the number of idle ticks in the last second.
	MOV  lcb_counter1Sec[BP],AL
	XCHG AX,lcb_idleTicksLastSec[BP]
; idleTicksLastSec = 0, counter1Sec = 0, AX = number of idle ticks last second.
	MOV  lcb_statIdleTicksLastSec[BP],AX
	INC  lcb_counter10Sec[BP]
	CMP  lcb_counter10Sec[BP],10
	JNE  TestTimeout
; Each 10 seconds, save the number of idle ticks in the last 10 seconds.
	XOR  AX,AX
	MOV  lcb_counter10Sec[BP],AL
	XCHG AX,lcb_idleTicksLast10Sec[BP]
; idleTicksLast10Sec = 0, counter10Sec = 0, AX = number of idle ticks last 10
; seconds.
	MOV  lcb_statIdleTicksLast10Sec[BP],AX
	
TestTimeout:
; if snrming let the PIT take care of the timeout
	MOV  BX,lcb_dctCurrent[BP]
	LEA  DX,lcb_listActiveHead[BP]	
	CMP  BX,DX			;no active dct?
	JE   TestT1			;No
	CMP  dctlinestate[BX],statePollingInactive ;Are we snrming?
	JNE  TestT1
	JMP  ProcessTRBExit		; yes so exit
TestT1:
; See if a poll timed out. If pollSequenceNumber = lastPollSequenceNumber  then
; we are waiting for the same read as the last time we were interrupted.
	CMP  lcb_pollState[BP],stateNoPoll	;Test for stateIdle
	JBE  NoTimeout1
	MOV  AX,lcb_pollSequenceNumber[BP]
	CMP  AX,lcb_lastPollSequenceNumber[BP]
	MOV  lcb_lastPollSequenceNumber[BP],AX
	JE	 TestT2	
	JMP  NoTimeout			
TestT2:
; It looks like we may have a timeout, but we could have two TRBs close
; together. Calculate the number of ticks since the last poll and see if we
; really have a timeout.

%IF(0) THEN (
; We claim nFalseTimeout is an obsolete concept because we no longer use both 
; RTC and PIT for timing.  Should be removed in next (>3.3) release - AT/JA.
; Removed, 03/20/93 by FW, caused line hangs due to race conditions between the
; PIT and RTC on some machines.
	MOV  CX,lcb_pollSystimeLow[BP]
	MOV  DX,lcb_pollSystimeHigh[BP]
	CALL SystimeTicksDiff
	CMP  AX,lcb_timeoutTicks[BP]
	JAE  Timeout
	INC  nFalseTimeout
	JMP  TimeoutHandled
) ELSE (
	JMP  Timeout
)FI%'

NoTimeout1:
	MOV  BX,lcb_listActiveHead[BP]
	LEA  DX,lcb_listActiveHead[BP]	
	CMP  BX,DX			;Back at top of list?
	JE   Not2
	PUSHF
	CLI
	CALL UnchainDct					; unchain head of list and chain to 
	MOV  lcb_dctCurrent[BP],SI
	MOV  DI,lcb_listActiveTail[BP]	; tail of list for fairness of polling
	CALL ChainDct
	POPF
Not2:
	JMP  SHORT TimeoutHandled

Timeout:
PUBLIC Timeout
	MOV  lcb_fTimeout[BP],0FFh	;So we won't send a SNRM this time
; The poll timed out. Disable the state machine and the Dma. dctCurrent points
; to the dct that timed out. We want to continue polling where we left off. If
; we have had too many timeouts for this dct, unchain it from listActive and
; send it to the MstrAgentReceiver.

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,lcb_logBufferIndex[BP]
	MOV  logErc[DI],ercTimeout
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	INC  nTimeout
	CALL StopRead			;on return BX points to dct that timed out
	INC  dctnTimeout[BX]
	CMP  dctLineState[BX],stateDisconnecting
	JNE  NotDisconnecting
; If we sent a DISC to the workstation and did not get a response,
; put this dct on listInactive.
	CALL MoveDctToInactive		;Sets dctCurrent to next in listActive
	JMP  SHORT TimeoutHandled

NotDisconnecting:
; Set to poll the next workstation in listActive.
	MOV  AX,dctNext[BX]
	MOV  lcb_dctCurrent[BP],AX
	MOV  DX,dctErc[BX]		;Save previous erc
	MOV  CX,ercTimeout
	CALL HandleError		;Log error only
; Don't check the maxTimeoutCount if the previous error was not a timeout.
	CMP  DX,ercTimeout
	JNE  TimeoutHandled
	CMP  AL,maxTimeoutCount
	JB   TimeoutHandled
	MOV  lcb_dctTimedOut[BP],BX
	CALL UnchainDct
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CMP  fCrashIfWsDown,0FFh
	JNE  DontCrashIfWsDown
	CMP  dctLineState,stateAccessProtocolDone
	JB   DontCrashIfWsDown
	MOV  AX,6
	PUSH AX
	CALL Crash
DontCrashIfWsDown:
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; If workstation was online, increment the count of the number of workstations
; that went down due to timeout.
	CMP  dctLineState[BX],stateAccessProtocolDone
	JB   TimeoutHandled
	INC  nWsDownTimeout

TimeoutHandled:
NoTimeout:
	CALL PreparePollInactive
	CALL StartPoll
; We have started the next poll cycle. If a poll timed out, clean up this dct.
	MOV  CX,lcb_dctTimedOut[BP]
	JCXZ ProcessTRBExit
	STI				;Enable
	PUSH CX
;HandleFatalError calls DeactivateDct to put dct back on listunresponsive.
	CALL HandleFatalError					

ProcessTRBExit:
;	STI				;Enable
;Reduce RS232 latency
	CALL EnableRelatedInterrupts	;Reenable Cluster and Timer Ints

	RET
ProcessTRB ENDP

PUBLIC SendXBlock
SendXBlock PROC FAR
	PUSH BP
;*****************************************************************************
; This procedure is called by the Agent when it has an XBlock ready to
; transmit. 
; ES points to XBlock to send. 
; The XBlock is currently on dctSaXBlockIn. We remove it from this
; list and chain in onto the end of dctSaXBlockOut.
;*****************************************************************************
	CALL UnchainXBlock		;Comes back with interrupts enabled
	MOV  BP,dctoLcb[BX]		; get address of lcb

; Restore response field of request -- used by WsAgent to know what request is
; being returned.
	MOV  AX,ES:[xbRespExch]
	MOV  ES:[xbRqRespExch],AX
%IF (%LogXb) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logXbIndex
	ADD  DI,logXbEntrySize
	CMP  DI,logXbIndexMax
	JBE  logXbIndexOk
	MOV  DI,0
logXbIndexOk:
	MOV  logXbIndex,DI
	MOV  AX,lcb_pollSequenceNumber[BP]
	MOV  logXbFrameNumber[DI],AX
	MOV  AX,lcb_curPollCycleNbr[BP]
	MOV  logXbPollCycle[DI],AX
	MOV  logXbXBlockOut[DI],ES
	MOV  AL,dctLineState[BX]
	MOV  logXbLineState[DI],AL
	MOV  AL,lcb_pollState[BP]
	MOV  logXbPollState[DI],AL
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; Link the XBlock onto the tail of dctSaXBlockOut. The order in which we 
; return the XBlocks is not important, but it is possible that the first 
; XBlock on the list is being sent at this very moment, so we cannot link the 
; new one onto the head of the list.
	LEA  SI,dctSaXBlockOut[BX]

;Reduce RS232 latency
;	PUSHF
;	CLI  				;Disable
	PUSH ES
	CALL	DisableRelatedInterrupts	;Disable Cluster and Timer INTs
	POP  ES
	CALL ChainXBlock

; Don't make this DCT active if we a retrying a poll to any DCT.  On IOGA
; machines, tx underruns are frequent and to prevent back to back underruns
; on the same dct, to activate any dct's during retrys.
	CMP  dctRetryCount[BX],0
	JNE  SendXBlockRet

	MOV  AL,nRepollActive
	CMP  AL,1
	ADC  AL,0			;at least 1
	MOV  dctnRepollActive[BX],AL
	MOV  lcb_fActivePollCycle[BP],AL
	CMP  lcb_pollState[BP],stateIdle ;Are we polling anyone?
	JE   TestWsReady		;No
	CMP  lcb_dctCurrent[BP],BX	;Is this workstation being polled?
	JE   SendXBlockRet		;If so, then exit
	CMP  dctLineState[BX],stateWorkstationReady
	JNE  SendXBlockRet
	MOV  dctLineState[BX],stateSendIFrame
; Check to see if this workstation can exchange IFrames. If so, we want to turn
; off the 10h bit in the CField to tell the WS we can receive an IFrame in
; response to the one we are sending.
	CMP  dctRevisionLevel[BX],90h
	JBE  SendXBlockRet
	MOV  dctLineState[BX],stateSendIFrameMasterReady
	JMP  SendXBlockRet
TestWsReady:
; If this workstation is ready, change the state to stateSendIFrame.
; Otherwise we will have to poll the workstation before we can send.
	CMP  dctLineState[BX],stateWorkstationReady
	JE   ChangeToSendIFrame
	CMP  dctLineState[BX],stateAckNotReady	; Not ready because of XBlock limit
	JNE  CallStartPoll
ChangeToSendIFrame:
	MOV  dctLineState[BX],stateSendIFrame
; Check to see if this workstation can exchange IFrames. If so, we want to turn
; off the 10h bit in the CField to tell the WS we can receive an IFrame in
; response to the one we are sending.
	CMP  dctRevisionLevel[BX],90h
	JBE  CallStartPoll
	MOV  dctLineState[BX],stateSendIFrameMasterReady
CallStartPoll:
	CALL StartPoll
SendXBlockRet:

;Reduce RS232 latency
;	POPF				;Enable
	CALL EnableRelatedInterrupts	;Reenable Cluster and Timer INTs

	POP  BP
	RET

SendXBlock  ENDP

%IF(0) THEN (%' removed t0 support
PUBLIC SendT0XBlock
SendT0XBlock PROC FAR
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
; This procedure is called by the Agent when it has an XBlock ready to
; transmit from SendT0Req.  The XBlock is not linked to dctSaXBlockIn.
;*****************************************************************************
	MOV  BX,[BP+6]			; oDct
	MOV  ES,[BP+8]			; XBlock
	MOV  AX,ES:[xbRqRespExch]
	MOV  ES:[xbRespExch],AX
	MOV  AX,dctNOutstanding[BX]	;AL = dctNOutstandingRq
					;AH = dctNOutstandingSmallRq

	INC  AL				;increment total requests outstanding
	MOV  dctNOutstanding[BX],AX

	CALL SendT0
	POP  BP
	RET  4
SendT0XBlock ENDP
)FI
PUBLIC ReadInterrupt
ReadInterrupt PROC FAR
;*****************************************************************************
; This is the beginning of the read interrupt handling. This is a FAR PROC 
; so that we will return FAR to the interrupted process.
;*****************************************************************************

RxPollingInactive:
PUBLIC RxPollingInactive
;*****************************************************************************
; We have just finished reading a reply to a SNRM.
; The reply is in ackInBuf and AX.
; ES points to ackInBuf.
; There could be a race condition with TimerIsr, so check to be sure we did
; not already get a timeout for this dct.
;*****************************************************************************
	MOV  DL,statePitIdle
	XCHG DL,lcb_statePit[BP]	;Disarm timeout pit
	JNZ  SnrmError
	ADD  nSnrmReplyLow,1
	ADC  nSnrmReplyHigh,0
	CMP  DL,statePitSnrmTimeout	; Timer was still pending?
	JNE  IsrDone1				;  jmp if not pending, had expired.

	MOV  timerInterruptsPerSnrm, 1	; Got reply, SNRM lots, client(s) waiting
	MOV  lcb_SnrmNext[BP], 0	; Reset fast-snrm timer
	MOV  lcb_countSendSnrm[BP],CL	;Zero countSendSnrm to wait a
	CMP  AH,frameTypeRIM		; while before sending another SNRM
	JE   RespondToRIM
	CMP  AH,frameTypeXid
	JE   RespondToNewXID
	CMP  AH,frameTypeUA
	JE   RespondToUA
	MOV  CX,ercProtocolError
SnrmError:
	ADD  nSnrmErrorReplyLow,1
	ADC  nSnrmErrorReplyHigh,0
; If we got an error on the reply to our snrm, remove the dct from
; listActive. We will send another SNRM at the next opportunity.
	CMP  DL,statePitSnrmTimeout	; Timer was still pending?
	JE   ResendSnrm
IsrDone1:
	JMP  IsrDone

NewUserWentDown:
; Come here if we did not get all the way through the protocol to establish a
; new connection. 
	DEC  nWsActive
ResendSnrm:
	CALL HandleError		;Log this error
	CALL UnchainDct
	MOV  lcb_dctCurrent[BP],SI
; Chain current dct pointed to by BX onto listInactive. 
	CALL ChainDctToInactive
; Set up countSendSnrm so that we will send a SNRM
; at the next timer interrupt.
	MOV  AL, timerInterruptsPerSnrm
	MOV  lcb_countSendSnrm[BP], AL
	MOV  BX,lcb_dctCurrent[BP]
	JMP  PollCurrentDct

RespondToRIM:
PUBLIC RespondToRIM
;*****************************************************************************
; When a workstation responds to a SNRM with a RIM, it is preparing to either 
; boot or dump. We must answer a RIM immediately with a SIM. We must not poll 
; another workstation before responding. 
;*****************************************************************************		
	CALL CheckT0
	MOV  dctLineState[BX],stateRespondingToRIM
	JMP  PollCurrentDct

RespondToUA:
Public RespondToUA
;*****************************************************************************
; We got a UA in response to our SNRM.
; We are entering access link protocol. We must respond immediately to the UA.
; The master is not ready to receive a frame. Send RNR to the workstation.
;*****************************************************************************		
	CALL CheckT0
	INC  nWsAccessLinkRequest
	MOV  dctLineState[BX],stateMasterNotReady
	JMP  PollCurrentDct

RespondToNewXID:
PUBLIC RespondToNewXID
;*****************************************************************************
; When a workstation responds to a SNRM with an XID, it is preparing to enter 
; resource access protocol.  Save the software revision level of the WS to 
; see if it can exchange IFrames. Send an XID in response. 
; If this workstation can change station addresses, see if we have
; a dct with a station address > 31. If so, assign a new station address to
; this workstation. This permits us to support more than 31 workstations, even
; though the boot rom will only support 31.
; AL = stationAddress
;*****************************************************************************		
	CALL CheckT0
	MOV  AH,BYTE PTR ES:[xidRevisionLevel]
	MOV  DL,BYTE PTR ES:[xidDAINumber]

	MOV  SI,0-2		; initial loop value
	MOV  CX,lcb_KHLineSpeed[BP]
	CMP  DI, cbXidKHLineSpeed
	JB   FindSioClock
	MOV  CX, ES:[xidKHLineSpeed]
FindSioClock:
	ADD  SI,2
	CMP  CX, rgKHLineSpeed[SI]
	JB   FindSioClock
	SHR  SI,1
	MOV  CL, rgSioClock[SI]
	MOV  bSioClock, CL

; If we are in fixed ID mode, then we don't want to change our address. 
	CMP  fFixedId,0
	JNE  RespondWithXID
	CMP  AH,90h
	JLE  RespondWithXID
	MOV  CX,lcb_listInactive31PlusHead[BP]
	PUSH AX
	LEA  AX,lcb_listInactive31PlusHead[BP]
	CMP  CX,AX
	POP  AX
	JNE  ChangeStationAddress	;Change to stationAddress > 31
; We don't have any station addresses left that are > 31. See if we can change
; it to	an address in the range 16 to 31.
	CMP  dctStation[BX],15
	JA   RespondWithXID		;station address already > 15          
	MOV  CX,lcb_listInactive16To31Head[BP]
	PUSH AX
	LEA  AX,lcb_listInactive16To31Head[BP]
	CMP  CX,AX
	POP  AX
	JE   RespondWithXID		;no dcts with stationAddress > 15
ChangeStationAddress:
; Change the station address of this dct. We will send an XID to the station,
; and the XID will be sent to the new address. We will save the address we are
; responding to in the XID so that the receiving station can check and see if
; the XID is addressed to it.
; CX has address of list head.
; AL has original stationAddress
; AH has revisionLevel of workstation.
; DL has DAINumber
	PUSH DX				;Save DAI Number
	PUSH AX				;Save revision level and oldAddress
	PUSH dctPrev[BX]		;Save address of previous dct
; Unchain dct from the active list.
	CALL UnchainDct
; And put it back on the low station address list.
	CALL ChainDctToInactive
; Unchain a dct from a list with a higher station address.
	MOV  BX,CX			;BX = address of dct to exchange
	CALL UnchainDct
; Chain this higher station address dct back in the active list.
	POP  DI			;Chain new dct back where it was in list
	CALL ChainDct
	CALL InitializeDct
	MOV  lcb_dctCurrent[BP],BX
	POP  AX				;Restore revision level and oldAddress
	POP  DX				;Restore DAI Number 
RespondWithXID:
PUBLIC RespondWithXID
	MOV  dctRevisionLevel[BX],AH
	MOV  CL,bSioClock
	MOV  dctSioClock[BX],CL

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CMP  fCrashIfOldWs,0FFh
	JNE  OldWsOk
	CMP  AL,90h
	JA   OldWsOk
	MOV  AX,3
	PUSH AX
	CALL Crash
OldWsOk:
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	MOV  ES,lcb_saAckOutBuf[BP]
	MOV  ES:[xidOldAddress],AL
;
; Does this WS have an DAI module?
	CMP  DL,0
	JE   NoDAI
	DEC  DL							; we found DAI +1 in the frame
;
; We must verify that this DAI Number is not yet used.
; We must glance through all the DCTs because the active DCTs can be in the
; ListActive or sent to MasterAgentReceiver.
;
	MOV  SI,oRgDct
	MOV  CX,nDct
	JCXZ  NODAI
DAIyetUsed:
	CMP  DL,dctDAINumber[SI]
	JNE  SearchDctNext
	CMP  BX,SI
	JNE  NoDAI
SearchDCTNext:
	ADD  SI,dctSize
	LOOP DAIYetUsed
	MOV  dctDAINumber[BX],DL
NoDAI:
	MOV  dctLineState[BX],stateRespondingToNewXID
	JMP  PollCurrentDct

RxRespondingToRIM:
PUBLIC RxRespondingToRIM
;*****************************************************************************
; Come here when we have finished reading the response to our SIM.
; ES points to ackInBuf.
; We expect to receive an XID in the ackInBuf. Byte 2 should contain the
; OS type of the workstation, which we save in the dct.
;*****************************************************************************
	JNZ  RimError
	CMP  AH,frameTypeXid
	JNE  RimProtocolError
	MOV  AH,BYTE PTR ES:[xidRevisionLevel]
	MOV  dctRevisionLevel[BX], AH		;store the revision level for dumps

	MOV  AL,BYTE PTR ES:[xidOsType]		;AL has Os type
	MOV  dctLineState[BX],stateRespondingToXID

%IF (%Ngen) THEN (
	CMP  DI,2
	JA   StoreOsType
; If this is an old style XID, the workstation sent only one byte of data 
; (the OS type), and it was not stored in the buffer by the Dma.
	MOV  AL,lastByteRead
) ELSE (
	CMP  DI,3
	JA   StoreOsType
)FI

	MOV  dctLineState[BX],statePrepareToBootOrDump
StoreOsType:
	MOV  dctOsType[BX],AL
; Temporary kludge that may or may not work. The NGen boot ROM has a bug. It
; should send us the WsType in the XID. In error recovery, it moves the WsType
; that it receives into its own WsType field (which is a bug!). We end up
; getting zero for a WsId, and disconnect the workstation because we don't have
; a boot file for it. So back the same ID we receive.
	MOV  ES,lcb_saAckOutBuf[BP]
	MOV  ES:[xidOsType],AL
	JMP  PollCurrentDct
RimProtocolError:
	MOV  CX,ercProtocolError
RimError:
; If we got an error on the reply to our SIM, unchain this dct and set up to
; send a SNRM at the next opportunity.
	JMP  NewUserWentDown

RxRespondingToXID:
PUBLIC RxRespondingToXID
;*****************************************************************************
; We go a RIM in response to a SNRM, sent a SIM, got back an XID. The station
; responded with a new XID, so we sent back our own XID.
; Station may be booting or dumping.
; Come here when we get the response to the XID we sent. We are expecting UA.
;*****************************************************************************

	JNZ  XidResponseError
	CMP  AH,frameTypeUA
	JNE  XidProtocolError
	MOV  dctLineState[BX],statePrepareToBootOrDump
	JMP  SetActiveAndPollNext
XidProtocolError:
	MOV  CX,ercProtocolError
XidResponseError:
; If we got an error on the reply to our XID, unchain this dct and set up to
; send a SNRM at the next opportunity.
	JMP  NewUserWentDown

RxPrepareToBootOrDump:
PUBLIC RxPrepareToBootOrDump
;*****************************************************************************
; We sent UP to the workstation. 
; The response is in the XBlock pointed to by ES (saXBlockCurrent).
; We expect UA if the workstation wants to boot, 
; or UI if the workstation wants to dump.
;*****************************************************************************		
	JNZ  BootOrDumpError
	CMP  AH,frameTypeUA
	JE   PrepareToBoot
	CMP  AH,frameTypeUI
	JE   PrepareToDump
	MOV  CX,ercProtocolError
BootOrDumpError:
	JMP  HandleErrorAndPollNext

PrepareToBoot:
; This workstation wants to boot. We have an XBlock which we will use for the
;  entire booting process. Save the pointer to the XBlock in dctSaXBlockOut
; and  get another XBlock for the next poll. Unchain this dct and send it to
; the  MstrAgentReceiver. dctActionCode of actionBooting will cause the 
; MstrAgentReceiver to call BootRequest. BootRequest will read as many pages
; of  the boot file as will fit into the XBlock. When the request has
; completed,  the Agent will call ActivateDct.
	INC  nWsBootRequest
	MOV  dctSaXBlockOut[BX],ES
	CALL GetXBlock
	MOV  dctLineState[BX],stateBooting
	MOV  dctActionCode[BX],actionBooting
	JMP  SendDctToMstrAgentReceiver

PrepareToDump:
; This workstation wants to dump. This first dump block is in the XBlock
; pointed to by ES (saXBlockCurrent). Save the pointer to the XBlock in 
; dctSaXBlockIn. Get another XBlock for the next poll. Unchain this  dct and
; send it to the MstrAgentReceiver. dctActionCode of actionDumping will  cause
; the MstrAgentReceiver to call DumpRequest. DumpRequest will write the  page
; to the dump file. When the request has completed, the Agent will  free the
; XBlock, and call ActivateDct.
	INC  nWsDumpRequest
	MOV  dctLineState[BX],stateDumping
	MOV  dctActionCode[BX],actionDumping
	JMP  SendDumpBlock

RxBooting:
PUBLIC RxBooting
;*****************************************************************************
; We just sent a boot block to a workstation. 
; The response is the ackInBuf and AH. We expect UA.
; dctSaXBlockOut points to the XBlock.
; xbBootPagesInXBlock is the number of pages total in the XBlock.
; xbBootPageIndex is the number of the last page sent.
; xbBootPagesTotal is the total number of pages to send.
;*****************************************************************************		
	JNZ  BootingError
	CMP  AH,frameTypeREJ
	JNE  BootNotRejected
; If the workstation sent REJ in response to our page of boot data, send
; the page again.
	JMP  PollNextDct
BootNotRejected:
	CMP  AH,frameTypeUA
	JNE  BootingProtocolError
	MOV  ES,dctSaXBlockOut[BX]
	CMP  WORD PTR ES:[xbBootPagesTotal],CX	;Test for zero
	JE   BootingFinished
	MOV  AX, ES:[xbCbData]
	SHR  AX, 9
	SUB  ES:[xbBootPagesTotal], AX
	JZ   LastBootPageSent
	ADD  ES:[xbBootPageIndex], AX
	MOV  AX,ES:[xbBootPageIndex]
	CMP  AX,ES:[xbBootPagesInXBlock]
	JAE  GetNextBootPage
	CALL PrepareNextBootPage
	JMP  SetActiveAndPollNext
BootingFinished:
; We have sent all boot pages and the starting address. Send the dct to  the
; MstrAgentReceiver. The MstrAgentReceiver will know from the zero 
; dctNBootPagesTotal that we are finished. The MstrAgentReceiver will free the 
; XBlock and return the dct to listInactive.

GetNextBootPage:
	MOV  dctActionCode[BX],actionBooting
	JMP  SendDctToMstrAgentReceiver

LastBootPageSent:
; When the last boot page has been sent, we still need to send the starting
; address as the last block. Change the count to send only 6 bytes. Change
; xbDmaAddr to point to the first page in the XBlock following the request. 
	INC  nWsBootComplete
	MOV  ES,dctSaXBlockOut[BX]
	MOV  WORD PTR ES:[xbCbData],6
	MOV  AX,ES:[xbBootRaStart]
	MOV  ES:[xbBootBx],AX
	MOV  AX,ES:[xbBootSaStart]
	MOV  ES:[xbBootDs],AX
	MOV  DI,xbBootStation
	CALL CalculateDmaAddr
	JMP  SetActiveAndPollNext

BootingProtocolError:
	MOV  CX,ercProtocolError

BootingError:
	JMP  HandleErrorAndPollNext

RxDumping:
RxDumpingError:
PUBLIC RxDumping
;*****************************************************************************
; We processed a dump block and sent UP to the workstation. The response is in 
; the XBlock pointed to by ES (saXBlockCurrent). We expect another UI dump 
; block or a RD if the workstation has finished dumping. Save the pointer to 
; the XBlock in dctSaXBlockIn. Get another XBlock for the next poll. 
; Unchain this dct and send it to the MstrAgentReceiver. dctActionCode of 
; actionDumping will cause the MstrAgentReceiver to call DumpRequest. 
; DumpRequest will write the page to the dump file. When the request has 
; completed, the Agent will free the XBlock and call ActivateDct. If this is a 
; DISC, the length of the response will be less than pageSize+6, and 
; DumpRequest will call Disconnect to disconnect the dct.
;*****************************************************************************		
	JNZ  DumpingError
	MOV  dctLineState[BX],stateDumping
	MOV  dctActionCode[BX],actionDumping
	CMP  AH,frameTypeUI
	JE   SendDumpBlock
	CMP  AH,frameTypeREJ
	JNE  TestDumpDone
	MOV  CX,ercREJ
	JMP  SHORT DumpingError

TestDumpDone:
	CMP  AH,frameTypeRD
	JNE  DumpingProtocolError
	INC  nWsDumpComplete

SendDumpBlock:
	CALL ChainXBlockIn
	JMP  SendDctToMstrAgentReceiver

DumpingProtocolError:
	MOV  CX,ercProtocolError

DumpingError:
; If we got an error reading the next frame, send REJ to the workstation.
; The workstation will resend the last frame.
	MOV  dctLineState[BX],stateDumpingError
	JMP  HandleErrorAndPollNext

RxRespondingToNewXID:
PUBLIC RxRespondingToNewXID
;*****************************************************************************
; Come here when we get the response to the XID we sent. We are expecting a 
; UA. When a workstation responds to a SNRM with an XID, it is preparing to 
; enter resource access protocol. 
;*****************************************************************************		
	JNZ  NewXidError
	CMP  AH,frameTypeUA
	JNE  NewXidProtocolError
	MOV  dctLineState[BX],stateMasterNotReady
	INC  nWsAccessLinkRequest
	JMP  PollCurrentDct

NewXidProtocolError:
	MOV  CX,ercProtocolError

NewXidError:
; If we got an error on the reply to our XID, unchain this dct and set up to
; send a SNRM at the next opportunity.
	JMP  NewUserWentDown

RxAckIFrame:
PUBLIC RxAckIFrame
;*****************************************************************************
; We sent RR to the workstation in response to an IFrame received.
; We read the reply into the XBlock pointed to by ES (saXBlockCurrent).
;*****************************************************************************


RxWorkstationReady:
RxWorkstationNotReady:
PUBLIC RxWorkstationReady
;*****************************************************************************
; We sent RR to the workstation.
; We read the reply into the XBlock pointed to by ES (saXBlockCurrent).
;*****************************************************************************

	JNZ  WsReadyReplyError
	ADD  nRrOutLow,1
	ADC  nRrOutHigh,0
	TEST AH,1			;If low bit is zero,
%IF(%Aug87JA) THEN(
	JZ   RRCheckSequence
) ELSE (
	JZ   IFrameReceived		;we received an IFrame
)FI

%IF(%VariablePoll) THEN (%'
	CMP  lcb_fPollActiveOnly[BP],0
	JE   NoFrameReceived
; This must be a timed active poll, ws missed chance to send a Request.
; Active poll more slowly.
	XOR  CL, Cl
	CMP  dctShActivePoll[BX], shRepollMax	; Longer delay next time active
	RCL  CL, 3								;   polling this ws, but no longer
	ADD  dctShActivePoll[BX], CL			;   than a poll cycle.
; Poll soon when ws answers RR in active poll cycle.
; Might have been just a little fast.
	CALL ReqTimedActiveCycle

NoFrameReceived:
)FI%'

; If we did not get an IFrame, return the XBlock to the free list.
; Then look to see if we got RR or RNR.
	MOV  dctLineState[BX],stateWorkstationReady
	JMP  TestForRR

WsReadyReplyError:
	ADD  nRrOutLow,1
	ADC  nRrOutHigh,0
	JMP  HandleErrorAndPollNext

%IF(%Aug87JA) THEN(
RRPollSequenceError:
	JMP  PollSequenceError

RRCheckSequence:
	MOV  DH,AH			;Preserve AH in case of error
	AND  DH,0E0h			;Sequence number comes in bits 7 6 5
	CMP  DH,dctNS[BX]
	JNE  RRPollSequenceError
)FI

IFrameReceived:
PUBLIC IFrameReceived
;*****************************************************************************
; ES and saXBlockCurrent point to IFrame received.
; DI contains count of bytes read.
; Chain this XBlock onto dctSaXBlockIn and 
; Get another XBlock from the free list for the next poll.
; Mediate this interrupt so that we can send a message to the
; MstrAgentReceiver. 
; This dct will stay on the active list for the duration of the poll cycle.
;*****************************************************************************

%IF (%LogIn) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  SI,logInIndex
	ADD  SI,logInEntrySize
	CMP  SI,logInMax
	JB   logInIndexOk
	MOV  SI,0
logInIndexOk:
	MOV  logInIndex,SI
	MOV  logInFrame[SI],AX
	MOV  DX,dctNRNS[BX]
	MOV  logInNrNs[SI],DX
	MOV  logInXBlock[SI],ES
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	ADD  dctnIFramesLow[BX],1
	ADC  dctnIFramesHigh[BX],0

	MOV  DX,ES:[xbCbDataSent]
	AND  DH, 7Fh
; DI contains the number of bytes transferred. Check to be sure this is the
; same as the number of bytes sent by the WS agent.
	SUB  DI,2			;DI = xbCbData-2
	CMP  DI,DX
	JE   CheckSequenceNumber
	JMP  IFrameLengthError

; Check the sequence number of this frame. 
CheckSequenceNumber:
	MOV  DH,AH			;Preserve AH in case of error
	SHL  DH,1			;Sequence number comes in bits 3 2 1
	SHL  DH,1
	SHL  DH,1
	SHL  DH,1			;Now sequence is in bits 7 6 5
	CMP  DH,dctNR[BX]
	JE   IFrameSequenceOk

; The IFrame we received is not in sequence. The workstation probably resent
; the IFrame because it did not correctly receive our ack of the IFrame. Throw
; the frame away and send the last frame again.
	INC  dctNSequenceError[BX]
	MOV  CX,ercSequenceError
	JMP  HandleErrorAndPollNext

IFrameSequenceOk:
	ADD  dctNR[BX],20h		;Increment number received
	MOV  DX,dctNOutstanding[BX];DL = dctNOutstandingRq
					;DH = dctNOutstandingSmallRq

	INC  DL				;increment total requests outstanding
	MOV  dctNOutstanding[BX],DX
; Set up DL for test for flow control. Small XBlocks don't count.
	SUB  DL,DH			;Subtract small XBlocks from count  

%IF(%VariablePoll) THEN (%'
; Active poll faster when ws sends frame in active poll cycle.
	CMP  lcb_fPollActiveOnly[BP],0
	JE   TestAckWithIFrame
	CMP  dctShActivePoll[BX], 1
	CMC
	SBB  dctShActivePoll[BX], 0

TestAckWithIFrame:
)FI%'
; Test to see if we can ack this IFrame with another IFrame. If the workstation
; is ready to receive an IFrame in response to the IFrame sent, the 10h bit of
; the CField will be zero.
	TEST AH,10h
	JNZ  CantAckWithIFrame
	ADD  nIFramesRrInLow,1
	ADC  nIFramesRrInHigh,0
	CMP  dctSaXBlockOut[BX],0
	JZ   NoIFrameToExchange
	MOV  dctLineState[BX],stateSendIFrameMasterReady
	JMP  SHORT TestRepoll

NoIFrameToExchange:
; If the workstation does not have the max number of requests outstanding,
; state becomes stateWorkstationReady. 
	MOV  dctLineState[BX],stateWorkstationReady
	CMP  DL,maxXBlocksPerUser	;Is he using the max number of XBlocks?
	JB   TestRepoll				;No
	MOV  dctLineState[BX],stateAckNotReady
; If the station does have the maximum number of requests outstanding, state 
; becomes stateAckNotReady so that we can Ack the IFrame with RNR. We
; won't ack this IFrame until it's necessary in order to avoid a timeout. This
; state can be changed to stateSendIFrame by SendXBlock.
	JMP  SHORT ReceiveIFrame

CantAckWithIFrame:
	ADD  nIFramesRnrInLow,1
	ADC  nIFramesRnrInHigh,0
; If the workstation does not have the max number of requests outstanding, 
; state becomes stateAckIFrame to send RR in reply to IFrame. We don't want 
; state to become stateWorkstationReady until we have sent the RR; otherwise 
; our state could get changed to stateSendIFrame if an IFrame comes ready.  If
; the station does have the maximum number of requests outstanding, state 
; becomes stateMasterNotReady so that we can Ack the IFrame with RNR. 
	MOV  dctLineState[BX],stateAckIFrame
	CMP  DL,maxXBlocksPerUser	;Is he using the max number of XBlocks?
	JB   TestRepoll		;No
	MOV  dctLineState[BX],stateMasterNotReady
	JMP  Short ReceiveIFrame

TestRepoll:
; If xbCbDataSent high bit is set, workstation wants
; to be polled again because he has another IFrame to send.
	TEST BYTE PTR ES:[xbCbDataSent+1], 80h
	JNZ  RepollIFrame

%IF(%VariablePoll) THEN (%'
; Poll soon when ws sends frame in poll cycle,
;  and is not going to be repolled.
	CMP  lcb_fPollActiveOnly[BP],0
	JNE  ReceiveIFrame
	MOV  dctPollCycleInterval[BX], 0
	MOV  dctPollCycleNext[BX], 0
)FI%'
	JMP  Short ReceiveIFrame

RepollIFrame:
	INC  dctnRepollActive[BX]
	MOV  lcb_fActivePollCycle[BP],0FFh

ReceiveIFrame:
	PUSH ES				;Save pointer to XBlock
	CALL ChainXBlockIn
; Set up to poll next dct in the list.
; Start the poll of the next dct in listActive.
	MOV  BX,dctNext[BX]
	CALL PollCurrent

%IF (%LogIn) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  AL,dctLineState[BX]
	MOV  AH,0
	MOV  logInState[SI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%fRawInt) THEN (
	POP  DS				;save pointer to XBlock in DS
	MOV  AX,0FFh			;mediate will handle EOI for 186
%IF (%CtosP) THEN (
	SUB  SP, 18			; Fake push of process registers
)FI

;We are already a mediated interrupt, reduce RS232 latency
;	PUSH AX
;	CALL MediateIntHandler
; Returns with interrupts enabled.
;	CLI

%IF (NOT %CtosP) THEN (
	MOV  DX,CPIntContPort0		;load CP 8259 interrupt prot address
	MOV  AL,intCmdEOI			;load EOI command
	OUT  DX,AL					;EOI CP 8259
	MOV  DX,EoiRegister
	MOV  AX,NsEoi
	OUT  DX,AX
)FI

	MOV  AX,DS			;DS points to XBlock
	MOV  ES,AX

) ELSE (%'Mediated int
	POP	ES
)FI

	XOR  DI,DI
	MOV  AX,DGroup
	MOV  DS,AX
	JMP  SendMessageToAgent

IFrameLengthError:
PUBLIC IFrameLengthError
; We received an IFrame in the XBlock pointed to by ES.
; cbDataSent+2 should be equal to cbData. If not, then we did not receive
; the entire packet. Ack with the last NR so that the workstation will
; resend the last IFrame.
	INC  dctNLengthError[BX]
	INC  nLengthError
	MOV  CX,ercLengthError
	JMP  HandleErrorAndPollNext

RxAckNotReady:
PUBLIC RxAckNotReady
;*****************************************************************************
; We received a response to the RNR we sent out.
; We expect RR or RNR.
;*****************************************************************************
; This state differs from MasterNotReady because this RNR was only because
;  of the XBlock limit; SendXBlock is allowed to override it.
; MasterNotReady cannot be changed into an IFrame until RNR is sent at least
;  once; then the state becomes AckNotReady.

RxMasterNotReady:
PUBLIC RxMasterNotReady
;*****************************************************************************
; We received a response to the RNR we sent out. 
; We expect RR or RNR.
;*****************************************************************************

	JNZ  RnrError
	ADD  nRnrOutLow,1
	ADC  nRnrOutHigh,0
TestForRR:
	MOV  DH,AH			;Preserve AH in case of error
	AND  DH,0E0h			;Sequence number comes in bits 7 6 5
	CMP  DH,dctNS[BX]
	JE   RRSequenceOk 

; The last IFrame we received was not in sequence. We must check the sequence
; number of RR and RNR frames.  If they are out of order we could get in a 
; loop with the workstation sending if/rr rr/rr start over.  The loop is that
; a good RR/RNR frame clears any Error count so we stay out of sequence 
; forever.
%IF(%Aug87JA) THEN(
PollSequenceError:
	MOV  dctNS[BX],DH		; Only call it an error the first time.
)FI
	INC  dctNSequenceError[BX]
	INC  nSequenceError
	MOV  CX,ercSequenceError
	JMP  HandleErrorAndPollNext

RRSequenceOk:
	AND  AH,frameMaskOffNR		;Mask off NR bits in bits 7 6 5
	CMP  AH,frameTypeRR
	JE   WorkstationReady
	CMP  AH,frameTypeRNR
	JE   WorkstationNotReady
	MOV  CX,ercProtocolError
RnrError:
	ADD  nRnrOutLow,1
	ADC  nRnrOutHigh,0
	JMP  HandleErrorAndPollNext
	
WorkstationNotReady:
PUBLIC WorkstationNotReady
;*****************************************************************************
; We received RNR (ReceiverNotReady) from a workstation.
; DI = count of bytes read.
;*****************************************************************************
; The only reply we can send is RR or RNR. If the workstation does not have
; too many requests outstanding, we will put him in stateWorkstationNotReady.
; This means we will send RR unless we don't have an XBlock when it comes his
; turn to be polled again. If we don't have an XBlock when his turn comes up,
; we will send RNR. The reason we want to poll him is that he may reply with
; RR, which would allow us to free an XBlock.
	ADD  nRnrInLow,1
	ADC  nRnrInHigh,0
	MOV  dctLineState[BX],stateWorkstationNotReady
; If the workstation sent a 4-byte RNR, this has a special meaning. The
; workstation needs to resend an IFrame, and it needs a RR from us. The purpose
; of this is to avoid a deadlock. If we keep sending RNR because he has too
; many requests outstanding, and he keeps sending RNR because he can't accept
; another IFrame, we are stuck. When we see a 4-byte RNR, avoid the check of
; outstanding requests.
	CMP  DI,4
	JNE  PollNotReadyWorkstation
	INC  n4ByteRnr
	JMP  PollNextDct

PollNotReadyWorkstation:
; We are ready to send RR to the workstation if the station does not have too
; many requests outstanding. We don't count small requests.
	MOV  AX,dctNOutstanding[BX]	;DL = dctNOutstandingRq
	SUB  AL,AH			;subtract dctNOutstandingSmallRq
	CMP  AL,maxXBlocksPerUser	;Is he using the max number of XBlocks?
	JB   PollNextDct2		;No
; If the station already has the maximum number of requests outstanding and no
; requests are ready to return, put him in state MasterNotReady.
	MOV  dctLineState[BX],stateMasterNotReady
	JMP  PollNextDct


WorkstationReady:
;*****************************************************************************
; We received RR (ReceiverReady) from a workstation.
; See if we have a frame to transmit.
;*****************************************************************************
	
	ADD  nRrInLow,1
	ADC  nRrInHigh,0
	CMP  dctSaXBlockOut[BX],0
	JNE  FrameReadyToSend
; We don't have a frame to send, so the only reply we can send is RR or RNR. 
; If the workstation does not have too many requests outstanding, we will put
; him in stateWorkstationReady.  This means we will send RR unless we don't 
; have an XBlock when it comes his turn to be polled again. If we don't have 
; an XBlock when his turn comes up,  we won't poll him at all unless we must
; in order to avoid a timeout. There is no sense in polling him if we don't 
; have an XBlock.
	MOV  dctLineState[BX],stateWorkstationReady

; We are ready to send RR to the workstation if the station does not have too
; many requests outstanding. We don't count small requests.
	MOV  AX,dctNOutstanding[BX]	;DL = dctNOutstandingRq
	SUB  AL,AH			;subtract dctNOutstandingSmallRq
	CMP  AL,maxXBlocksPerUser	;Is he using the max number of XBlocks?
	JB   PollNextDct2		;No
; If the station already has the maximum number of requests outstanding and no
; requests are ready to return, put him in state MasterNotReady.
	MOV  dctLineState[BX],stateAckNotReady
PollNextDct2:
	JMP  PollNextDct

FrameReadyToSend:
PUBLIC FrameReadyToSend
;*****************************************************************************
; We received RR from a workstation.
; We have an IFrame ready to send to a workstation.
;*****************************************************************************
; Set dctnRepollActive to Max 1, nRepollActive to be sure we send it this cycle
	MOV  DL,nRepollActive
	CMP  DL,1
	ADC  DL,0
	MOV  dctnRepollActive[BX],DL
	MOV  lcb_fActivePollCycle[BP],DL
%IF (%LogOut) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  SI,logOutIndex
	ADD  SI,logOutEntrySize
	CMP  SI,logOutMax
	JB   logOutIndexOk
	MOV  SI,0
logOutIndexOk:
	MOV  logOutIndex,SI
	MOV  AX,dctNRNS[BX]
	MOV  logOutNrNs[SI],AX
	MOV  AX,dctSaXBlockOut[BX]
	MOV  logOutXBlock[SI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; Check to see if this workstation can exchange IFrames. If so, we want to turn
; off the 10h bit in the CField to tell the WS we can receive an IFrame in
; response to the one we are sending.
	MOV  dctLineState[BX],stateSendIFrame
	CMP  dctRevisionLevel[BX],90h
	JBE  PollNextDct1
	MOV  dctLineState[BX],stateSendIFrameMasterReady
PollNextDct1:
	JMP  PollNextDct

RxDisconnecting:
PUBLIC RxDisconnecting
;*****************************************************************************
; We sent a DISC to the workstation and got a response. 
; Put this dct on listInactive
;*****************************************************************************
	CALL MoveDctToInactive
	MOV  BX,lcb_dctCurrent[BP]
	JMP  PollCurrentDct


RxSendIFrameMasterReady:
;*****************************************************************************
; We received a reply in XBlockCurrent after sending an IFrame. 
; We sent the IFrame in response to RR or an IFrame with the poll bit turned
; off from the workstation.
; We could receive an IFrame in reply.
;*****************************************************************************
%IF (%Logout) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  SI,logOutIndex
	MOV  logOutAck[SI],AX
	MOV  logOutAckErc[SI],CX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	JNZ  AckIFrameError1
	CMP  AH,frameTypeREJ
	JE   IFrameRejected
	TEST AH,1
	JNZ  NoIFrameExchange
; We did receive an IFrame in response to our IFrame. We increment dctNS by
; one. This is the sequence number of the last frame sent. We expect RR or RNR
; and sequence number bits in bits 7 6 5 to be equal to dctNS.
	MOV  DL,dctNS[BX]
	ADD  DL,20h
	MOV  DH,AH
	AND  DH,0E0h
	CMP  DH,DL
	JNE  IFrameSequenceError
%IF(%Aug87JA) THEN(
IFrameSentAndReceived:
)FI
	PUSH AX				;Save station and CField
	PUSH DI				;Save count of bytes read
	CALL ReturnIFrameToFreeList
	POP  DI				;Restore count of bytes read
	POP  AX				;Restore station and CField
	MOV  ES,lcb_saXBlockCurrent[BP]	;ES ponts to IFrame received
	JMP  IFrameReceived

IFrameRejected:
PUBLIC IFrameRejected
;*****************************************************************************
; We received a REJ after sending an IFrame. The workstation did not 
; recognize this IFrame as one belonging to it because the response exchange
; field did not have a valid pointer to an rcb.
;*****************************************************************************
	MOV  CX,ercREJ
	JMP  HandleErrorAndPollNext

RxSendIFrame:
PUBLIC RxSendIFrame
;*****************************************************************************
; We received a reply after sending an IFrame.
; The reply is in AX and the ackInBuf.
; We increment dctNS by one. This is the sequence number of the last frame
; sent. We expect RR or RNR and sequence number bits in bits 7 6 5 to be equal
; to dctNS.
;*****************************************************************************
%IF (%LogOut) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  SI,logOutIndex
	MOV  logOutAck[SI],AX
	MOV  logOutAckErc[SI],CX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

AckIFrameError1:
	JZ	 CheckRej
	JMP  AckIFrameError
CheckRej:
	CMP  AH,frameTypeREJ
	JE   IFrameRejected

NoIFrameExchange:
	MOV  DL,dctNS[BX]
	ADD  DL,20h
	OR   DL,frameTypeRR		;11h
	CMP  DL,AH
	JE   AckRR
	OR   DL,frameTypeRNR		;15h
	CMP  DL,AH
	JNE  InvalidIFrameReply
AckRNR:
; The workstation sent RNR in response to our IFrame.
; dctSaXBlockOut points to the IFrame that we sent. Return this XBlock to
; the free list.
	CALL ReqTimedActiveCycle
	PUSH DI				;Save count of bytes read
	CALL ReturnIFrameToFreeList
	POP  DI				;Restore count of bytes read
	JMP  WorkstationNotReady

AckRR:
; The workstation sent RR in response to our IFrame. Return the XBlock 
; we sent to the free list and see if we have another IFrame to send.
	CALL ReqTimedActiveCycle
	CALL ReturnIFrameToFreeList
	JMP  WorkstationReady

InvalidIFrameReply:
PUBLIC InvalidIFrameReply
; We did not receive a valid reply to our IFrame. Is this a sequence
; number error or a protocol error?
	MOV  DX,AX						;Save AX for LogError
	AND  DH,frameMaskOffNR
	CMP  DH,frameTypeRR
	JNE  CheckRNR
; Since we had a sequence  error, we should not repoll this DCT.
	MOV  dctNRepollActive[BX],0
	MOV  lcb_fPollActiveOnly[BP],00h
	
	INC  dctNSequenceError[BX]		; if frame type RR resend IFrame so
	INC  nSequenceError				; retry count won't be reset by valid
	MOV  CX,ercSequenceError		; RR frame.
	JMP  HandleErrorPollNextDct
CheckRNR:
	CMP  DH,frameTypeRNR
	JNE  IFrameProtocolError
IFrameSequenceError:
PUBLIC IFrameSequenceError
	INC  dctNSequenceError[BX]
	INC  nSequenceError
	MOV  CX,ercSequenceError
	JMP  SHORT AckIFrameError
ReqTimedActiveCycle PROC
%IF(%VariablePoll) THEN (%'
;***************************************************************************
;
; Request a timed active poll cycle, to catch next Request as soon as possible.
; If not enough time left in cycle, skip active poll, will have regular poll 
; cycle very soon.
;
;***************************************************************************
	PUSH DX
	MOV  CL,dctShActivePoll[BX]
; Fool around with CL so shActivePoll must change by 4 to make any difference
	SHR  CL, 2			; shActivePoll in units of log2(1/8ms); CL=log2(2ms)
	MOV  DX,40			; 40 pit ticks = 2ms
	SHL  DX,CL			; 2ms * 2^log2(N 2ms) = 2ms*N, N is power of 2
	CMP  lcb_pollCycleTimeout[BP],DX
	JBE  NoActivePollRet
	CMP  lcb_ActivePollCycleTimeout[BP],DX
	JBE  NotShortestPoll
	MOV  lcb_ActivePollCycleTimeout[BP],DX	; Delayed active poll!
	MOV  lcb_fActivePollCycle[BP],0FFh

NotShortestPoll:
	CMP  dctnRepollActive[BX],1
	ADC  dctnRepollActive[BX],0

; Poll soon after sending ws a response.  Ws may become active soon.
; (Case of large synchronous piecemeal read/write, last piece.)
	MOV  dctPollCycleInterval[BX], 0
	MOV  dctPollCycleNext[BX], 0
	
NoActivePollRet:
	POP  DX
)FI%'
	RET

ReqTimedActiveCycle ENDP

IFrameProtocolError:
PUBLIC IFrameProtocolError
	MOV  CX,ercProtocolError
AckIFrameError:
;*****************************************************************************
; We did not receive a good response to the IFrame we sent. We must resend the
; last IFrame, but we must wait until the workstation is ready to receive an
; IFrame. If the workstation is reading into its ackInBuf and not expecting an
; IFrame, it will get overrun errors. Change our state to stateErrorRecovery
; and wait until we receive RR from the workstation to resend the IFrame. We
; must send RR to the workstation. If the workstation was trying to ack our
; IFrame with an IFrame, it will want to resend the IFrame. It cannot resend
; the IFrame unless we send RR. If we send RNR, we could end up in a deadlock
; with each station waiting for the other to send RR.
;*****************************************************************************
	MOV  dctLineState[BX],stateErrorRecovery
	JMP  SHORT HandleErrorAndPollNext

RxErrorRecovery:
;*****************************************************************************
; We are waiting for the workstation to send RR, and we are trying to send RR
; to the workstation. This is similar to stateWorkstationReady except that we
; do not do any flow control because we MUST send RR, and we do not send RNR.
; If we don't have an IFrame, we send RNR until an IFrame is available. It is
; possible that the workstation did receive the IFrame and there was an error
; in the transmission of the response to the IFrame. So we keep looking for an
; ack to our IFrame.
;*****************************************************************************
	JNZ  AckIFrameError
	MOV  DL,dctNS[BX]
	ADD  DL,20h			;DL = ack sequence number expected
	MOV  DH,AH
	AND  DH,0E0h			;DH = sequence number bits only
	CMP  DH,DL
	JNE  MustResendIFrame
	TEST AH,1			;If low bit is zero,
	JZ   RxerrorR2
	JMP  NoIFrameExchange		;see if RR/RNR 
RxerrorR2:
%IF(%Aug87JA) THEN(
	JMP  IFrameSentAndReceived
) ELSE (
	JMP  IFrameReceived 		;we received an IFrame
)FI
MustResendIFrame:
	TEST AH,1			;If low bit is zero,
	JZ   RecoveryIFrameReceived	;we received an IFrame
	AND  AH,frameMaskOffNR		;Mask off NR bits in bits 7 6 5
	CMP  AH,frameTypeRR
	JE   RecoveryWorkstationReady
	CMP  AH,frameTypeRNR
	JNE  IFrameProtocolError
	JMP  PollNextDct		;Wait till next poll cycle
RecoveryIFrameReceived:
	JMP  IFrameReceived
RecoveryWorkstationReady:
	JMP  FrameReadyToSend

;*****************************************************************************
; This is the end of the read interrupt processing. 
; Start the poll of the next dct and return from interrupt.
;*****************************************************************************
HandleErrorAndPollNext:
	CALL HandleError
	MOV  CX,0			; flag to poll this dct not next!
	JMP  SHORT SetActive1

; Added as a backoff when a DCT sees a sequence error.
HandleErrorPollNextDct:
	CALL HandleError
	MOV  CX,1
	JMP  PollNextDct

SetActiveAndPollNext:
; Come here if error, when we respond to XID, or when we send a boot block.
; Set dctnRepollActive to Max(1, NrepollActive).
	MOV  CX,1			; set flag to poll next dct.
SetActive1:
	MOV  AL,nRepollActive
	CMP  AL,1
	ADC  AL,0
	MOV  dctnRepollActive[BX],AL
	MOV  lcb_fActivePollCycle[BP],AL
	JCXZ PollCurrentDct
PollNextDct:
	MOV  BX,dctNext[BX]
PollCurrentDct:
	CALL PollCurrent
	JMP  IsrDone
ReadInterrupt ENDP

SendDctToMstrAgentReceiver:
PUBLIC SendDctToMstrAgentReceiver
;*****************************************************************************
; Unchain the current dct and send it to the MstrAgentReceiver. 
; dctActionCode tells the MstrAgentReceiver what to do with the dct:
;	actionBooting says we need pages from the boot file.
;	actionDumping says we have the next dump page to write to the dump
;	file.
;	actionError says this dct caused too many errors.
;*****************************************************************************
	CALL UnchainDct
	PUSH BX				;Save address of dct
	MOV  BX,SI			;BX points to next dct in list
	CALL PollCurrent		;Start poll of next dct


; Mediate this interrupt so that we can send a message to the
; MstrAgentReceiver. We cannot have any state in the stack at this time. We
; save the pointer to the dct in DS.
%IF(%fRawInt) THEN (
%if(%ctosp)then(
	pop  bp					; bp not corrupted in protected
							; MediateIntHandler
	SUB  SP, 18			; Fake push of process registers
)else(
	POP  DS					;save pointer to dct in DS
)fi
	MOV  AX,0FFh			;Mediate will handle EOI for device

;We are already a mediated interrupt, reduce RS232 latency
;	PUSH AX
;	CALL MediateIntHandler
; Returns with interrupts enabled.
;	CLI

%IF (NOT %CtosP) THEN (
	MOV  DX,CPIntContPort0		;load CP 8259 interrupt prot address
	MOV  AL,intCmdEOI		;load EOI command
	OUT  DX,AL			;EOI CP 8259
	MOV  DX,EoiRegister
	MOV  AX,NsEoi
	OUT  DX,AX
)FI

%if(%ctosp)then(
	mov  di, bp
)else(
	MOV  DI,DS				;ES:DI points to dct 
)fi

) ELSE (%'Mediated int
	POP  DI
)FI

	MOV  AX,DGroup
	MOV  ES,AX

	MOV  DS,AX

SendMessageToAgent:
PUBLIC SendMessageToAgent
;*****************************************************************************
; Interrupts are disabled.
; This is the end of the read interrupt processing if we converted to
; a mediated interrupt handler so we could send a message to the 
; MstrAgentReceiver. 
; ES:DI points to message to send to MstrAgentReceiver (a dct or XBlock).
; Start the poll of the next dct and return from interrupt.
;*****************************************************************************
	PUSH exchMstrAgentReceiver
	PUSH ES
	PUSH DI

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  SI,logMsgBufferIndex
	ADD  SI,logMsgEntrySize
	CMP  SI,logMsgBufferIndexMax
	JBE  logMsgBufferIndexOk
	MOV  SI,0
logMsgBufferIndexOk:
	MOV  logMsgBufferIndex,SI
	MOV  logMsgRa[SI],DI
	MOV  logMsgSa[SI],ES
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	CALL PSend
;
; Don't enable interrupts until after PSend to avoid request queueing out of
; order.
;
	STI

FarProc PROC FAR
 	RET				;Return from mediated interrupt
FarProc ENDP

CheckT0:
PUBLIC CheckT0
;*****************************************************************************
; When a workstation responds to a SNRM we need to check the OS type in the   
; ackin buffer to see if we have a T0 family terminal.  If we do the do the  
; T0 setup. 
;*****************************************************************************		
	INC  nWsActive

	RET

MoveDctToInactive:
	CALL UnchainDct
	MOV  lcb_dctCurrent[BP],SI
ChainDctToInactive:
	MOV  dctLineState[BX],0
	MOV  DCTDAINumber[BX],NoDAImodule
	CMP  fFixedId,0
	JE   MoveInactiveToTail
; If IWS or if NGen in testing mode, we must chain this to the tail of the list
; so that fixed ID machines can boot.
	LEA  DI,lcb_listInactive31PlusTail[BP]
	CMP  dctStation[BX],31
	JA   ChainDct
	LEA  DI,lcb_listInactive16To31Tail[BP]
	CMP  dctStation[BX],15
	JA   ChainDct
	LEA  DI,lcb_listInactive1To15Tail[BP]
	JMP  SHORT ChainDct

MoveInactiveToTail:
; It is important to chain this to the head of the list so that we will send
; another SNRM for the  same station the next time we send a SNRM.
	LEA  DI,lcb_listInactive31PlusHead[BP]
	CMP  dctStation[BX],31
	JA   ChainDct
	LEA  DI,lcb_listInactive16To31Head[BP]
	CMP  dctStation[BX],15
	JA   ChainDct
	LEA  DI,lcb_listInactive1To15Head[BP]

ChainDct PROC NEAR
PUBLIC ChainDct
;*****************************************************************************	; Chain dct onto list.
; On entry, BX points to dct to chain, and 
; DI points to prev dct or list head if none.
; On return, SI points to next dct or list head if none.
;*****************************************************************************	
	PUSHF
	CLI	

%IF (%DebugChain) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CMP		BX,orgDct
	JB		ChainCrash
;	TEST 	dctNext[BX],0FFFFh
;	JNE	 	ChainCrash
;	TEST 	dctPrev[BX],0FFFFh
;	JNE	 	ChainCrash
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	MOV  	SI,dctNext[DI]	;SI points to next dct in list or list head
	MOV  	dctNext[BX],SI	;set next pointer of dct being chained.
	MOV  	dctPrev[BX],DI	;set prev pointer of dct being chained
							;to point to prev dct or head of list.
	MOV  	dctPrev[SI],BX	;prev pointer of next dct points to dct
							;being chained
	MOV  	dctNext[DI],BX	;next pointer of prev dct points to dct
							;being chained
	POPF
	RET
%IF (%DebugChain) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
ChainCrash:
	PUSH 	AX
	MOV 	AX,3
	PUSH 	AX
	CALL 	Crash
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
ChainDct ENDP
UnchainDct PROC NEAR
PUBLIC UnchainDct
;*****************************************************************************
; Unchain Dct from whatever list it is in.
; On entry, BX points to dct to unchain.
; On return, SI points to next dct or list head if none, and
; DI points to prev dct or list head if none.
;*****************************************************************************		
	PUSHF
	CLI
	MOV  SI,dctNext[BX]	;SI points to next dct or list head if none
%IF (%DebugChain) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CMP		BX,orgDct
	JB		UnChainCrash
	AND 	SI,SI
	JE 		UnChainCrash
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	MOV  DI,dctPrev[BX]	;DI points to prev dct or list head if none
%IF (%DebugChain) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	AND 	DI,DI
	JE 		UnChainCrash
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; Unchain this dct from the prev pointer of the next dct.
	MOV  	dctPrev[SI],DI
; Unchain this dct from the next pointer of the previous dct.
	MOV  	dctNext[DI],SI
%IF (%DebugChain) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV 	dctNext[BX],0	;Debugging code
	MOV 	dctPrev[BX],0
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	POPF
	RET
%IF (%DebugChain) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
UnchainCrash:
	PUSH 	AX
	MOV 	AX,3
	PUSH 	AX
	CALL 	Crash
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
UnchainDct ENDP


ChainXBlock PROC NEAR
PUBLIC ChainXBlock
;*****************************************************************************
; ES points to XBlock to chain onto list.
; DS:SI points to head of list to chain onto.
; On return, DS is as on entry.
;*****************************************************************************		
	PUSH DS
	JMP  SHORT TestLastXBlock
FindLastXBlock:
	MOV  DS,xbSaLink[SI]
	XOR  SI,SI			;Next time through SI must be zero
TestLastXBlock:
	CMP  WORD PTR xbSaLink[SI],0
	JNE  FindLastXBlock
; DS:SI points to the last XBlock or the head of the list. Move the pointer to
; the new XBlock to send to the link of the last XBlock or list head.
	MOV  xbSaLink[SI],ES
	MOV  WORD PTR ES:[xbSaLink],0
	POP  DS				;Restore DS
	RET
ChainXBlock ENDP

ChainXBlockIn PROC NEAR
PUBLIC ChainXBlockIn
;*****************************************************************************
; ES points to the XBlock that has just been used. 
; Chain this onto the head of dctSaXBlockIn.
; Then get the next XBlock.
;*****************************************************************************
	MOV  AX,dctSaXBlockIn[BX]
	MOV  ES:[xbSaLink],AX
	MOV  dctSaXBlockIn[BX],ES

GetXBlock:
;*****************************************************************************
; See if an XBlock is available. If so, unchain it from the free list.
; On return, ES and saXBlockCurrent point to XBlock.
; Condition code is zero if no XBlock is available.
;*****************************************************************************
	MOV  AX,saFreeList
	MOV  lcb_saXBlockCurrent[BP],AX	;Save pointer to XBlock to read into
	OR   AX,AX
	JZ   GetXBlockRet			;no XBlock is free

	PUSH AX
	DEC  nXBlocksFree
	LES  DI,pStat
	MOV  AH,0					;DHG...
	MOV  AL,nXBlocksFree		;nAvailX = nAvailX -1
	MOV  ES:nAvailX[DI],AX		;nAvailX = nAvailX -1
	CMP  AX,ES:nMinX[DI]		;IF nAvailX < nMinX THEN
	JG   @1						;
	MOV  ES:nMinX[DI],AX		; nMinX = nAvailX
@1:								;...DHG
	POP  ES						;ES points to XBlock

	MOV  AX,0					;AX = 0
	XCHG AX,ES:[xbSaLink]		;AX = next pointer, next pointer = 0
	MOV  saFreeList,AX			;saFreeList points to next XBlock
	MOV  BYTE PTR ES:[xbStatus],stXbInUse ;Set in only 1 place
	OR   AX,1					;Set "Z" flag

GetXBlockRet:
	RET
ChainXBlockIn ENDP

HandleError PROC NEAR
PUBLIC HandleError
;*****************************************************************************
; If we have not yet reached the maximum retry count, return to caller.
; If the maximum error count has been reached, unchain this dct, and send
; a message to the MstrAgentReceiver. In this case we will not return to the 
; caller -- we will poll the next dct.
; On entry, CX = error code to store in dctErc.
; AX = first word received from workstation -- stationID and frameType
; If we return, AL = dctRetryCount
; Does not alter DX
;*****************************************************************************		

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,lcb_logBufferIndex[BP]
	MOV  logErc[DI],CX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	MOV  dctErc[BX],CX		;Save error code in Dct
	CMP  CX,ercProtocolError
	JNE  NotProtocolError
	INC  dctNProtocolError[BX]
	INC  nProtocolError
NotProtocolError:
%IF (%LogErrors) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
LogError:
PUBLIC LogError
;*****************************************************************************
; AX contains first word received.
; BX points to dct that encountered error.
; CX contains error code
;*****************************************************************************
	MOV  DI,errorLogIndex
	ADD  DI,errorLogEntrySize
	CMP  DI,errorLogIndexMax
	JBE  errorLogIndexOk
	MOV  DI,0
errorLogIndexOk:
	MOV  errorLogIndex,DI
	MOV  errorLogDct[DI],BX
	MOV  errorLogErc[DI],CX
	MOV  errorLogStationFrame[DI],AX
	MOV  AX,lcb_pollSequenceNumber[BP]
	MOV  errorLogPollSequenceNumber[DI],AX
	MOV  AX,dctPollSequenceNumber[BX]
	MOV  errorLogDctPollSequenceNumber[DI],AX
	MOV  AL,dctStation[BX]
	MOV  errorLogStation[DI],AL
	MOV  AL,dctLineState[BX]
	MOV  errorLogLineState[DI],AL
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	MOV  AL,dctRetryCount[BX]
	INC  AL
	MOV  dctRetryCount[BX],AL
; We must always return if we were called from ProcessTRB!
	CMP  CX,ercTimeout
	JE   HandleErrorRet
	CMP  AL,maxErrorCount
	JA   TooManyErrors
HandleErrorRet:
	RET
TooManyErrors:
	INC  nWsDownErrors
	MOV  dctActionCode[BX],actionError
	POP  AX				;Discard return address
	JMP  SendDctToMstrAgentReceiver
HandleError ENDP

InitializeDct PROC NEAR
PUBLIC InitializeDct
;*****************************************************************************
; BX points to dct to zero
; Zero all but the pointers and the station number. 
;*****************************************************************************
	CLD
	MOV  CX,dctSizeToZero
	PUSH DS
	POP  ES
	LEA  DI,dctStation+1[BX]
	XOR  AX,AX
	REPNZ STOSB
	RET
InitializeDct ENDP

MeterPoint PROC FAR
PUBLIC MeterPoint
;*****************************************************************************
; MeterPoint: procedure(saXBlock, point)
; This entry is called from the Agent when it receives a Response or a Request
;*****************************************************************************
	CMP  saMeterBuffer,0		;Is meter turned on?
	JE   MeterPointRet
	PUSH BP
	MOV  BP,SP
;       | saXBlock | +8
;       | point    | +6
;       | CS       | +4
;       | IP       | +2
;       | BP       | <--BP
	LES  DX,DWORD PTR[BP+6]		;DX = point, ES = saXBlock
	MOV  BX,ES:[xboDct]
	MOV  DH,dctLineState[BX]	;DH = lineState
	CLI
	CALL MeterXBlock
	STI
	POP  BP
MeterPointRet:
	RET  4
MeterPoint ENDP

MeterXBlock PROC NEAR
PUBLIC MeterXBlock
;*****************************************************************************
; This entry is called from the Line Protocol Handler for Start Read and 
; Write Complete. It is also called from MeterPoint
; ES points to XBlock
; DL = point:
;      1 = Start write (poll)
;      2 = read complete
;      3 = issue request
;      4 = response received
; Only AX, DX and DI are changed
;*****************************************************************************
	PUSH DS				;Save pointer to DGroup
	PUSH ES				;Save pointer to XBlock
	MOV  ES,saMeterBuffer		;ES points to meterBuffer
	MOV  DI,mbIndex			;DI contains current index
	CMP  DI,mbIndexMax
	JB   MbIndexOk
; When we have used the last entry stop meter.
	MOV  saMeterBuffer,0		;Turn off meter
	POP  ES				;Restore pointer to XBlock
	POP  DS				;Restore ponter to DGroup
	RET
MbIndexOk:
	ADD  mbIndex,mbEntrySize	;Increment index for next time
; mbVariable can be set by the caller after we return. DI still contains the
; index. This can be used for anything we care to trace.
	MOV  mbVariable,0
	MOV  mbPoint,DL
	MOV  mbLineState,DH
	MOV  BP,dctoLcb[BX]
	MOV  AX,lcb_curPollCycleNbr[BP]
	MOV  mbPollNumber,AX
;	MOV  AX,sysTimeLow
	MOV  AX,timerNumber
	MOV  mbSystimeLow,AX
;	MOV  AX,systimeSecs
	MOV  mbSecs,AX
	MOV  DX,0FF60h			;Address of Rtc register
	IN   AX,DX
	MOV  mbRtc,AX
	POP  DX				;DX = address of XBlock
	MOV  DS,DX			;DS = address of XBlock
	MOV  AX,DS:[xbStation]		;AX = stationFrame
	MOV  mbStationFrame,AX
	MOV  AX,DS:[xbRqCode]
	MOV  mbRqCode,AX
	MOV  AX,DS:[xbRqErcRet]
	MOV  mbErcRet,AX
	MOV  AX,DS:[xbCbData]
	MOV  mbCount,AX
	MOV  ES,DX			;Restore pointer to XBlock
	POP  DS				;Restore pointer to DGroup
	RET
MeterXBlock ENDP

MeterFrame PROC NEAR
PUBLIC MeterFrame
;*****************************************************************************
; This entry is called from the Line Protocol Handler for Start Read and 
; Write Complete.
; ES points to frame in ackInBuf or ackOutBuf
; AX = stationFrame
; DL = point:
;      1 = Start write (poll)
;      2 = read complete
;      5 = timer interrupt
; Only DX and DI are changed
;*****************************************************************************
	PUSH ES				;Save pointer to frame
	PUSH AX				;Save stationFrame
	MOV  ES,saMeterBuffer		;ES points to meterBuffer
	MOV  DI,mbIndex			;DI contains current index
	CMP  DI,mbIndexMax
	JB   MbIndexOk1
; When we have used the last entry stop meter.
	MOV  saMeterBuffer,0		;Turn off meter
	POP  AX
	POP  ES				;Restore pointer to frame
	RET
MbIndexOk1:
	ADD  mbIndex,mbEntrySize	;Increment index for next time
	MOV  mbVariable,0
; mbVariable can be set by the caller after we return. DI still contains the
; index. This can be used for anything we care to trace.
	MOV  mbPoint,DL
	MOV  mbLineState,DH
	MOV  AX,lcb_curPollCycleNbr[BP]
	MOV  mbPollNumber,AX
;	MOV  AX,sysTimeLow
	MOV  AX, timerNumber
	MOV  mbSystimeLow,AX
;	MOV  AX,systimeSecs
	MOV  mbSecs,AX
	MOV  DX,0FF60h			;Address of Rtc register
	IN   AX,DX
	MOV  mbRtc,AX
	POP  AX				;AX = stationFrame
	MOV  mbStationFrame,AX
	POP  ES				;Restore pointer to frame
	RET
MeterFrame ENDP

PrepareNextBootPage PROC NEAR
PUBLIC PrepareNextBootPage
;*****************************************************************************
; Prepare to send the next page of boot data from the XBlock.
; dctSaXBlockOut points to the XBlock.
; xbBootPagesInXBlock is the number of pages total in the XBlock.
; xbBootPageIndex is the number of the next page to send.
; The first 64 bytes of the XBlock are used by the Agent to build a Read 
; request. The first page of data starts at xbBootPage. We must build
; station ID, frame type, and DS:BX before the data.
;*****************************************************************************
cbBoot82Max EQU 4096+6
	MOV  ES,dctSaXBlockOut[BX]
	MOV  AX, bootPageSize
	CMP  dctRevisionLevel[BX], 82h
	JB   SetBootSize
	MOV  AX, ES:[xbBootPagesInXBlock]
	SHL  AX, 9
	ADD  AX, 6
	CMP  AX, cbBoot82Max
	JBE  SetBootSize
	MOV  AX, cbBoot82Max
SetBootSize:
	MOV  WORD PTR ES:[xbCbData],AX
	XOR  AX,AX
	MOV  AH,ES:[xbBootPageIndex]
	SHL  AX,1			;AX = xbBootPageIndex*512
	ADD  AX,xbBootStation
	XCHG DI,AX			;DI points stationAddress of next page 
	MOV  AL,dctStation[BX]
	MOV  AH,frameTypeUI		;Store station address and
	MOV  ES:[DI],AX			;frame type in next page
; Calculate DS:BX from dctLfa
	MOV  CX,4			;CX = 4 for shift count
	MOV  AX,dctLfaLow[BX]
	SHR  AX,CL			;SHR(lfaLow,4)
	XOR  DX,DX
	MOV  DH,dctLfaByte2[BX]
	SHL  DX,CL
	ADD  AX,DX			;+ SHL(lfaHigh,12)
	MOV  WORD PTR ES:[DI+2],0	;RA of DS:BX is zero
	MOV  DX,ES:[xbBootPageIndex]
	SHL  DX,CL
	SHL  DX,1
	ADD  AX,DX			;+ SHL(dctBootPageIndex,5)
	MOV  ES:[DI+4],AX		;Store SA of DS:BX
	CALL CalculateDmaAddr
	RET
PrepareNextBootPage ENDP

PreparePollInactive PROC NEAR
PUBLIC PreparePollInactive
;*****************************************************************************
; See if it's time to send a SNRM. If so, remove a dct from listInactive 
; and chain it to the head of listActive.
;*****************************************************************************		
	CMP  lcb_fDisableCl[BP],0FFh	;Is the cluster disabled?
	JE   PreparePollInactiveRet	;Yes
;	CMP  lcb_fGoingDown[BP],0FFh		- fGoingDown <> lcb_fGoingDown
;	JE   PreparePollInactiveRet	;Yes
	TEST fGoingDown,0FFh		;Is the cluster going down?
	JNZ  PreparePollInactiveRet	;Yes
	MOV  AL, timerInterruptsPerSnrm
	CMP  lcb_countSendSnrm[BP], AL
	JB   PreparePollInactiveRet
	CMP  lcb_fTimeout[BP],0FFh		;If we just had a timeout,
	JE   PreparePollInactiveRet	;Don't send a Snrm

; Only send a SNRM if the state is idle -- otherwise we are too busy to send a
; SRNM.
	CMP  lcb_pollState[BP],stateIdle
	JE   PreparePollInactiveOk
PreparePollInactiveRet:
	RET

PreparePollInactiveOk:
; It's time to send a SNRM. Unchain a dct from listInactive and chain it onto
; the head of listActive. When we send a SNRM, it will always be the first dct
; on listActive. Try to send a SNRM with a station address in the range 1 to 15
; if we have one.
	MOV  BX,lcb_listInactive1To15Head[BP] ;BX points to unresponsive dct
	LEA  DI,lcb_listInactive1To15Head[BP]
	CMP  BX,DI
	JNE  UnchainFromInactive

; If we don't have a station in the range 1 to 15, see if we have one in the
; range 16 to 31. Boot Roms 9.2 and later will respond.
	MOV  BX,lcb_listInactive16To31Head[BP] ;BX points to unresponsive dct
	LEA  DI,lcb_listInactive16To31Head[BP]
	CMP  BX,DI
	JE   PreparePollInactiveRet	;There are no unresponsive dcts
UnchainFromInactive:
	CALL UnchainDct			;Unchain dct from listInactive
	LEA  DI,lcb_listActiveHead[BP]
	CALL ChainDct			;Chain dct onto listActive
	MOV  lcb_dctCurrent[BP],BX

; The first entry in listActive is the unresponsive dct. It is important that
; the next dct we poll be the unresponsive dct because we are starting the
; timer now. If the timer goes off, we want the time out to be for the SNRM 
; and not some other dct.
	MOV  AL,dctStation[BX]
	MOV  lcb_lastSnrmSent[BP],AL
	MOV  lcb_statePit[BP],statePitIdle	; disarm pending pit before sti
	MOV  AX,lcb_snrmTimeout[BP]
	MOV  lcb_pitTimeout[BP],AX
	ADD  nSnrmLow,1
	ADC  nSnrmHigh,0
	CALL InitializeDct
	MOV  AL,bSioClockSnrm
	MOV  dctSioClock[BX],AL
;Insure that StartPoll will definitely poll this dct.  (If it didnt then
;we would have the PIT running but lcb_dctCurrent pointing to the list head).
	MOV dctnRepollActive[BX],1

; Set the Programmable Interval Timer before we start polling.
; We set the PIT to a smaller interval when we are sending a SNRM.
; Disable interrupts to guarantee statePit gets set before timer expires
	PUSHF
	CLI
	PUSH DS
	LEA  AX,lcb_timerIntBlock[BP]
	PUSH AX
	CALL SetTimerInt
	MOV  lcb_statePit[BP],statePitSnrmTimeout
	POPF			; Done atomic operation

	RET
PreparePollInactive ENDP

ReleaseXBlock PROC FAR
PUBLIC ReleaseXBlock
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;           ReleaseXBlock: Procedure(saXBlock)
; This procedure is called the Agent to free an XBlock.
;       | saXBlock | +6
;       | CS       | +4
;       | IP       | +2
;       | BP       | <--SP
;*****************************************************************************		
	MOV  ES,[BP+6]			;ES points to XBlock to release
	CLI				;Disable
	CALL ReturnXBlockToFreeList
	STI				;Enable
	POP  BP
	RET  2
ReleaseXBlock ENDP

ResetCounters PROC NEAR
PUBLIC ResetCounters
;*****************************************************************************
; When the clock changes to midnight, reset all the counters so they won't
; overflow.
;*****************************************************************************
	MOV  fCountersReset,0FFh
	CLD
	LEA  CX,lastCountToZero
	LEA  DI,firstCountToZero
	SUB  CX,DI
	XOR  AX,AX
	PUSH DS
	POP  ES
; Zero master's counters.
	REPNZ STOSB
; Now zero the counters in each dct.
	MOV  BX,oRgDct
	MOV  SI,nDct
	OR   SI,SI
	JZ   ResetCountersRet
ResetNextDct:
	MOV  CX,dctSizeToReset
	LEA  DI,dctFirstFieldToReset[BX]
	REPNZ STOSB
	ADD  BX,dctSize
	DEC  SI
	JNZ  ResetNextDct
ResetCountersRet:
	RET
ResetCounters ENDP

ReturnIFrameToFreeList PROC NEAR
PUBLIC ReturnIFrameToFreeList
;*****************************************************************************
; Called only from RxSendIFrame and RxSendIFrameMasterReady
; We just sent the IFrame pointed to by dctSaXBlockOut to a workstation
; and got a valid reply. Return this XBlock to the free list and update
; dctSaXBlockOutOut, dctNOutstandingRq, and dctNS.
;*****************************************************************************
	MOV  ES,dctSaXBlockOut[BX]
	MOV  AX,ES:[xbSaLink]
	MOV  dctSaXBlockOut[BX],AX
	DEC  dctNOutstandingRq[BX]	;decrement requests outstanding
	ADD  dctNS[BX],20h
	MOV  AX,1
	XOR  DX,DX
	TEST BYTE PTR ES:[xbFrameType],frameTypeI
	JNZ  UpdateIFrameRnr
	ADD  nIFramesRrOutLow,AX
	ADC  nIFramesRrOutHigh,DX
	JMP  SHORT UpdatePagesRead
UpdateIFrameRnr:
	ADD  nIFramesRnrOutLow,AX
	ADC  nIFramesRnrOutHigh,DX
UpdatePagesRead:
; If this is a read request, increment the number of pages of data read by this
; workstation.
	CMP  WORD PTR ES:[xbrqCode],rcRead
	JNE  TestWriteRq
	MOV  AL,ES:[xbRqsBufferMax+1]
	SHR  AX,1			;AX = number of pages
	ADD  nPagesReadLow,AX
	ADC  nPagesReadHigh,DX
	ADD  dctnPagesReadLow[BX],AX
	ADC  dctnPagesReadHigh[BX],DX
TestWriteRq:
; If this is a write request, increment the number of pages of data written by
; this workstation.
	CMP  WORD PTR ES:[xbrqCode],rcWrite
	JNE  ReturnXBlockToFreeList
	MOV  AL,ES:[xbRqsBufferMax+1]
	SHR  AX,1			;AX = number of pages
	ADD  nPagesWrittenLow,AX
	ADC  nPagesWrittenHigh,DX
	ADD  dctnPagesWrittenLow[BX],AX
	ADC  dctnPagesWrittenHigh[BX],DX

ReturnXBlockToFreeList:
;*****************************************************************************
; Entry from ReleaseXBlock
; ES points to XBlock to return to saFreeList.
; Initialize xbDmaAddr. It will have been changed if this dct was booting.
;*****************************************************************************
	MOV  AX,ES
	AND  BYTE PTR ES:[xbFlags],xbSmall
	JZ   FreeBigXBlock
	MOV  BX, WORD PTR ES:[xbODct]	; not set up in call from agent
	DEC  dctNOutstandingSmallRq[BX]	;decrement small requests outstanding
	INC  nXBlocksSmallFree
	XCHG AX,saFreeListSmall
; saFreeListSmall points to XBlock being freed. AX points to next free XBlock.
	JMP  SHORT InitXb
FreeBigXBlock:
	INC  nXBlocksFree
	XCHG AX,saFreeList
; saFreeList points to XBlock being freed. AX points to next free XBlock.
InitXb:
	MOV  ES:[xbSaLink],AX		;update pointer to next free
	MOV  BYTE PTR ES:[xbStatus],stXbAvail
	CMP  WORD PTR ES:[xboCf],0
	JE   ResetXb
	PUSH ES
	PUSH BX
	MOV  BX, ES:[xboCf]
	MOV  ES, WORD PTR pCachedFhs+2
	DEC  ES:BYTE PTR cfcRef[BX]
	POP  BX
	POP  ES
	MOV  WORD PTR ES:[xboCf],0
ResetXb:
	MOV  DI,xbStation
	CALL CalculateDmaAddr
RetXB:
	RET
ReturnIFrameToFreeList ENDP

%IF (%XBlockAudit) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
XBlockAudit PROC NEAR
PUBLIC XBlockAudit
;*****************************************************************************
; Make sure we have not lost any XBlocks.
;*****************************************************************************		
	PUSH DX
	PUSH ES
	PUSH CX
	XOR  DX,DX
	CLI					; DISABLE INTERRUPTS WHILE CHECKING XBLOCKS
	MOV  ES,saFreeList
CountXBlocks:
	MOV  CX,ES
	JCXZ EndOfXBlockFreeList
	TEST BYTE PTR ES:[xbFlags],xbSmall
	JZ   XBlockBigOk
	MOV  AX,3
	PUSH AX
	CALL Crash
XBlockBigOk:
	CMP  BYTE PTR ES:[xbStatus],stXbAvail
	JE   XBlockStatusOk
	MOV  AX,3
	PUSH AX
	CALL Crash
XBlockStatusOk:
	INC  DX
	MOV  ES,ES:[xbSaLink]
	JMP  CountXBlocks
EndOfXBlockFreeList:
	CMP  DL,nXBlocksFree
	JE   XBlocksOk
	MOV  AX,3
	PUSH AX
	CALL Crash
XBlocksOk:
	STI					; GIVE INTERRUPTS A CHANCE ON OTHER LINE
	XOR  DX,DX
	CLI					; DISABLE INTERRUPTS WHILE CHECKING XBLOCKS
	MOV  ES,saFreeListSmall
CountSmallXBlocks:
	MOV  CX,ES
	JCXZ EndOfXBlockSmallFreeList
	TEST BYTE PTR ES:[xbFlags],xbSmall
	JNZ  XBlockSmallOk
	MOV  AX,3
	PUSH AX
	CALL Crash
XBlockSmallOk:
	CMP  BYTE PTR ES:[xbStatus],stXbAvail
	JE   XBlockSmallStatusOk
	MOV  AX,3
	PUSH AX
	CALL Crash
XBlockSmallStatusOk:
	INC  DX
	MOV  ES,ES:[xbSaLink]
	JMP  CountSmallXBlocks
EndOfXBlockSmallFreeList:
	CMP  DL,nXBlocksSmallFree
	JE   XBlocksSmallOk
	MOV  AX,3
	PUSH AX
	CALL Crash
XBlocksSmallOk:
	STI
	POP  CX
	POP  ES
	POP  DX
	RET
XBlockAudit ENDP
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; Literals for ControlInterrupt
bOpEnable   EQU 0
bOpDisable  EQU 1
tyPIT       EQU 3
tyRS4221    EQU 7

; Disable cluster and PIT interrupts
DisableRelatedInterrupts		Proc	Near

	PUSHF
	CLI					;Disable both atomically
	PUSHA
	PUSH tyPIT
	PUSH bOpDisable
	CALL ControlInterrupt
	PUSH tyRS4221
	PUSH bOpDisable
	CALL ControlInterrupt
	POPA
	POPF
	RET

DisableRelatedInterrupts		Endp

; Enable cluster and PIT interrupts
EnableRelatedInterrupts		Proc	near
	
	PUSHF
	CLI					;Enable both atomically
	PUSHA
	PUSH tyPIT
	PUSH bOpEnable
	CALL ControlInterrupt
	PUSH tyRS4221
	PUSH bOpEnable
	CALL ControlInterrupt
	POPA
	POPF
	RET

EnableRelatedInterrupts		Endp


SystimeTicksDiff PROC NEAR
PUBLIC SystimeTicksDiff
;*****************************************************************************
; Calculate the difference in ticks between the previous time and the 
; current systime, and return the difference in AX.
; On entry:
;	CX = previous systime low (ticks and msec100)
;	DX = previous systime seconds
;*****************************************************************************

	LES  DI, pSysTime
	MOV  AX,systimeSecs[DI]
	SUB  AX,DX						;AX = difference in seconds 
	JNZ  CalculateTicksInSeconds
CalculateMsec100Diff:
	XOR  DX,DX
	MOV  DL,systimeMsec100[DI]		;DX = number of hundred msec (0 - 9)
	SUB  DL,CH						;DX = difference in hundred msec
	JGE  MultiplyHundredMsec
	MOV  DH,0FFh					;Extend sign
MultiplyHundredMsec:
	SHL  DX,1						;HundredMsec diff * 2
	SHL  DX,1						;HundredMsec diff * 4
	ADD  AX,DX						;Add ticks in hundred msec diff to total
; Calculate the difference in ticks. The ticks counter counts down from 4 to 1, 
; so the ticks counter is normally less.
	SUB  CL,systimeTicks[DI]
	MOV  CH,0
	JGE  AddTicks
	MOV  CH,0FFh					;Extend sign
AddTicks:
	ADD  AX,CX						;Add ticks to total
	JL   ForgetThisCalculation
	RET

ForgetThisCalculation:
; Sometimes we see something like:
; prev systime -- 85C:401
; new  systime -- 85C:404
; This is because when the real time clock interrupt routine finds that it is 
; time to update systime msec100 and friends, it mediates itself. We can then 
; get an interrupt and find the clock partially updated -- the ticks have been 
; updated, but the rest has not.
	XOR  AX,AX
	RET

CalculateTicksInSeconds:
; Come here if the difference between the seconds portion is not zero.
	JNS  MultiplySeconds

; If seconds were greater last time, then the seconds counter was reset. 
; Seconds count from 0 to 43199: the number of seconds since the last 
; midnight/noon.
	ADD  AX,43200

MultiplySeconds:
; Multiply the difference in seconds * 40 (40 ticks per second).
	MOV  DX,AX						;DX = difference in seconds
	SHL  AX,1						;Seconds diff *2
	SHL  AX,1						;*4
	ADD  AX,DX						;*5
	SHL  AX,1						;*10
	SHL  AX,1						;*20
	SHL  AX,1						;*40
	JMP  CalculateMsec100Diff
SystimeTicksDiff ENDP


data SEGMENT WORD 'data'
statePit LABEL WORD
statePitIdle EQU 0
	DW	PitIdle
statePitSnrmTimeout EQU 2
	DW	PitSnrmTimeout
statePitStartPollCycle EQU 4
	DW	PitStartPollCycle
statePitStartActivePollCycle EQU 6
	DW	PitStartActivePollCycle
data ENDS

TimerISR PROC FAR
PUBLIC TimerISR
;*****************************************************************************
; Come here when the Programmable Interval Timer goes off. We set the PIT
; whenever we send a SNRM so that we won't waste time with a long timeout.
; We will always come here when we send a SNRM because we don't reset the 
; timer.  If we did not get a reply to the snrm, unchain this dct from the
; list and put it back on listInactive. This is a mediated interrupt routine.
; We also set the PIT for starting a poll cycle.
;*****************************************************************************
	PUSH BP
	MOV  BP,WORD PTR pPitRet			;get BP = lcb base
	SUB  BP,OFFSET DGroup:lcb_timerIntBlock

	MOV  AX,lcb_pitTimeout[BP]
	ADD  lcb_timerNumber[BP], AX

	MOV  AX, lcb_timer100Ms[BP]
	SUB  AX, lcb_timerNumber[BP]
	CWD
	XCHG AX, DX				; AX = 0 if not yet 100ms, else 0FFFFh
	JNS  Not100ms
	ADD  lcb_timer100Ms[BP], 2000 ; pit ticks = 100ms

	TEST fGoingDown,1
	JZ   GoingDownDone
	CMP  rqDelayDisc,1		; IF rqDelayDisc >= 1 THEN
	CMC
	SBB  rqDelayDisc,0		;	 rqDelayDisc = rqDelayDisc-1
	JNZ  GoingDownDone		; IF rqDelayDisc = 0 THEN
	MOV  fDisconnectAll, TRUE
GoingDownDone:

Not100ms:

	CALL DisableRelatedInterrupts					;Protect statePit
	MOV  BL, lcb_statePit[BP]
	XOR  BH, BH
	MOV  lcb_statePit[BP],statePitIdle
	JMP  WORD PTR statePit[BX]

PitStartPollCycle:
	CALL EnableRelatedInterrupts

%IF(%VariablePoll) THEN (
; Reset poll cycle timeout to full interval in case had active poll cycles.
	CMP  lcb_pollCycleTimeout[BP],1000
	JA   PitPollTimeoutOk
	MOV  lcb_pollCycleTimeout[BP],1000
PitPollTimeoutOk:
)FI%'
	CALL ProcessTRB			;(AX=f100ms, BP=rbLcb)
	JMP  PitIdle

%IF(%VariablePoll) THEN (
PitStartActivePollCycle:
	MOV  lcb_fActivePollCycle[BP],0FFh	; Active poll.
	MOV  DX, lcb_timerNumber[BP]
	MOV  lcb_curPollCycleNbr[BP],DX		; No overrun.
	CALL EnableRelatedInterrupts
	CALL ProcessTRB			;(AX=f100ms, BP=rbLcb)
	JMP  PitIdle
)FI%'

PitSnrmTimeout:
;	Leave CLI - managing chip, queues.
	MOV  lcb_countSendSnrm[BP],0		;Wait before sending another SNRM
	MOV  BX,lcb_dctCurrent[BP]			;BX points to dct that timed out
	CALL StopRead

; Count un-answered snrms.
	TEST BYTE PTR lcb_SNRMall[BP],0FFh
	JZ   PSTFast
	INC  lcb_SnrmNext[BP]
	CMP  lcb_SnrmNext[BP], 64	; Lots of unanswered SNRMs in a row?
	JB   PSTFast				; .. no, keep SNRMing fast.
	CMP  nWsActive, 0
	JE   PSTFast				; Nobody up yet, keep SNRMing fast.
; Lots of unanswered SNRMs.  Slow SNRM rate.
	MOV  timerInterruptsPerSnrm, 10
PSTFast:

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,lcb_logBufferIndex[BP]
	MOV  logErc[DI],ercTimeout
	MOV  logFrameIn[DI],0
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	CALL MoveDctToInactive

; Update startIdleTime so that we don't count idle ticks twice. 
	LES  BX, pSysTime
	MOV  AX,systimelow[BX]
	MOV  lcb_startIdleTimeLow[BP],AX
	MOV  AX,systimehigh[BX]
	MOV  lcb_startIdleTimeHigh[BP],AX

	CALL StartPoll

PitIdle:
	CALL EnableRelatedInterrupts
; Set the Programmable Interval Timer for the start of the next poll cycle.
; We set the PIT elsewhere to a smaller interval sometimes,
; e.g. sending a SNRM, delayed active poll cycle.
	CMP  lcb_statePit[BP],statePitIdle
	JNE  PitRet		; Timer already restarted.

	MOV  AX,lcb_pollCycleTimeout[BP]
	MOV  lcb_pitTimeout[BP],AX
	MOV  lcb_statePit[BP],statePitStartPollCycle
	PUSH DS
	LEA  AX,lcb_timerIntBlock[BP]
	PUSH AX
	CALL SetTimerInt
PitRet:
	POP  BP
	RET
TimerISR ENDP

MstrLph ENDS

; LOG
; 3/28/84 by Jim Frandeen: Created file
; 1/31/85 by Bob Merrell: Modified for Megaframe
; 4/10/85 by Bob Merrell: Change repoll algorithm. nRepollActive is a Sysgen
; parameter.  When the workstation is active(when we send or receive an 
; IFrame), repoll the workstation this many times.  If the workstation has
; another Iframe to send, he will set the high bit of cbDataSent (the second
; word in the frame) to indicate that he wants to be poled again. If this
; is set, we will always repoll him. as taken from JF.
; 3/14/86 by PBC:  Added 6 words to masterStats for Y and Z block reporting.
; 5/31/86 by JA, don't STI in DeactivateDct, do PUSHF,CLI,POPF.  Fixes init
;	early-enable bug.
; 6/12/86 by RLM Don't do CheckT0 if nPTTotal = 0.
; 6/20/86 by RLM Request can become disordered if interrupts are turned on
; 		  before PSend of the first request.
; 10/17/86 by RLM add sequence check on RR/RNR frames.
; 1/9/86   by RLM make HandleErrorAndPollNext into HandleErrorAndPollCurrent
;		  for 9.x compatability answering Iframe to RNR.
; 1/12/87  by RLM set xblock in use in getxblock was reset from xbObit in
;		  Agentsubs
; 03/26/87 by RLM in InvalidIFrameReply if frame type was rr resend IFrame
;07/28/87  by RLM add poll fairness in TestTimeOut.
; 07/31/87 by JM/RLM reduce interrupt latency by enabling in PollCurrent.
; 08/17/87 by JA add IFrameSentAndReceived to free xBlock in RxError and
;				update dctNS.  Marked by %Aug87JA.
; 08/25/87 by JA PollCurrent set lcb_pollState to stateIdle before STI/CLI,
;			check after.
; 10/6/87 by JA changed		JH:MOV  CX,140h  to  JH:MOV	CX,1D0h
;						for slow PTs under CTIX.
; 11/02/87 by RLM/JA merge cluster code
; 11/10/87 by RLM/JA add stateNoPoll logic to stop reentrant problems in 
; pollcurrent.
; 9/8/88 by JA add %fRawInt around mediate,eoi code.
; 08/07/89 by AT, nOutstandingMax and maxXBlocksPerUser are the same.
; 09/29/89 by MTR oRgSbWsUserName -> pRgSbWsUserName (array moved from DGroup)
; 10/11/89 by DHG added XBlocks stats (old UVA)
; 11/06/89 by AT, MegaFrameDisableCluster now rBroadcast, dec rqDelayDisc.
; 01/09/90 by AT, use nXBlk, sXBlk, etc. instead of old variables.
; 01/09/90 by JA SysTimeTicksDiff, TimerIsr1&2 from MstrLph_P.Asm.
;				Rewrite TimerIsr, start poll cycle from pit.
; 02/08/90 by AT, Check fEnableCluster before starting to poll.
; 02/15/90 by RLM, changed maxWaitingTicks to 10 from 100 caused WS timeouts.
; 02/28/90 by JA use pSysTime since now linked separate from OS.
;               Remove fPitEarly.
; 03/01/90 by JA exchMstrAgentReceiver EXTERN.
; 03/02/90 by JA, use pStat since separately linked.
; 03/23/90 by JA, find fEnableCluster using pfEnableCluster.
; 04/14/90 by AT, Merged CTOS/XE 3.0 and CTOS/VM 3.3.
; 05/21/90 by JA, get sioClock from XID, put in dct.
; 06/20/90 by JA, timerNumber now in PIT units; added VariablePoll code; t0 out.
; 06/21/90 by JA, stateAckIFrameNotReady -> stateAckNotReady.
;				Don't set dct active for repoll if xblock limit reached.
;				WorkstationActive sets stateAckNotReady when xblock lim reached.
; 07/25/90 by JA, Delayed active poll cycles.
; 08/03/90 by JA, don't enable in PreparePollInactive: timer might expire, 
;				Don't clear fActivePollCycle in TestActiveDct.
;				Clear ActivePollCycleTimeout when cycle ends for any reason.
;				 - trouble if ^ not 0 when SNRM dct queued - statePit corrupt.
; 08/15/90 by JC, added RS232 latency reduction improvements
; 08/21/90 by JA, NoXBlockAvailable: nXBlockWaitsLow MOV AX, not ADD AX.
; 08/26/90 by JC, added declaration for sMasterStats, prevents an erc 80
;				for the limit of bytes GetClusterStatus can return
; 08/29/90 by JM, remove extra PUSHF in SendXblock.
; 09/06/90 by JA, dctShActivePoll limit; GetXBlock fix; ResetCounters nDct=0.
; 09/29/90 by JA, ActivateDct clear dctPollCycleInterval for faster dump.
; 11/12/90 by JM, change rgKHLineSpeed(0) from 3600 to 3680.
; 12/03/90 by GWH, change EN/DISABLERelatedInterrupts to work on SGEN.
; 01/28/91 by AT,  Use ControlInterrupt in Disable/EnableRelatedInterrupts.
;                  P1: Disable interrupts around SetTimerInt for SNRM timeout.
; 02/01/91 by SG,  Store revisionlevel in DCT for > 1M dumping. 
; 04/05/91 by BA,  Check for short frames in CalculatePollInterval and if 
;                  found jump to WaitForWrite instead of returning.
; 05/06/91 by JA,  PreparePollInactive use fGoingDown.
; 05/15/91 by AT,  Always disable interrupts around SetTimerInt for SNRM 
;                  timeout, not 'P1 debugging only'.
; 05/29/92 by GWH, Removed bogus delay when responding to RIM from boot rom.
; 05/30/91 by BA & JMR, Use Disable/EnableRelatedInterrupts in ActivateDct
;                  instead of disabling all interrupts to reduce interrupt
;                  latency.
; 06/07/91 by JA/SP/DG, PollCurrent never skip dcts in boot states.
; 09/09/91 by JA,  SendXBlock save ES around DisableRelatedInterrupts.
; 11/05/91 by GWH, Fix BX to be lcb_dctCurrent when calling stopread after
;				   a snrm times out.  Fixes RTC,Floppy, PIT latency problems
;				   with IOGA (T2/T3) modules.
; 12/10/91 by GWH,JA ReqTimedActiveCycle.  No longer repoll a ws that responds
;				   out of sequence right away.  Move on in poll cycle.  This
;				   prevents multiple TX underruns in a row to the same dct.
; 12/10/91 by GWH,JA In SendXblock check dctRetryCount[] to see if the
;				   dct is retrying before we trigger an active poll cycle
;				   due to a xblock from the agent for this dct.
; 01/09/92 by GWH,JA No longer force state to MasterNotReady when we need
;				   to complete a poll quick but have no Xblock and are in
;				   StateErrorRecovery ( in TestNeedXblock ).  Rather, don't
;				   poll until an xblock becomes available.  If workstations
;				   drop due to time outs, the work around is to have more
;				   xblocks or a larger ws timeout value.  This fixed the
;				   bad rcb problem where the sequence numbers got out of
;				   sync due to the state coersion described above.
; 03/09/92 by JA   NoIFrameResponse poll ws soon, may become active.
; 				   lcb_ActivePollCycleTimeout[] MIN of dct's requesting.
; 				   lcb_pollCycleTimeout[] SUB'd only once.
; 03/06/93 by JA   ReturnXBlockToFreeList mask xbSmall (reset other flags).
;				   Also clear oCf, dec cfcRef.
; 03/08/93 by FW   Remove nFalseTimeout code; it aggravated
;				   a PIT/RTC race condition resulting in whole line drops due
;				   to a single workstation going down.
; 05/11/93 by JA   RxBooting inc by xbCbData.  PrepareNextBootPage set xbCbData
;				   large if revision 82h or greater.
; 05/12/93 by JA   Oops! Add 6 to xbCbData; no greater than cbBoot82Max.
;				   Expunge maxTimerInterruptsPerSnrm,
;				   make timerInterruptsPerSnrm variable.
;				   Also RxPollingInactive set timerInterruptsPerSnrm low when
;				   got a reply so SNRM more when clients coming up.
;				   PitSnrmTimeout set high when many unanswered SNRMs in a row.
; 05/18/93 by JA   ReqTimedActiveCycle SHR shActivePoll 2 so can in units of
;				   log2(1/8ms).
;				   RxWorkstationReady inc shActivePoll by 4(2ms) & repoll when
;				   ws wasn't ready.
; 06/03/93 by BA   Don't check wLocalWho anymore when deciding whether to 
;				   disable the cluster. We now make this decision in the agent.
; 06/15/93 by BA   Added fDisableCluster so GetClusterStatus can indicate if 
;				   the line is up or not.  Bumped revisionLevel to 2 so 
;				   ClusterStatus knows fDisableCluster is active.